/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.binding;

import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.impl.ExtendedSqlMapClient;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.mapping.statement.GeneralStatement;
import com.ibatis.sqlmap.engine.mapping.statement.StatementType;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class MapperCommand {
    private SqlMapClient client;
    private SqlMapExecutorDelegate delegate;
    private boolean hasSuppliedValueObject;
    private Method method;
    private int argCount;
    private boolean returnsList;
    private boolean hasListBounds;
    private boolean hasPageSize;
    private boolean returnsMap;
    private boolean hasMapValueKey;
    private StatementType type;
    private String statementName;
    private Class parameterClass;
    private Class resultClass;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$lang$String;

    public MapperCommand(Method method, SqlMapClient client) {
        this.client = client;
        this.method = method;
        this.setupFields();
        this.determineStatementType();
        this.determineSelectMethod();
        this.validateStatement();
        this.validateResult();
        this.validateParameter();
    }

    private void setupFields() {
        this.statementName = this.method.getName();
        this.delegate = ((ExtendedSqlMapClient)this.client).getDelegate();
        GeneralStatement statement = (GeneralStatement)this.delegate.getMappedStatement(this.statementName);
        this.parameterClass = statement.getParameterClass();
        this.resultClass = statement.getResultMap() == null ? null : statement.getResultMap().getResultClass();
        this.type = statement.getStatementType();
        this.argCount = this.method.getParameterTypes().length;
    }

    private void determineStatementType() {
        if (StatementType.PROCEDURE == this.type || StatementType.UNKNOWN == this.type) {
            if (this.statementName.startsWith("insert")) {
                this.type = StatementType.INSERT;
            } else if (this.statementName.startsWith("create")) {
                this.type = StatementType.INSERT;
            } else if (this.statementName.startsWith("update")) {
                this.type = StatementType.UPDATE;
            } else if (this.statementName.startsWith("save")) {
                this.type = StatementType.UPDATE;
            } else if (this.statementName.startsWith("delete")) {
                this.type = StatementType.DELETE;
            } else if (this.statementName.startsWith("remove")) {
                this.type = StatementType.DELETE;
            } else if (this.statementName.startsWith("select")) {
                this.type = StatementType.SELECT;
            } else if (this.statementName.startsWith("query")) {
                this.type = StatementType.SELECT;
            } else if (this.statementName.startsWith("get")) {
                this.type = StatementType.SELECT;
            } else if (this.statementName.startsWith("fetch")) {
                this.type = StatementType.SELECT;
            }
        }
    }

    private void determineSelectMethod() {
        if (StatementType.SELECT == this.type) {
            if ((class$java$util$List == null ? (class$java$util$List = MapperCommand.class$("java.util.List")) : class$java$util$List).isAssignableFrom(this.method.getReturnType())) {
                this.returnsList = true;
                if (this.argCount == 2) {
                    this.hasPageSize = true;
                } else if (this.argCount == 3) {
                    this.hasListBounds = true;
                }
            } else if ((class$java$util$Map == null ? (class$java$util$Map = MapperCommand.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(this.method.getReturnType()) && this.argCount > 1 && (class$java$lang$String == null ? (class$java$lang$String = MapperCommand.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(this.method.getParameterTypes()[1])) {
                if (this.argCount == 2) {
                    this.returnsMap = true;
                    this.hasMapValueKey = false;
                } else if (this.argCount == 3) {
                    this.returnsMap = true;
                    this.hasMapValueKey = true;
                }
            } else if (this.argCount == 2) {
                this.hasSuppliedValueObject = true;
            }
        }
    }

    private void validateStatement() {
        try {
            this.delegate.getMappedStatement(this.statementName);
        }
        catch (Exception e) {
            throw new SqlMapException("Invalid bound statement (not found): " + this.statementName);
        }
        if (StatementType.UNKNOWN == this.type || StatementType.PROCEDURE == this.type) {
            throw new SqlMapException("Unkown statement type for statement: " + this.statementName);
        }
    }

    private void validateResult() {
        if (this.returnsList || !this.returnsMap) {
            // empty if block
        }
    }

    private void validateParameter() {
        if (this.argCount > 0) {
            Class<?> paramType = this.method.getParameterTypes()[0];
            if (this.parameterClass != null) {
                // empty if block
            }
        }
        if (this.argCount > 1 && this.type != StatementType.SELECT) {
            throw new SqlMapException("Too many parameters for statement (must be 1 or 0): " + this.statementName);
        }
        if (this.argCount > 1 && this.type != StatementType.SELECT) {
            throw new SqlMapException("Too many parameters for statement (must be 1 or 0): " + this.statementName);
        }
    }

    public Object execute(Object[] args) throws SQLException {
        Object result = null;
        if (StatementType.INSERT == this.type) {
            Object param = this.getParam(args);
            result = this.client.insert(this.statementName, param);
        } else if (StatementType.UPDATE == this.type) {
            Object param = this.getParam(args);
            result = new Integer(this.client.update(this.statementName, param));
        } else if (StatementType.DELETE == this.type) {
            Object param = this.getParam(args);
            result = new Integer(this.client.delete(this.statementName, param));
        } else if (StatementType.SELECT == this.type) {
            result = this.returnsList ? this.executeForList(args) : (this.returnsMap ? this.executeForMap(args) : this.executeForObject(args));
        } else {
            throw new SqlMapException("Unkown execution method for: " + this.statementName);
        }
        return result;
    }

    private Object executeForObject(Object[] args) throws SQLException {
        Object result;
        if (this.hasSuppliedValueObject) {
            Object param = this.getParam(args);
            Object valueObject = args[1];
            result = this.client.queryForObject(this.statementName, param, valueObject);
        } else {
            Object param = this.getParam(args);
            result = this.client.queryForObject(this.statementName, param);
        }
        return result;
    }

    private Object executeForMap(Object[] args) throws SQLException {
        Map result;
        if (this.hasMapValueKey) {
            Object param = this.getParam(args);
            String keyProp = (String)args[1];
            String valueProp = (String)args[2];
            result = this.client.queryForMap(this.statementName, param, keyProp, valueProp);
        } else {
            Object param = this.getParam(args);
            String keyProp = (String)args[1];
            result = this.client.queryForMap(this.statementName, param, keyProp);
        }
        return result;
    }

    private Object executeForList(Object[] args) throws SQLException {
        List result;
        if (this.hasListBounds) {
            Object param = this.getParam(args);
            int skip = (Integer)args[1];
            int max = (Integer)args[2];
            result = this.client.queryForList(this.statementName, param, skip, max);
        } else if (this.hasPageSize) {
            Object param = this.getParam(args);
            int pageSize = (Integer)args[1];
            result = this.client.queryForPaginatedList(this.statementName, param, pageSize);
        } else {
            Object param = this.getParam(args);
            result = this.client.queryForList(this.statementName, param);
        }
        return result;
    }

    private Object getParam(Object[] args) {
        if (args == null) {
            return null;
        }
        return args.length > 0 ? args[0] : null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

