------------------------------------------------------------------
-- 테이블 생성 ------------------------------------------------------
------------------------------------------------------------------

-- Article 테이블
DROP SEQUENCE article_seq IF EXISTS CASCADE;
CREATE SEQUENCE article_seq START WITH 1;

DROP TABLE Article IF EXISTS CASCADE;
CREATE TABLE Article (
	id INTEGER IDENTITY,
	title VARCHAR ( 80 ) NOT NULL,
	url VARCHAR ( 255 ) NOT NULL,
	pub_date DATE NOT NULL,
	description VARCHAR ( 1000 ),
	author_ref INTEGER,
	source_ref INTEGER,
	CONSTRAINT pk_article PRIMARY KEY (id)
);


-- Author 테이블
DROP SEQUENCE author_seq IF EXISTS CASCADE;
CREATE SEQUENCE author_seq START WITH 1;

DROP TABLE Author IF EXISTS CASCADE;
CREATE TABLE Author (
	id INTEGER IDENTITY,
	name VARCHAR ( 25 ) NOT NULL,
	email VARCHAR (50),
	blog VARCHAR (80),
	CONSTRAINT pk_author PRIMARY KEY (id)
);


-- ArtSrc 테이블
DROP SEQUENCE artsrc_seq IF EXISTS CASCADE;
CREATE SEQUENCE artsrc_seq START WITH 1;

DROP TABLE ArtSrc IF EXISTS CASCADE;
CREATE TABLE ArtSrc (
	id INTEGER IDENTITY,
	name VARCHAR ( 25 ) NOT NULL,
	url VARCHAR ( 255 ) NOT NULL,
	feed VARCHAR ( 255 ) NOT NULL,
	CONSTRAINT pk_artsrc PRIMARY KEY (id)
);

-- Admin 테이블
DROP TABLE Admin IF EXISTS CASCADE;
CREATE TABLE Admin (
	id VARCHAR ( 25 ) NOT NULL,
	password VARCHAR ( 25 ) NOT NULL,
	CONSTRAINT pk_admin PRIMARY KEY (id)
);

-- AdminRole 테이블
DROP TABLE Admin_Roles IF EXISTS CASCADE;
CREATE TABLE Admin_Roles (
  admin_name        varchar(15) not null,
  role_name         varchar(15) not null,
  primary key (admin_name, role_name)
);