package ams.dao.article.ibatis;

import java.util.List;

import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

import ams.dao.article.IArticleDao;
import ams.domain.article.Article;

public class SqlmapArticleDao extends SqlMapClientDaoSupport implements
		IArticleDao {

	public void insertArticle(Article article) {
		getSqlMapClientTemplate().insert("insertArticle", article);
	}

	@SuppressWarnings("unchecked")
	public List<Article> selectArticleList() {
		return getSqlMapClientTemplate()
				.queryForList("selectArticleList", null);
	}

	public Article selectArticle(Integer id) {
		return (Article) getSqlMapClientTemplate()
				.queryForObject("findByPrimaryKey", id);
	}

}
