package ams.service.article;

import java.util.List;

import ams.dao.article.IArticleDao;
import ams.dao.article.IAuthorDao;
import ams.domain.article.Article;
import ams.domain.article.Author;
import ams.domain.form.ArticleRegistrationForm;

public class ArticleFacade implements IArticle {

	private IArticleDao articleDao;
	private IAuthorDao authorDao;



	public void setArticleDao(IArticleDao articleDao) {
		this.articleDao = articleDao;
	}

	public void setAuthorDao(IAuthorDao authorDao) {
		this.authorDao = authorDao;
	}



	public List<Article> getArticleList() {
		return articleDao.selectArticleList();
	}



	public void registerArticle(ArticleRegistrationForm entry) {

		Article articleOfEntry = entry.getArticle();
		Author authorOfEntry = entry.getAuthor();

		articleDao.insertArticle(articleOfEntry);
		authorDao.insertAuthor(authorOfEntry);



	}

	public Article getArticle(Integer id) {

		return articleDao.selectArticle(id);

	}

}
