package ams.web.article;

import javax.servlet.ServletException;

import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;

import ams.domain.form.ArticleRegistrationForm;
import ams.service.article.IArticle;

public class ArticleRegistrationController extends SimpleFormController {

	private IArticle articleFacade;

	public void setArticleFacade(IArticle articleFacade) {
		this.articleFacade = articleFacade;
	}

	public ModelAndView onSubmit(Object command) throws ServletException {

		ArticleRegistrationForm article = (ArticleRegistrationForm) command;

		logger.info("title: " + article.getTitle());
		logger.info("url: " + article.getUrl());
		logger.info("published: " + article.getDescription());
		logger.info("authorName: " + article.getAuthorName());
		logger.info("authorEmail: " + article.getAuthorEmail());
		logger.info("authorBlog: " + article.getAuthorBlog());

		articleFacade.registerArticle(article);

		return new ModelAndView(getSuccessView(), "article" , article);

	}

}