<%@ page language="java" errorPage="error.jsp" pageEncoding="UTF-8"
	contentType="text/html; charset=utf-8"%>

<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core_rt"%>
<%@ taglib uri="http://www.opensymphony.com/sitemesh/page" prefix="page"%>

<html>
<head>
<title>업무중심 자바개발 예제</title>
<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />
<link rel="stylesheet" type="text/css"
	href="<%=request.getContextPath() %>/css/top.css" />
</head>

<body>
<table id="boundary" name="boundary">
	<tr id="info" name="info">
		<td>
		<fieldset id="top"><legend>아티클 상세 정보: <c:out value="${article.title}" /></legend>
		<div id="box">
			<table>
				<tr><td>저자: <c:out value="${article.author.name}" />
				(이메일:
				<c:if test='${article.author.email != "unknown"}'>
					<a href="mailto:<c:out value="${article.author.email}" />">
				</c:if>
				<c:out value="${article.author.email}" />
				<c:if test='${article.author.email != "unknown"}'>
					</a>
				</c:if>,
				블로그:
				<c:if test='${article.author.blog != "unknown"}'>
					<a href="<c:out value="${article.author.blog}" />">
				</c:if>
				<c:out value="${article.author.blog}" />
				<c:if test='${article.author.blog != "unknown"}'>
					</a>
				</c:if>
				)</td></tr>
				<tr>
					<td>발행일: <c:out value="${article.published}" /></td>
					<td>발행처:
						<a href="<c:out value="${article.source.url}" />">
						<c:out value="${article.source.name}" />
						</a>
					</td>
				</tr>
			</table>
		</div>
		</fieldset>
		</td>
	</tr>
	<tr id="details" name="details">
		<td>
		<c:choose>
        <c:when test='${article.source.name == "JavaWorld"}'>
        	<br>
        	<a href="<c:out value="${article.url}" />">${article.url}</a>
        	<br>
        	<font style="font-size: 10pt;">
        	(죄송합니다. 자바 월드의 경우는 본문 추출에 제약이 있어 링크로 대체합니다.)
        	</font>
        </c:when>
        <c:otherwise>
            <page:applyDecorator page="${article.url}" encoding="utf-8"
				name="panel" />
        </c:otherwise>
    	</c:choose>
		</td>
	</tr>
</table>
</body>
</html>