<%@ page language="java" errorPage="error.jsp" pageEncoding="UTF-8"
	contentType="text/html; charset=utf-8"%>

<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>

<html>
<head>
<title>업무중심 자바개발 예제</title>
<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />
<link rel="stylesheet" type="text/css"
	href="<%=request.getContextPath() %>/css/form.css" />

<script type="text/javascript"
	src="<%=request.getContextPath() %>/js/form.js"></script>
</head>

<body onLoad="init();">
<fieldset><legend>아티클 등록 >> 아티클 기본 정보 입력</legend>
<div id="box">
<form id="form" autocomplete="off" method="post"
	action="<%=request.getContextPath() %>/article/register.do">

<table>
	<tr>
		<spring:bind path="articleRegistrationForm.title">
			<td class="label"><label for="title">제목</label></td>
			<td class="field"><input id="title" name="title" type="text"
				class="textfield" value="" maxlength="80" /></td>
			<td class="status"><span id="titleStatus"></span></td>
		</spring:bind>
	</tr>
	<tr>
		<spring:bind path="articleRegistrationForm.url">
		<td class="label"><label for="url">URL</label></td>
		<td class="field"><input id="url" name="url" type="text"
			class="textfield" value="" maxlength="255" /></td>
		<td class="status"><span id="urlStatus"></span></td>
		</spring:bind>
	</tr>
	<tr>
		<spring:bind path="articleRegistrationForm.authorName">
		<td class="label"><label for="authorName">저자</label></td>
		<td class="field"><input id="authorName" name="authorName" type="text"
			class="textfield" value="" maxlength="15" /></td>
		<td class="status"><span id="authorNameStatus"></span></td>
		</spring:bind>
	</tr>
	<tr>
		<spring:bind path="articleRegistrationForm.authorEmail">
		<td class="label"><label for="authorEmail">이메일</label></td>
		<td class="field"><input id="authorEmail" name="authorEmail"
			type="text" class="disabledTextfield" value="" maxlength="50"
			disabled="disabled" /></td>
		<td class="status"><span id="authorEmailStatus"></span></td>
		</spring:bind>
	</tr>
	<tr>
		<spring:bind path="articleRegistrationForm.authorBlog">
		<td class="label"><label for="authorBlog">블로그</label></td>
		<td class="field"><input id="authorBlog" name="authorBlog" type="text"
			class="disabledTextfield" value="" maxlength="50" disabled="disabled" /></td>
		<td class="status"><span id="authorBlogStatus"></span></td>
		</spring:bind>
	</tr>
	<tr>
		<spring:bind path="articleRegistrationForm.published">
		<td class="label"><label for="published">발행일</label></td>
		<td class="field"><input id="published" name="published" type="text"
			class="textfield" value="" maxlength="18" /></td>
		<td class="status"><span id="publishedStatus"></span></td>
		</spring:bind>
	</tr>
	<tr>
		<spring:bind path="articleRegistrationForm.description">
		<td class="label"><label for="description">설명</label></td>
		<td class="field"><textarea class="textarea" id="description"
			name="description"></textarea></td>
		<td class="status">&nbsp;</td>
		</spring:bind>
	</tr>
	<tr>
		<td class="label">&nbsp;</td>
		<td class="field" colspan="2"><input id="submit" name="submit"
			type="submit" value="등록" /></td>
	</tr>
</table>

</form>
</div>
</fieldset>
</body>
</html>
