<%@ page language="java" errorPage="error.jsp" pageEncoding="UTF-8"
	contentType="text/html; charset=utf-8"%>

<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core_rt"%>

<html>
<head>
<title>업무중심 자바개발 예제</title>
<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />
<link rel="stylesheet" type="text/css"
	href="<%=request.getContextPath() %>/css/form.css" />

</head>

<body>
<fieldset><legend>아티클 등록 완료</legend>
<div id="box">
<form id="form" autocomplete="off" method="post" action="">

<table>
	<tr>
		<td class="label"><label for="title">제목</label></td>
		<td class="field"><input id="title" name="title" type="text"
			class="textfield" readonly="readonly"
			value="<c:out value="${article.title}" />" maxlength="50" /></td>
		<td class="status"><span id="titleStatus"></span></td>
	</tr>
	<tr>
		<td class="label"><label for="url">URL</label></td>
		<td class="field"><input id="url" name="url" type="text"
			class="textfield" readonly="readonly"
			value="<c:out value="${article.url}" />" maxlength="255" /></td>
		<td class="status"><span id="urlStatus"></span></td>
	</tr>
	<tr>
		<td class="label"><label for="published">발행일</label></td>
		<td class="field"><input id="published" name="published" type="text"
			class="textfield" readonly="readonly"
			value="<c:out value="${article.published}" />" maxlength="18" /></td>
		<td class="status"><span id="publishedStatus"></span></td>
	</tr>
	<tr>
		<td class="label"><label for="author">저자</label></td>
		<td class="field"><input id="author" name="author" type="text"
			class="textfield" readonly="readonly"
			value="<c:out value="${article.authorName}" />" maxlength="18" /></td>
		<td class="status"><span id="authorStatus"></span></td>
	</tr>
	<tr>
		<td class="label"><label for="description">설명</label></td>
		<td class="field"><textarea class="textarea" id="description"
			readonly="readonly" name="description"><c:out
			value="${article.description}" /></textarea></td>
		<td class="status">&nbsp;</td>
	</tr>
</table>
</form>
</div>
</fieldset>
</body>
</html>
