// dlgconfigure.cpp : implementation file
//

#include "arch/frame/stdafx.h"
#include "arch/frame/aipc.h"
#include "arch/frame/dlgconfigure.h"
#include "arch/frame/wcsliderbutton.h"
#include "mousecard.h"
#include "diskinterface.h"
#include "phasor.h"
#include "appleclock.h"
#include "joystick.h"
#include "arch/directx/dikeyboard.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CAppleClock* g_pBoard;
extern CDIKeyboard g_cDIKeyboard;

/////////////////////////////////////////////////////////////////////////////
// CDlgConfigure dialog


CDlgConfigure::CDlgConfigure(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgConfigure::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgConfigure)
	m_bMasterMute = FALSE;
	m_bSpeakerMute = FALSE;
	//}}AFX_DATA_INIT
}

CDlgConfigure::~CDlgConfigure()
{
	int i;
	for( i = 0; i < 7; i++ )
	{
		//  ߴ ī ߿     Ѵ.
		if ( m_pCards[i] != NULL && m_pCards[i] != g_pBoard->m_cSlots.GetCard(i) )
		{
			delete m_pCards[i];
			m_pCards[i] = NULL;		// not necessary but...
		}
	}
}

void CDlgConfigure::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgConfigure)
	DDX_Control(pDX, IDC_SPEAKER_VOLUME, m_slSpeakerVolume);
	DDX_Control(pDX, IDC_SPEAKER_BALANCE, m_slSpeakerBalance);
	DDX_Control(pDX, IDC_MASTER_VOLUME, m_slMasterVolume);
	DDX_Control(pDX, IDC_MASTER_BALANCE, m_slMasterBalance);
	DDX_Check(pDX, IDC_MASTER_MUTE, m_bMasterMute);
	DDX_Check(pDX, IDC_SPEAKER_MUTE, m_bSpeakerMute);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_MACHINE_2PLUS, m_btnMachine[0]);
	DDX_Control(pDX, IDC_MACHINE_2E, m_btnMachine[1]);
	DDX_Control(pDX, IDC_MACHINE_2C, m_btnMachine[2]);
	DDX_Control(pDX, IDC_JOYSTICK_NONE, m_btnJoystick[0]);
	DDX_Control(pDX, IDC_JOYSTICK_NUMPAD, m_btnJoystick[1]);
	DDX_Control(pDX, IDC_JOYSTICK_PCJOYSTICK, m_btnJoystick[2]);
	DDX_Control(pDX, IDC_SLOT1, m_cbSlot[0]);
	DDX_Control(pDX, IDC_SLOT2, m_cbSlot[1]);
	DDX_Control(pDX, IDC_SLOT3, m_cbSlot[2]);
	DDX_Control(pDX, IDC_SLOT4, m_cbSlot[3]);
	DDX_Control(pDX, IDC_SLOT5, m_cbSlot[4]);
	DDX_Control(pDX, IDC_SLOT6, m_cbSlot[5]);
	DDX_Control(pDX, IDC_SLOT7, m_cbSlot[6]);
	DDX_Control(pDX, IDC_SLOT1_SETUP, m_btnSetupCard[0]);
	DDX_Control(pDX, IDC_SLOT2_SETUP, m_btnSetupCard[1]);
	DDX_Control(pDX, IDC_SLOT3_SETUP, m_btnSetupCard[2]);
	DDX_Control(pDX, IDC_SLOT4_SETUP, m_btnSetupCard[3]);
	DDX_Control(pDX, IDC_SLOT5_SETUP, m_btnSetupCard[4]);
	DDX_Control(pDX, IDC_SLOT6_SETUP, m_btnSetupCard[5]);
	DDX_Control(pDX, IDC_SLOT7_SETUP, m_btnSetupCard[6]);
	DDX_SliderButtonCtrl(pDX, IDC_KEYBOARD_DELAY, m_sbKeyDelay, 0);
	DDX_SliderButtonCtrl(pDX, IDC_KEYBOARD_REPEAT, m_sbKeyRepeat, 0);
	DDX_SliderButtonCtrl(pDX, IDC_VIDEO_H, m_sbVideoH, 0);
	DDX_SliderButtonCtrl(pDX, IDC_VIDEO_S, m_sbVideoS, 0);
	DDX_SliderButtonCtrl(pDX, IDC_VIDEO_B, m_sbVideoB, 0);
}


BEGIN_MESSAGE_MAP(CDlgConfigure, CDialog)
	//{{AFX_MSG_MAP(CDlgConfigure)
	//}}AFX_MSG_MAP
	ON_CONTROL_RANGE(CBN_SELCHANGE, IDC_SLOT1, IDC_SLOT7, OnSelchangeSlot)
	ON_CONTROL_RANGE(BN_CLICKED, IDC_SLOT1_SETUP, IDC_SLOT7_SETUP, OnClickedSlotSetup)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgConfigure message handlers

void CDlgConfigure::OnSelchangeSlot(UINT uId) 
{
	int nCurSel;
	CCard* pCard;
	if ( uId < IDC_SLOT1 || uId > IDC_SLOT7 )
		return;			// it must not occur
	uId -= IDC_SLOT1;
	nCurSel = m_cbSlot[uId].GetCurSel();
	if ( m_pCards[uId] == NULL || m_pCards[uId]->GetDeviceNum() != nCurSel )
	{
		pCard = g_pBoard->m_cSlots.GetCard(uId);
		if ( m_pCards[uId] != NULL )
		{
			//  ġ ī  
			// rollback(cancel) 츦 ؼ  ī  ʴ´.
			if ( m_pCards[uId] != pCard )
				delete m_pCards[uId];
			m_pCards[uId] = NULL;
		}
		//  ִ ī ϸ  ī带 Ѵ.
		if ( pCard != NULL && pCard->GetDeviceNum() == nCurSel )
			m_pCards[uId] = pCard;
		else
		{
			switch( nCurSel )
			{
			case CARD_EMPTY:		// empty
				m_btnSetupCard[uId].EnableWindow(FALSE);
				return;
			case CARD_MOUSE_INTERFACE:		// mouse interface card
				m_pCards[uId] = new CMouseCard();
				break;
			case CARD_DISK_INTERFACE:		// apple disk ii interface card
				m_pCards[uId] = new CDiskInterface();
				break;
			case CARD_PHASOR:				// phasor/mocking board sound card
				m_pCards[uId] = new CPhasor();
				break;
			default:
				return;	// it must not occur
			}
		}
	}
	m_btnSetupCard[uId].EnableWindow(TRUE);
}

void CDlgConfigure::OnClickedSlotSetup(UINT uId) 
{
	if ( uId < IDC_SLOT1_SETUP || uId > IDC_SLOT7_SETUP )
		return;			// it must not occur
	uId -= IDC_SLOT1_SETUP;
	// m_pCards[uId]  NULL  Empty DisableǾ ־ Ѵ.
	if ( m_pCards[uId] == NULL )
	{
		m_btnSetupCard[uId].EnableWindow(FALSE);
		return;
	}
	m_pCards[uId]->Configure();
}

BOOL CDlgConfigure::OnInitDialog() 
{
	int i;
	int nKeyDelay, nKeyRepeat;
	BOOL bIsPowerOn;
//	CEdit* pComboEdit;

	CDialog::OnInitDialog();

	bIsPowerOn = g_pBoard->GetIsActive();
	for( i = 0; i < 7; i++ )
	{
		m_pCards[i] = g_pBoard->m_cSlots.GetCard(i);
		if ( m_pCards[i] != NULL )
		{
			m_cbSlot[i].SetCurSel( m_pCards[i]->GetDeviceNum() );
			m_btnSetupCard[i].EnableWindow(TRUE);
		}
		else
		{
			m_cbSlot[i].SetCurSel(CARD_EMPTY);
			m_btnSetupCard[i].EnableWindow(FALSE);
		}
		m_cbSlot[i].EnableWindow( !bIsPowerOn );
		/*
		if ( bIsPowerOn )
		{
			pComboEdit = (CEdit*)(GetDlgItem( IDC_SLOT1 + i )->GetWindow(GW_CHILD ));
			pComboEdit->EnableWindow(TRUE);
			pComboEdit->SetReadOnly();
		}
		*/
	}
	m_btnMachine[1].SetCheck(BST_CHECKED);
	for( i = 0; i < 3; i++ )
		m_btnMachine[i].EnableWindow(FALSE);
	// keyboard

	g_cDIKeyboard.GetDelayTime( &nKeyRepeat, &nKeyDelay );
	m_sbKeyRepeat.SetRange( nKeyRepeat, 15, 100 );
	m_sbKeyDelay.SetRange(  nKeyDelay, 250, 1000 );


	// Joystick
	i = g_pBoard->m_joystick.GetDevice();
	if ( !g_pBoard->m_joystick.m_bHasPCJoystick )
	{
		if ( i == JM_PCJOYSTICK )
			i = JM_KEYPAD;
		m_btnJoystick[JM_PCJOYSTICK].EnableWindow(FALSE);
	}
	m_btnJoystick[i].SetCheck(BST_CHECKED);


	// Master Volume
	m_slMasterVolume.SetRange( -31, -4, FALSE );
	m_slMasterVolume.SetTicFreq( 2 );
	m_slMasterVolume.SetPageSize( 4 );

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CDlgConfigure::OnOK() 
{
	// TODO: Add extra validation here
	int i;
	for( i = 0; i < 7; i++ )
	{
		if ( m_pCards[i] != g_pBoard->m_cSlots.GetCard(i) )
		{
			g_pBoard->m_cSlots.RemoveCard(i);
			g_pBoard->m_cSlots.InsertCard(i, m_pCards[i]);
		}
	}
	g_pBoard->m_cSlots.Initialize();
	// keyboard
	g_cDIKeyboard.SetDelayTime( m_sbKeyRepeat.GetPos(), m_sbKeyDelay.GetPos() );

	// joystick
	for ( i = 0; i < 3; i++ )
	{
		if ( m_btnJoystick[i].GetCheck() == BST_CHECKED )
		{
			g_pBoard->m_joystick.ChangeDevice( i );
			break;
		}
	}
	CDialog::OnOK();
}

void CDlgConfigure::OnCancel() 
{
	// TODO: Add extra cleanup here
	int i;
	for( i = 0; i < 7; i++ )
	{
		//  ߴ ī ߿     Ѵ.
		if ( m_pCards[i] != NULL && m_pCards[i] != g_pBoard->m_cSlots.GetCard(i) )
		{
			delete m_pCards[i];
			m_pCards[i] = NULL;		// not necessary but...
		}
	}
	
	CDialog::OnCancel();
}

