/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.adaptor.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.adaptor.core.AbstractBundleData;
import org.eclipse.osgi.framework.adaptor.core.AbstractFrameworkAdaptor;
import org.eclipse.osgi.framework.adaptor.core.AdaptorMsg;
import org.eclipse.osgi.framework.adaptor.core.BundleEntry;
import org.eclipse.osgi.framework.adaptor.core.BundleFile;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.util.Headers;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class SystemBundleData
extends AbstractBundleData {
    public static final String OSGI_FRAMEWORK = "osgi.framework";

    public SystemBundleData(AbstractFrameworkAdaptor adaptor) throws BundleException {
        super(adaptor, 0L);
        File osgiBase = this.getOsgiBase();
        this.createBundleFile(osgiBase);
        this.manifest = this.createManifest(osgiBase);
        this.setMetaData();
        this.setLastModified(System.currentTimeMillis());
    }

    private File getOsgiBase() {
        String frameworkLocation = System.getProperty(OSGI_FRAMEWORK);
        if (frameworkLocation != null) {
            return new File(frameworkLocation.substring(5));
        }
        frameworkLocation = System.getProperty("user.dir");
        if (frameworkLocation != null) {
            return new File(frameworkLocation);
        }
        return null;
    }

    private Headers createManifest(File osgiBase) throws BundleException {
        InputStream in = null;
        if (osgiBase != null && osgiBase.exists()) {
            try {
                in = this.baseBundleFile.getEntry("META-INF/MANIFEST.MF").getInputStream();
            }
            catch (IOException iOException) {}
        }
        if (in == null) {
            in = this.getClass().getResourceAsStream("/META-INF/SYSTEMBUNDLE.MF");
        }
        if (Debug.DEBUG_GENERAL && in == null) {
            Debug.println("Unable to find system bundle manifest /META-INF/SYSTEMBUNDLE.MF");
        }
        if (in == null) {
            throw new BundleException(AdaptorMsg.formatter.getString("SYSTEMBUNDLE_MISSING_MANIFEST"));
        }
        Headers systemManifest = Headers.parseManifest(in);
        String systemExportProp = System.getProperty("org.osgi.framework.system.packages");
        if (systemExportProp != null) {
            this.appendManifestValue(systemManifest, "Export-Package", systemExportProp);
        }
        if ((systemExportProp = System.getProperty("osgi.framework.systempackages")) != null) {
            this.appendManifestValue(systemManifest, "Export-Package", systemExportProp);
        }
        String exportPackages = this.adaptor.getExportPackages();
        String exportServices = this.adaptor.getExportServices();
        String providePackages = this.adaptor.getProvidePackages();
        if (exportPackages != null) {
            this.appendManifestValue(systemManifest, "Export-Package", exportPackages);
        }
        if (exportServices != null) {
            this.appendManifestValue(systemManifest, "Export-Service", exportServices);
        }
        if (providePackages != null) {
            this.appendManifestValue(systemManifest, "Provide-Package", providePackages);
        }
        return systemManifest;
    }

    private void appendManifestValue(Headers systemManifest, String header, String append) {
        String newValue = (String)systemManifest.get(header);
        newValue = newValue == null ? append : String.valueOf(newValue) + "," + append;
        systemManifest.set(header, null);
        systemManifest.set(header, newValue);
    }

    private void createBundleFile(File osgiBase) {
        if (osgiBase != null) {
            try {
                this.baseBundleFile = this.adaptor.createBundleFile(osgiBase, this);
            }
            catch (IOException iOException) {}
        } else {
            this.baseBundleFile = new BundleFile(osgiBase){

                public File getFile(String path) {
                    return null;
                }

                public BundleEntry getEntry(String path) {
                    return null;
                }

                public Enumeration getEntryPaths(String path) {
                    return null;
                }

                public void close() throws IOException {
                }

                public void open() throws IOException {
                }

                public boolean containsDir(String dir) {
                    return false;
                }
            };
        }
    }

    private void setMetaData() {
        this.setActivator((String)this.manifest.get("Bundle-Activator"));
        this.setClassPathString((String)this.manifest.get("Bundle-ClassPath"));
        this.setDynamicImports((String)this.manifest.get("DynamicImport-Package"));
        this.setExecutionEnvironment((String)this.manifest.get("Bundle-RequiredExecutionEnvironment"));
        this.setLocation("System Bundle");
        this.setSymbolicName(AbstractBundleData.parseSymbolicName(this.manifest));
        String sVersion = (String)this.manifest.get("Bundle-Version");
        if (sVersion != null) {
            this.setVersion(Version.parseVersion(sVersion));
        }
    }

    public BundleClassLoader createClassLoader(ClassLoaderDelegate delegate, BundleProtectionDomain domain, String[] bundleclasspath) {
        return null;
    }

    public File createGenerationDir() {
        return null;
    }

    public String findLibrary(String libname) {
        return null;
    }

    public void installNativeCode(String[] nativepaths) throws BundleException {
    }

    public File getDataFile(String path) {
        return null;
    }

    public int getStartLevel() {
        return 0;
    }

    public int getStatus() {
        return 0;
    }

    public void close() throws IOException {
    }

    public void open() throws IOException {
    }

    public void save() throws IOException {
    }
}

