/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public class BundleFragment
extends AbstractBundle {
    protected BundleLoaderProxy[] hosts = null;

    public BundleFragment(BundleData bundledata, Framework framework) throws BundleException {
        super(bundledata, framework);
    }

    protected void load() throws BundleException {
        if (Debug.DEBUG_GENERAL && (this.state & 2) == 0) {
            Debug.println("Bundle.load called when state != INSTALLED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        if (this.framework.isActive()) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                this.domain = this.framework.permissionAdmin.createProtectionDomain(this);
            }
            try {
                this.bundledata.open();
            }
            catch (IOException e) {
                throw new BundleException(Msg.formatter.getString("BUNDLE_READ_EXCEPTION"), e);
            }
        }
    }

    protected boolean reload(AbstractBundle newBundle) throws BundleException {
        if (Debug.DEBUG_GENERAL && (this.state & 6) == 0) {
            Debug.println("Bundle.reload called when state != INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        boolean exporting = false;
        if (this.framework.isActive()) {
            if (this.hosts != null && this.state == 4) {
                exporting = true;
                this.hosts = null;
                this.state = 2;
            }
        } else {
            try {
                this.bundledata.close();
            }
            catch (IOException iOException) {}
        }
        if (!exporting) {
            try {
                this.bundledata.close();
            }
            catch (IOException iOException) {}
        }
        this.bundledata = newBundle.bundledata;
        this.bundledata.setBundle(this);
        if (this.framework.isActive() && System.getSecurityManager() != null) {
            this.domain = this.framework.permissionAdmin.createProtectionDomain(this);
        }
        return exporting;
    }

    protected void refresh() throws BundleException {
        if (Debug.DEBUG_GENERAL && (this.state & 7) == 0) {
            Debug.println("Bundle.refresh called when state != UNINSTALLED | INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        if (this.state == 4) {
            this.hosts = null;
            this.state = 2;
        }
        this.manifestLocalization = null;
    }

    protected boolean unload() {
        if (Debug.DEBUG_GENERAL && (this.state & 7) == 0) {
            Debug.println("Bundle.unload called when state != UNINSTALLED | INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        boolean exporting = false;
        if (this.framework.isActive() && this.hosts != null) {
            if (this.state == 4) {
                exporting = true;
                this.hosts = null;
                this.state = 2;
            }
            this.domain = null;
        }
        if (!exporting) {
            try {
                this.bundledata.close();
            }
            catch (IOException iOException) {}
        }
        return exporting;
    }

    protected Class loadClass(String name, boolean checkPermission) throws ClassNotFoundException {
        if (checkPermission) {
            try {
                this.framework.checkAdminPermission(this, "class");
            }
            catch (SecurityException securityException) {
                throw new ClassNotFoundException();
            }
            this.checkValid();
        }
        throw new ClassNotFoundException(Msg.formatter.getString("BUNDLE_FRAGMENT_CNFE", name));
    }

    public URL getResource(String name) {
        this.checkValid();
        return null;
    }

    public Enumeration getResources(String name) {
        this.checkValid();
        return null;
    }

    protected void startWorker(boolean persistent) throws BundleException {
        throw new BundleException(Msg.formatter.getString("BUNDLE_FRAGMENT_START", this));
    }

    protected void stopWorker(boolean persistent) throws BundleException {
        throw new BundleException(Msg.formatter.getString("BUNDLE_FRAGMENT_STOP", this));
    }

    public ServiceReference[] getRegisteredServices() {
        this.checkValid();
        return null;
    }

    public ServiceReference[] getServicesInUse() {
        this.checkValid();
        return null;
    }

    protected BundleLoaderProxy[] getHosts() {
        return this.hosts;
    }

    protected boolean isFragment() {
        return true;
    }

    protected boolean addHost(BundleLoaderProxy host) {
        if (host != null) {
            try {
                ((BundleHost)host.getBundleHost()).attachFragment(this);
            }
            catch (BundleException be) {
                this.framework.publishFrameworkEvent(2, host.getBundleHost(), be);
                return false;
            }
        }
        if (this.hosts == null) {
            this.hosts = new BundleLoaderProxy[]{host};
            return true;
        }
        int i = 0;
        while (i < this.hosts.length) {
            if (host.getBundleHost() == this.hosts[i].getBundleHost()) {
                return true;
            }
            ++i;
        }
        BundleLoaderProxy[] newHosts = new BundleLoaderProxy[this.hosts.length + 1];
        System.arraycopy(this.hosts, 0, newHosts, 0, this.hosts.length);
        newHosts[newHosts.length - 1] = host;
        return true;
    }

    protected BundleLoader getBundleLoader() {
        return null;
    }

    protected BundleContextImpl getContext() {
        return null;
    }
}

