/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.VersionRange;

public class ImportPackageSpecificationImpl
extends VersionConstraintImpl
implements ImportPackageSpecification {
    private static final String ALL_PACKAGES = "*";
    private String[] propagate;
    private int resolution = 1;
    private String symbolicName;
    private VersionRange bundleVersionRange;
    private Map attributes;

    public String[] getPropagate() {
        return this.propagate;
    }

    public int getResolution() {
        return this.resolution;
    }

    public String getBundleSymbolicName() {
        return this.symbolicName;
    }

    public VersionRange getBundleVersionRange() {
        if (this.bundleVersionRange == null) {
            return VersionRange.emptyRange;
        }
        return this.bundleVersionRange;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public boolean isSatisfiedBy(BaseDescription supplier) {
        String[] mandatory;
        String name;
        if (!(supplier instanceof ExportPackageDescription)) {
            return false;
        }
        ExportPackageDescription pkgDes = (ExportPackageDescription)supplier;
        boolean matchName = false;
        if (this.symbolicName != null) {
            BundleDescription exporter = pkgDes.getExporter();
            if (!this.symbolicName.equals(exporter.getSymbolicName())) {
                return false;
            }
            if (this.getBundleVersionRange() != null && !this.getBundleVersionRange().isIncluded(exporter.getVersion())) {
                return false;
            }
        }
        if (ALL_PACKAGES.equals(name = this.getName()) || ALL_PACKAGES.equals(pkgDes.getName())) {
            matchName = true;
        } else if (name.endsWith(".*")) {
            if (pkgDes.getName().startsWith(name.substring(0, name.length() - 1))) {
                matchName = true;
            }
        } else if (pkgDes.getName().equals(name)) {
            matchName = true;
        } else if (pkgDes.getName().endsWith(".*") && name.startsWith(pkgDes.getName().substring(0, name.length() - 1))) {
            matchName = true;
        }
        if (!matchName) {
            return false;
        }
        if (this.getVersionRange() != null && !this.getVersionRange().isIncluded(pkgDes.getVersion())) {
            return false;
        }
        Map importAttrs = this.getAttributes();
        if (importAttrs != null) {
            Map exportAttrs = pkgDes.getAttributes();
            if (exportAttrs == null) {
                return false;
            }
            Iterator i = importAttrs.keySet().iterator();
            while (i.hasNext()) {
                String importKey = (String)i.next();
                String importValue = (String)importAttrs.get(importKey);
                String exportValue = (String)exportAttrs.get(importKey);
                if (exportValue != null && importValue.equals(exportValue)) continue;
                return false;
            }
        }
        if ((mandatory = pkgDes.getMandatory()) != null) {
            int i = 0;
            while (i < mandatory.length) {
                if ("bundle-symbolic-name".equals(mandatory[i])) {
                    if (this.symbolicName == null) {
                        return false;
                    }
                } else if ("bundle-version".equals(mandatory[i])) {
                    if (this.bundleVersionRange == null) {
                        return false;
                    }
                } else if ("specification-version".equals(mandatory[i])) {
                    if (this.getVersionRange() == null) {
                        return false;
                    }
                } else {
                    if (importAttrs == null) {
                        return false;
                    }
                    if (importAttrs.get(mandatory[i]) == null) {
                        return false;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    protected void setPropagate(String[] propagate) {
        this.propagate = propagate;
    }

    protected void setBundleSymbolicName(String symbolicName) {
        this.symbolicName = symbolicName;
    }

    protected void setBundleVersionRange(VersionRange bundleVersionRange) {
        this.bundleVersionRange = bundleVersionRange;
    }

    protected void setResolution(int resolution) {
        this.resolution = resolution;
    }

    protected void setAttributes(Map attributes) {
        this.attributes = attributes;
    }

    public String toString() {
        return "Import-Package: " + this.getName() + " - version: " + this.getVersionRange();
    }
}

