/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.util;

import java.lang.reflect.Field;
import org.eclipse.osgi.framework.internal.core.MessageResourceBundle;
import org.eclipse.osgi.framework.msg.MessageFormat;

public abstract class NLS {
    public static boolean DEBUG_MESSAGE_BUNDLES = false;

    protected NLS() {
    }

    public static String bind(String message, Object binding) {
        return NLS.bind(message, new Object[]{binding});
    }

    public static String bind(String message, Object binding1, Object binding2) {
        return NLS.bind(message, new Object[]{binding1, binding2});
    }

    public static String bind(String message, Object[] bindings) {
        if (message == null) {
            return "No message available";
        }
        if (bindings == null) {
            return message;
        }
        return MessageFormat.format(message, bindings);
    }

    public static void initializeMessages(String bundleName, Class clazz) {
        long start = System.currentTimeMillis();
        Field[] fields = clazz.getDeclaredFields();
        MessageResourceBundle.load(bundleName, clazz.getClassLoader(), fields);
        int numFields = fields.length;
        int i = 0;
        while (i < numFields) {
            Field field = fields[i];
            if ((field.getModifiers() & 0x19) == 9) {
                try {
                    if (field.get(clazz) == null) {
                        String value = "Missing message: " + field.getName() + " in: " + bundleName;
                        if (DEBUG_MESSAGE_BUNDLES) {
                            System.out.println(value);
                        }
                        field.set(null, value);
                    }
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        if (DEBUG_MESSAGE_BUNDLES) {
            System.out.println("Time to load message bundle: " + bundleName + " was " + (System.currentTimeMillis() - start) + "ms.");
        }
    }
}

