/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine;

import com.sun.speech.engine.SpeechEventDispatcher;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.security.AccessControlException;
import javax.speech.SpeechEvent;

public class SpeechEventUtilities {
    protected static boolean awtRunning = false;
    protected static EventQueue systemEventQueue = null;
    protected static SpeechAWTEventTarget speechAWTEventTarget = null;
    public static boolean waitUntilDispatched = false;

    protected static boolean isAWTRunning() {
        if (awtRunning) {
            return true;
        }
        try {
            ThreadGroup g;
            ThreadGroup rootGroup = g = Thread.currentThread().getThreadGroup();
            for (ThreadGroup parent = rootGroup.getParent(); parent != null; parent = parent.getParent()) {
                rootGroup = parent;
            }
            int activeCount = rootGroup.activeCount();
            Thread[] threads = new Thread[activeCount];
            rootGroup.enumerate(threads, true);
            for (int i = 0; i < threads.length; ++i) {
                String name;
                if (threads[i] == null || !(name = threads[i].getName()).startsWith("AWT-EventQueue")) continue;
                awtRunning = true;
                return true;
            }
        }
        catch (AccessControlException ace) {
            return true;
        }
        return false;
    }

    public static void postSpeechEvent(SpeechEventDispatcher dispatcher, SpeechEvent event) {
        SpeechEventUtilities.postSpeechEvent(dispatcher, event, waitUntilDispatched);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void postSpeechEvent(SpeechEventDispatcher dispatcher, SpeechEvent event, boolean waitUntilDispatched) {
        if (SpeechEventUtilities.isAWTRunning()) {
            if (speechAWTEventTarget == null) {
                speechAWTEventTarget = new SpeechAWTEventTarget();
                systemEventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            }
            if (waitUntilDispatched) {
                Object lock;
                Object object = lock = new Object();
                synchronized (object) {
                    systemEventQueue.postEvent(new SpeechAWTEvent(speechAWTEventTarget, dispatcher, event, lock));
                    try {
                        lock.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            systemEventQueue.postEvent(new SpeechAWTEvent(speechAWTEventTarget, dispatcher, event));
        } else {
            dispatcher.dispatchSpeechEvent(event);
        }
    }

    protected static class SpeechAWTEvent
    extends AWTEvent {
        static final int EVENT_ID = 16829;
        SpeechEventDispatcher dispatcher = null;
        SpeechEvent event = null;
        Object lock = null;

        SpeechAWTEvent(SpeechAWTEventTarget target, SpeechEventDispatcher dispatcher, SpeechEvent event) {
            this(target, dispatcher, event, null);
        }

        SpeechAWTEvent(SpeechAWTEventTarget target, SpeechEventDispatcher dispatcher, SpeechEvent event, Object lock) {
            super(target, 16829);
            this.dispatcher = dispatcher;
            this.event = event;
            this.lock = lock;
        }
    }

    protected static class SpeechAWTEventTarget
    extends Component {
        SpeechAWTEventTarget() {
            this.enableEvents(16829L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processEvent(AWTEvent event) {
            if (event instanceof SpeechAWTEvent) {
                SpeechAWTEvent sae = (SpeechAWTEvent)event;
                sae.dispatcher.dispatchSpeechEvent(sae.event);
                if (sae.lock != null) {
                    Object object = sae.lock;
                    synchronized (object) {
                        sae.lock.notify();
                    }
                }
            }
        }
    }
}

