/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.bindings.keys.formatting;

import java.util.Comparator;
import java.util.HashMap;
import java.util.ResourceBundle;
import org.eclipse.jface.bindings.keys.CharacterKey;
import org.eclipse.jface.bindings.keys.Key;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ModifierKey;
import org.eclipse.jface.bindings.keys.SpecialKey;
import org.eclipse.jface.bindings.keys.formatting.AbstractKeyFormatter;
import org.eclipse.jface.bindings.keys.formatting.NativeModifierKeyComparator;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.SWT;

public class NativeKeyFormatter
extends AbstractKeyFormatter {
    private static final String CARBON_KEY_DELIMITER_KEY = "CARBON_KEY_DELIMITER";
    private static final HashMap CARBON_KEY_LOOK_UP = new HashMap();
    private static final Comparator MODIFIER_KEY_COMPARATOR = new NativeModifierKeyComparator();
    private static final ResourceBundle RESOURCE_BUNDLE;
    private static final String WIN32_KEY_STROKE_DELIMITER_KEY = "WIN32_KEY_STROKE_DELIMITER";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.bindings.keys.formatting.NativeKeyFormatter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RESOURCE_BUNDLE = ResourceBundle.getBundle(clazz.getName());
        CARBON_KEY_LOOK_UP.put(CharacterKey.BS.toString(), Character.toString('\u232b'));
        CARBON_KEY_LOOK_UP.put(CharacterKey.CR.toString(), Character.toString('\u21a9'));
        CARBON_KEY_LOOK_UP.put(CharacterKey.DEL.toString(), Character.toString('\u2326'));
        CARBON_KEY_LOOK_UP.put(CharacterKey.SPACE.toString(), Character.toString('\u2423'));
        CARBON_KEY_LOOK_UP.put(ModifierKey.ALT.toString(), Character.toString('\u2325'));
        CARBON_KEY_LOOK_UP.put(ModifierKey.COMMAND.toString(), Character.toString('\u2318'));
        CARBON_KEY_LOOK_UP.put(ModifierKey.CTRL.toString(), Character.toString('\u2303'));
        CARBON_KEY_LOOK_UP.put(ModifierKey.SHIFT.toString(), Character.toString('\u21e7'));
        CARBON_KEY_LOOK_UP.put(SpecialKey.ARROW_DOWN.toString(), Character.toString('\u2193'));
        CARBON_KEY_LOOK_UP.put(SpecialKey.ARROW_LEFT.toString(), Character.toString('\u2190'));
        CARBON_KEY_LOOK_UP.put(SpecialKey.ARROW_RIGHT.toString(), Character.toString('\u2192'));
        CARBON_KEY_LOOK_UP.put(SpecialKey.ARROW_UP.toString(), Character.toString('\u2191'));
        CARBON_KEY_LOOK_UP.put(SpecialKey.END.toString(), Character.toString('\u2198'));
        CARBON_KEY_LOOK_UP.put(SpecialKey.NUMPAD_ENTER.toString(), Character.toString('\u2324'));
        CARBON_KEY_LOOK_UP.put(SpecialKey.HOME.toString(), Character.toString('\u2196'));
        CARBON_KEY_LOOK_UP.put(SpecialKey.PAGE_DOWN.toString(), Character.toString('\u21df'));
        CARBON_KEY_LOOK_UP.put(SpecialKey.PAGE_UP.toString(), Character.toString('\u21de'));
    }

    public String format(Key key) {
        String formattedName;
        String name = key.toString();
        if ("carbon".equals(SWT.getPlatform()) && (formattedName = (String)CARBON_KEY_LOOK_UP.get(name)) != null) {
            return formattedName;
        }
        return super.format(key);
    }

    protected String getKeyDelimiter() {
        if ("carbon".equals(SWT.getPlatform())) {
            return Util.translateString(RESOURCE_BUNDLE, CARBON_KEY_DELIMITER_KEY, "");
        }
        return Util.translateString(RESOURCE_BUNDLE, "KEY_DELIMITER", KeyStroke.KEY_DELIMITER);
    }

    protected String getKeyStrokeDelimiter() {
        if ("win32".equals(SWT.getPlatform())) {
            return Util.translateString(RESOURCE_BUNDLE, WIN32_KEY_STROKE_DELIMITER_KEY, KeySequence.KEY_STROKE_DELIMITER);
        }
        return Util.translateString(RESOURCE_BUNDLE, "KEY_STROKE_DELIMITER", KeySequence.KEY_STROKE_DELIMITER);
    }

    protected Comparator getModifierKeyComparator() {
        return MODIFIER_KEY_COMPARATOR;
    }
}

