/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.Serializable;
import java.util.ArrayList;

public class Explanation
implements Serializable {
    private float value;
    private String description;
    private ArrayList details;

    public Explanation() {
    }

    public Explanation(float value, String description) {
        this.value = value;
        this.description = description;
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Explanation[] getDetails() {
        if (this.details == null) {
            return null;
        }
        return this.details.toArray(new Explanation[0]);
    }

    public void addDetail(Explanation detail) {
        if (this.details == null) {
            this.details = new ArrayList();
        }
        this.details.add(detail);
    }

    public String toString() {
        return this.toString(0);
    }

    private String toString(int depth) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < depth) {
            buffer.append("  ");
            ++i;
        }
        buffer.append(this.getValue());
        buffer.append(" = ");
        buffer.append(this.getDescription());
        buffer.append("\n");
        Explanation[] details = this.getDetails();
        if (details != null) {
            int i2 = 0;
            while (i2 < details.length) {
                buffer.append(details[i2].toString(depth + 1));
                ++i2;
            }
        }
        return buffer.toString();
    }

    public String toHtml() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<ul>\n");
        buffer.append("<li>");
        buffer.append(this.getValue());
        buffer.append(" = ");
        buffer.append(this.getDescription());
        buffer.append("</li>\n");
        Explanation[] details = this.getDetails();
        if (details != null) {
            int i = 0;
            while (i < details.length) {
                buffer.append(details[i].toHtml());
                ++i;
            }
        }
        buffer.append("</ul>\n");
        return buffer.toString();
    }
}

