/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;

public class TextTransfer
extends ByteArrayTransfer {
    private static TextTransfer _instance = new TextTransfer();
    private static final String COMPOUND_TEXT = "COMPOUND_TEXT";
    private static final String STRING = "STRING";
    private static final int COMPOUND_TEXT_ID = Transfer.registerType("COMPOUND_TEXT");
    private static final int STRING_ID = Transfer.registerType("STRING");

    private TextTransfer() {
    }

    public static TextTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        transferData.result = 0;
        if (!this.checkText(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String string = (String)object;
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        if (transferData.type == COMPOUND_TEXT_ID) {
            int[] encoding = new int[1];
            int[] format = new int[1];
            int[] ctext = new int[1];
            int[] length = new int[1];
            boolean result = OS.gdk_utf8_to_compound_text((byte[])buffer, (int[])encoding, (int[])format, (int[])ctext, (int[])length);
            if (!result) {
                return;
            }
            transferData.type = encoding[0];
            transferData.format = format[0];
            transferData.length = length[0];
            transferData.pValue = ctext[0];
            transferData.result = 1;
        }
        if (transferData.type == STRING_ID) {
            int pValue = OS.g_malloc((int)buffer.length);
            if (pValue == 0) {
                return;
            }
            OS.memmove((int)pValue, (byte[])buffer, (int)buffer.length);
            transferData.type = STRING_ID;
            transferData.format = 8;
            transferData.length = buffer.length - 1;
            transferData.pValue = pValue;
            transferData.result = 1;
        }
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pValue == 0) {
            return null;
        }
        byte[] buffer = null;
        if (transferData.type == COMPOUND_TEXT_ID) {
            int[] list = new int[1];
            int count = OS.gdk_text_property_to_utf8_list((int)transferData.type, (int)transferData.format, (int)transferData.pValue, (int)transferData.length, (int[])list);
            if (count == 0) {
                return null;
            }
            int[] ptr = new int[1];
            OS.memmove((int[])ptr, (int)list[0], (int)OS.PTR_SIZEOF);
            int length = OS.strlen((int)ptr[0]);
            buffer = new byte[length];
            OS.memmove((byte[])buffer, (int)ptr[0], (int)length);
            OS.g_strfreev((int)list[0]);
        }
        if (transferData.type == STRING_ID) {
            int size = transferData.format * transferData.length / 8;
            if (size == 0) {
                return null;
            }
            buffer = new byte[size];
            OS.memmove((byte[])buffer, (int)transferData.pValue, (int)size);
        }
        if (buffer == null) {
            return null;
        }
        char[] unicode = Converter.mbcsToWcs(null, buffer);
        String string = new String(unicode);
        int end = string.indexOf(0);
        return end == -1 ? string : string.substring(0, end);
    }

    protected int[] getTypeIds() {
        return new int[]{COMPOUND_TEXT_ID, STRING_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{COMPOUND_TEXT, STRING};
    }

    boolean checkText(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected boolean validate(Object object) {
        return this.checkText(object);
    }
}

