/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.cairo.cairo_font_extents_t;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkGCValues;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoAttribute;

public final class GC {
    public int handle;
    Drawable drawable;
    GCData data;

    GC() {
    }

    public GC(Drawable drawable) {
        this(drawable, 0);
    }

    public GC(Drawable drawable, int style) {
        if (drawable == null) {
            SWT.error(4);
        }
        GCData data = new GCData();
        data.style = GC.checkStyle(style);
        int gdkGC = drawable.internal_new_GC(data);
        Device device = data.device;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        data.device = device;
        this.init(drawable, data, gdkGC);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    static int checkStyle(int style) {
        if ((style & 0x2000000) != 0) {
            style &= 0xFBFFFFFF;
        }
        return style & 0x6000000;
    }

    public static GC gtk_new(Drawable drawable, GCData data) {
        GC gc = new GC();
        int gdkGC = drawable.internal_new_GC(data);
        gc.init(drawable, data, gdkGC);
        return gc;
    }

    public void copyArea(Image image, int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.type != 0 || image.isDisposed()) {
            SWT.error(5);
        }
        Rectangle rect = image.getBounds();
        int gdkGC = OS.gdk_gc_new((int)image.pixmap);
        if (gdkGC == 0) {
            SWT.error(2);
        }
        OS.gdk_gc_set_subwindow((int)gdkGC, (int)1);
        OS.gdk_draw_drawable((int)image.pixmap, (int)gdkGC, (int)this.data.drawable, (int)x, (int)y, (int)0, (int)0, (int)rect.width, (int)rect.height);
        OS.g_object_unref((int)gdkGC);
    }

    public void copyArea(int srcX, int srcY, int width, int height, int destX, int destY) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        int deltaX = destX - srcX;
        int deltaY = destY - srcY;
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        int drawable = this.data.drawable;
        OS.gdk_gc_set_exposures((int)this.handle, (boolean)true);
        OS.gdk_draw_drawable((int)drawable, (int)this.handle, (int)drawable, (int)srcX, (int)srcY, (int)destX, (int)destY, (int)width, (int)height);
        OS.gdk_gc_set_exposures((int)this.handle, (boolean)false);
        if (this.data.image != null) {
            return;
        }
        boolean disjoint = destX + width < srcX || srcX + width < destX || destY + height < srcY || srcY + height < destY;
        GdkRectangle rect = new GdkRectangle();
        if (disjoint) {
            rect.x = srcX;
            rect.y = srcY;
            rect.width = width;
            rect.height = height;
            OS.gdk_window_invalidate_rect((int)drawable, (GdkRectangle)rect, (boolean)false);
        } else {
            if (deltaX != 0) {
                int newX = destX - deltaX;
                if (deltaX < 0) {
                    newX = destX + width;
                }
                rect.x = newX;
                rect.y = srcY;
                rect.width = Math.abs(deltaX);
                rect.height = height;
                OS.gdk_window_invalidate_rect((int)drawable, (GdkRectangle)rect, (boolean)false);
            }
            if (deltaY != 0) {
                int newY = destY - deltaY;
                if (deltaY < 0) {
                    newY = destY + height;
                }
                rect.x = srcX;
                rect.y = newY;
                rect.width = width;
                rect.height = Math.abs(deltaY);
                OS.gdk_window_invalidate_rect((int)drawable, (GdkRectangle)rect, (boolean)false);
            }
        }
    }

    public void dispose() {
        int layout;
        int context;
        Image image;
        int inverseMatrix;
        int matrix;
        if (this.handle == 0) {
            return;
        }
        if (this.data.device.isDisposed()) {
            return;
        }
        int cairo = this.data.cairo;
        if (cairo != 0) {
            Cairo.cairo_destroy((int)cairo);
        }
        if ((matrix = this.data.matrix) != 0) {
            Cairo.cairo_matrix_destroy((int)matrix);
        }
        if ((inverseMatrix = this.data.inverseMatrix) != 0) {
            Cairo.cairo_matrix_destroy((int)inverseMatrix);
        }
        this.data.inverseMatrix = 0;
        this.data.matrix = 0;
        this.data.cairo = 0;
        int clipRgn = this.data.clipRgn;
        if (clipRgn != 0) {
            OS.gdk_region_destroy((int)clipRgn);
        }
        if ((image = this.data.image) != null) {
            image.memGC = null;
            if (image.transparentPixel != -1) {
                image.createMask();
            }
        }
        if ((context = this.data.context) != 0) {
            OS.g_object_unref((int)context);
        }
        if ((layout = this.data.layout) != 0) {
            OS.g_object_unref((int)layout);
        }
        Device device = this.data.device;
        this.drawable.internal_dispose_GC(this.handle, this.data);
        this.data.clipRgn = 0;
        this.data.drawable = 0;
        this.data.context = 0;
        this.data.layout = 0;
        this.drawable = null;
        this.handle = 0;
        this.data.image = null;
        this.data.string = null;
        if (device.tracking) {
            device.dispose_Object(this);
        }
        this.data.device = null;
        this.data = null;
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        int cairo = this.data.cairo;
        if (cairo != 0) {
            Cairo.cairo_save((int)cairo);
            Cairo.cairo_translate((int)cairo, (double)((float)x + (float)width / 2.0f), (double)((float)y + (float)height / 2.0f));
            Cairo.cairo_scale((int)cairo, (double)((float)width / 2.0f), (double)((float)height / 2.0f));
            Cairo.cairo_set_line_width((int)cairo, (double)(Cairo.cairo_current_line_width((int)cairo) / (double)((float)width / 2.0f)));
            Cairo.cairo_arc_negative((int)cairo, (double)0.0, (double)0.0, (double)1.0, (double)((float)(-startAngle) * (float)Compatibility.PI / 180.0f), (double)((float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f));
            Cairo.cairo_stroke((int)cairo);
            Cairo.cairo_restore((int)cairo);
            return;
        }
        OS.gdk_draw_arc((int)this.data.drawable, (int)this.handle, (int)0, (int)x, (int)y, (int)width, (int)height, (int)(startAngle * 64), (int)(arcAngle * 64));
    }

    public void drawFocus(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int style = OS.gtk_widget_get_style((int)this.data.device.shellHandle);
        OS.gtk_paint_focus((int)style, (int)this.data.drawable, (int)0, null, (int)0, (byte[])new byte[1], (int)x, (int)y, (int)width, (int)height);
    }

    public void drawImage(Image image, int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, 0, 0, -1, -1, x, y, -1, -1, true);
    }

    public void drawImage(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (srcWidth == 0 || srcHeight == 0 || destWidth == 0 || destHeight == 0) {
            return;
        }
        if (srcX < 0 || srcY < 0 || srcWidth < 0 || srcHeight < 0 || destWidth < 0 || destHeight < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, false);
    }

    void drawImage(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        int[] width = new int[1];
        int[] height = new int[1];
        OS.gdk_drawable_get_size((int)srcImage.pixmap, (int[])width, (int[])height);
        int imgWidth = width[0];
        int imgHeight = height[0];
        if (simple) {
            srcWidth = destWidth = imgWidth;
            srcHeight = destHeight = imgHeight;
        } else {
            boolean bl = simple = srcX == 0 && srcY == 0 && srcWidth == destWidth && destWidth == imgWidth && srcHeight == destHeight && destHeight == imgHeight;
            if (srcX + srcWidth > imgWidth || srcY + srcHeight > imgHeight) {
                SWT.error(5);
            }
        }
        if (srcImage.alpha != -1 || srcImage.alphaData != null) {
            this.drawImageAlpha(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight);
        } else if (srcImage.transparentPixel != -1 || srcImage.mask != 0) {
            this.drawImageMask(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight);
        } else {
            this.drawImage(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight);
        }
    }

    void drawImage(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, int imgWidth, int imgHeight) {
        int cairo = this.data.cairo;
        if (cairo != 0) {
            if (srcImage.surface == 0) {
                int xDisplay = OS.GDK_DISPLAY();
                int xDrawable = OS.GDK_PIXMAP_XID((int)srcImage.pixmap);
                int xVisual = OS.gdk_x11_visual_get_xvisual((int)OS.gdk_visual_get_system());
                int xColormap = OS.gdk_x11_colormap_get_xcolormap((int)OS.gdk_colormap_get_system());
                srcImage.surface = Cairo.cairo_xlib_surface_create((int)xDisplay, (int)xDrawable, (int)xVisual, (int)0, (int)xColormap);
            }
            Cairo.cairo_save((int)cairo);
            Cairo.cairo_translate((int)cairo, (double)((double)(destX - srcX) + 0.5), (double)(destY - srcY));
            if (srcWidth != destWidth || srcHeight != destHeight) {
                Cairo.cairo_scale((int)cairo, (double)((float)destWidth / (float)srcWidth), (double)((float)destHeight / (float)srcHeight));
            }
            Cairo.cairo_show_surface((int)cairo, (int)srcImage.surface, (int)imgWidth, (int)imgHeight);
            Cairo.cairo_restore((int)cairo);
            return;
        }
        if (srcWidth == destWidth && srcHeight == destHeight) {
            OS.gdk_draw_drawable((int)this.data.drawable, (int)this.handle, (int)srcImage.pixmap, (int)srcX, (int)srcY, (int)destX, (int)destY, (int)destWidth, (int)destHeight);
        } else {
            int pixbuf = this.scale(srcImage.pixmap, srcX, srcY, srcWidth, srcHeight, destWidth, destHeight);
            if (pixbuf != 0) {
                OS.gdk_pixbuf_render_to_drawable((int)pixbuf, (int)this.data.drawable, (int)this.handle, (int)0, (int)0, (int)destX, (int)destY, (int)destWidth, (int)destHeight, (int)1, (int)0, (int)0);
                OS.g_object_unref((int)pixbuf);
            }
        }
    }

    void drawImageAlpha(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, int imgWidth, int imgHeight) {
        if (srcImage.alpha == 0) {
            return;
        }
        if (srcImage.alpha == 255) {
            this.drawImage(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight);
            return;
        }
        int pixbuf = OS.gdk_pixbuf_new((int)0, (boolean)true, (int)8, (int)srcWidth, (int)srcHeight);
        if (pixbuf == 0) {
            return;
        }
        int colormap = OS.gdk_colormap_get_system();
        OS.gdk_pixbuf_get_from_drawable((int)pixbuf, (int)srcImage.pixmap, (int)colormap, (int)srcX, (int)srcY, (int)0, (int)0, (int)srcWidth, (int)srcHeight);
        int stride = OS.gdk_pixbuf_get_rowstride((int)pixbuf);
        int pixels = OS.gdk_pixbuf_get_pixels((int)pixbuf);
        byte[] line = new byte[stride];
        byte alpha = (byte)srcImage.alpha;
        byte[] alphaData = srcImage.alphaData;
        int y = 0;
        while (y < srcHeight) {
            int alphaIndex = (y + srcY) * imgWidth + srcX;
            OS.memmove((byte[])line, (int)(pixels + y * stride), (int)stride);
            int x = 3;
            while (x < stride) {
                line[x] = alphaData == null ? alpha : alphaData[alphaIndex++];
                x += 4;
            }
            OS.memmove((int)(pixels + y * stride), (byte[])line, (int)stride);
            ++y;
        }
        if (srcWidth != destWidth || srcHeight != destHeight) {
            int scaledPixbuf = OS.gdk_pixbuf_scale_simple((int)pixbuf, (int)destWidth, (int)destHeight, (int)2);
            OS.g_object_unref((int)pixbuf);
            if (scaledPixbuf == 0) {
                return;
            }
            pixbuf = scaledPixbuf;
        }
        if (OS.GTK_VERSION >= OS.VERSION((int)2, (int)2, (int)0)) {
            OS.gdk_draw_pixbuf((int)this.data.drawable, (int)this.handle, (int)pixbuf, (int)0, (int)0, (int)destX, (int)destY, (int)destWidth, (int)destHeight, (int)1, (int)0, (int)0);
        } else {
            OS.gdk_pixbuf_render_to_drawable_alpha((int)pixbuf, (int)this.data.drawable, (int)0, (int)0, (int)destX, (int)destY, (int)destWidth, (int)destHeight, (int)0, (int)128, (int)1, (int)0, (int)0);
        }
        OS.g_object_unref((int)pixbuf);
    }

    void drawImageMask(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, int imgWidth, int imgHeight) {
        int newHeight;
        int newWidth;
        int bytesPerLine;
        byte[] maskData;
        int mask;
        int drawable = this.data.drawable;
        int colorPixmap = srcImage.pixmap;
        if (srcImage.transparentPixel != -1) {
            srcImage.createMask();
        }
        int maskPixmap = srcImage.mask;
        if (srcWidth != destWidth || srcHeight != destHeight) {
            int pixbuf = OS.gdk_pixbuf_new((int)0, (boolean)true, (int)8, (int)srcWidth, (int)srcHeight);
            if (pixbuf != 0) {
                int colormap = OS.gdk_colormap_get_system();
                OS.gdk_pixbuf_get_from_drawable((int)pixbuf, (int)colorPixmap, (int)colormap, (int)srcX, (int)srcY, (int)0, (int)0, (int)srcWidth, (int)srcHeight);
                int gdkImagePtr = OS.gdk_drawable_get_image((int)maskPixmap, (int)0, (int)0, (int)imgWidth, (int)imgHeight);
                if (gdkImagePtr != 0) {
                    int stride = OS.gdk_pixbuf_get_rowstride((int)pixbuf);
                    int pixels = OS.gdk_pixbuf_get_pixels((int)pixbuf);
                    byte[] line = new byte[stride];
                    int y = 0;
                    while (y < srcHeight) {
                        int offset = pixels + y * stride;
                        OS.memmove((byte[])line, (int)offset, (int)stride);
                        int x = 0;
                        while (x < srcWidth) {
                            if (OS.gdk_image_get_pixel((int)gdkImagePtr, (int)(x + srcX), (int)(y + srcY)) == 0) {
                                line[x * 4 + 3] = 0;
                            }
                            ++x;
                        }
                        OS.memmove((int)offset, (byte[])line, (int)stride);
                        ++y;
                    }
                    OS.g_object_unref((int)gdkImagePtr);
                    int scaledPixbuf = OS.gdk_pixbuf_scale_simple((int)pixbuf, (int)destWidth, (int)destHeight, (int)2);
                    if (scaledPixbuf != 0) {
                        int[] colorBuffer = new int[1];
                        int[] maskBuffer = new int[1];
                        OS.gdk_pixbuf_render_pixmap_and_mask((int)scaledPixbuf, (int[])colorBuffer, (int[])maskBuffer, (int)128);
                        colorPixmap = colorBuffer[0];
                        maskPixmap = maskBuffer[0];
                        OS.g_object_unref((int)scaledPixbuf);
                    }
                }
                OS.g_object_unref((int)pixbuf);
            }
            srcX = 0;
            srcY = 0;
            srcWidth = destWidth;
            srcHeight = destHeight;
        }
        if (this.data.clipRgn != 0 && (mask = OS.gdk_bitmap_create_from_data((int)0, (byte[])(maskData = new byte[(bytesPerLine = ((newWidth = srcX + srcWidth) + 7) / 8) * (newHeight = srcY + srcHeight)]), (int)newWidth, (int)newHeight)) != 0) {
            int gc = OS.gdk_gc_new((int)mask);
            OS.gdk_region_offset((int)this.data.clipRgn, (int)(-destX + srcX), (int)(-destY + srcY));
            OS.gdk_gc_set_clip_region((int)gc, (int)this.data.clipRgn);
            OS.gdk_region_offset((int)this.data.clipRgn, (int)(destX - srcX), (int)(destY - srcY));
            GdkColor color = new GdkColor();
            color.pixel = 1;
            OS.gdk_gc_set_foreground((int)gc, (GdkColor)color);
            OS.gdk_draw_rectangle((int)mask, (int)gc, (int)1, (int)0, (int)0, (int)newWidth, (int)newHeight);
            OS.gdk_gc_set_function((int)gc, (int)4);
            OS.gdk_draw_drawable((int)mask, (int)gc, (int)maskPixmap, (int)0, (int)0, (int)0, (int)0, (int)newWidth, (int)newHeight);
            OS.g_object_unref((int)gc);
            if (maskPixmap != 0 && srcImage.mask != maskPixmap) {
                OS.g_object_unref((int)maskPixmap);
            }
            maskPixmap = mask;
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
        OS.gdk_gc_set_clip_mask((int)this.handle, (int)maskPixmap);
        OS.gdk_gc_set_clip_origin((int)this.handle, (int)(destX - srcX), (int)(destY - srcY));
        OS.gdk_draw_drawable((int)drawable, (int)this.handle, (int)colorPixmap, (int)srcX, (int)srcY, (int)destX, (int)destY, (int)srcWidth, (int)srcHeight);
        OS.gdk_gc_set_values((int)this.handle, (GdkGCValues)values, (int)6272);
        if (this.data.clipRgn != 0) {
            OS.gdk_gc_set_clip_region((int)this.handle, (int)this.data.clipRgn);
        }
        if (colorPixmap != 0 && srcImage.pixmap != colorPixmap) {
            OS.g_object_unref((int)colorPixmap);
        }
        if (maskPixmap != 0 && srcImage.mask != maskPixmap) {
            OS.g_object_unref((int)maskPixmap);
        }
        if (srcImage.transparentPixel != -1 && srcImage.memGC != null) {
            srcImage.destroyMask();
        }
    }

    int scale(int src, int srcX, int srcY, int srcWidth, int srcHeight, int destWidth, int destHeight) {
        int pixbuf = OS.gdk_pixbuf_new((int)0, (boolean)false, (int)8, (int)srcWidth, (int)srcHeight);
        if (pixbuf == 0) {
            return 0;
        }
        int colormap = OS.gdk_colormap_get_system();
        OS.gdk_pixbuf_get_from_drawable((int)pixbuf, (int)src, (int)colormap, (int)srcX, (int)srcY, (int)0, (int)0, (int)srcWidth, (int)srcHeight);
        int scaledPixbuf = OS.gdk_pixbuf_scale_simple((int)pixbuf, (int)destWidth, (int)destHeight, (int)2);
        OS.g_object_unref((int)pixbuf);
        return scaledPixbuf;
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        int cairo;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((cairo = this.data.cairo) != 0) {
            Cairo.cairo_move_to((int)cairo, (double)x1, (double)y1);
            Cairo.cairo_line_to((int)cairo, (double)x2, (double)y2);
            Cairo.cairo_stroke((int)cairo);
            return;
        }
        OS.gdk_draw_line((int)this.data.drawable, (int)this.handle, (int)x1, (int)y1, (int)x2, (int)y2);
    }

    public void drawOval(int x, int y, int width, int height) {
        int cairo;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if ((cairo = this.data.cairo) != 0) {
            Cairo.cairo_save((int)cairo);
            Cairo.cairo_translate((int)cairo, (double)((float)x + (float)width / 2.0f), (double)((float)y + (float)height / 2.0f));
            Cairo.cairo_scale((int)cairo, (double)((float)width / 2.0f), (double)((float)height / 2.0f));
            Cairo.cairo_set_line_width((int)cairo, (double)(Cairo.cairo_current_line_width((int)cairo) / (double)((float)width / 2.0f)));
            Cairo.cairo_arc_negative((int)cairo, (double)0.0, (double)0.0, (double)1.0, (double)0.0, (double)(-2.0f * (float)Compatibility.PI));
            Cairo.cairo_stroke((int)cairo);
            Cairo.cairo_restore((int)cairo);
            return;
        }
        OS.gdk_draw_arc((int)this.data.drawable, (int)this.handle, (int)0, (int)x, (int)y, (int)width, (int)height, (int)0, (int)23040);
    }

    public void drawPath(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path.handle == 0) {
            SWT.error(5);
        }
        this.initCairo();
        Cairo.cairo_add_path((int)this.data.cairo, (int)path.handle);
        Cairo.cairo_stroke((int)this.data.cairo);
    }

    public void drawPoint(int x, int y) {
        int cairo;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((cairo = this.data.cairo) != 0) {
            Cairo.cairo_rectangle((int)cairo, (double)x, (double)y, (double)1.0, (double)1.0);
            Cairo.cairo_fill((int)cairo);
            return;
        }
        OS.gdk_draw_point((int)this.data.drawable, (int)this.handle, (int)x, (int)y);
    }

    public void drawPolygon(int[] pointArray) {
        int cairo;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        if ((cairo = this.data.cairo) != 0) {
            this.drawPolyline(cairo, pointArray, true);
            Cairo.cairo_stroke((int)cairo);
            return;
        }
        OS.gdk_draw_polygon((int)this.data.drawable, (int)this.handle, (int)0, (int[])pointArray, (int)(pointArray.length / 2));
    }

    public void drawPolyline(int[] pointArray) {
        int cairo;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        if ((cairo = this.data.cairo) != 0) {
            this.drawPolyline(cairo, pointArray, false);
            Cairo.cairo_stroke((int)cairo);
            return;
        }
        OS.gdk_draw_lines((int)this.data.drawable, (int)this.handle, (int[])pointArray, (int)(pointArray.length / 2));
    }

    void drawPolyline(int cairo, int[] pointArray, boolean close) {
        int count = pointArray.length / 2;
        if (count == 0) {
            return;
        }
        Cairo.cairo_move_to((int)cairo, (double)pointArray[0], (double)pointArray[1]);
        int i = 1;
        int j = 2;
        while (i < count) {
            Cairo.cairo_line_to((int)cairo, (double)pointArray[j], (double)pointArray[j + 1]);
            ++i;
            j += 2;
        }
        if (close) {
            Cairo.cairo_close_path((int)cairo);
        }
    }

    public void drawRectangle(int x, int y, int width, int height) {
        int cairo;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if ((cairo = this.data.cairo) != 0) {
            Cairo.cairo_rectangle((int)cairo, (double)x, (double)y, (double)width, (double)height);
            Cairo.cairo_stroke((int)cairo);
            return;
        }
        OS.gdk_draw_rectangle((int)this.data.drawable, (int)this.handle, (int)0, (int)x, (int)y, (int)width, (int)height);
    }

    public void drawRectangle(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        this.drawRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void drawRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        int cairo;
        if (this.handle == 0) {
            SWT.error(44);
        }
        int nx = x;
        int ny = y;
        int nw = width;
        int nh = height;
        int naw = arcWidth;
        int nah = arcHeight;
        if (nw < 0) {
            nw = 0 - nw;
            nx -= nw;
        }
        if (nh < 0) {
            nh = 0 - nh;
            ny -= nh;
        }
        if (naw < 0) {
            naw = 0 - naw;
        }
        if (nah < 0) {
            nah = 0 - nah;
        }
        if ((cairo = this.data.cairo) != 0) {
            float naw2 = (float)naw / 2.0f;
            float nah2 = (float)nah / 2.0f;
            float fw = (float)nw / naw2;
            float cfr_ignored_0 = (float)nh / nah2;
            Cairo.cairo_save((int)cairo);
            Cairo.cairo_translate((int)cairo, (double)nx, (double)ny);
            Cairo.cairo_scale((int)cairo, (double)naw2, (double)nah2);
            Cairo.cairo_move_to((int)cairo, (double)(fw - 1.0f), (double)0.0);
            Cairo.cairo_close_path((int)this.handle);
            Cairo.cairo_stroke((int)cairo);
            Cairo.cairo_restore((int)cairo);
            return;
        }
        int naw2 = naw / 2;
        int nah2 = nah / 2;
        int drawable = this.data.drawable;
        if (nw > naw) {
            if (nh > nah) {
                OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)0, (int)nx, (int)ny, (int)naw, (int)nah, (int)5760, (int)5760);
                OS.gdk_draw_line((int)drawable, (int)this.handle, (int)(nx + naw2), (int)ny, (int)(nx + nw - naw2), (int)ny);
                OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)0, (int)(nx + nw - naw), (int)ny, (int)naw, (int)nah, (int)0, (int)5760);
                OS.gdk_draw_line((int)drawable, (int)this.handle, (int)(nx + nw), (int)(ny + nah2), (int)(nx + nw), (int)(ny + nh - nah2));
                OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)0, (int)(nx + nw - naw), (int)(ny + nh - nah), (int)naw, (int)nah, (int)17280, (int)5760);
                OS.gdk_draw_line((int)drawable, (int)this.handle, (int)(nx + naw2), (int)(ny + nh), (int)(nx + nw - naw2), (int)(ny + nh));
                OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)0, (int)nx, (int)(ny + nh - nah), (int)naw, (int)nah, (int)11520, (int)5760);
                OS.gdk_draw_line((int)drawable, (int)this.handle, (int)nx, (int)(ny + nah2), (int)nx, (int)(ny + nh - nah2));
            } else {
                OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)0, (int)nx, (int)ny, (int)naw, (int)nh, (int)5760, (int)11520);
                OS.gdk_draw_line((int)drawable, (int)this.handle, (int)(nx + naw2), (int)ny, (int)(nx + nw - naw2), (int)ny);
                OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)0, (int)(nx + nw - naw), (int)ny, (int)naw, (int)nh, (int)17280, (int)11520);
                OS.gdk_draw_line((int)drawable, (int)this.handle, (int)(nx + naw2), (int)(ny + nh), (int)(nx + nw - naw2), (int)(ny + nh));
            }
        } else if (nh > nah) {
            OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)0, (int)nx, (int)ny, (int)nw, (int)nah, (int)0, (int)11520);
            OS.gdk_draw_line((int)drawable, (int)this.handle, (int)(nx + nw), (int)(ny + nah2), (int)(nx + nw), (int)(ny + nh - nah2));
            OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)0, (int)nx, (int)(ny + nh - nah), (int)nw, (int)nah, (int)11520, (int)11520);
            OS.gdk_draw_line((int)drawable, (int)this.handle, (int)nx, (int)(ny + nah2), (int)nx, (int)(ny + nh - nah2));
        } else {
            OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)0, (int)nx, (int)ny, (int)nw, (int)nh, (int)0, (int)23040);
        }
    }

    public void drawString(String string, int x, int y) {
        this.drawString(string, x, y, false);
    }

    public void drawString(String string, int x, int y, boolean isTransparent) {
        this.drawText(string, x, y, isTransparent ? 1 : 0);
    }

    public void drawText(String string, int x, int y) {
        this.drawText(string, x, y, 6);
    }

    public void drawText(String string, int x, int y, boolean isTransparent) {
        int flags = 6;
        if (isTransparent) {
            flags |= 1;
        }
        this.drawText(string, x, y, flags);
    }

    public void drawText(String string, int x, int y, int flags) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return;
        }
        int cairo = this.data.cairo;
        if (cairo != 0) {
            cairo_font_extents_t extents = new cairo_font_extents_t();
            Cairo.cairo_current_font_extents((int)cairo, (cairo_font_extents_t)extents);
            double baseline = (float)y + extents.ascent;
            Cairo.cairo_move_to((int)cairo, (double)x, (double)baseline);
            byte[] buffer = Converter.wcsToMbcs(null, string, true);
            Cairo.cairo_text_path((int)cairo, (byte[])buffer);
            Cairo.cairo_fill((int)cairo);
            return;
        }
        this.setString(string, flags);
        GdkColor background = null;
        GdkGCValues values = null;
        if ((flags & 1) == 0) {
            values = new GdkGCValues();
            OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
            background = new GdkColor();
            background.pixel = values.background_pixel;
            int colormap = OS.gdk_colormap_get_system();
            OS.gdk_colormap_query_color((int)colormap, (int)background.pixel, (GdkColor)background);
        }
        if (!this.data.xorMode) {
            OS.gdk_draw_layout_with_colors((int)this.data.drawable, (int)this.handle, (int)x, (int)y, (int)this.data.layout, null, (GdkColor)background);
        } else {
            int gdkGC;
            int layout = this.data.layout;
            int[] w = new int[1];
            int[] h = new int[1];
            OS.pango_layout_get_size((int)layout, (int[])w, (int[])h);
            int width = OS.PANGO_PIXELS((int)w[0]);
            int height = OS.PANGO_PIXELS((int)h[0]);
            int pixmap = OS.gdk_pixmap_new((int)OS.GDK_ROOT_PARENT(), (int)width, (int)height, (int)-1);
            if (pixmap == 0) {
                SWT.error(2);
            }
            if ((gdkGC = OS.gdk_gc_new((int)pixmap)) == 0) {
                SWT.error(2);
            }
            GdkColor foreground = new GdkColor();
            OS.gdk_gc_set_foreground((int)gdkGC, (GdkColor)foreground);
            OS.gdk_draw_rectangle((int)pixmap, (int)gdkGC, (int)1, (int)0, (int)0, (int)width, (int)height);
            if (values == null) {
                values = new GdkGCValues();
                OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
            }
            foreground.pixel = values.foreground_pixel;
            OS.gdk_gc_set_foreground((int)gdkGC, (GdkColor)foreground);
            OS.gdk_draw_layout_with_colors((int)pixmap, (int)gdkGC, (int)0, (int)0, (int)layout, null, (GdkColor)background);
            OS.g_object_unref((int)gdkGC);
            OS.gdk_draw_drawable((int)this.data.drawable, (int)this.handle, (int)pixmap, (int)0, (int)0, (int)x, (int)y, (int)width, (int)height);
            OS.g_object_unref((int)pixmap);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GC)) {
            return false;
        }
        return this.handle == ((GC)object).handle;
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
        GdkColor color = new GdkColor();
        color.pixel = values.background_pixel;
        int cairo = this.data.cairo;
        if (cairo != 0) {
            int colormap = OS.gdk_colormap_get_system();
            OS.gdk_colormap_query_color((int)colormap, (int)color.pixel, (GdkColor)color);
            Cairo.cairo_save((int)cairo);
            Cairo.cairo_set_rgb_color((int)cairo, (double)((float)(color.red & 0xFFFF) / 65535.0f), (double)((float)(color.green & 0xFFFF) / 65535.0f), (double)((float)(color.blue & 0xFFFF) / 65535.0f));
            Cairo.cairo_translate((int)cairo, (double)((float)x + (float)width / 2.0f), (double)((float)y + (float)height / 2.0f));
            Cairo.cairo_scale((int)cairo, (double)((float)width / 2.0f), (double)((float)height / 2.0f));
            Cairo.cairo_arc_negative((int)cairo, (double)0.0, (double)0.0, (double)1.0, (double)((float)(-startAngle) * (float)Compatibility.PI / 180.0f), (double)((float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f));
            Cairo.cairo_line_to((int)cairo, (double)0.0, (double)0.0);
            Cairo.cairo_fill((int)cairo);
            Cairo.cairo_restore((int)cairo);
            return;
        }
        OS.gdk_gc_set_foreground((int)this.handle, (GdkColor)color);
        OS.gdk_draw_arc((int)this.data.drawable, (int)this.handle, (int)1, (int)x, (int)y, (int)width, (int)height, (int)(startAngle * 64), (int)(arcAngle * 64));
        color.pixel = values.foreground_pixel;
        OS.gdk_gc_set_foreground((int)this.handle, (GdkColor)color);
    }

    public void fillGradientRectangle(int x, int y, int width, int height, boolean vertical) {
        RGB foregroundRGB;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width == 0 || height == 0) {
            return;
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
        RGB backgroundRGB = this.getBackground().getRGB();
        RGB fromRGB = foregroundRGB = this.getForeground().getRGB();
        RGB toRGB = backgroundRGB;
        boolean swapColors = false;
        if (width < 0) {
            x += width;
            width = -width;
            if (!vertical) {
                swapColors = true;
            }
        }
        if (height < 0) {
            y += height;
            height = -height;
            if (vertical) {
                swapColors = true;
            }
        }
        if (swapColors) {
            fromRGB = backgroundRGB;
            toRGB = foregroundRGB;
        }
        if (fromRGB.equals(toRGB)) {
            this.fillRectangle(x, y, width, height);
            return;
        }
        int cairo = this.data.cairo;
        if (cairo != 0) {
            int pattern = vertical ? Cairo.cairo_pattern_create_linear((double)0.0, (double)0.0, (double)0.0, (double)1.0) : Cairo.cairo_pattern_create_linear((double)0.0, (double)0.0, (double)1.0, (double)0.0);
            Cairo.cairo_pattern_add_color_stop((int)pattern, (double)0.0, (double)((float)fromRGB.red / 255.0f), (double)((float)fromRGB.green / 255.0f), (double)((float)fromRGB.blue / 255.0f), (double)1.0);
            Cairo.cairo_pattern_add_color_stop((int)pattern, (double)1.0, (double)((float)toRGB.red / 255.0f), (double)((float)toRGB.green / 255.0f), (double)((float)toRGB.blue / 255.0f), (double)1.0);
            Cairo.cairo_save((int)cairo);
            Cairo.cairo_translate((int)cairo, (double)x, (double)y);
            Cairo.cairo_scale((int)cairo, (double)width, (double)height);
            Cairo.cairo_rectangle((int)cairo, (double)0.0, (double)0.0, (double)1.0, (double)1.0);
            Cairo.cairo_set_pattern((int)cairo, (int)pattern);
            Cairo.cairo_fill((int)cairo);
            Cairo.cairo_restore((int)cairo);
            Cairo.cairo_pattern_destroy((int)pattern);
            return;
        }
        ImageData.fillGradientRectangle(this, this.data.device, x, y, width, height, vertical, fromRGB, toRGB, 8, 8, 8);
    }

    public void fillOval(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
        GdkColor color = new GdkColor();
        color.pixel = values.background_pixel;
        int cairo = this.data.cairo;
        if (cairo != 0) {
            int colormap = OS.gdk_colormap_get_system();
            OS.gdk_colormap_query_color((int)colormap, (int)color.pixel, (GdkColor)color);
            Cairo.cairo_save((int)cairo);
            Cairo.cairo_set_rgb_color((int)cairo, (double)((float)(color.red & 0xFFFF) / 65535.0f), (double)((float)(color.green & 0xFFFF) / 65535.0f), (double)((float)(color.blue & 0xFFFF) / 65535.0f));
            Cairo.cairo_translate((int)cairo, (double)((float)x + (float)width / 2.0f), (double)((float)y + (float)height / 2.0f));
            Cairo.cairo_scale((int)cairo, (double)((float)width / 2.0f), (double)((float)height / 2.0f));
            Cairo.cairo_arc_negative((int)cairo, (double)0.0, (double)0.0, (double)1.0, (double)0.0, (double)(2.0f * (float)Compatibility.PI));
            Cairo.cairo_fill((int)cairo);
            Cairo.cairo_restore((int)cairo);
            return;
        }
        OS.gdk_gc_set_foreground((int)this.handle, (GdkColor)color);
        OS.gdk_draw_arc((int)this.data.drawable, (int)this.handle, (int)1, (int)x, (int)y, (int)width, (int)height, (int)0, (int)23040);
        color.pixel = values.foreground_pixel;
        OS.gdk_gc_set_foreground((int)this.handle, (GdkColor)color);
    }

    public void fillPath(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path.handle == 0) {
            SWT.error(5);
        }
        this.initCairo();
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
        GdkColor color = new GdkColor();
        color.pixel = values.background_pixel;
        int cairo = this.data.cairo;
        int colormap = OS.gdk_colormap_get_system();
        OS.gdk_colormap_query_color((int)colormap, (int)color.pixel, (GdkColor)color);
        Cairo.cairo_save((int)cairo);
        Cairo.cairo_set_rgb_color((int)cairo, (double)((float)(color.red & 0xFFFF) / 65535.0f), (double)((float)(color.green & 0xFFFF) / 65535.0f), (double)((float)(color.blue & 0xFFFF) / 65535.0f));
        Cairo.cairo_add_path((int)cairo, (int)path.handle);
        Cairo.cairo_fill((int)cairo);
        Cairo.cairo_restore((int)cairo);
    }

    public void fillPolygon(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
        GdkColor color = new GdkColor();
        color.pixel = values.background_pixel;
        int cairo = this.data.cairo;
        if (cairo != 0) {
            int colormap = OS.gdk_colormap_get_system();
            OS.gdk_colormap_query_color((int)colormap, (int)color.pixel, (GdkColor)color);
            Cairo.cairo_save((int)cairo);
            Cairo.cairo_set_rgb_color((int)cairo, (double)((float)(color.red & 0xFFFF) / 65535.0f), (double)((float)(color.green & 0xFFFF) / 65535.0f), (double)((float)(color.blue & 0xFFFF) / 65535.0f));
            this.drawPolyline(cairo, pointArray, true);
            Cairo.cairo_fill((int)cairo);
            Cairo.cairo_restore((int)cairo);
            return;
        }
        OS.gdk_gc_set_foreground((int)this.handle, (GdkColor)color);
        OS.gdk_draw_polygon((int)this.data.drawable, (int)this.handle, (int)1, (int[])pointArray, (int)(pointArray.length / 2));
        color.pixel = values.foreground_pixel;
        OS.gdk_gc_set_foreground((int)this.handle, (GdkColor)color);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
        GdkColor color = new GdkColor();
        color.pixel = values.background_pixel;
        int cairo = this.data.cairo;
        if (cairo != 0) {
            int colormap = OS.gdk_colormap_get_system();
            OS.gdk_colormap_query_color((int)colormap, (int)color.pixel, (GdkColor)color);
            Cairo.cairo_save((int)cairo);
            Cairo.cairo_set_rgb_color((int)cairo, (double)((float)(color.red & 0xFFFF) / 65535.0f), (double)((float)(color.green & 0xFFFF) / 65535.0f), (double)((float)(color.blue & 0xFFFF) / 65535.0f));
            Cairo.cairo_rectangle((int)cairo, (double)x, (double)y, (double)width, (double)height);
            Cairo.cairo_fill((int)cairo);
            Cairo.cairo_restore((int)cairo);
            return;
        }
        OS.gdk_gc_set_foreground((int)this.handle, (GdkColor)color);
        OS.gdk_draw_rectangle((int)this.data.drawable, (int)this.handle, (int)1, (int)x, (int)y, (int)width, (int)height);
        color.pixel = values.foreground_pixel;
        OS.gdk_gc_set_foreground((int)this.handle, (GdkColor)color);
    }

    public void fillRectangle(Rectangle rect) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.fillRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void fillRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int nx = x;
        int ny = y;
        int nw = width;
        int nh = height;
        int naw = arcWidth;
        int nah = arcHeight;
        if (nw < 0) {
            nw = 0 - nw;
            nx -= nw;
        }
        if (nh < 0) {
            nh = 0 - nh;
            ny -= nh;
        }
        if (naw < 0) {
            naw = 0 - naw;
        }
        if (nah < 0) {
            nah = 0 - nah;
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
        GdkColor color = new GdkColor();
        color.pixel = values.background_pixel;
        int cairo = this.data.cairo;
        if (cairo != 0) {
            float naw2 = (float)naw / 2.0f;
            float nah2 = (float)nah / 2.0f;
            float fw = (float)nw / naw2;
            float cfr_ignored_0 = (float)nh / nah2;
            int colormap = OS.gdk_colormap_get_system();
            OS.gdk_colormap_query_color((int)colormap, (int)color.pixel, (GdkColor)color);
            Cairo.cairo_save((int)cairo);
            Cairo.cairo_set_rgb_color((int)cairo, (double)((float)(color.red & 0xFFFF) / 65535.0f), (double)((float)(color.green & 0xFFFF) / 65535.0f), (double)((float)(color.blue & 0xFFFF) / 65535.0f));
            Cairo.cairo_translate((int)cairo, (double)nx, (double)ny);
            Cairo.cairo_scale((int)cairo, (double)naw2, (double)nah2);
            Cairo.cairo_move_to((int)cairo, (double)(fw - 1.0f), (double)0.0);
            Cairo.cairo_close_path((int)this.handle);
            Cairo.cairo_stroke((int)cairo);
            Cairo.cairo_restore((int)cairo);
            return;
        }
        int naw2 = naw / 2;
        int nah2 = nah / 2;
        OS.gdk_gc_set_foreground((int)this.handle, (GdkColor)color);
        int drawable = this.data.drawable;
        if (nw > naw) {
            if (nh > nah) {
                OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)1, (int)nx, (int)ny, (int)naw, (int)nah, (int)5760, (int)5760);
                OS.gdk_draw_rectangle((int)drawable, (int)this.handle, (int)1, (int)(nx + naw2), (int)ny, (int)(nw - naw2 * 2), (int)nh);
                OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)1, (int)(nx + nw - naw), (int)ny, (int)naw, (int)nah, (int)0, (int)5760);
                OS.gdk_draw_rectangle((int)drawable, (int)this.handle, (int)1, (int)nx, (int)(ny + nah2), (int)naw2, (int)(nh - nah2 * 2));
                OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)1, (int)(nx + nw - naw), (int)(ny + nh - nah), (int)naw, (int)nah, (int)17280, (int)5760);
                OS.gdk_draw_rectangle((int)drawable, (int)this.handle, (int)1, (int)(nx + nw - naw2), (int)(ny + nah2), (int)naw2, (int)(nh - nah2 * 2));
                OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)1, (int)nx, (int)(ny + nh - nah), (int)naw, (int)nah, (int)11520, (int)5760);
            } else {
                OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)1, (int)nx, (int)ny, (int)naw, (int)nh, (int)5760, (int)11520);
                OS.gdk_draw_rectangle((int)drawable, (int)this.handle, (int)1, (int)(nx + naw2), (int)ny, (int)(nw - naw2 * 2), (int)nh);
                OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)1, (int)(nx + nw - naw), (int)ny, (int)naw, (int)nh, (int)17280, (int)11520);
            }
        } else if (nh > nah) {
            OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)1, (int)nx, (int)ny, (int)nw, (int)nah, (int)0, (int)11520);
            OS.gdk_draw_rectangle((int)drawable, (int)this.handle, (int)1, (int)nx, (int)(ny + nah2), (int)nw, (int)(nh - nah2 * 2));
            OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)1, (int)nx, (int)(ny + nh - nah), (int)nw, (int)nah, (int)11520, (int)11520);
        } else {
            OS.gdk_draw_arc((int)drawable, (int)this.handle, (int)1, (int)nx, (int)ny, (int)nw, (int)nh, (int)0, (int)23040);
        }
        color.pixel = values.foreground_pixel;
        OS.gdk_gc_set_foreground((int)this.handle, (GdkColor)color);
    }

    int fixMnemonic(char[] buffer) {
        int i = 0;
        int j = 0;
        int mnemonic = -1;
        while (i < buffer.length) {
            if ((buffer[j++] = buffer[i++]) != '&' || i == buffer.length) continue;
            if (buffer[i] == '&') {
                ++i;
                continue;
            }
            if (mnemonic == -1) {
                mnemonic = j;
            }
            --j;
        }
        while (j < buffer.length) {
            buffer[j++] = '\u0000';
        }
        return mnemonic;
    }

    public int getAdvanceWidth(char ch) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.stringExtent((String)new String((char[])new char[]{ch})).x;
    }

    public int getAlpha() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.initCairo();
        return (int)(Cairo.cairo_current_alpha((int)this.data.cairo) * 255.0);
    }

    public Color getBackground() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
        GdkColor color = new GdkColor();
        color.pixel = values.background_pixel;
        int colormap = OS.gdk_colormap_get_system();
        OS.gdk_colormap_query_color((int)colormap, (int)color.pixel, (GdkColor)color);
        return Color.gtk_new(this.data.device, color);
    }

    public int getCharWidth(char ch) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.stringExtent((String)new String((char[])new char[]{ch})).x;
    }

    public Rectangle getClipping() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        Region region = new Region();
        this.getClipping(region);
        Rectangle rect = region.getBounds();
        region.dispose();
        return rect;
    }

    public void getClipping(Region region) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        int hRegion = region.handle;
        OS.gdk_region_subtract((int)hRegion, (int)hRegion);
        int clipRgn = this.data.clipRgn;
        if (clipRgn == 0) {
            int[] width = new int[1];
            int[] height = new int[1];
            OS.gdk_drawable_get_size((int)this.data.drawable, (int[])width, (int[])height);
            GdkRectangle rect = new GdkRectangle();
            rect.y = 0;
            rect.x = 0;
            rect.width = width[0];
            rect.height = height[0];
            OS.gdk_region_union_with_rect((int)hRegion, (GdkRectangle)rect);
        } else {
            OS.gdk_region_union((int)hRegion, (int)clipRgn);
            if (!this.isIdentity(this.data.matrix)) {
                return;
            }
        }
        if (this.data.damageRgn != 0) {
            OS.gdk_region_intersect((int)hRegion, (int)this.data.damageRgn);
        }
    }

    public Font getFont() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return Font.gtk_new(this.data.device, this.data.font);
    }

    public FontMetrics getFontMetrics() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int context = this.data.context;
        int lang = OS.pango_context_get_language((int)context);
        int metrics = OS.pango_context_get_metrics((int)context, (int)this.data.font, (int)lang);
        FontMetrics fm = new FontMetrics();
        fm.ascent = OS.PANGO_PIXELS((int)OS.pango_font_metrics_get_ascent((int)metrics));
        fm.descent = OS.PANGO_PIXELS((int)OS.pango_font_metrics_get_descent((int)metrics));
        fm.averageCharWidth = OS.PANGO_PIXELS((int)OS.pango_font_metrics_get_approximate_char_width((int)metrics));
        fm.height = fm.ascent + fm.descent;
        OS.pango_font_metrics_unref((int)metrics);
        return fm;
    }

    public Color getForeground() {
        if (this.handle == 0) {
            SWT.error(24);
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
        GdkColor color = new GdkColor();
        color.pixel = values.foreground_pixel;
        int colormap = OS.gdk_colormap_get_system();
        OS.gdk_colormap_query_color((int)colormap, (int)color.pixel, (GdkColor)color);
        return Color.gtk_new(this.data.device, color);
    }

    public int getLineCap() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
        int cap = 1;
        switch (values.cap_style) {
            case 2: {
                cap = 2;
                break;
            }
            case 1: {
                cap = 1;
                break;
            }
            case 3: {
                cap = 3;
            }
        }
        return cap;
    }

    public int[] getLineDash() {
        byte[] dash_list;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((dash_list = this.data.dashes) == null) {
            return null;
        }
        int[] dashes = new int[dash_list.length];
        int i = 0;
        while (i < dash_list.length) {
            dashes[i] = dash_list[i] & 0xFF;
            ++i;
        }
        return dashes;
    }

    public int getLineJoin() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
        int join = 1;
        switch (values.join_style) {
            case 0: {
                join = 1;
                break;
            }
            case 1: {
                join = 2;
                break;
            }
            case 2: {
                join = 3;
            }
        }
        return join;
    }

    public int getLineStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineStyle;
    }

    public int getLineWidth() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
        return values.line_width;
    }

    public int getStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.style;
    }

    public void getTransform(Transform transform) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (transform == null) {
            SWT.error(4);
        }
        if (transform.isDisposed()) {
            SWT.error(5);
        }
        this.initCairo();
        Cairo.cairo_matrix_copy((int)transform.handle, (int)this.data.matrix);
    }

    public boolean getXORMode() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
        return values.function == 2;
    }

    public int hashCode() {
        return this.handle;
    }

    void init(Drawable drawable, GCData data, int gdkGC) {
        Image image;
        int font;
        GdkColor background;
        int context = OS.gdk_pango_context_get();
        if (context == 0) {
            SWT.error(2);
        }
        OS.pango_context_set_language((int)context, (int)OS.gtk_get_default_language());
        OS.pango_context_set_base_dir((int)context, (int)0);
        OS.gdk_pango_context_set_colormap((int)context, (int)OS.gdk_colormap_get_system());
        data.context = context;
        int layout = OS.pango_layout_new((int)context);
        if (layout == 0) {
            SWT.error(2);
        }
        data.layout = layout;
        GdkColor foreground = data.foreground;
        if (foreground != null) {
            OS.gdk_gc_set_foreground((int)gdkGC, (GdkColor)foreground);
        }
        if ((background = data.background) != null) {
            OS.gdk_gc_set_background((int)gdkGC, (GdkColor)background);
        }
        if ((font = data.font) != 0) {
            OS.pango_layout_set_font_description((int)layout, (int)font);
        }
        if ((image = data.image) != null) {
            image.memGC = this;
            if (image.transparentPixel != -1) {
                image.destroyMask();
            }
        }
        this.drawable = drawable;
        this.data = data;
        this.handle = gdkGC;
    }

    void initCairo() {
        this.data.device.checkCairo();
        int cairo = this.data.cairo;
        if (cairo != 0) {
            return;
        }
        this.data.cairo = cairo = Cairo.cairo_create();
        if (cairo == 0) {
            SWT.error(2);
        }
        this.data.matrix = Cairo.cairo_matrix_create();
        if (this.data.matrix == 0) {
            SWT.error(2);
        }
        this.data.inverseMatrix = Cairo.cairo_matrix_create();
        if (this.data.inverseMatrix == 0) {
            SWT.error(2);
        }
        int xDisplay = OS.GDK_DISPLAY();
        int xDrawable = 0;
        int translateX = 0;
        int translateY = 0;
        if (this.data.image != null) {
            xDrawable = OS.GDK_PIXMAP_XID((int)this.data.drawable);
        } else {
            int[] x = new int[1];
            int[] y = new int[1];
            int[] real_drawable = new int[1];
            OS.gdk_window_get_internal_paint_info((int)this.data.drawable, (int[])real_drawable, (int[])x, (int[])y);
            xDrawable = OS.gdk_x11_drawable_get_xid((int)real_drawable[0]);
            translateX = -x[0];
            translateY = -y[0];
        }
        Cairo.cairo_set_target_drawable((int)cairo, (int)xDisplay, (int)xDrawable);
        Cairo.cairo_translate((int)cairo, (double)translateX, (double)translateY);
        Cairo.cairo_set_fill_rule((int)cairo, (int)1);
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
        GdkColor color = new GdkColor();
        color.pixel = values.foreground_pixel;
        int colormap = OS.gdk_colormap_get_system();
        OS.gdk_colormap_query_color((int)colormap, (int)color.pixel, (GdkColor)color);
        Cairo.cairo_set_rgb_color((int)cairo, (double)((float)(color.red & 0xFFFF) / 65535.0f), (double)((float)(color.green & 0xFFFF) / 65535.0f), (double)((float)(color.blue & 0xFFFF) / 65535.0f));
        Cairo.cairo_set_line_width((int)cairo, (double)Math.max(1, values.line_width));
        int cap = 0;
        switch (values.cap_style) {
            case 2: {
                cap = 1;
                break;
            }
            case 1: {
                cap = 0;
                break;
            }
            case 3: {
                cap = 2;
            }
        }
        Cairo.cairo_set_line_cap((int)cairo, (int)cap);
        int join = 0;
        switch (values.join_style) {
            case 0: {
                join = 0;
                break;
            }
            case 1: {
                join = 1;
                break;
            }
            case 2: {
                join = 2;
            }
        }
        Cairo.cairo_set_line_join((int)cairo, (int)join);
        if (this.data.dashes != null) {
            double[] dashes = new double[this.data.dashes.length];
            int i = 0;
            while (i < dashes.length) {
                dashes[i] = this.data.dashes[i];
                ++i;
            }
            Cairo.cairo_set_dash((int)cairo, (double[])dashes, (int)dashes.length, (double)0.0);
        }
        GC.setCairoFont(cairo, this.data.font);
        GC.setCairoClip(cairo, this.data.clipRgn);
    }

    public boolean isClipped() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.clipRgn != 0;
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    boolean isIdentity(int matrix) {
        if (matrix == 0) {
            return true;
        }
        double[] a = new double[1];
        double[] b = new double[1];
        double[] c = new double[1];
        double[] d = new double[1];
        double[] tx = new double[1];
        double[] ty = new double[1];
        Cairo.cairo_matrix_get_affine((int)matrix, (double[])a, (double[])b, (double[])c, (double[])d, (double[])tx, (double[])ty);
        return a[0] == 1.0 && b[0] == 0.0 && c[0] == 0.0 && d[0] == 1.0 && tx[0] == 0.0 && ty[0] == 0.0;
    }

    public void setAlpha(int alpha) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.initCairo();
        Cairo.cairo_set_alpha((int)this.data.cairo, (double)((float)alpha / 255.0f));
    }

    public void setBackground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        OS.gdk_gc_set_background((int)this.handle, (GdkColor)color.handle);
    }

    static void setCairoFont(int cairo, Font font) {
        GC.setCairoFont(cairo, font.handle);
    }

    static void setCairoFont(int cairo, int font) {
        int family = OS.pango_font_description_get_family((int)font);
        int length = OS.strlen((int)family);
        byte[] buffer = new byte[length + 1];
        OS.memmove((byte[])buffer, (int)family, (int)length);
        double height = OS.PANGO_PIXELS((int)OS.pango_font_description_get_size((int)font)) * 96 / 72;
        int pangoStyle = OS.pango_font_description_get_style((int)font);
        int pangoWeight = OS.pango_font_description_get_weight((int)font);
        int slant = 0;
        if (pangoStyle == 2) {
            slant = 1;
        }
        if (pangoStyle == 1) {
            slant = 2;
        }
        int weight = 0;
        if (pangoWeight == 700) {
            weight = 1;
        }
        Cairo.cairo_select_font((int)cairo, (byte[])buffer, (int)slant, (int)weight);
        Cairo.cairo_scale_font((int)cairo, (double)height);
    }

    static void setCairoClip(int cairo, int clipRgn) {
        Cairo.cairo_init_clip((int)cairo);
        if (clipRgn == 0) {
            return;
        }
        int[] nRects = new int[1];
        int[] rects = new int[1];
        OS.gdk_region_get_rectangles((int)clipRgn, (int[])rects, (int[])nRects);
        GdkRectangle rect = new GdkRectangle();
        int i = 0;
        while (i < nRects[0]) {
            OS.memmove((GdkRectangle)rect, (int)(rects[0] + i * GdkRectangle.sizeof), (int)GdkRectangle.sizeof);
            Cairo.cairo_rectangle((int)cairo, (double)rect.x, (double)rect.y, (double)rect.width, (double)rect.height);
            ++i;
        }
        Cairo.cairo_clip((int)cairo);
        Cairo.cairo_new_path((int)cairo);
        if (rects[0] != 0) {
            OS.g_free((int)rects[0]);
        }
    }

    void setClipping(int clipRgn) {
        int clipping;
        if (clipRgn == 0) {
            if (this.data.clipRgn == 0) {
                return;
            }
            OS.gdk_region_destroy((int)this.data.clipRgn);
            this.data.clipRgn = 0;
            clipping = this.data.damageRgn != 0 ? this.data.damageRgn : 0;
            OS.gdk_gc_set_clip_region((int)this.handle, (int)clipping);
        } else {
            if (this.data.clipRgn == 0) {
                this.data.clipRgn = OS.gdk_region_new();
            }
            OS.gdk_region_subtract((int)this.data.clipRgn, (int)this.data.clipRgn);
            OS.gdk_region_union((int)this.data.clipRgn, (int)clipRgn);
            clipping = clipRgn;
            if (this.data.damageRgn != 0) {
                clipping = OS.gdk_region_new();
                OS.gdk_region_union((int)clipping, (int)clipRgn);
                OS.gdk_region_intersect((int)clipping, (int)this.data.damageRgn);
            }
            OS.gdk_gc_set_clip_region((int)this.handle, (int)clipping);
            if (clipping != clipRgn) {
                OS.gdk_region_destroy((int)clipping);
            }
        }
        int cairo = this.data.cairo;
        if (cairo != 0) {
            GC.setCairoClip(cairo, clipRgn);
        }
    }

    public void setClipping(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        GdkRectangle rect = new GdkRectangle();
        rect.x = x;
        rect.y = y;
        rect.width = width;
        rect.height = height;
        int clipRgn = OS.gdk_region_new();
        OS.gdk_region_union_with_rect((int)clipRgn, (GdkRectangle)rect);
        this.setClipping(clipRgn);
        OS.gdk_region_destroy((int)clipRgn);
    }

    public void setClipping(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path != null && path.isDisposed()) {
            SWT.error(44);
        }
        this.setClipping(0);
        if (path != null) {
            this.initCairo();
            int cairo = this.data.cairo;
            Cairo.cairo_add_path((int)cairo, (int)path.handle);
            Cairo.cairo_clip((int)cairo);
            Cairo.cairo_new_path((int)cairo);
        }
    }

    public void setClipping(Rectangle rect) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (rect == null) {
            this.setClipping(0);
        } else {
            this.setClipping(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public void setClipping(Region region) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region != null && region.isDisposed()) {
            SWT.error(5);
        }
        this.setClipping(region != null ? region.handle : 0);
    }

    public void setFont(Font font) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (font == null) {
            font = this.data.device.systemFont;
        }
        if (font.isDisposed()) {
            SWT.error(5);
        }
        int fontHandle = this.data.font = font.handle;
        OS.pango_layout_set_font_description((int)this.data.layout, (int)fontHandle);
        this.data.stringHeight = -1;
        this.data.stringWidth = -1;
        int cairo = this.data.cairo;
        if (cairo != 0) {
            GC.setCairoFont(cairo, fontHandle);
        }
    }

    public void setForeground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        OS.gdk_gc_set_foreground((int)this.handle, (GdkColor)color.handle);
        int cairo = this.data.cairo;
        if (cairo != 0) {
            GdkColor gdkColor = color.handle;
            Cairo.cairo_set_rgb_color((int)cairo, (double)((float)(gdkColor.red & 0xFFFF) / 65535.0f), (double)((float)(gdkColor.green & 0xFFFF) / 65535.0f), (double)((float)(gdkColor.blue & 0xFFFF) / 65535.0f));
        }
    }

    public void setLineCap(int cap) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int cap_style = 0;
        int cairo_style = 0;
        switch (cap) {
            case 2: {
                cap_style = 2;
                cairo_style = 1;
                break;
            }
            case 1: {
                cap_style = 1;
                cairo_style = 0;
                break;
            }
            case 3: {
                cap_style = 3;
                cairo_style = 2;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
        int line_style = this.data.lineStyle == 1 ? 0 : 1;
        OS.gdk_gc_set_line_attributes((int)this.handle, (int)values.line_width, (int)line_style, (int)cap_style, (int)values.join_style);
        int cairo = this.data.cairo;
        if (cairo != 0) {
            Cairo.cairo_set_line_cap((int)cairo, (int)cairo_style);
        }
    }

    public void setLineDash(int[] dashes) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (dashes != null && dashes.length > 0) {
            byte[] dash_list = new byte[dashes.length];
            int i = 0;
            while (i < dashes.length) {
                int dash = dashes[i];
                if (dash <= 0) {
                    SWT.error(5);
                }
                dash_list[i] = (byte)dash;
                ++i;
            }
            OS.gdk_gc_set_dashes((int)this.handle, (int)0, (byte[])dash_list, (int)dash_list.length);
            this.data.dashes = dash_list;
            this.data.lineStyle = 6;
        } else {
            this.data.dashes = null;
            this.data.lineStyle = 1;
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
        int line_style = this.data.lineStyle == 1 ? 0 : 1;
        OS.gdk_gc_set_line_attributes((int)this.handle, (int)values.line_width, (int)line_style, (int)values.cap_style, (int)values.join_style);
        int cairo = this.data.cairo;
        if (cairo != 0) {
            if (this.data.dashes != null) {
                double[] cairoDashes = new double[this.data.dashes.length];
                int i = 0;
                while (i < dashes.length) {
                    cairoDashes[i] = this.data.dashes[i];
                    ++i;
                }
                Cairo.cairo_set_dash((int)cairo, (double[])cairoDashes, (int)cairoDashes.length, (double)0.0);
            } else {
                Cairo.cairo_set_dash((int)cairo, null, (int)0, (double)0.0);
            }
        }
    }

    public void setLineJoin(int join) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int join_style = 0;
        int cairo_style = 0;
        switch (join) {
            case 1: {
                join_style = 0;
                cairo_style = 0;
                break;
            }
            case 2: {
                join_style = 1;
                cairo_style = 1;
                break;
            }
            case 3: {
                join_style = 2;
                cairo_style = 2;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
        int line_style = this.data.lineStyle == 1 ? 0 : 1;
        OS.gdk_gc_set_line_attributes((int)this.handle, (int)values.line_width, (int)line_style, (int)values.cap_style, (int)join_style);
        int cairo = this.data.cairo;
        if (cairo != 0) {
            Cairo.cairo_set_line_join((int)cairo, (int)cairo_style);
        }
    }

    public void setLineStyle(int lineStyle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int cairo = this.data.cairo;
        int line_style = 1;
        switch (lineStyle) {
            case 1: {
                line_style = 0;
                if (cairo == 0) break;
                Cairo.cairo_set_dash((int)cairo, null, (int)0, (double)0.0);
                break;
            }
            case 2: {
                OS.gdk_gc_set_dashes((int)this.handle, (int)0, (byte[])new byte[]{18, 6}, (int)2);
                if (cairo == 0) break;
                Cairo.cairo_set_dash((int)cairo, (double[])new double[]{18.0, 6.0}, (int)2, (double)0.0);
                break;
            }
            case 3: {
                OS.gdk_gc_set_dashes((int)this.handle, (int)0, (byte[])new byte[]{3, 3}, (int)2);
                if (cairo == 0) break;
                Cairo.cairo_set_dash((int)cairo, (double[])new double[]{3.0, 3.0}, (int)2, (double)0.0);
                break;
            }
            case 4: {
                OS.gdk_gc_set_dashes((int)this.handle, (int)0, (byte[])new byte[]{9, 6, 3, 6}, (int)4);
                if (cairo == 0) break;
                Cairo.cairo_set_dash((int)cairo, (double[])new double[]{9.0, 6.0, 3.0, 6.0}, (int)4, (double)0.0);
                break;
            }
            case 5: {
                OS.gdk_gc_set_dashes((int)this.handle, (int)0, (byte[])new byte[]{9, 3, 3, 3, 3, 3}, (int)6);
                if (cairo != 0) {
                    Cairo.cairo_set_dash((int)cairo, (double[])new double[]{9.0, 3.0, 3.0, 3.0, 3.0, 3.0}, (int)6, (double)0.0);
                }
            }
            case 6: {
                byte[] dash_list = this.data.dashes;
                if (dash_list != null) {
                    OS.gdk_gc_set_dashes((int)this.handle, (int)0, (byte[])dash_list, (int)dash_list.length);
                    if (cairo == 0) break;
                    double[] dashes = new double[this.data.dashes.length];
                    int i = 0;
                    while (i < dashes.length) {
                        dashes[i] = this.data.dashes[i];
                        ++i;
                    }
                    Cairo.cairo_set_dash((int)cairo, (double[])dashes, (int)dashes.length, (double)0.0);
                    break;
                }
                line_style = 0;
                if (cairo == 0) break;
                Cairo.cairo_set_dash((int)cairo, null, (int)0, (double)0.0);
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineStyle = lineStyle;
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
        OS.gdk_gc_set_line_attributes((int)this.handle, (int)values.line_width, (int)line_style, (int)values.cap_style, (int)values.join_style);
    }

    public void setLineWidth(int width) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        GdkGCValues values = new GdkGCValues();
        OS.gdk_gc_get_values((int)this.handle, (GdkGCValues)values);
        int line_style = this.data.lineStyle == 1 ? 0 : 1;
        OS.gdk_gc_set_line_attributes((int)this.handle, (int)width, (int)line_style, (int)values.cap_style, (int)values.join_style);
        int cairo = this.data.cairo;
        if (cairo != 0) {
            Cairo.cairo_set_line_width((int)cairo, (double)width);
        }
    }

    void setString(String string, int flags) {
        byte[] buffer;
        int mnemonic;
        if (string == this.data.string && (flags & 0xFFFFFFFE) == (this.data.drawFlags & 0xFFFFFFFE)) {
            return;
        }
        int length = string.length();
        int layout = this.data.layout;
        char[] text = new char[length];
        string.getChars(0, length, text, 0);
        if ((flags & 8) != 0 && (mnemonic = this.fixMnemonic(text)) != -1) {
            char[] text1 = new char[mnemonic - 1];
            System.arraycopy(text, 0, text1, 0, text1.length);
            byte[] buffer1 = Converter.wcsToMbcs(null, text1, false);
            char[] text2 = new char[text.length - mnemonic];
            System.arraycopy(text, mnemonic - 1, text2, 0, text2.length);
            byte[] buffer2 = Converter.wcsToMbcs(null, text2, false);
            buffer = new byte[buffer1.length + buffer2.length];
            System.arraycopy(buffer1, 0, buffer, 0, buffer1.length);
            System.arraycopy(buffer2, 0, buffer, buffer1.length, buffer2.length);
            int attr_list = OS.pango_attr_list_new();
            int attr = OS.pango_attr_underline_new((int)3);
            PangoAttribute attribute = new PangoAttribute();
            OS.memmove((PangoAttribute)attribute, (int)attr, (int)PangoAttribute.sizeof);
            attribute.start_index = buffer1.length;
            attribute.end_index = buffer1.length + 1;
            OS.memmove((int)attr, (PangoAttribute)attribute, (int)PangoAttribute.sizeof);
            OS.pango_attr_list_insert((int)attr_list, (int)attr);
            OS.pango_layout_set_attributes((int)layout, (int)attr_list);
            OS.pango_attr_list_unref((int)attr_list);
        } else {
            buffer = Converter.wcsToMbcs(null, text, false);
            OS.pango_layout_set_attributes((int)layout, (int)0);
        }
        OS.pango_layout_set_text((int)layout, (byte[])buffer, (int)buffer.length);
        OS.pango_layout_set_single_paragraph_mode((int)layout, ((flags & 2) == 0 ? 1 : 0) != 0);
        OS.pango_layout_set_tabs((int)layout, (int)((flags & 4) != 0 ? 0 : this.data.device.emptyTab));
        this.data.string = string;
        this.data.stringHeight = -1;
        this.data.stringWidth = -1;
        this.data.drawFlags = flags;
    }

    public void setTransform(Transform transform) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (transform == null) {
            SWT.error(4);
        }
        if (transform.isDisposed()) {
            SWT.error(5);
        }
        this.initCairo();
        int cairo = this.data.cairo;
        Cairo.cairo_concat_matrix((int)cairo, (int)this.data.inverseMatrix);
        Cairo.cairo_concat_matrix((int)cairo, (int)transform.handle);
        Cairo.cairo_matrix_copy((int)this.data.matrix, (int)transform.handle);
        Cairo.cairo_matrix_copy((int)this.data.inverseMatrix, (int)transform.handle);
        Cairo.cairo_matrix_invert((int)this.data.inverseMatrix);
        int clipRgn = this.data.clipRgn;
        if (clipRgn != 0) {
            int matrix = this.data.inverseMatrix;
            int newRgn = OS.gdk_region_new();
            int[] nRects = new int[1];
            int[] rects = new int[1];
            OS.gdk_region_get_rectangles((int)clipRgn, (int[])rects, (int[])nRects);
            GdkRectangle rect = new GdkRectangle();
            int[] pointArray = new int[8];
            double[] x = new double[1];
            double[] y = new double[1];
            int i = 0;
            while (i < nRects[0]) {
                OS.memmove((GdkRectangle)rect, (int)(rects[0] + i * GdkRectangle.sizeof), (int)GdkRectangle.sizeof);
                x[0] = rect.x;
                y[0] = rect.y;
                Cairo.cairo_matrix_transform_point((int)matrix, (double[])x, (double[])y);
                pointArray[0] = (int)Math.round(x[0]);
                pointArray[1] = (int)Math.round(y[0]);
                x[0] = rect.x + rect.width;
                y[0] = rect.y;
                Cairo.cairo_matrix_transform_point((int)matrix, (double[])x, (double[])y);
                pointArray[2] = (int)Math.round(x[0]);
                pointArray[3] = (int)Math.round(y[0]);
                x[0] = rect.x + rect.width;
                y[0] = rect.y + rect.height;
                Cairo.cairo_matrix_transform_point((int)matrix, (double[])x, (double[])y);
                pointArray[4] = (int)Math.round(x[0]);
                pointArray[5] = (int)Math.round(y[0]);
                x[0] = rect.x;
                y[0] = rect.y + rect.height;
                Cairo.cairo_matrix_transform_point((int)matrix, (double[])x, (double[])y);
                pointArray[6] = (int)Math.round(x[0]);
                pointArray[7] = (int)Math.round(y[0]);
                int polyRgn = OS.gdk_region_polygon((int[])pointArray, (int)(pointArray.length / 2), (int)0);
                OS.gdk_region_union((int)newRgn, (int)polyRgn);
                OS.gdk_region_destroy((int)polyRgn);
                ++i;
            }
            OS.gdk_region_destroy((int)clipRgn);
            this.data.clipRgn = newRgn;
        }
    }

    public void setXORMode(boolean xor) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        OS.gdk_gc_set_function((int)this.handle, (int)(xor ? 2 : 0));
        this.data.xorMode = xor;
    }

    public Point stringExtent(String string) {
        return this.textExtent(string, 0);
    }

    public Point textExtent(String string) {
        return this.textExtent(string, 6);
    }

    public Point textExtent(String string, int flags) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        this.setString(string, flags);
        if (this.data.stringWidth != -1) {
            return new Point(this.data.stringWidth, this.data.stringHeight);
        }
        int[] width = new int[1];
        int[] height = new int[1];
        OS.pango_layout_get_size((int)this.data.layout, (int[])width, (int[])height);
        this.data.stringWidth = OS.PANGO_PIXELS((int)width[0]);
        this.data.stringHeight = OS.PANGO_PIXELS((int)height[0]);
        return new Point(this.data.stringWidth, this.data.stringHeight);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "GC {*DISPOSED*}";
        }
        return "GC {" + this.handle + "}";
    }
}

