/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.cairo.cairo_font_extents_t;

public class Path {
    public int handle;
    Device device;

    public Path(Device device) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        device.checkCairo();
        this.handle = Cairo.cairo_create();
        if (this.handle == 0) {
            SWT.error(2);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public void addArc(float x, float y, float width, float height, float startAngle, float arcAngle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int matrix = Cairo.cairo_matrix_create();
        Cairo.cairo_current_matrix((int)this.handle, (int)matrix);
        double lineWidth = Cairo.cairo_current_line_width((int)this.handle);
        Cairo.cairo_translate((int)this.handle, (double)(x + width / 2.0f), (double)(y + height / 2.0f));
        Cairo.cairo_scale((int)this.handle, (double)(width / 2.0f), (double)(height / 2.0f));
        Cairo.cairo_set_line_width((int)this.handle, (double)(lineWidth / (double)(width / 2.0f)));
        Cairo.cairo_arc_negative((int)this.handle, (double)0.0, (double)0.0, (double)1.0, (double)(-startAngle * (float)Compatibility.PI / 180.0f), (double)(-(startAngle + arcAngle) * (float)Compatibility.PI / 180.0f));
        Cairo.cairo_set_line_width((int)this.handle, (double)lineWidth);
        Cairo.cairo_set_matrix((int)this.handle, (int)matrix);
        Cairo.cairo_destroy((int)matrix);
    }

    public void addPath(Path path) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (path.isDisposed()) {
            SWT.error(5);
        }
        Cairo.cairo_add_path((int)this.handle, (int)path.handle);
    }

    public void addRectangle(float x, float y, float width, float height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Cairo.cairo_rectangle((int)this.handle, (double)x, (double)y, (double)width, (double)height);
    }

    public void addString(String string, float x, float y, Font font) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (font == null) {
            SWT.error(4);
        }
        if (font.isDisposed()) {
            SWT.error(5);
        }
        GC.setCairoFont(this.handle, font);
        cairo_font_extents_t extents = new cairo_font_extents_t();
        Cairo.cairo_current_font_extents((int)this.handle, (cairo_font_extents_t)extents);
        double baseline = y + extents.ascent;
        Cairo.cairo_move_to((int)this.handle, (double)x, (double)baseline);
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        Cairo.cairo_text_path((int)this.handle, (byte[])buffer);
    }

    public void close() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Cairo.cairo_close_path((int)this.handle);
    }

    public void curveTo(float cx1, float cy1, float cx2, float cy2, float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Cairo.cairo_curve_to((int)this.handle, (double)cx1, (double)cy1, (double)cx2, (double)cy2, (double)x, (double)y);
    }

    public void getCurrentPoint(float[] point) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (point == null) {
            SWT.error(4);
        }
        if (point.length < 2) {
            SWT.error(5);
        }
        double[] x = new double[1];
        double[] y = new double[1];
        Cairo.cairo_current_point((int)this.handle, (double[])x, (double[])y);
        point[0] = (float)x[0];
        point[1] = (float)y[0];
    }

    public void lineTo(float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Cairo.cairo_line_to((int)this.handle, (double)x, (double)y);
    }

    public void moveTo(float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Cairo.cairo_move_to((int)this.handle, (double)x, (double)y);
    }

    public void quadTo(float cx, float cy, float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Cairo.cairo_curve_to((int)this.handle, (double)cx, (double)cy, (double)cx, (double)cy, (double)x, (double)y);
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        Cairo.cairo_destroy((int)this.handle);
        this.handle = 0;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Path {*DISPOSED*}";
        }
        return "Path {" + this.handle + "}";
    }
}

