/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.program;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.cde.CDE;
import org.eclipse.swt.internal.cde.DtActionArg;
import org.eclipse.swt.internal.gnome.GNOME;
import org.eclipse.swt.internal.gnome.GnomeVFSMimeApplication;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.kde.KDE;
import org.eclipse.swt.widgets.Display;

public final class Program {
    String name;
    String command;
    String iconPath;
    Display display;
    boolean gnomeExpectUri;
    static int cdeShell;
    static final String[] CDE_ICON_EXT;
    static final String[] CDE_MASK_EXT;
    static final String DESKTOP_DATA = "Program_DESKTOP";
    static final int DESKTOP_UNKNOWN = 0;
    static final int DESKTOP_GNOME = 1;
    static final int DESKTOP_KDE = 2;
    static final int DESKTOP_CDE = 3;
    static final int PREFERRED_ICON_SIZE = 16;

    static {
        CDE_ICON_EXT = new String[]{".m.pm", ".l.pm", ".s.pm", ".t.pm"};
        CDE_MASK_EXT = new String[]{".m_m.bm", ".l_m.bm", ".s_m.bm", ".t_m.bm"};
    }

    Program() {
    }

    static int getDesktop(Display display) {
        byte[] gnomeName;
        int gnome;
        int index;
        if (display == null) {
            return 0;
        }
        Integer desktopValue = (Integer)display.getData(DESKTOP_DATA);
        if (desktopValue != null) {
            return desktopValue;
        }
        int desktop = 0;
        int xDisplay = OS.GDK_DISPLAY();
        int rootWindow = OS.XDefaultRootWindow((int)xDisplay);
        int[] numProp = new int[1];
        int propList = OS.XListProperties((int)xDisplay, (int)rootWindow, (int[])numProp);
        int[] property = new int[numProp[0]];
        if (propList != 0) {
            OS.memmove((int[])property, (int)propList, (int)(property.length * OS.PTR_SIZEOF));
            OS.XFree((int)propList);
        }
        if (desktop == 0) {
            byte[] kdeName = Converter.wcsToMbcs(null, "KWIN_RUNNING", true);
            int kde = OS.XInternAtom((int)xDisplay, (byte[])kdeName, (boolean)true);
            index = 0;
            while (desktop == 0 && index < property.length) {
                if (property[index] != 0 && property[index] == kde && Program.kde_init()) {
                    desktop = 2;
                }
                ++index;
            }
        }
        if (desktop == 0 && (gnome = OS.XInternAtom((int)xDisplay, (byte[])(gnomeName = Converter.wcsToMbcs(null, "_NET_SUPPORTING_WM_CHECK", true)), (boolean)true)) != 0 && Program.gnome_init()) {
            desktop = 1;
        }
        if (desktop == 0) {
            byte[] cdeName = Converter.wcsToMbcs(null, "_DT_SM_PREFERENCES", true);
            int cde = OS.XInternAtom((int)xDisplay, (byte[])cdeName, (boolean)true);
            index = 0;
            while (desktop == 0 && index < property.length) {
                if (property[index] != 0 && property[index] == cde && Program.cde_init(display)) {
                    desktop = 3;
                }
                ++index;
            }
        }
        display.setData(DESKTOP_DATA, new Integer(desktop));
        return desktop;
    }

    boolean cde_execute(String fileName) {
        byte[] action = Converter.wcsToMbcs(null, this.command, true);
        byte[] fileArg = Converter.wcsToMbcs(null, fileName, true);
        int ptr = OS.g_malloc((int)fileArg.length);
        OS.memmove((int)ptr, (byte[])fileArg, (int)fileArg.length);
        DtActionArg args = new DtActionArg();
        args.argClass = 1;
        args.name = ptr;
        long actionID = CDE.DtActionInvoke((int)cdeShell, (byte[])action, (DtActionArg)args, (int)1, null, null, null, (int)1, (int)0, (int)0);
        OS.g_free((int)ptr);
        return actionID != 0L;
    }

    static String cde_getAction(String dataType) {
        String action = null;
        String actions = Program.cde_getAttribute(dataType, "ACTIONS");
        if (actions != null) {
            int index = actions.indexOf("Open");
            action = index != -1 ? actions.substring(index, index + 4) : ((index = actions.indexOf(",")) != -1 ? actions.substring(0, index) : actions);
        }
        return action;
    }

    static String cde_getAttribute(String dataType, String attrName) {
        byte[] optNameBuf;
        byte[] attrNameBuf;
        byte[] dataTypeBuf = Converter.wcsToMbcs(null, dataType, true);
        int attrValue = CDE.DtDtsDataTypeToAttributeValue((byte[])dataTypeBuf, (byte[])(attrNameBuf = Converter.wcsToMbcs(null, attrName, true)), (byte[])(optNameBuf = (byte[])null));
        if (attrValue == 0) {
            return null;
        }
        int length = OS.strlen((int)attrValue);
        byte[] attrValueBuf = new byte[length];
        OS.memmove((byte[])attrValueBuf, (int)attrValue, (int)length);
        CDE.DtDtsFreeAttributeValue((int)attrValue);
        return new String(Converter.mbcsToWcs(null, attrValueBuf));
    }

    static Hashtable cde_getDataTypeInfo() {
        Hashtable dataTypeInfo = new Hashtable();
        int dataTypeList = CDE.DtDtsDataTypeNames();
        if (dataTypeList != 0) {
            int index = 0;
            int[] dataType = new int[1];
            OS.memmove((int[])dataType, (int)(dataTypeList + index++ * 4), (int)4);
            while (dataType[0] != 0) {
                int length = OS.strlen((int)dataType[0]);
                byte[] dataTypeBuf = new byte[length];
                OS.memmove((byte[])dataTypeBuf, (int)dataType[0], (int)length);
                String dataTypeName = new String(Converter.mbcsToWcs(null, dataTypeBuf));
                String extension = Program.cde_getExtension(dataTypeName);
                if (!CDE.DtDtsDataTypeIsAction((byte[])dataTypeBuf) && extension != null && Program.cde_getAction(dataTypeName) != null) {
                    Vector<String> exts = new Vector<String>();
                    exts.addElement(extension);
                    dataTypeInfo.put(dataTypeName, exts);
                }
                OS.memmove((int[])dataType, (int)(dataTypeList + index++ * 4), (int)4);
            }
            CDE.DtDtsFreeDataTypeNames((int)dataTypeList);
        }
        return dataTypeInfo;
    }

    static String cde_getExtension(String dataType) {
        String fileExt = Program.cde_getAttribute(dataType, "NAME_TEMPLATE");
        if (fileExt == null || fileExt.indexOf("%s.") == -1) {
            return null;
        }
        int dot = fileExt.indexOf(".");
        return fileExt.substring(dot);
    }

    ImageData cde_getImageData() {
        return null;
    }

    static Program cde_getProgram(Display display, String mimeType) {
        Program program = new Program();
        program.display = display;
        program.name = mimeType;
        program.command = Program.cde_getAction(mimeType);
        program.iconPath = Program.cde_getAttribute(program.name, "ICON");
        return program;
    }

    static boolean cde_init(Display display) {
        try {
            Library.loadLibrary((String)"swt-cde");
        }
        catch (Throwable throwable) {
            return false;
        }
        CDE.XtToolkitInitialize();
        int xtContext = CDE.XtCreateApplicationContext();
        int xDisplay = OS.GDK_DISPLAY();
        byte[] appName = Converter.wcsToMbcs(null, "CDE", true);
        byte[] appClass = Converter.wcsToMbcs(null, "CDE", true);
        int[] argc = new int[1];
        CDE.XtDisplayInitialize((int)xtContext, (int)xDisplay, (byte[])appName, (byte[])appClass, (int)0, (int)0, (int[])argc, (int)0);
        int widgetClass = CDE.topLevelShellWidgetClass();
        cdeShell = CDE.XtAppCreateShell((byte[])appName, (byte[])appClass, (int)widgetClass, (int)xDisplay, null, (int)0);
        CDE.XtSetMappedWhenManaged((int)cdeShell, (boolean)false);
        CDE.XtResizeWidget((int)cdeShell, (int)10, (int)10, (int)0);
        CDE.XtRealizeWidget((int)cdeShell);
        boolean initOK = CDE.DtAppInitialize((int)xtContext, (int)xDisplay, (int)cdeShell, (byte[])appName, (byte[])appName);
        if (initOK) {
            CDE.DtDbLoad();
        }
        return initOK;
    }

    /*
     * Unable to fully structure code
     */
    static String[] parseCommand(String cmd) {
        args = new Vector<String>();
        sIndex = 0;
        ** GOTO lbl25
        {
            ++sIndex;
            do {
                if (sIndex < cmd.length() && Compatibility.isWhitespace(cmd.charAt(sIndex))) continue block0;
                if (sIndex >= cmd.length()) continue;
                if (cmd.charAt(sIndex) == '\"' || cmd.charAt(sIndex) == '\'') {
                    eIndex = sIndex + 1;
                    while (eIndex < cmd.length() && cmd.charAt(eIndex) != cmd.charAt(sIndex)) {
                        ++eIndex;
                    }
                    if (eIndex >= cmd.length()) {
                        args.addElement(cmd.substring(sIndex, eIndex));
                    } else {
                        args.addElement(cmd.substring(sIndex + 1, eIndex));
                    }
                    sIndex = eIndex + 1;
                    continue;
                }
                eIndex = sIndex;
                while (eIndex < cmd.length() && !Compatibility.isWhitespace(cmd.charAt(eIndex))) {
                    ++eIndex;
                }
                args.addElement(cmd.substring(sIndex, eIndex));
                sIndex = eIndex + 1;
lbl25:
                // 4 sources

            } while (sIndex < cmd.length());
        }
        strings = new String[args.size()];
        index = 0;
        while (index < args.size()) {
            strings[index] = (String)args.elementAt(index);
            ++index;
        }
        return strings;
    }

    boolean gnome_execute(String fileName) {
        if (this.gnomeExpectUri) {
            fileName = "file://" + fileName;
        }
        String[] args = Program.parseCommand(this.command);
        int fileArg = -1;
        int index = 0;
        while (index < args.length) {
            int j = args[index].indexOf("%f");
            if (j != -1) {
                String value = args[index];
                fileArg = index;
                args[index] = String.valueOf(value.substring(0, j)) + fileName + value.substring(j + 2);
            }
            ++index;
        }
        if (fileName.length() > 0 && fileArg < 0) {
            String[] newArgs = new String[args.length + 1];
            index = 0;
            while (index < args.length) {
                newArgs[index] = args[index];
                ++index;
            }
            newArgs[args.length] = fileName;
            args = newArgs;
        }
        try {
            Compatibility.exec(args);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    ImageData gnome_getImageData() {
        if (this.iconPath == null) {
            return null;
        }
        try {
            return new ImageData(this.iconPath);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static Hashtable gnome_getMimeInfo() {
        int mimeList;
        Hashtable mimeInfo = new Hashtable();
        int[] mimeData = new int[1];
        int[] extensionData = new int[1];
        int mimeElement = mimeList = GNOME.gnome_vfs_get_registered_mime_types();
        while (mimeElement != 0) {
            OS.memmove((int[])mimeData, (int)mimeElement, (int)OS.PTR_SIZEOF);
            int mimePtr = mimeData[0];
            int mimeLength = OS.strlen((int)mimePtr);
            byte[] mimeTypeBuffer = new byte[mimeLength];
            OS.memmove((byte[])mimeTypeBuffer, (int)mimePtr, (int)mimeLength);
            String mimeType = new String(Converter.mbcsToWcs(null, mimeTypeBuffer));
            int extensionList = GNOME.gnome_vfs_mime_get_extensions_list((int)mimePtr);
            if (extensionList != 0) {
                Vector<String> extensions = new Vector<String>();
                int extensionElement = extensionList;
                while (extensionElement != 0) {
                    OS.memmove((int[])extensionData, (int)extensionElement, (int)OS.PTR_SIZEOF);
                    int extensionPtr = extensionData[0];
                    int extensionLength = OS.strlen((int)extensionPtr);
                    byte[] extensionBuffer = new byte[extensionLength];
                    OS.memmove((byte[])extensionBuffer, (int)extensionPtr, (int)extensionLength);
                    String extension = new String(Converter.mbcsToWcs(null, extensionBuffer));
                    extension = String.valueOf('.') + extension;
                    extensions.addElement(extension);
                    extensionElement = GNOME.g_list_next((int)extensionElement);
                }
                GNOME.gnome_vfs_mime_extensions_list_free((int)extensionList);
                if (extensions.size() > 0) {
                    mimeInfo.put(mimeType, extensions);
                }
            }
            mimeElement = GNOME.g_list_next((int)mimeElement);
        }
        if (mimeList != 0) {
            GNOME.gnome_vfs_mime_registered_mime_type_list_free((int)mimeList);
        }
        return mimeInfo;
    }

    static Program gnome_getProgram(Display display, String mimeType) {
        Program program = null;
        byte[] mimeTypeBuffer = Converter.wcsToMbcs(null, mimeType, true);
        int ptr = GNOME.gnome_vfs_mime_get_default_application((byte[])mimeTypeBuffer);
        if (ptr != 0) {
            program = new Program();
            program.display = display;
            program.name = mimeType;
            GnomeVFSMimeApplication application = new GnomeVFSMimeApplication();
            GNOME.memmove((GnomeVFSMimeApplication)application, (int)ptr, (int)GnomeVFSMimeApplication.sizeof);
            int length = OS.strlen((int)application.command);
            byte[] buffer = new byte[length];
            OS.memmove((byte[])buffer, (int)application.command, (int)length);
            program.command = new String(Converter.mbcsToWcs(null, buffer));
            program.gnomeExpectUri = application.expects_uris == 0;
            length = OS.strlen((int)application.id);
            buffer = new byte[length + 1];
            OS.memmove((byte[])buffer, (int)application.id, (int)length);
            int icon_theme = GNOME.gnome_icon_theme_new();
            int icon_name = GNOME.gnome_icon_lookup((int)icon_theme, (int)0, null, (byte[])buffer, (int)0, (byte[])mimeTypeBuffer, (int)0, null);
            int path = 0;
            if (icon_name != 0) {
                path = GNOME.gnome_icon_theme_lookup_icon((int)icon_theme, (int)icon_name, (int)16, null, null);
            }
            GNOME.g_object_unref((int)icon_theme);
            if (path != 0) {
                length = OS.strlen((int)path);
                if (length > 0) {
                    buffer = new byte[length];
                    OS.memmove((byte[])buffer, (int)path, (int)length);
                    program.iconPath = new String(Converter.mbcsToWcs(null, buffer));
                }
                GNOME.g_free((int)path);
            }
            if (icon_name != 0) {
                GNOME.g_free((int)icon_name);
            }
            GNOME.gnome_vfs_mime_application_free((int)ptr);
        }
        return program;
    }

    static boolean gnome_init() {
        try {
            return GNOME.gnome_vfs_init();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static String kde_convertQStringAndFree(int qString) {
        if (qString == 0) {
            return null;
        }
        int qCString = KDE.QString_utf8((int)qString);
        int charString = KDE.QCString_data((int)qCString);
        int length = OS.strlen((int)charString);
        byte[] buffer = new byte[length];
        OS.memmove((byte[])buffer, (int)charString, (int)length);
        String answer = new String(Converter.mbcsToWcs(null, buffer));
        KDE.QCString_delete((int)qCString);
        KDE.QString_delete((int)qString);
        return answer;
    }

    static boolean kde_init() {
        return false;
    }

    boolean kde_execute(String fileName) {
        String urlString = "file://" + fileName;
        byte[] buffer = Converter.wcsToMbcs(null, urlString, true);
        int qString = KDE.QString_new((byte[])buffer);
        int url = KDE.KURL_new((int)qString);
        buffer = Converter.wcsToMbcs(null, this.name, true);
        int mimeTypeName = KDE.QString_new((byte[])buffer);
        int pid = KDE.KRun_runURL((int)url, (int)mimeTypeName);
        KDE.QString_delete((int)mimeTypeName);
        KDE.KURL_delete((int)url);
        KDE.QString_delete((int)qString);
        return pid != 0;
    }

    ImageData kde_getImageData() {
        if (this.iconPath == null) {
            return null;
        }
        if (this.iconPath.endsWith("xpm")) {
            int xDisplay = OS.GDK_DISPLAY();
            int rootWindow = OS.XDefaultRootWindow((int)xDisplay);
            byte[] iconName = Converter.wcsToMbcs(null, this.iconPath, true);
            int[] pixmap = new int[1];
            int[] mask = new int[1];
            KDE.XpmReadFileToPixmap((int)xDisplay, (int)rootWindow, (byte[])iconName, (int[])pixmap, (int[])mask, (int)0);
            if (pixmap[0] == 0 || pixmap[0] == 2) {
                return null;
            }
            int gdkPixmap = OS.gdk_pixmap_foreign_new((int)pixmap[0]);
            int gdkMask = mask[0] != 0 ? OS.gdk_pixmap_foreign_new((int)mask[0]) : 0;
            Image image = Image.gtk_new(this.display, gdkMask != 0 ? 1 : 0, gdkPixmap, gdkMask);
            ImageData imageData = image.getImageData();
            if (gdkPixmap != 0) {
                OS.g_object_unref((int)gdkPixmap);
            }
            if (gdkMask != 0) {
                OS.g_object_unref((int)gdkMask);
            }
            if (pixmap[0] != 0) {
                KDE.XFreePixmap((int)xDisplay, (int)pixmap[0]);
            }
            if (mask[0] != 0) {
                KDE.XFreePixmap((int)xDisplay, (int)mask[0]);
            }
            return imageData;
        }
        try {
            return new ImageData(this.iconPath);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static Hashtable kde_getMimeInfo() {
        Hashtable mimeInfo = new Hashtable();
        Vector<String> mimeExts = null;
        int mimeTypeList = KDE.KMimeType_allMimeTypes();
        int iterator = KDE.KMimeTypeList_begin((int)mimeTypeList);
        int listEnd = KDE.KMimeTypeList_end((int)mimeTypeList);
        while (!KDE.KMimeTypeListIterator_equals((int)iterator, (int)listEnd)) {
            int kMimeType = KDE.KMimeTypeListIterator_dereference((int)iterator);
            int mimeName = KDE.KMimeType_name((int)kMimeType);
            String mimeType = Program.kde_convertQStringAndFree(mimeName);
            mimeExts = new Vector<String>();
            int patternList = KDE.KMimeType_patterns((int)kMimeType);
            int patIterator = KDE.QStringList_begin((int)patternList);
            int patListEnd = KDE.QStringList_end((int)patternList);
            while (!KDE.QStringListIterator_equals((int)patIterator, (int)patListEnd)) {
                int patString = KDE.QStringListIterator_dereference((int)patIterator);
                String extension = Program.kde_convertQStringAndFree(patString);
                int period = extension.indexOf(46);
                if (period != -1) {
                    mimeExts.addElement(extension.substring(period));
                }
                KDE.QStringListIterator_increment((int)patIterator);
            }
            KDE.QStringListIterator_delete((int)patIterator);
            KDE.QStringListIterator_delete((int)patListEnd);
            KDE.QStringList_delete((int)patternList);
            if (mimeExts.size() > 0) {
                mimeInfo.put(mimeType, mimeExts);
            }
            KDE.KMimeTypeListIterator_increment((int)iterator);
        }
        KDE.KMimeTypeListIterator_delete((int)iterator);
        KDE.KMimeTypeListIterator_delete((int)listEnd);
        KDE.KMimeTypeList_delete((int)mimeTypeList);
        return mimeInfo;
    }

    static Program kde_getProgram(Display display, String mimeType) {
        Program program = null;
        byte[] buffer = Converter.wcsToMbcs(null, mimeType, true);
        int mimeTypeName = KDE.QString_new((byte[])buffer);
        int serviceList = KDE.KMimeType_offers((int)mimeTypeName);
        if (serviceList != 0) {
            KDE.KServiceList_delete((int)serviceList);
            program = new Program();
            program.display = display;
            program.name = mimeType;
            program.command = "KRun::runURL(url,mimeType)";
            int kMimeType = KDE.KMimeType_mimeType((int)mimeTypeName);
            if (kMimeType != 0) {
                int mimeIcon = KDE.KMimeType_icon((int)kMimeType, (int)0, (boolean)false);
                int loader = KDE.KGlobal_iconLoader();
                int path = KDE.KIconLoader_iconPath((int)loader, (int)mimeIcon, (int)0, (boolean)true);
                program.iconPath = Program.kde_convertQStringAndFree(path);
                KDE.QString_delete((int)mimeIcon);
                KDE.KMimeType_delete((int)kMimeType);
            }
        }
        KDE.QString_delete((int)mimeTypeName);
        return program;
    }

    public static Program findProgram(String extension) {
        return Program.findProgram(Display.getCurrent(), extension);
    }

    static Program findProgram(Display display, String extension) {
        if (extension == null) {
            SWT.error(4);
        }
        if (extension.length() == 0) {
            return null;
        }
        if (extension.charAt(0) != '.') {
            extension = "." + extension;
        }
        int desktop = Program.getDesktop(display);
        Hashtable mimeInfo = null;
        switch (desktop) {
            case 1: {
                mimeInfo = Program.gnome_getMimeInfo();
                break;
            }
            case 2: {
                mimeInfo = Program.kde_getMimeInfo();
                break;
            }
            case 3: {
                mimeInfo = Program.cde_getDataTypeInfo();
            }
        }
        if (mimeInfo == null) {
            return null;
        }
        String mimeType = null;
        Enumeration keys = mimeInfo.keys();
        block10: while (mimeType == null && keys.hasMoreElements()) {
            String type = (String)keys.nextElement();
            Vector mimeExts = (Vector)mimeInfo.get(type);
            int index = 0;
            while (index < mimeExts.size()) {
                if (extension.equals(mimeExts.elementAt(index))) {
                    mimeType = type;
                    continue block10;
                }
                ++index;
            }
        }
        if (mimeType == null) {
            return null;
        }
        Program program = null;
        switch (desktop) {
            case 1: {
                program = Program.gnome_getProgram(display, mimeType);
                break;
            }
            case 2: {
                program = Program.kde_getProgram(display, mimeType);
                break;
            }
            case 3: {
                program = Program.cde_getProgram(display, mimeType);
            }
        }
        return program;
    }

    public static String[] getExtensions() {
        return Program.getExtensions(Display.getCurrent());
    }

    static String[] getExtensions(Display display) {
        int desktop = Program.getDesktop(display);
        Hashtable mimeInfo = null;
        switch (desktop) {
            case 1: {
                mimeInfo = Program.gnome_getMimeInfo();
                break;
            }
            case 2: {
                mimeInfo = Program.kde_getMimeInfo();
                break;
            }
            case 3: {
                mimeInfo = Program.cde_getDataTypeInfo();
            }
        }
        if (mimeInfo == null) {
            return new String[0];
        }
        Vector extensions = new Vector();
        Enumeration keys = mimeInfo.keys();
        while (keys.hasMoreElements()) {
            String mimeType = (String)keys.nextElement();
            Vector mimeExts = (Vector)mimeInfo.get(mimeType);
            int index = 0;
            while (index < mimeExts.size()) {
                if (!extensions.contains(mimeExts.elementAt(index))) {
                    extensions.addElement(mimeExts.elementAt(index));
                }
                ++index;
            }
        }
        String[] extStrings = new String[extensions.size()];
        int index = 0;
        while (index < extensions.size()) {
            extStrings[index] = (String)extensions.elementAt(index);
            ++index;
        }
        return extStrings;
    }

    public static Program[] getPrograms() {
        return Program.getPrograms(Display.getCurrent());
    }

    static Program[] getPrograms(Display display) {
        int desktop = Program.getDesktop(display);
        Hashtable mimeInfo = null;
        switch (desktop) {
            case 1: {
                mimeInfo = Program.gnome_getMimeInfo();
                break;
            }
            case 2: {
                mimeInfo = Program.kde_getMimeInfo();
                break;
            }
            case 3: {
                mimeInfo = Program.cde_getDataTypeInfo();
            }
        }
        if (mimeInfo == null) {
            return new Program[0];
        }
        Vector<Program> programs = new Vector<Program>();
        Enumeration keys = mimeInfo.keys();
        while (keys.hasMoreElements()) {
            String mimeType = (String)keys.nextElement();
            Program program = null;
            switch (desktop) {
                case 1: {
                    program = Program.gnome_getProgram(display, mimeType);
                    break;
                }
                case 2: {
                    program = Program.kde_getProgram(display, mimeType);
                    break;
                }
                case 3: {
                    program = Program.cde_getProgram(display, mimeType);
                }
            }
            if (program == null) continue;
            programs.addElement(program);
        }
        Program[] programList = new Program[programs.size()];
        int index = 0;
        while (index < programList.length) {
            programList[index] = (Program)programs.elementAt(index);
            ++index;
        }
        return programList;
    }

    public static boolean launch(String fileName) {
        return Program.launch(Display.getCurrent(), fileName);
    }

    static boolean launch(Display display, String fileName) {
        String extension;
        Program program;
        int index;
        if (fileName == null) {
            SWT.error(4);
        }
        if ((index = fileName.lastIndexOf(46)) > 0 && (program = Program.findProgram(display, extension = fileName.substring(index))) != null && program.execute(fileName)) {
            return true;
        }
        try {
            Compatibility.exec(fileName);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Program)) {
            return false;
        }
        Program program = (Program)other;
        return this.display == program.display && this.name.equals(program.name) && this.command.equals(program.command);
    }

    public boolean execute(String fileName) {
        if (fileName == null) {
            SWT.error(4);
        }
        int desktop = Program.getDesktop(this.display);
        switch (desktop) {
            case 1: {
                return this.gnome_execute(fileName);
            }
            case 2: {
                return this.kde_execute(fileName);
            }
            case 3: {
                return this.cde_execute(fileName);
            }
        }
        return false;
    }

    public ImageData getImageData() {
        switch (Program.getDesktop(this.display)) {
            case 1: {
                return this.gnome_getImageData();
            }
            case 2: {
                return this.kde_getImageData();
            }
            case 3: {
                return this.cde_getImageData();
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.command.hashCode() ^ this.display.hashCode();
    }

    public String toString() {
        return "Program {" + this.name + "}";
    }
}

