/*
 * Decompiled with CFR 0.152.
 */
package org.argosdic.action.program;

import org.argosdic.ArgosDic;
import org.argosdic.action.BaseAction;
import org.argosdic.dictionary.SearchHistory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;

public class BackAction
extends BaseAction {
    public BackAction(ArgosDic application) {
        super(application, 4);
        this.setEnabled(false);
    }

    public void runWithEvent(Event event) {
        SearchHistory history = this.application.getSearchHistory();
        if (event.detail == 4) {
            Display display = Display.getCurrent();
            Shell shell = display.getActiveShell();
            Menu menu = new Menu((Decorations)shell, 8);
            int i = history.getCurrentIndex();
            for (String word : history.getBackwardHistory()) {
                MenuItem item = new MenuItem(menu, 8);
                item.setText(word);
                item.addListener(13, (Listener)new MenuItemListener(--i));
            }
            if (event.widget instanceof ToolItem) {
                ToolItem button = (ToolItem)event.widget;
                Rectangle bounds = button.getBounds();
                Point location = new Point(bounds.x, bounds.y + bounds.height);
                location = button.getParent().toDisplay(location);
                menu.setLocation(location);
            }
            menu.setVisible(true);
        } else {
            String word = history.back();
            if (word != null) {
                this.application.search(word, false);
            }
        }
    }

    private class MenuItemListener
    implements Listener {
        private int index;

        MenuItemListener(int index) {
            this.index = index;
        }

        public void handleEvent(Event event) {
            SearchHistory history = BackAction.this.application.getSearchHistory();
            String word = history.go(this.index);
            BackAction.this.application.search(word, false);
        }
    }
}

