/*
 * Decompiled with CFR 0.152.
 */
package org.argosdic.dictionary;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.BindException;
import java.net.ServerSocket;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.argosdic.dictionary.Dictionary;
import org.argosdic.dictionary.DictionaryEvent;
import org.argosdic.dictionary.DictionaryListener;
import org.argosdic.dictionary.DictionaryManager;
import org.argosdic.dictionary.SearchHistory;
import org.argosdic.dictionary.ServerWorker;
import org.argosdic.resource.ResourceManager;
import org.argosdic.search.EnglishAnalyzer;
import org.argosdic.util.SpecialFolders;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.JFacePreferences;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DictionaryServer {
    protected static final int STATUS_OK = 200;
    protected static final int STATUS_NOT_MODIFIED = 304;
    protected static final int STATUS_NOT_FOUND = 404;
    protected static final int STATUS_INTERNAL_ERROR = 500;
    protected static final String LINE_SEPARATOR = "\r\n";
    private static Log log = LogFactory.getLog(DictionaryServer.class);
    private ServerSocket socket;
    private Analyzer simpleAnalyzer;
    private Analyzer sentenceAnalyzer;
    private Dictionary dictionary;
    private IndexSearcher searcher;
    private String url;
    private String dataDir;
    private String htmlDir;
    private FontData font;
    private int port;
    private int poolSize;
    private int wildcardQueryThreshold;
    private List workers;
    private SearchHistory searchHistory;
    private long templateModifiedTime;
    private MessageFormat templateFormat;
    static /* synthetic */ Class class$0;

    public DictionaryServer() {
        ResourceManager resources = ResourceManager.getInstance();
        IPreferenceStore preferences = JFacePreferences.getPreferenceStore();
        this.htmlDir = SpecialFolders.getHtmlDirectory();
        this.dataDir = preferences.getString("data.dir");
        this.port = preferences.getInt("server.port");
        this.poolSize = preferences.getInt("server.workers");
        this.url = "http://localhost:" + this.port;
        this.searchHistory = new SearchHistory();
        this.handleDictionaryChanged();
        DictionaryManager manager = DictionaryManager.getInstance();
        manager.getSelectedDictionary();
        manager.addDictionaryListener(new DictionaryListener(){

            public void dictionaryUpdated(DictionaryEvent event) {
            }

            public void dictionaryChanged(DictionaryEvent event) {
                DictionaryServer.this.handleDictionaryChanged();
            }
        });
        preferences.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                DictionaryServer.this.handlePreferencesChanged();
            }
        });
        BooleanQuery.setMaxClauseCount((int)Integer.MAX_VALUE);
        this.handlePreferencesChanged();
    }

    private void handlePreferencesChanged() {
        IPreferenceStore preferences = JFacePreferences.getPreferenceStore();
        this.font = PreferenceConverter.getFontData((IPreferenceStore)preferences, (String)"browser.font");
        this.wildcardQueryThreshold = preferences.getInt("wildcard.query.threshold");
    }

    private void handleDictionaryChanged() {
        if (this.searcher != null) {
            block11: {
                try {
                    this.searcher.close();
                }
                catch (IOException e) {
                    if (!log.isWarnEnabled()) break block11;
                    String msg = "Unable to close IndexSearcher instance.";
                    log.warn((Object)msg, (Throwable)e);
                }
            }
            this.searcher = null;
        }
        this.searchHistory.clear();
        DictionaryManager manager = DictionaryManager.getInstance();
        manager.getSelectedDictionary();
        this.dictionary = manager.getSelectedDictionary();
        if (this.dictionary != null) {
            block12: {
                StringBuffer buffer = new StringBuffer();
                buffer.append(this.dataDir);
                buffer.append(File.separator);
                buffer.append(this.dictionary.getId());
                try {
                    this.searcher = new IndexSearcher(buffer.toString());
                }
                catch (IOException e) {
                    if (!log.isWarnEnabled()) break block12;
                    String msg = "Unable to use the selected dictionary.";
                    log.warn((Object)msg, (Throwable)e);
                }
            }
            EnglishAnalyzer analyzer = null;
            String analyzerClass = this.dictionary.getAnalyzer();
            if (analyzerClass != null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Instantiating anayzer : " + analyzerClass));
                }
                try {
                    Class<?> cl = Class.forName(analyzerClass);
                    analyzer = (Analyzer)cl.newInstance();
                }
                catch (Exception e) {
                    String msg = "Unable to instantiate the specified analyzer class.";
                    log.error((Object)msg, (Throwable)e);
                }
            }
            if (analyzer == null) {
                analyzer = new EnglishAnalyzer();
                log.info((Object)("Using default anayzer : " + ((Object)((Object)analyzer)).getClass()));
            }
            this.simpleAnalyzer = new SimpleAnalyzer();
            this.sentenceAnalyzer = analyzer;
        }
    }

    public Hits search(String word) throws ParseException, IOException {
        return this.search(word, true);
    }

    public Hits search(String word, boolean updateHistory) throws ParseException, IOException {
        int matches;
        if (word == null || word.trim().length() == 0) {
            return null;
        }
        if (this.searcher == null) {
            ResourceManager resources = ResourceManager.getInstance();
            Shell parent = Display.getCurrent().getActiveShell();
            String title = resources.getString("dialog.title.warning");
            String msg = resources.getString("error.message.dictionary");
            MessageDialog.openWarning((Shell)parent, (String)title, (String)msg);
            return null;
        }
        word = word.trim();
        Hits hits = null;
        Query query = this.parseQueryString(word);
        hits = this.searcher.search(query, null);
        if (updateHistory && (matches = hits.length()) > 0) {
            Document document = null;
            int i = 0;
            while (i < matches) {
                Document doc = hits.doc(i);
                if (word.equalsIgnoreCase(doc.getField("word").stringValue())) {
                    document = doc;
                    break;
                }
                ++i;
            }
            if (document == null) {
                document = hits.doc(0);
            }
            this.searchHistory.add(document);
        }
        return hits;
    }

    public static boolean isSimpleQuery(String word) {
        Assert.isNotNull((Object)word);
        boolean simple = word.indexOf(" ") == -1 && !word.endsWith("*") && !word.endsWith("~") && !word.endsWith("?");
        return simple;
    }

    protected Query parseQueryString(String word) throws ParseException {
        Query query = null;
        if (DictionaryServer.isSimpleQuery(word)) {
            if (word.length() >= this.wildcardQueryThreshold) {
                word = word.concat("*");
            }
            query = QueryParser.parse((String)word, (String)"word", (Analyzer)this.simpleAnalyzer);
        } else {
            query = QueryParser.parse((String)word, (String)"word", (Analyzer)this.sentenceAnalyzer);
            if (log.isDebugEnabled()) {
                try {
                    Token token;
                    StringReader reader = new StringReader(word.trim());
                    TokenStream in = this.sentenceAnalyzer.tokenStream("word", (Reader)reader);
                    while ((token = in.next()) != null) {
                        log.debug((Object)("Found token : " + token.termText()));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return query;
    }

    public String getUrl() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        if (this.socket == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Starting dictionary server...");
            }
            DictionaryServer dictionaryServer = this;
            synchronized (dictionaryServer) {
                int retry = 30;
                while (!(this.socket != null && this.socket.isBound() || retry <= 0)) {
                    try {
                        this.socket = new ServerSocket(this.port);
                    }
                    catch (BindException e) {
                        --retry;
                        --this.port;
                        if (!log.isWarnEnabled()) continue;
                        log.warn((Object)"Unable to bind to the specified port.");
                        log.warn((Object)("Retrying with port : " + this.port));
                    }
                }
                if (this.socket == null || !this.socket.isBound()) {
                    String msg = "Unable to bind to the specified port range.";
                    throw new IOException(msg);
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Dictionary server has been bound for port : " + this.port));
                }
            }
        }
        if (this.workers != null && this.workers.size() > 0) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Dictionary server is already running.");
            }
        } else {
            this.workers = new ArrayList(this.poolSize);
            int i = 1;
            while (i <= this.poolSize) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Spawning new server worker (" + i + " of  " + this.poolSize + ")..."));
                }
                ServerWorker runnable = new ServerWorker(this, this.socket, i);
                Thread worker = new Thread(runnable);
                worker.start();
                this.workers.add(worker);
                ++i;
            }
        }
    }

    public void stop() throws IOException {
        if (this.socket != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Stopping dictionary server...");
            }
            this.socket.close();
            if (this.workers != null && this.workers.size() > 0) {
                int i = 1;
                while (i <= this.poolSize) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Stopping server worker (" + i + " of  " + this.poolSize + ")..."));
                    }
                    Thread worker = (Thread)this.workers.get(i - 1);
                    worker.interrupt();
                    ++i;
                }
                this.workers.clear();
            }
        }
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public FontData getFont() {
        return this.font;
    }

    public String getHtmlDir() {
        return this.htmlDir;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public int getPort() {
        return this.port;
    }

    protected IndexSearcher getSearcher() {
        return this.searcher;
    }

    protected Analyzer getSimpleAnalyzer() {
        return this.simpleAnalyzer;
    }

    protected Analyzer getSentenceAnalyzer() {
        return this.sentenceAnalyzer;
    }

    public SearchHistory getSearchHistory() {
        return this.searchHistory;
    }

    public Dictionary getDictionary() {
        return this.dictionary;
    }

    protected String getHttpHeader(int status) {
        return this.getHttpHeader(status, null);
    }

    protected String getHttpHeader(int status, String message) {
        HashMap<String, String> headers = new HashMap<String, String>(1);
        StringBuffer buffer = new StringBuffer();
        buffer.append("text/html");
        if (this.dictionary != null) {
            buffer.append(";charset=");
            buffer.append(this.dictionary.getCharset());
        }
        headers.put("Content-Type", buffer.toString());
        return this.getHttpHeader(status, null, headers);
    }

    protected String getHttpHeader(int status, String message, Map headers) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("HTTP/1.0 ");
        buffer.append(status);
        if (message != null) {
            buffer.append(" ");
            buffer.append(message);
        }
        buffer.append(LINE_SEPARATOR);
        if (headers != null) {
            for (Object key : headers.keySet()) {
                Object value = headers.get(key);
                buffer.append(key);
                buffer.append(": ");
                buffer.append(value);
                buffer.append(LINE_SEPARATOR);
            }
        }
        buffer.append(LINE_SEPARATOR);
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getHtmlContent(Object[] args) {
        String path = String.valueOf(SpecialFolders.getHtmlDirectory()) + "/template.html";
        File file = new File(path);
        if (this.templateFormat == null || this.templateModifiedTime < file.lastModified()) {
            DictionaryServer dictionaryServer = this;
            synchronized (dictionaryServer) {
                BufferedReader reader = null;
                StringBuffer buffer = new StringBuffer();
                try {
                    try {
                        reader = new BufferedReader(new FileReader(file));
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            buffer.append(line);
                            buffer.append("\n");
                        }
                        this.templateFormat = new MessageFormat(buffer.toString());
                        this.templateModifiedTime = file.lastModified();
                    }
                    catch (IOException e) {
                        if (log.isErrorEnabled()) {
                            String msg = "Unable to read HTML template.";
                            log.error((Object)msg, (Throwable)e);
                        }
                    }
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        return this.templateFormat.format(args);
    }

    public static void main(String[] args) {
        DictionaryServer server = null;
        try {
            try {
                server = new DictionaryServer();
                server.start();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (server != null) {
                try {
                    server.stop();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

