/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GtkSelectionData;
import org.eclipse.swt.internal.gtk.GtkTargetEntry;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

class ClipboardProxy {
    Object[] clipboardData;
    Transfer[] clipboardDataTypes;
    Object[] primaryClipboardData;
    Transfer[] primaryClipboardDataTypes;
    Display display;
    Clipboard activeClipboard = null;
    Clipboard activePrimaryClipboard = null;
    Callback getFunc;
    Callback clearFunc;
    static String ID = "CLIPBOARD PROXY OBJECT";

    static ClipboardProxy _getInstance(final Display display) {
        ClipboardProxy proxy = (ClipboardProxy)display.getData(ID);
        if (proxy != null) {
            return proxy;
        }
        proxy = new ClipboardProxy(display);
        display.setData(ID, proxy);
        display.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                ClipboardProxy clipbordProxy = (ClipboardProxy)display.getData(ID);
                if (clipbordProxy == null) {
                    return;
                }
                display.setData(ID, null);
                clipbordProxy.dispose();
            }
        });
        return proxy;
    }

    ClipboardProxy(Display display) {
        this.display = display;
        this.getFunc = new Callback(this, "getFunc", 4);
        this.clearFunc = new Callback(this, "clearFunc", 2);
    }

    void clear(Clipboard owner, int clipboards) {
        if ((clipboards & 1) != 0 && this.activeClipboard == owner) {
            OS.gtk_clipboard_clear((int)Clipboard.GTKCLIPBOARD);
        }
        if ((clipboards & 2) != 0 && this.activePrimaryClipboard == owner) {
            OS.gtk_clipboard_clear((int)Clipboard.GTKPRIMARYCLIPBOARD);
        }
    }

    int clearFunc(int clipboard, int user_data_or_owner) {
        if (clipboard == Clipboard.GTKCLIPBOARD) {
            this.activeClipboard = null;
            this.clipboardData = null;
            this.clipboardDataTypes = null;
        }
        if (clipboard == Clipboard.GTKPRIMARYCLIPBOARD) {
            this.activePrimaryClipboard = null;
            this.primaryClipboardData = null;
            this.primaryClipboardDataTypes = null;
        }
        return 1;
    }

    void dispose() {
        if (this.display == null) {
            return;
        }
        if (this.activeClipboard != null) {
            OS.gtk_clipboard_clear((int)Clipboard.GTKCLIPBOARD);
        }
        if (this.activePrimaryClipboard != null) {
            OS.gtk_clipboard_clear((int)Clipboard.GTKPRIMARYCLIPBOARD);
        }
        this.display = null;
        if (this.getFunc != null) {
            this.getFunc.dispose();
        }
        this.getFunc = null;
        if (this.clearFunc != null) {
            this.clearFunc.dispose();
        }
        this.clearFunc = null;
        this.clipboardData = null;
        this.clipboardDataTypes = null;
        this.primaryClipboardData = null;
        this.primaryClipboardDataTypes = null;
    }

    int getFunc(int clipboard, int selection_data, int info, int user_data_or_owner) {
        if (selection_data == 0) {
            return 0;
        }
        GtkSelectionData selectionData = new GtkSelectionData();
        OS.memmove((GtkSelectionData)selectionData, (int)selection_data, (int)GtkSelectionData.sizeof);
        TransferData tdata = new TransferData();
        tdata.type = selectionData.target;
        Transfer[] types = clipboard == Clipboard.GTKCLIPBOARD ? this.clipboardDataTypes : this.primaryClipboardDataTypes;
        int index = -1;
        int i = 0;
        while (i < types.length) {
            if (types[i].isSupportedType(tdata)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return 0;
        }
        Object[] data = clipboard == Clipboard.GTKCLIPBOARD ? this.clipboardData : this.primaryClipboardData;
        types[index].javaToNative(data[index], tdata);
        if (tdata.format < 8 || tdata.format % 8 != 0) {
            return 0;
        }
        OS.gtk_selection_data_set((int)selection_data, (int)tdata.type, (int)tdata.format, (int)tdata.pValue, (int)tdata.length);
        OS.g_free((int)tdata.pValue);
        return 1;
    }

    /*
     * Unable to fully structure code
     */
    boolean setData(Clipboard owner, Object[] data, Transfer[] dataTypes, int clipboards) {
        block23: {
            block21: {
                block22: {
                    block20: {
                        entries = new GtkTargetEntry[]{};
                        pTargetsList = 0;
                        i = 0;
                        while (i < dataTypes.length) {
                            transfer = dataTypes[i];
                            typeIds = transfer.getTypeIds();
                            typeNames = transfer.getTypeNames();
                            j = 0;
                            while (j < typeIds.length) {
                                entry = new GtkTargetEntry();
                                entry.info = typeIds[j];
                                buffer = Converter.wcsToMbcs(null, typeNames[j], true);
                                pName = OS.g_malloc((int)buffer.length);
                                OS.memmove((int)pName, (byte[])buffer, (int)buffer.length);
                                entry.target = pName;
                                tmp = new GtkTargetEntry[entries.length + 1];
                                System.arraycopy(entries, 0, tmp, 0, entries.length);
                                tmp[entries.length] = entry;
                                entries = tmp;
                                ++j;
                            }
                            ++i;
                        }
                        pTargetsList = OS.g_malloc((int)(GtkTargetEntry.sizeof * entries.length));
                        offset = 0;
                        i = 0;
                        while (i < entries.length) {
                            OS.memmove((int)(pTargetsList + offset), (GtkTargetEntry)entries[i], (int)GtkTargetEntry.sizeof);
                            offset += GtkTargetEntry.sizeof;
                            ++i;
                        }
                        if ((clipboards & 1) == 0) ** GOTO lbl55
                        if (this.activeClipboard != null) {
                            OS.gtk_clipboard_clear((int)Clipboard.GTKCLIPBOARD);
                        }
                        this.clipboardData = data;
                        this.clipboardDataTypes = dataTypes;
                        getFuncProc = this.getFunc.getAddress();
                        if (OS.gtk_clipboard_set_with_data((int)Clipboard.GTKCLIPBOARD, (int)pTargetsList, (int)entries.length, (int)getFuncProc, (int)(clearFuncProc = this.clearFunc.getAddress()), (int)0)) break block20;
                        var16_18 = null;
                        i = 0;
                        ** while (i < entries.length)
lbl-1000:
                        // 1 sources

                        {
                            entry = entries[i];
                            if (entry.target != 0) {
                                OS.g_free((int)entry.target);
                            }
                            ++i;
                            continue;
                        }
lbl49:
                        // 1 sources

                        if (pTargetsList != 0) {
                            OS.g_free((int)pTargetsList);
                        }
                        return false;
                    }
                    this.activeClipboard = owner;
lbl55:
                    // 2 sources

                    if ((clipboards & 2) == 0) break block21;
                    if (this.activePrimaryClipboard != null) {
                        OS.gtk_clipboard_clear((int)Clipboard.GTKPRIMARYCLIPBOARD);
                    }
                    this.primaryClipboardData = data;
                    this.primaryClipboardDataTypes = dataTypes;
                    getFuncProc = this.getFunc.getAddress();
                    if (OS.gtk_clipboard_set_with_data((int)Clipboard.GTKPRIMARYCLIPBOARD, (int)pTargetsList, (int)entries.length, (int)getFuncProc, (int)(clearFuncProc = this.clearFunc.getAddress()), (int)0)) break block22;
                    var16_19 = null;
                    i = 0;
                    ** while (i < entries.length)
lbl-1000:
                    // 1 sources

                    {
                        entry = entries[i];
                        if (entry.target != 0) {
                            OS.g_free((int)entry.target);
                        }
                        ++i;
                        continue;
                    }
lbl71:
                    // 1 sources

                    if (pTargetsList != 0) {
                        OS.g_free((int)pTargetsList);
                    }
                    return false;
                }
                try {
                    this.activePrimaryClipboard = owner;
                }
                catch (Throwable var17_30) {
                    var16_21 = null;
                    i = 0;
                    ** while (i < entries.length)
                }
            }
            var16_20 = null;
            i = 0;
            while (i < entries.length) {
                entry = entries[i];
                if (entry.target != 0) {
                    OS.g_free((int)entry.target);
                }
                ++i;
            }
            if (pTargetsList != 0) {
                OS.g_free((int)pTargetsList);
            }
            return true;
lbl-1000:
            // 1 sources

            {
                entry = entries[i];
                if (entry.target != 0) {
                    OS.g_free((int)entry.target);
                }
                ++i;
                continue;
            }
lbl100:
            // 1 sources

            if (pTargetsList == 0) break block23;
            OS.g_free((int)pTargetsList);
        }
        throw var17_30;
    }
}

