/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoAttribute;
import org.eclipse.swt.internal.gtk.PangoItem;
import org.eclipse.swt.internal.gtk.PangoLayoutLine;
import org.eclipse.swt.internal.gtk.PangoLayoutRun;
import org.eclipse.swt.internal.gtk.PangoLogAttr;
import org.eclipse.swt.internal.gtk.PangoRectangle;

public final class TextLayout {
    Device device;
    Font font;
    String text;
    int ascent;
    int descent;
    int[] segments;
    StyleItem[] styles;
    int layout;
    int context;
    int attrList;
    int[] invalidOffsets;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    static final char ZWS = '\u200b';
    static final char ZWNBS = '\ufeff';

    public TextLayout(Device device) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        this.context = OS.gdk_pango_context_get();
        if (this.context == 0) {
            SWT.error(2);
        }
        this.layout = OS.pango_layout_new((int)this.context);
        if (this.layout == 0) {
            SWT.error(2);
        }
        OS.pango_context_set_language((int)this.context, (int)OS.gtk_get_default_language());
        OS.pango_context_set_base_dir((int)this.context, (int)0);
        OS.gdk_pango_context_set_colormap((int)this.context, (int)OS.gdk_colormap_get_system());
        OS.pango_layout_set_wrap((int)this.layout, (int)2);
        OS.pango_layout_set_tabs((int)this.layout, (int)device.emptyTab);
        this.text = "";
        this.descent = -1;
        this.ascent = -1;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    void computeRuns() {
        char c;
        if (this.attrList != 0) {
            return;
        }
        String segmentsText = this.getSegmentsText();
        byte[] buffer = Converter.wcsToMbcs(null, segmentsText, false);
        OS.pango_layout_set_text((int)this.layout, (byte[])buffer, (int)buffer.length);
        if (this.styles.length == 2 && this.styles[0].style == null && this.ascent == -1 && this.descent == -1) {
            return;
        }
        int ptr = OS.pango_layout_get_text((int)this.layout);
        this.attrList = OS.pango_attr_list_new();
        PangoAttribute attribute = new PangoAttribute();
        char[] chars = null;
        int segementsLength = segmentsText.length();
        if ((this.ascent != -1 || this.descent != -1) && segementsLength > 0) {
            int iter = OS.pango_layout_get_iter((int)this.layout);
            if (iter == 0) {
                SWT.error(2);
            }
            PangoRectangle rect = new PangoRectangle();
            if (this.ascent != -1) {
                rect.y = -(this.ascent * 1024);
            }
            rect.height = (Math.max(0, this.ascent) + Math.max(0, this.descent)) * 1024;
            int lineCount = OS.pango_layout_get_line_count((int)this.layout);
            chars = new char[segementsLength + lineCount * 2];
            int oldPos = 0;
            int count = 0;
            do {
                int bytePos = OS.pango_layout_iter_get_index((int)iter);
                int offset = count * 6;
                int attr = OS.pango_attr_shape_new((PangoRectangle)rect, (PangoRectangle)rect);
                OS.memmove((PangoAttribute)attribute, (int)attr, (int)PangoAttribute.sizeof);
                attribute.start_index = bytePos + offset;
                attribute.end_index = bytePos + offset + 3;
                OS.memmove((int)attr, (PangoAttribute)attribute, (int)PangoAttribute.sizeof);
                OS.pango_attr_list_insert((int)this.attrList, (int)attr);
                attr = OS.pango_attr_shape_new((PangoRectangle)rect, (PangoRectangle)rect);
                OS.memmove((PangoAttribute)attribute, (int)attr, (int)PangoAttribute.sizeof);
                attribute.start_index = bytePos + offset + 3;
                attribute.end_index = bytePos + offset + 6;
                OS.memmove((int)attr, (PangoAttribute)attribute, (int)PangoAttribute.sizeof);
                OS.pango_attr_list_insert((int)this.attrList, (int)attr);
                int pos = OS.g_utf8_pointer_to_offset((int)ptr, (int)(ptr + bytePos));
                chars[pos + count * 2] = 8203;
                chars[pos + count * 2 + 1] = 65279;
                segmentsText.getChars(oldPos, pos, chars, oldPos + count * 2);
                oldPos = pos;
                ++count;
            } while (OS.pango_layout_iter_next_line((int)iter));
            OS.pango_layout_iter_free((int)iter);
            segmentsText.getChars(oldPos, segementsLength, chars, oldPos + count * 2);
            buffer = Converter.wcsToMbcs(null, chars, false);
            OS.pango_layout_set_text((int)this.layout, (byte[])buffer, (int)buffer.length);
            ptr = OS.pango_layout_get_text((int)this.layout);
        } else {
            chars = new char[segementsLength];
            segmentsText.getChars(0, segementsLength, chars, 0);
        }
        int offsetCount = 0;
        int i = 0;
        while (i < chars.length) {
            c = chars[i];
            if (c == '\u200e' || c == '\u200f' || c == '\ufeff' || c == '\u200b') {
                ++offsetCount;
            }
            ++i;
        }
        this.invalidOffsets = new int[offsetCount];
        offsetCount = 0;
        i = 0;
        while (i < chars.length) {
            c = chars[i];
            if (c == '\u200e' || c == '\u200f' || c == '\ufeff' || c == '\u200b') {
                this.invalidOffsets[offsetCount++] = i;
            }
            ++i;
        }
        i = 0;
        while (i < this.styles.length - 1) {
            StyleItem styleItem = this.styles[i];
            TextStyle style = styleItem.style;
            if (style != null) {
                Color background;
                Color foreground;
                int attr;
                int start = this.translateOffset(styleItem.start);
                int end = this.translateOffset(this.styles[i + 1].start - 1);
                int byteStart = OS.g_utf8_offset_to_pointer((int)ptr, (int)start) - ptr;
                int byteEnd = OS.g_utf8_offset_to_pointer((int)ptr, (int)(end + 1)) - ptr;
                Font font = style.font;
                if (font != null && !font.isDisposed()) {
                    attr = OS.pango_attr_font_desc_new((int)font.handle);
                    OS.memmove((PangoAttribute)attribute, (int)attr, (int)PangoAttribute.sizeof);
                    attribute.start_index = byteStart;
                    attribute.end_index = byteEnd;
                    OS.memmove((int)attr, (PangoAttribute)attribute, (int)PangoAttribute.sizeof);
                    OS.pango_attr_list_insert((int)this.attrList, (int)attr);
                }
                if (style.underline) {
                    attr = OS.pango_attr_underline_new((int)1);
                    OS.memmove((PangoAttribute)attribute, (int)attr, (int)PangoAttribute.sizeof);
                    attribute.start_index = byteStart;
                    attribute.end_index = byteEnd;
                    OS.memmove((int)attr, (PangoAttribute)attribute, (int)PangoAttribute.sizeof);
                    OS.pango_attr_list_insert((int)this.attrList, (int)attr);
                }
                if (style.strikeout) {
                    attr = OS.pango_attr_strikethrough_new((boolean)true);
                    OS.memmove((PangoAttribute)attribute, (int)attr, (int)PangoAttribute.sizeof);
                    attribute.start_index = byteStart;
                    attribute.end_index = byteEnd;
                    OS.memmove((int)attr, (PangoAttribute)attribute, (int)PangoAttribute.sizeof);
                    OS.pango_attr_list_insert((int)this.attrList, (int)attr);
                }
                if ((foreground = style.foreground) != null && !foreground.isDisposed()) {
                    GdkColor fg = foreground.handle;
                    int attr2 = OS.pango_attr_foreground_new((short)fg.red, (short)fg.green, (short)fg.blue);
                    OS.memmove((PangoAttribute)attribute, (int)attr2, (int)PangoAttribute.sizeof);
                    attribute.start_index = byteStart;
                    attribute.end_index = byteEnd;
                    OS.memmove((int)attr2, (PangoAttribute)attribute, (int)PangoAttribute.sizeof);
                    OS.pango_attr_list_insert((int)this.attrList, (int)attr2);
                }
                if ((background = style.background) != null && !background.isDisposed()) {
                    GdkColor bg = background.handle;
                    int attr3 = OS.pango_attr_background_new((short)bg.red, (short)bg.green, (short)bg.blue);
                    OS.memmove((PangoAttribute)attribute, (int)attr3, (int)PangoAttribute.sizeof);
                    attribute.start_index = byteStart;
                    attribute.end_index = byteEnd;
                    OS.memmove((int)attr3, (PangoAttribute)attribute, (int)PangoAttribute.sizeof);
                    OS.pango_attr_list_insert((int)this.attrList, (int)attr3);
                }
            }
            ++i;
        }
        OS.pango_layout_set_attributes((int)this.layout, (int)this.attrList);
    }

    public void dispose() {
        if (this.layout == 0) {
            return;
        }
        this.font = null;
        this.text = null;
        this.styles = null;
        this.freeRuns();
        if (this.layout != 0) {
            OS.g_object_unref((int)this.layout);
        }
        this.layout = 0;
        if (this.context != 0) {
            OS.g_object_unref((int)this.context);
        }
        this.context = 0;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public void draw(GC gc, int x, int y) {
        this.checkLayout();
        this.computeRuns();
        if (gc == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        OS.gdk_draw_layout((int)gc.data.drawable, (int)gc.handle, (int)x, (int)y, (int)this.layout);
    }

    public void draw(GC gc, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        boolean hasSelection;
        int length;
        this.checkLayout();
        this.computeRuns();
        if (gc == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        if (selectionForeground != null && selectionForeground.isDisposed()) {
            SWT.error(5);
        }
        if (selectionBackground != null && selectionBackground.isDisposed()) {
            SWT.error(5);
        }
        if ((length = this.text.length()) == 0) {
            return;
        }
        boolean bl = hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
        if (!hasSelection) {
            OS.gdk_draw_layout((int)gc.data.drawable, (int)gc.handle, (int)x, (int)y, (int)this.layout);
        } else {
            boolean fullSelection;
            selectionStart = Math.min(Math.max(0, selectionStart), length - 1);
            selectionEnd = Math.min(Math.max(0, selectionEnd), length - 1);
            length = OS.g_utf8_strlen((int)OS.pango_layout_get_text((int)this.layout), (int)-1);
            selectionStart = this.translateOffset(selectionStart);
            selectionEnd = this.translateOffset(selectionEnd);
            if (selectionForeground == null) {
                selectionForeground = this.device.getSystemColor(27);
            }
            if (selectionBackground == null) {
                selectionBackground = this.device.getSystemColor(26);
            }
            boolean bl2 = fullSelection = selectionStart == 0 && selectionEnd == length - 1;
            if (fullSelection) {
                OS.gdk_draw_layout_with_colors((int)gc.data.drawable, (int)gc.handle, (int)x, (int)y, (int)this.layout, (GdkColor)selectionForeground.handle, (GdkColor)selectionBackground.handle);
            } else {
                int ptr = OS.pango_layout_get_text((int)this.layout);
                Region clipping = new Region();
                gc.getClipping(clipping);
                int byteSelStart = OS.g_utf8_offset_to_pointer((int)ptr, (int)selectionStart) - ptr;
                int byteSelEnd = OS.g_utf8_offset_to_pointer((int)ptr, (int)(selectionEnd + 1)) - ptr;
                OS.gdk_draw_layout((int)gc.data.drawable, (int)gc.handle, (int)x, (int)y, (int)this.layout);
                int[] ranges = new int[]{byteSelStart, byteSelEnd};
                int rgn = OS.gdk_pango_layout_get_clip_region((int)this.layout, (int)x, (int)y, (int[])ranges, (int)(ranges.length / 2));
                if (rgn != 0) {
                    OS.gdk_gc_set_clip_region((int)gc.handle, (int)rgn);
                    OS.gdk_region_destroy((int)rgn);
                }
                OS.gdk_draw_layout_with_colors((int)gc.data.drawable, (int)gc.handle, (int)x, (int)y, (int)this.layout, (GdkColor)selectionForeground.handle, (GdkColor)selectionBackground.handle);
                gc.setClipping(clipping);
            }
        }
    }

    void freeRuns() {
        if (this.attrList == 0) {
            return;
        }
        OS.pango_layout_set_attributes((int)this.layout, (int)0);
        OS.pango_attr_list_unref((int)this.attrList);
        this.attrList = 0;
        this.invalidOffsets = null;
    }

    public int getAlignment() {
        this.checkLayout();
        int align = OS.pango_layout_get_alignment((int)this.layout);
        switch (align) {
            case 1: {
                return 0x1000000;
            }
            case 2: {
                return 131072;
            }
        }
        return 16384;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascent;
    }

    public Rectangle getBounds() {
        this.checkLayout();
        this.computeRuns();
        int[] w = new int[1];
        int[] h = new int[1];
        OS.pango_layout_get_size((int)this.layout, (int[])w, (int[])h);
        int wrapWidth = OS.pango_layout_get_width((int)this.layout);
        int width = OS.PANGO_PIXELS((int)(wrapWidth != -1 ? wrapWidth : w[0]));
        int height = OS.PANGO_PIXELS((int)h[0]);
        return new Rectangle(0, 0, width, height);
    }

    public Rectangle getBounds(int start, int end) {
        int linesRegion;
        int byteEnd;
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (length == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (start > end) {
            return new Rectangle(0, 0, 0, 0);
        }
        start = Math.min(Math.max(0, start), length - 1);
        end = Math.min(Math.max(0, end), length - 1);
        start = this.translateOffset(start);
        end = this.translateOffset(end);
        int ptr = OS.pango_layout_get_text((int)this.layout);
        int byteStart = OS.g_utf8_offset_to_pointer((int)ptr, (int)start) - ptr;
        int[] ranges = new int[]{byteStart, byteEnd = OS.g_utf8_offset_to_pointer((int)ptr, (int)(end + 1)) - ptr};
        int clipRegion = OS.gdk_pango_layout_get_clip_region((int)this.layout, (int)0, (int)0, (int[])ranges, (int)1);
        if (clipRegion == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        GdkRectangle rect = new GdkRectangle();
        PangoRectangle pangoRect = new PangoRectangle();
        int iter = OS.pango_layout_get_iter((int)this.layout);
        if (iter == 0) {
            SWT.error(2);
        }
        if ((linesRegion = OS.gdk_region_new()) == 0) {
            SWT.error(2);
        }
        int lineStart = 0;
        int lineEnd = 0;
        do {
            OS.pango_layout_iter_get_line_extents((int)iter, null, (PangoRectangle)pangoRect);
            lineEnd = OS.pango_layout_iter_next_line((int)iter) ? OS.pango_layout_iter_get_index((int)iter) - 1 : OS.strlen((int)ptr);
            if (lineStart > byteStart && byteEnd > lineEnd) continue;
            rect.x = OS.PANGO_PIXELS((int)pangoRect.x);
            rect.y = OS.PANGO_PIXELS((int)pangoRect.y);
            rect.width = OS.PANGO_PIXELS((int)pangoRect.width);
            rect.height = OS.PANGO_PIXELS((int)pangoRect.height);
            OS.gdk_region_union_with_rect((int)linesRegion, (GdkRectangle)rect);
        } while ((lineStart = lineEnd + 1) <= byteEnd);
        OS.gdk_region_intersect((int)clipRegion, (int)linesRegion);
        OS.gdk_region_destroy((int)linesRegion);
        OS.pango_layout_iter_free((int)iter);
        OS.gdk_region_get_clipbox((int)clipRegion, (GdkRectangle)rect);
        OS.gdk_region_destroy((int)clipRegion);
        return new Rectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public int getDescent() {
        this.checkLayout();
        return this.descent;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    public int getLevel(int offset) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        offset = this.translateOffset(offset);
        int iter = OS.pango_layout_get_iter((int)this.layout);
        if (iter == 0) {
            SWT.error(2);
        }
        int level = 0;
        PangoItem item = new PangoItem();
        PangoLayoutRun run = new PangoLayoutRun();
        int ptr = OS.pango_layout_get_text((int)this.layout);
        int byteOffset = OS.g_utf8_offset_to_pointer((int)ptr, (int)offset) - ptr;
        do {
            int runPtr;
            if ((runPtr = OS.pango_layout_iter_get_run((int)iter)) == 0) continue;
            OS.memmove((PangoLayoutRun)run, (int)runPtr, (int)PangoLayoutRun.sizeof);
            OS.memmove((PangoItem)item, (int)run.item, (int)PangoItem.sizeof);
            if (item.offset > byteOffset || byteOffset >= item.offset + item.length) continue;
            level = item.analysis_level;
            break;
        } while (OS.pango_layout_iter_next_run((int)iter));
        OS.pango_layout_iter_free((int)iter);
        return level;
    }

    public Rectangle getLineBounds(int lineIndex) {
        int iter;
        this.checkLayout();
        this.computeRuns();
        int lineCount = OS.pango_layout_get_line_count((int)this.layout);
        if (lineIndex < 0 || lineIndex >= lineCount) {
            SWT.error(6);
        }
        if ((iter = OS.pango_layout_get_iter((int)this.layout)) == 0) {
            SWT.error(2);
        }
        int i = 0;
        while (i < lineIndex) {
            OS.pango_layout_iter_next_line((int)iter);
            ++i;
        }
        PangoRectangle rect = new PangoRectangle();
        OS.pango_layout_iter_get_line_extents((int)iter, null, (PangoRectangle)rect);
        OS.pango_layout_iter_free((int)iter);
        int x = OS.PANGO_PIXELS((int)rect.x);
        int y = OS.PANGO_PIXELS((int)rect.y);
        int width = OS.PANGO_PIXELS((int)rect.width);
        int height = OS.PANGO_PIXELS((int)rect.height);
        return new Rectangle(x, y, width, height);
    }

    public int getLineCount() {
        this.checkLayout();
        this.computeRuns();
        return OS.pango_layout_get_line_count((int)this.layout);
    }

    public int getLineIndex(int offset) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(5);
        }
        offset = this.translateOffset(offset);
        int line = 0;
        int ptr = OS.pango_layout_get_text((int)this.layout);
        int byteOffset = OS.g_utf8_offset_to_pointer((int)ptr, (int)offset) - ptr;
        int iter = OS.pango_layout_get_iter((int)this.layout);
        if (iter == 0) {
            SWT.error(2);
        }
        while (OS.pango_layout_iter_next_line((int)iter)) {
            if (OS.pango_layout_iter_get_index((int)iter) > byteOffset) break;
            ++line;
        }
        OS.pango_layout_iter_free((int)iter);
        return line;
    }

    public FontMetrics getLineMetrics(int lineIndex) {
        this.checkLayout();
        this.computeRuns();
        int lineCount = OS.pango_layout_get_line_count((int)this.layout);
        if (lineIndex < 0 || lineIndex >= lineCount) {
            SWT.error(6);
        }
        int font = this.font != null ? this.font.handle : this.device.systemFont.handle;
        int lang = OS.pango_context_get_language((int)this.context);
        int ascent = 0;
        int descent = 0;
        int averageCharWidth = 0;
        int height = 0;
        int metrics = OS.pango_context_get_metrics((int)this.context, (int)font, (int)lang);
        if (this.text.length() == 0) {
            ascent = OS.pango_font_metrics_get_ascent((int)metrics);
            descent = OS.pango_font_metrics_get_descent((int)metrics);
            averageCharWidth = OS.pango_font_metrics_get_approximate_char_width((int)metrics);
            height = ascent + descent;
        } else {
            PangoLayoutLine line = new PangoLayoutLine();
            OS.memmove((PangoLayoutLine)line, (int)OS.pango_layout_get_line((int)this.layout, (int)lineIndex), (int)PangoLayoutLine.sizeof);
            int runs = line.runs;
            PangoItem item = new PangoItem();
            PangoLayoutRun run = new PangoLayoutRun();
            int runCount = 0;
            ascent = Math.max(0, this.ascent * 1024);
            descent = Math.max(0, this.descent * 1024);
            while (runs != 0) {
                OS.memmove((PangoLayoutRun)run, (int)OS.g_slist_data((int)runs), (int)PangoLayoutRun.sizeof);
                OS.memmove((PangoItem)item, (int)run.item, (int)PangoItem.sizeof);
                int runMetrics = metrics;
                if (item.analysis_font != 0) {
                    runMetrics = OS.pango_font_get_metrics((int)item.analysis_font, (int)item.analysis_language);
                }
                int runAscent = OS.pango_font_metrics_get_ascent((int)runMetrics);
                int runDescent = OS.pango_font_metrics_get_descent((int)runMetrics);
                ascent = Math.max(ascent, runAscent);
                descent = Math.max(descent, runDescent);
                averageCharWidth += OS.pango_font_metrics_get_approximate_char_width((int)runMetrics);
                height = Math.max(height, runAscent + runDescent);
                if (metrics != runMetrics) {
                    OS.pango_font_metrics_unref((int)runMetrics);
                }
                ++runCount;
                runs = OS.g_slist_next((int)runs);
            }
            averageCharWidth /= runCount;
        }
        OS.pango_font_metrics_unref((int)metrics);
        ascent = OS.PANGO_PIXELS((int)ascent);
        descent = OS.PANGO_PIXELS((int)descent);
        averageCharWidth = OS.PANGO_PIXELS((int)averageCharWidth);
        height = OS.PANGO_PIXELS((int)height);
        return FontMetrics.gtk_new(ascent, descent, averageCharWidth, 0, height);
    }

    public int[] getLineOffsets() {
        this.checkLayout();
        this.computeRuns();
        int lineCount = OS.pango_layout_get_line_count((int)this.layout);
        int[] offsets = new int[lineCount + 1];
        int ptr = OS.pango_layout_get_text((int)this.layout);
        int iter = OS.pango_layout_get_iter((int)this.layout);
        if (iter == 0) {
            SWT.error(2);
        }
        int i = 0;
        do {
            int bytePos = OS.pango_layout_iter_get_index((int)iter);
            int pos = OS.g_utf8_pointer_to_offset((int)ptr, (int)(ptr + bytePos));
            offsets[i++] = this.untranslateOffset(pos);
        } while (OS.pango_layout_iter_next_line((int)iter));
        offsets[lineCount] = this.text.length();
        return offsets;
    }

    public Point getLocation(int offset, boolean trailing) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        offset = this.translateOffset(offset);
        int ptr = OS.pango_layout_get_text((int)this.layout);
        int byteOffset = OS.g_utf8_offset_to_pointer((int)ptr, (int)offset) - ptr;
        PangoRectangle pos = new PangoRectangle();
        OS.pango_layout_index_to_pos((int)this.layout, (int)byteOffset, (PangoRectangle)pos);
        int x = trailing ? pos.x + pos.width : pos.x;
        int y = pos.y;
        return new Point(OS.PANGO_PIXELS((int)x), OS.PANGO_PIXELS((int)y));
    }

    public int getNextOffset(int offset, int movement) {
        return this._getOffset(offset, movement, true);
    }

    int _getOffset(int offset, int movement, boolean forward) {
        int step;
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        if (forward) {
            if (offset == length) {
                return length;
            }
        } else if (offset == 0) {
            return 0;
        }
        int n = step = forward ? 1 : -1;
        if ((movement & 1) != 0) {
            return offset + step;
        }
        int[] attrs = new int[1];
        int[] nAttrs = new int[1];
        OS.pango_layout_get_log_attrs((int)this.layout, (int[])attrs, (int[])nAttrs);
        if (attrs[0] == 0) {
            return offset + step;
        }
        length = OS.g_utf8_strlen((int)OS.pango_layout_get_text((int)this.layout), (int)-1);
        offset = this.translateOffset(offset);
        PangoLogAttr logAttr = new PangoLogAttr();
        offset = this.validateOffset(offset, step);
        while (offset > 0 && offset < length) {
            OS.memmove((PangoLogAttr)logAttr, (int)(attrs[0] + offset * PangoLogAttr.sizeof), (int)PangoLogAttr.sizeof);
            if ((movement & 2) != 0 && logAttr.is_cursor_position || (movement & 4) != 0 && (logAttr.is_word_start || logAttr.is_sentence_end)) break;
            offset = this.validateOffset(offset, step);
        }
        OS.g_free((int)attrs[0]);
        return Math.min(Math.max(0, this.untranslateOffset(offset)), this.text.length());
    }

    public int getOffset(Point point, int[] trailing) {
        this.checkLayout();
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffset(point.x, point.y, trailing);
    }

    public int getOffset(int x, int y, int[] trailing) {
        int iter;
        this.checkLayout();
        this.computeRuns();
        if (trailing != null && trailing.length < 1) {
            SWT.error(5);
        }
        if ((iter = OS.pango_layout_get_iter((int)this.layout)) == 0) {
            SWT.error(2);
        }
        PangoRectangle rect = new PangoRectangle();
        do {
            OS.pango_layout_iter_get_line_extents((int)iter, null, (PangoRectangle)rect);
            rect.y = OS.PANGO_PIXELS((int)rect.y);
            rect.height = OS.PANGO_PIXELS((int)rect.height);
            if (rect.y > y || y >= rect.y + rect.height) continue;
            rect.x = OS.PANGO_PIXELS((int)rect.x);
            rect.width = OS.PANGO_PIXELS((int)rect.width);
            if (x >= rect.x + rect.width) {
                x = rect.x + rect.width - 1;
            }
            if (x >= rect.x) break;
            x = rect.x;
            break;
        } while (OS.pango_layout_iter_next_line((int)iter));
        OS.pango_layout_iter_free((int)iter);
        int[] index = new int[1];
        int[] piTrailing = new int[1];
        OS.pango_layout_xy_to_index((int)this.layout, (int)(x * 1024), (int)(y * 1024), (int[])index, (int[])piTrailing);
        int ptr = OS.pango_layout_get_text((int)this.layout);
        int offset = OS.g_utf8_pointer_to_offset((int)ptr, (int)(ptr + index[0]));
        if (trailing != null) {
            trailing[0] = piTrailing[0];
        }
        return this.untranslateOffset(offset);
    }

    public int getOrientation() {
        this.checkLayout();
        int baseDir = OS.pango_context_get_base_dir((int)this.context);
        return baseDir == 1 ? 0x4000000 : 0x2000000;
    }

    public int getPreviousOffset(int index, int movement) {
        return this._getOffset(index, movement, false);
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    String getSegmentsText() {
        if (this.segments == null) {
            return this.text;
        }
        int nSegments = this.segments.length;
        if (nSegments <= 1) {
            return this.text;
        }
        int length = this.text.length();
        if (length == 0) {
            return this.text;
        }
        if (nSegments == 2 && this.segments[0] == 0 && this.segments[1] == length) {
            return this.text;
        }
        char[] oldChars = new char[length];
        this.text.getChars(0, length, oldChars, 0);
        char[] newChars = new char[length + nSegments];
        int charCount = 0;
        int segmentCount = 0;
        int separator = this.getOrientation() == 0x4000000 ? 8207 : 8206;
        while (charCount < length) {
            if (segmentCount < nSegments && charCount == this.segments[segmentCount]) {
                newChars[charCount + segmentCount++] = separator;
                continue;
            }
            newChars[charCount + segmentCount] = oldChars[charCount++];
        }
        if (segmentCount < nSegments) {
            this.segments[segmentCount] = charCount;
            newChars[charCount + segmentCount++] = separator;
        }
        return new String(newChars, 0, Math.min(charCount + segmentCount, newChars.length));
    }

    public int getSpacing() {
        this.checkLayout();
        return OS.PANGO_PIXELS((int)OS.pango_layout_get_spacing((int)this.layout));
    }

    public TextStyle getStyle(int offset) {
        this.checkLayout();
        int length = this.text.length();
        if (offset < 0 || offset >= length) {
            SWT.error(6);
        }
        int i = 1;
        while (i < this.styles.length) {
            StyleItem item = this.styles[i];
            if (item.start > offset) {
                return this.styles[i - 1].style;
            }
            ++i;
        }
        return null;
    }

    public int[] getTabs() {
        this.checkLayout();
        int tabArray = OS.pango_layout_get_tabs((int)this.layout);
        if (tabArray == 0) {
            return null;
        }
        int nTabs = OS.pango_tab_array_get_size((int)tabArray);
        int[] tabs = new int[nTabs];
        if (nTabs > 0) {
            int[] locations = new int[1];
            OS.pango_tab_array_get_tabs((int)tabArray, null, (int[])locations);
            if (locations[0] != 0) {
                OS.memmove((int[])tabs, (int)locations[0], (int)(nTabs * 4));
                OS.g_free((int)locations[0]);
            }
        }
        OS.pango_tab_array_free((int)tabArray);
        return tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getWidth() {
        this.checkLayout();
        int width = OS.pango_layout_get_width((int)this.layout);
        return width != -1 ? OS.PANGO_PIXELS((int)width) : -1;
    }

    public boolean isDisposed() {
        return this.layout == 0;
    }

    public void setAlignment(int alignment) {
        this.checkLayout();
        int mask = 16924672;
        if ((alignment &= mask) == 0) {
            return;
        }
        if ((alignment & 0x4000) != 0) {
            alignment = 16384;
        }
        if ((alignment & 0x20000) != 0) {
            alignment = 131072;
        }
        int align = 0;
        switch (alignment) {
            case 0x1000000: {
                align = 1;
                break;
            }
            case 131072: {
                align = 2;
            }
        }
        OS.pango_layout_set_alignment((int)this.layout, (int)align);
    }

    public void setAscent(int ascent) {
        this.checkLayout();
        if (ascent < -1) {
            SWT.error(5);
        }
        if (this.ascent == ascent) {
            return;
        }
        this.freeRuns();
        this.ascent = ascent;
    }

    public void setDescent(int descent) {
        this.checkLayout();
        if (descent < -1) {
            SWT.error(5);
        }
        if (this.descent == descent) {
            return;
        }
        this.freeRuns();
        this.descent = descent;
    }

    public void setFont(Font font) {
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (this.font == font) {
            return;
        }
        if (font != null && font.equals(this.font)) {
            return;
        }
        this.font = font;
        OS.pango_layout_set_font_description((int)this.layout, (int)(font != null ? font.handle : 0));
    }

    public void setOrientation(int orientation) {
        int baseDir;
        this.checkLayout();
        int mask = 0x6000000;
        if ((orientation &= mask) == 0) {
            return;
        }
        if ((orientation & 0x2000000) != 0) {
            orientation = 0x2000000;
        }
        int n = baseDir = orientation == 0x4000000 ? 1 : 0;
        if (OS.pango_context_get_base_dir((int)this.context) == baseDir) {
            return;
        }
        OS.pango_context_set_base_dir((int)this.context, (int)baseDir);
        OS.pango_layout_context_changed((int)this.layout);
    }

    public void setSpacing(int spacing) {
        this.checkLayout();
        if (spacing < 0) {
            SWT.error(5);
        }
        OS.pango_layout_set_spacing((int)this.layout, (int)(spacing * 1024));
    }

    public void setSegments(int[] segments) {
        this.checkLayout();
        if (this.segments == null && segments == null) {
            return;
        }
        if (this.segments != null && segments != null && this.segments.length == segments.length) {
            int i = 0;
            while (i < segments.length) {
                if (this.segments[i] != segments[i]) break;
                ++i;
            }
            if (i == segments.length) {
                return;
            }
        }
        this.freeRuns();
        this.segments = segments;
    }

    /*
     * Unable to fully structure code
     */
    public void setStyle(TextStyle style, int start, int end) {
        block15: {
            this.checkLayout();
            length = this.text.length();
            if (length == 0) {
                return;
            }
            if (start > end) {
                return;
            }
            start = Math.min(Math.max(0, start), length - 1);
            end = Math.min(Math.max(0, end), length - 1);
            if (start > 0 && TextLayout.isAlef(this.text.charAt(start)) && TextLayout.isLam(this.text.charAt(start - 1))) {
                --start;
            }
            if (end < length - 1 && TextLayout.isLam(this.text.charAt(end)) && TextLayout.isAlef(this.text.charAt(end + 1))) {
                ++end;
            }
            low = -1;
            high = this.styles.length;
            while (high - low > 1) {
                index = (high + low) / 2;
                if (start <= this.styles[index].start) {
                    high = index;
                    continue;
                }
                low = index;
            }
            if (high >= 0 && high < this.styles.length) {
                item = this.styles[high];
                if (item.start == start && this.styles[high + 1].start - 1 == end && (style == null ? item.style == null : style.equals(item.style) != false)) {
                    return;
                }
            }
            this.freeRuns();
            count = 0;
            newStyles = new StyleItem[this.styles.length + 2];
            i = 0;
            while (i < this.styles.length) {
                item = this.styles[i];
                if (item.start >= start) break;
                newStyles[count++] = item;
                ++i;
            }
            newItem = new StyleItem();
            newItem.start = start;
            newItem.style = style;
            newStyles[count++] = newItem;
            if (this.styles[i].start <= end) ** GOTO lbl49
            newItem = new StyleItem();
            newItem.start = end + 1;
            newItem.style = this.styles[i - 1].style;
            newStyles[count++] = newItem;
            break block15;
lbl-1000:
            // 1 sources

            {
                item = this.styles[i];
                if (item.start > end) break;
                ++i;
lbl49:
                // 2 sources

                ** while (i < this.styles.length)
            }
lbl50:
            // 2 sources

            if (end != this.styles[i].start - 1) {
                this.styles[--i].start = end + 1;
            }
        }
        while (i < this.styles.length) {
            item = this.styles[i];
            if (item.start > end) {
                newStyles[count++] = item;
            }
            ++i;
        }
        if (newStyles.length != count) {
            this.styles = new StyleItem[count];
            System.arraycopy(newStyles, 0, this.styles, 0, count);
        } else {
            this.styles = newStyles;
        }
    }

    public void setTabs(int[] tabs) {
        this.checkLayout();
        if (tabs == null) {
            OS.pango_layout_set_tabs((int)this.layout, (int)this.device.emptyTab);
        } else {
            int tabArray = OS.pango_tab_array_new((int)tabs.length, (boolean)true);
            if (tabArray != 0) {
                int i = 0;
                while (i < tabs.length) {
                    OS.pango_tab_array_set_tab((int)tabArray, (int)i, (int)0, (int)tabs[i]);
                    ++i;
                }
                OS.pango_layout_set_tabs((int)this.layout, (int)tabArray);
                OS.pango_tab_array_free((int)tabArray);
            }
        }
    }

    public void setText(String text) {
        this.checkLayout();
        if (text == null) {
            SWT.error(4);
        }
        if (text.equals(this.text)) {
            return;
        }
        this.freeRuns();
        this.text = text;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.styles[this.styles.length - 1].start = text.length();
    }

    public void setWidth(int width) {
        this.checkLayout();
        if (width < -1 || width == 0) {
            SWT.error(5);
        }
        OS.pango_layout_set_width((int)this.layout, (int)(width == -1 ? -1 : width * 1024));
    }

    static final boolean isLam(int ch) {
        return ch == 1604;
    }

    static final boolean isAlef(int ch) {
        switch (ch) {
            case 1570: 
            case 1571: 
            case 1573: 
            case 1575: 
            case 1609: 
            case 1648: 
            case 1649: 
            case 1650: 
            case 1651: 
            case 1653: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {" + this.layout + "}";
    }

    int translateOffset(int offset) {
        int length = this.text.length();
        if (length == 0) {
            return offset;
        }
        if (this.invalidOffsets == null) {
            return offset;
        }
        int i = 0;
        while (i < this.invalidOffsets.length) {
            if (offset < this.invalidOffsets[i]) break;
            ++offset;
            ++i;
        }
        return offset;
    }

    int untranslateOffset(int offset) {
        int length = this.text.length();
        if (length == 0) {
            return offset;
        }
        if (this.invalidOffsets == null) {
            return offset;
        }
        int i = 0;
        while (i < this.invalidOffsets.length) {
            if (offset == this.invalidOffsets[i]) {
                ++offset;
            } else if (offset < this.invalidOffsets[i]) {
                return offset - i;
            }
            ++i;
        }
        return offset - this.invalidOffsets.length;
    }

    int validateOffset(int offset, int step) {
        if (this.invalidOffsets == null) {
            return offset + step;
        }
        int i = step > 0 ? 0 : this.invalidOffsets.length - 1;
        block0: do {
            offset += step;
            while (i >= 0 && i < this.invalidOffsets.length) {
                if (this.invalidOffsets[i] == offset) continue block0;
                i += step;
            }
        } while (i >= 0 && i < this.invalidOffsets.length);
        return offset;
    }

    static class StyleItem {
        TextStyle style;
        int start;

        StyleItem() {
        }
    }
}

