/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.cairo.Cairo;

public class Transform {
    public int handle;
    Device device;

    public Transform(Device device) {
        this(device, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    }

    public Transform(Device device, float[] elements) {
        this(device, Transform.checkTransform(elements)[0], elements[1], elements[2], elements[3], elements[4], elements[5]);
    }

    public Transform(Device device, float m11, float m12, float m21, float m22, float dx, float dy) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        device.checkCairo();
        this.handle = Cairo.cairo_matrix_create();
        if (this.handle == 0) {
            SWT.error(2);
        }
        Cairo.cairo_matrix_set_affine((int)this.handle, (double)m11, (double)m12, (double)m21, (double)m22, (double)dx, (double)dy);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    static float[] checkTransform(float[] elements) {
        if (elements == null) {
            SWT.error(4);
        }
        if (elements.length < 6) {
            SWT.error(5);
        }
        return elements;
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        Cairo.cairo_matrix_destroy((int)this.handle);
        this.handle = 0;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public void getElements(float[] elements) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (elements == null) {
            SWT.error(4);
        }
        if (elements.length < 6) {
            SWT.error(5);
        }
        double[] a = new double[1];
        double[] b = new double[1];
        double[] c = new double[1];
        double[] d = new double[1];
        double[] tx = new double[1];
        double[] ty = new double[1];
        Cairo.cairo_matrix_get_affine((int)this.handle, (double[])a, (double[])b, (double[])c, (double[])d, (double[])tx, (double[])ty);
        elements[0] = (float)a[0];
        elements[1] = (float)b[0];
        elements[2] = (float)c[0];
        elements[3] = (float)d[0];
        elements[4] = (float)tx[0];
        elements[5] = (float)ty[0];
    }

    public void invert() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (Cairo.cairo_matrix_invert((int)this.handle) != 0) {
            SWT.error(10);
        }
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public boolean isIdentity() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        float[] m = new float[6];
        this.getElements(m);
        return m[0] == 1.0f && m[1] == 0.0f && m[2] == 0.0f && m[3] == 1.0f && m[4] == 0.0f && m[5] == 0.0f;
    }

    public void multiply(Transform matrix) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (matrix == null) {
            SWT.error(4);
        }
        if (matrix.isDisposed()) {
            SWT.error(5);
        }
        Cairo.cairo_matrix_multiply((int)this.handle, (int)matrix.handle, (int)this.handle);
    }

    public void rotate(float angle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Cairo.cairo_matrix_rotate((int)this.handle, (double)(angle * (float)Compatibility.PI / 180.0f));
    }

    public void scale(float scaleX, float scaleY) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Cairo.cairo_matrix_scale((int)this.handle, (double)scaleX, (double)scaleY);
    }

    public void setElements(float m11, float m12, float m21, float m22, float dx, float dy) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Cairo.cairo_matrix_set_affine((int)this.handle, (double)m11, (double)m12, (double)m21, (double)m22, (double)dx, (double)dy);
    }

    public void transform(float[] pointArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        double[] dx = new double[1];
        double[] dy = new double[1];
        int length = pointArray.length / 2;
        int i = 0;
        int j = 0;
        while (i < length) {
            dx[0] = pointArray[j];
            dy[0] = pointArray[j + 1];
            Cairo.cairo_matrix_transform_point((int)this.handle, (double[])dx, (double[])dy);
            pointArray[j] = (float)dx[0];
            pointArray[j + 1] = (float)dy[0];
            ++i;
            j += 2;
        }
    }

    public void translate(float offsetX, float offsetY) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Cairo.cairo_matrix_translate((int)this.handle, (double)offsetX, (double)offsetY);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Transform {*DISPOSED*}";
        }
        float[] elements = new float[6];
        this.getElements(elements);
        return "Transform {" + elements[0] + "," + elements[1] + "," + elements[2] + "," + elements[3] + "," + elements[4] + "," + elements[5] + "}";
    }
}

