/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Slider
extends Control {
    public Slider(Composite parent, int style) {
        super(parent, Slider.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    void createHandle(int index) {
        this.state |= 8;
        this.fixedHandle = OS.g_object_new((int)this.display.gtk_fixed_get_type(), (int)0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window((int)this.fixedHandle, (boolean)true);
        int hAdjustment = OS.gtk_adjustment_new((double)0.0, (double)0.0, (double)100.0, (double)1.0, (double)10.0, (double)10.0);
        if (hAdjustment == 0) {
            this.error(2);
        }
        this.handle = (this.style & 0x100) != 0 ? OS.gtk_hscrollbar_new((int)hAdjustment) : OS.gtk_vscrollbar_new((int)hAdjustment);
        if (this.handle == 0) {
            this.error(2);
        }
        OS.GTK_WIDGET_SET_FLAGS((int)this.handle, (int)2048);
        OS.gtk_container_add((int)this.fixedHandle, (int)this.handle);
    }

    int gtk_value_changed(int adjustment) {
        this.postEvent(13);
        return 0;
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect((int)this.handle, (byte[])OS.value_changed, (int)this.display.windowProc2, (int)48);
    }

    void register() {
        super.register();
        int hAdjustment = OS.gtk_range_get_adjustment((int)this.handle);
        this.display.addWidget(hAdjustment, this);
    }

    void deregister() {
        super.deregister();
        int hAdjustment = OS.gtk_range_get_adjustment((int)this.handle);
        this.display.removeWidget(hAdjustment);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        Point size = this.computeNativeSize(this.handle, wHint, hHint, changed);
        if ((this.style & 0x100) != 0) {
            if (wHint == -1) {
                size.x = 2 * size.x;
            }
        } else if (hHint == -1) {
            size.y = 2 * size.y;
        }
        return size;
    }

    public int getIncrement() {
        this.checkWidget();
        int hAdjustment = OS.gtk_range_get_adjustment((int)this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove((GtkAdjustment)adjustment, (int)hAdjustment);
        return (int)adjustment.step_increment;
    }

    public int getMaximum() {
        this.checkWidget();
        int hAdjustment = OS.gtk_range_get_adjustment((int)this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove((GtkAdjustment)adjustment, (int)hAdjustment);
        return (int)adjustment.upper;
    }

    public int getMinimum() {
        this.checkWidget();
        int hAdjustment = OS.gtk_range_get_adjustment((int)this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove((GtkAdjustment)adjustment, (int)hAdjustment);
        return (int)adjustment.lower;
    }

    public int getPageIncrement() {
        this.checkWidget();
        int hAdjustment = OS.gtk_range_get_adjustment((int)this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove((GtkAdjustment)adjustment, (int)hAdjustment);
        return (int)adjustment.page_increment;
    }

    public int getSelection() {
        this.checkWidget();
        int hAdjustment = OS.gtk_range_get_adjustment((int)this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove((GtkAdjustment)adjustment, (int)hAdjustment);
        return (int)adjustment.value;
    }

    public int getThumb() {
        this.checkWidget();
        int hAdjustment = OS.gtk_range_get_adjustment((int)this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove((GtkAdjustment)adjustment, (int)hAdjustment);
        return (int)adjustment.page_size;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)48);
        OS.gtk_range_set_increments((int)this.handle, (double)value, (double)this.getPageIncrement());
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)48);
    }

    public void setMaximum(int value) {
        this.checkWidget();
        int hAdjustment = OS.gtk_range_get_adjustment((int)this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove((GtkAdjustment)adjustment, (int)hAdjustment);
        int minimum = (int)adjustment.lower;
        if (value <= minimum) {
            return;
        }
        adjustment.upper = value;
        adjustment.page_size = Math.min((int)adjustment.page_size, value - minimum);
        adjustment.value = Math.min((int)adjustment.value, (int)((double)value - adjustment.page_size));
        OS.memmove((int)hAdjustment, (GtkAdjustment)adjustment);
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)48);
        OS.gtk_adjustment_changed((int)hAdjustment);
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)48);
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int hAdjustment = OS.gtk_range_get_adjustment((int)this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove((GtkAdjustment)adjustment, (int)hAdjustment);
        int maximum = (int)adjustment.upper;
        if (value >= maximum) {
            return;
        }
        adjustment.lower = value;
        adjustment.page_size = Math.min((int)adjustment.page_size, maximum - value);
        adjustment.value = Math.max((int)adjustment.value, value);
        OS.memmove((int)hAdjustment, (GtkAdjustment)adjustment);
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)48);
        OS.gtk_adjustment_changed((int)hAdjustment);
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)48);
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)48);
        OS.gtk_range_set_increments((int)this.handle, (double)this.getIncrement(), (double)value);
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)48);
    }

    public void setSelection(int value) {
        this.checkWidget();
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)48);
        OS.gtk_range_set_value((int)this.handle, (double)value);
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)48);
    }

    public void setThumb(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        int hAdjustment = OS.gtk_range_get_adjustment((int)this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove((GtkAdjustment)adjustment, (int)hAdjustment);
        value = Math.min(value, (int)(adjustment.upper - adjustment.lower));
        adjustment.page_size = value;
        adjustment.value = Math.min((int)adjustment.value, (int)(adjustment.upper - (double)value));
        OS.memmove((int)hAdjustment, (GtkAdjustment)adjustment);
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)48);
        OS.gtk_adjustment_changed((int)hAdjustment);
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)48);
    }

    public void setValues(int selection, int minimum, int maximum, int thumb, int increment, int pageIncrement) {
        this.checkWidget();
        if (minimum < 0) {
            return;
        }
        if (maximum < 0) {
            return;
        }
        if (thumb < 1) {
            return;
        }
        if (increment < 1) {
            return;
        }
        if (pageIncrement < 1) {
            return;
        }
        thumb = Math.min(thumb, maximum - minimum);
        int hAdjustment = OS.gtk_range_get_adjustment((int)this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove((GtkAdjustment)adjustment, (int)hAdjustment);
        adjustment.value = Math.min(Math.max(selection, minimum), maximum - thumb);
        adjustment.lower = minimum;
        adjustment.upper = maximum;
        adjustment.page_size = thumb;
        adjustment.step_increment = increment;
        adjustment.page_increment = pageIncrement;
        OS.memmove((int)hAdjustment, (GtkAdjustment)adjustment);
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)48);
        OS.gtk_adjustment_changed((int)hAdjustment);
        OS.gtk_adjustment_value_changed((int)hAdjustment);
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)48);
    }
}

