/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Spinner
extends Composite {
    static final int INNER_BORDER = 2;
    static final int MIN_ARROW_WIDTH = 6;
    int lastEventTime = 0;

    public Spinner(Composite parent, int style) {
        super(parent, Spinner.checkStyle(style));
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    static int checkStyle(int style) {
        return style & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        int[] w = new int[1];
        int[] h = new int[1];
        int layout = OS.gtk_entry_get_layout((int)this.handle);
        int hAdjustment = OS.gtk_spin_button_get_adjustment((int)this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove((GtkAdjustment)adjustment, (int)hAdjustment);
        String string = String.valueOf((int)adjustment.upper);
        byte[] buffer1 = Converter.wcsToMbcs(null, string, false);
        int ptr = OS.pango_layout_get_text((int)layout);
        int length = OS.strlen((int)ptr);
        byte[] buffer2 = new byte[length];
        OS.memmove((byte[])buffer2, (int)ptr, (int)length);
        OS.pango_layout_set_text((int)layout, (byte[])buffer1, (int)buffer1.length);
        OS.pango_layout_get_size((int)layout, (int[])w, (int[])h);
        OS.pango_layout_set_text((int)layout, (byte[])buffer2, (int)buffer2.length);
        int width = OS.PANGO_PIXELS((int)w[0]);
        int height = OS.PANGO_PIXELS((int)h[0]);
        width = wHint == -1 ? width : wHint;
        height = hHint == -1 ? height : hHint;
        Rectangle trim = this.computeTrim(0, 0, width, height);
        return new Point(trim.width, trim.height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int xborder = 0;
        int yborder = 0;
        int style = OS.gtk_widget_get_style((int)this.handle);
        if ((this.style & 0x800) != 0) {
            xborder += OS.gtk_style_get_xthickness((int)style);
            yborder += OS.gtk_style_get_ythickness((int)style);
        }
        xborder += 2;
        yborder += 2;
        int[] property = new int[1];
        OS.gtk_widget_style_get((int)this.handle, (byte[])OS.interior_focus, (int[])property, (int)0);
        if (property[0] != 0) {
            OS.gtk_widget_style_get((int)this.handle, (byte[])OS.focus_line_width, (int[])property, (int)0);
            xborder += property[0];
            yborder += property[0];
        }
        int fontDesc = OS.gtk_style_get_font_desc((int)style);
        int fontSize = OS.pango_font_description_get_size((int)fontDesc);
        int arrowSize = Math.max(OS.PANGO_PIXELS((int)fontSize), 6);
        arrowSize -= arrowSize % 2;
        Rectangle trim = super.computeTrim(x, y, width, height);
        trim.x -= xborder;
        trim.y -= yborder;
        trim.width += 2 * xborder;
        trim.height += 2 * yborder;
        trim.width += arrowSize + 2 * OS.gtk_style_get_xthickness((int)style);
        return new Rectangle(trim.x, trim.y, trim.width, trim.height);
    }

    public void copy() {
        this.checkWidget();
        OS.gtk_editable_copy_clipboard((int)this.handle);
    }

    void createHandle(int index) {
        this.state |= 0x28;
        this.fixedHandle = OS.g_object_new((int)this.display.gtk_fixed_get_type(), (int)0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window((int)this.fixedHandle, (boolean)true);
        int adjustment = OS.gtk_adjustment_new((double)0.0, (double)0.0, (double)100.0, (double)1.0, (double)10.0, (double)0.0);
        if (adjustment == 0) {
            this.error(2);
        }
        this.handle = OS.gtk_spin_button_new((int)adjustment, (double)1.0, (int)0);
        if (this.handle == 0) {
            this.error(2);
        }
        OS.gtk_container_add((int)this.fixedHandle, (int)this.handle);
        OS.gtk_editable_set_editable((int)this.handle, ((this.style & 8) == 0 ? 1 : 0) != 0);
        OS.gtk_entry_set_has_frame((int)this.handle, ((this.style & 0x800) != 0 ? 1 : 0) != 0);
        OS.gtk_spin_button_set_wrap((int)this.handle, (boolean)true);
    }

    public void cut() {
        this.checkWidget();
        OS.gtk_editable_cut_clipboard((int)this.handle);
    }

    void deregister() {
        super.deregister();
        int imContext = this.imContext();
        if (imContext != 0) {
            this.display.removeWidget(imContext);
        }
    }

    boolean filterKey(int keyval, int event) {
        boolean isTab = keyval == 65289 || keyval == 65056;
        int time = OS.gdk_event_get_time((int)event);
        if (time != this.lastEventTime || isTab) {
            this.lastEventTime = time;
            int imContext = this.imContext();
            if (imContext != 0) {
                return OS.gtk_im_context_filter_keypress((int)imContext, (int)event);
            }
        }
        return false;
    }

    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    public int getBorderWidth() {
        this.checkWidget();
        int style = OS.gtk_widget_get_style((int)this.handle);
        if ((this.style & 0x800) != 0) {
            return OS.gtk_style_get_xthickness((int)style);
        }
        return 0;
    }

    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public int getIncrement() {
        this.checkWidget();
        int hAdjustment = OS.gtk_spin_button_get_adjustment((int)this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove((GtkAdjustment)adjustment, (int)hAdjustment);
        return (int)adjustment.step_increment;
    }

    public int getMaximum() {
        this.checkWidget();
        int hAdjustment = OS.gtk_spin_button_get_adjustment((int)this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove((GtkAdjustment)adjustment, (int)hAdjustment);
        return (int)adjustment.upper;
    }

    public int getMinimum() {
        this.checkWidget();
        int hAdjustment = OS.gtk_spin_button_get_adjustment((int)this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove((GtkAdjustment)adjustment, (int)hAdjustment);
        return (int)adjustment.lower;
    }

    public int getPageIncrement() {
        this.checkWidget();
        int hAdjustment = OS.gtk_spin_button_get_adjustment((int)this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove((GtkAdjustment)adjustment, (int)hAdjustment);
        return (int)adjustment.page_increment;
    }

    public int getSelection() {
        this.checkWidget();
        int hAdjustment = OS.gtk_spin_button_get_adjustment((int)this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove((GtkAdjustment)adjustment, (int)hAdjustment);
        return (int)adjustment.value;
    }

    int gtk_activate(int widget) {
        this.postEvent(14);
        return 0;
    }

    int gtk_changed(int widget) {
        this.sendEvent(24);
        return 0;
    }

    int gtk_commit(int imContext, int text) {
        if (text == 0) {
            return 0;
        }
        if (!OS.gtk_editable_get_editable((int)this.handle)) {
            return 0;
        }
        int length = OS.strlen((int)text);
        if (length == 0) {
            return 0;
        }
        byte[] buffer = new byte[length];
        OS.memmove((byte[])buffer, (int)text, (int)length);
        char[] chars = Converter.mbcsToWcs(null, buffer);
        char[] newChars = this.sendIMKeyEvent(1, null, chars);
        if (newChars == null) {
            return 0;
        }
        OS.g_signal_handlers_block_matched((int)imContext, (int)16, (int)0, (int)0, (int)0, (int)0, (int)6);
        int id = OS.g_signal_lookup((byte[])OS.commit, (int)OS.gtk_im_context_get_type());
        int mask = 17;
        OS.g_signal_handlers_unblock_matched((int)imContext, (int)mask, (int)id, (int)0, (int)0, (int)0, (int)this.handle);
        if (newChars == chars) {
            OS.g_signal_emit_by_name((int)imContext, (byte[])OS.commit, (int)text);
        } else {
            buffer = Converter.wcsToMbcs(null, newChars, true);
            OS.g_signal_emit_by_name((int)imContext, (byte[])OS.commit, (byte[])buffer);
        }
        OS.g_signal_handlers_unblock_matched((int)imContext, (int)16, (int)0, (int)0, (int)0, (int)0, (int)6);
        OS.g_signal_handlers_block_matched((int)imContext, (int)mask, (int)id, (int)0, (int)0, (int)0, (int)this.handle);
        return 0;
    }

    int gtk_delete_text(int widget, int start_pos, int end_pos) {
        if (!this.hooks(25) && !this.filters(25)) {
            return 0;
        }
        String newText = this.verifyText("", start_pos, end_pos);
        if (newText == null) {
            OS.g_signal_stop_emission_by_name((int)this.handle, (byte[])OS.delete_text);
        } else if (newText.length() > 0) {
            int[] pos = new int[]{end_pos};
            byte[] buffer = Converter.wcsToMbcs(null, newText, false);
            OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
            OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)20);
            OS.gtk_editable_insert_text((int)this.handle, (byte[])buffer, (int)buffer.length, (int[])pos);
            OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)20);
            OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
            OS.gtk_editable_set_position((int)this.handle, (int)pos[0]);
        }
        return 0;
    }

    int gtk_event_after(int widget, int gdkEvent) {
        if (this.cursor != null) {
            this.setCursor(this.cursor.handle);
        }
        return super.gtk_event_after(widget, gdkEvent);
    }

    int gtk_insert_text(int widget, int new_text, int new_text_length, int position) {
        String newText;
        if (new_text == 0 || new_text_length == 0) {
            return 0;
        }
        byte[] buffer = new byte[new_text_length];
        OS.memmove((byte[])buffer, (int)new_text, (int)buffer.length);
        String oldText = new String(Converter.mbcsToWcs(null, buffer));
        int[] pos = new int[1];
        OS.memmove((int[])pos, (int)position, (int)4);
        if (pos[0] == -1) {
            int ptr = OS.gtk_entry_get_text((int)this.handle);
            pos[0] = OS.g_utf8_strlen((int)ptr, (int)-1);
        }
        if ((newText = this.verifyText(oldText, pos[0], pos[0])) == null) {
            OS.g_signal_stop_emission_by_name((int)this.handle, (byte[])OS.insert_text);
        } else if (newText != oldText) {
            byte[] buffer2 = Converter.wcsToMbcs(null, newText, false);
            OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)20);
            OS.gtk_editable_insert_text((int)this.handle, (byte[])buffer2, (int)buffer2.length, (int[])pos);
            OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)20);
            OS.g_signal_stop_emission_by_name((int)this.handle, (byte[])OS.insert_text);
            OS.memmove((int)position, (int[])pos, (int)4);
        }
        return 0;
    }

    int gtk_popup_menu(int widget) {
        int[] x = new int[1];
        int[] y = new int[1];
        OS.gdk_window_get_pointer((int)0, (int[])x, (int[])y, null);
        return this.showMenu(x[0], y[0]) ? 1 : 0;
    }

    int gtk_value_changed(int widget) {
        this.postEvent(13);
        return 0;
    }

    void hookEvents() {
        super.hookEvents();
        int windowProc2 = this.display.windowProc2;
        int windowProc3 = this.display.windowProc3;
        int windowProc4 = this.display.windowProc4;
        int windowProc5 = this.display.windowProc5;
        OS.g_signal_connect_after((int)this.handle, (byte[])OS.changed, (int)windowProc2, (int)4);
        OS.g_signal_connect((int)this.handle, (byte[])OS.insert_text, (int)windowProc5, (int)20);
        OS.g_signal_connect((int)this.handle, (byte[])OS.delete_text, (int)windowProc4, (int)10);
        OS.g_signal_connect((int)this.handle, (byte[])OS.value_changed, (int)windowProc2, (int)48);
        OS.g_signal_connect((int)this.handle, (byte[])OS.activate, (int)windowProc2, (int)1);
        int imContext = this.imContext();
        if (imContext != 0) {
            OS.g_signal_connect((int)imContext, (byte[])OS.commit, (int)windowProc3, (int)6);
            int id = OS.g_signal_lookup((byte[])OS.commit, (int)OS.gtk_im_context_get_type());
            int mask = 17;
            OS.g_signal_handlers_block_matched((int)imContext, (int)mask, (int)id, (int)0, (int)0, (int)0, (int)this.handle);
        }
    }

    int imContext() {
        return OS.GTK_ENTRY_IM_CONTEXT((int)this.handle);
    }

    int paintWindow() {
        int window = super.paintWindow();
        int children = OS.gdk_window_get_children((int)window);
        if (children != 0) {
            window = OS.g_list_data((int)children);
        }
        OS.g_list_free((int)children);
        return window;
    }

    public void paste() {
        this.checkWidget();
        OS.gtk_editable_paste_clipboard((int)this.handle);
    }

    void register() {
        super.register();
        int imContext = this.imContext();
        if (imContext != 0) {
            this.display.addWidget(imContext, this);
        }
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    void setBackgroundColor(GdkColor color) {
        super.setBackgroundColor(color);
        OS.gtk_widget_modify_base((int)this.handle, (int)0, (GdkColor)color);
    }

    void setCursor(int cursor) {
        int defaultCursor = 0;
        if (cursor == 0) {
            defaultCursor = OS.gdk_cursor_new((int)152);
        }
        super.setCursor(cursor != 0 ? cursor : defaultCursor);
        if (cursor == 0) {
            OS.gdk_cursor_destroy((int)defaultCursor);
        }
    }

    void setFontDescription(int font) {
        super.setFontDescription(font);
    }

    void setForegroundColor(GdkColor color) {
        super.setForegroundColor(color);
        OS.gtk_widget_modify_text((int)this.handle, (int)0, (GdkColor)color);
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)48);
        OS.gtk_spin_button_set_increments((int)this.handle, (double)value, (double)this.getPageIncrement());
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)48);
    }

    public void setMaximum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int minimum = this.getMinimum();
        if (value <= minimum) {
            return;
        }
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)48);
        OS.gtk_spin_button_set_range((int)this.handle, (double)minimum, (double)value);
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)48);
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int maximum = this.getMaximum();
        if (value >= maximum) {
            return;
        }
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)48);
        OS.gtk_spin_button_set_range((int)this.handle, (double)value, (double)maximum);
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)48);
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)48);
        OS.gtk_spin_button_set_increments((int)this.handle, (double)this.getIncrement(), (double)value);
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)48);
    }

    public void setSelection(int value) {
        this.checkWidget();
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)48);
        OS.gtk_spin_button_set_value((int)this.handle, (double)value);
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)48);
    }

    boolean translateTraversal(GdkEventKey keyEvent) {
        int key = keyEvent.keyval;
        switch (key) {
            case 65293: 
            case 65421: {
                int imContext = this.imContext();
                if (imContext == 0) break;
                int[] preeditString = new int[1];
                OS.gtk_im_context_get_preedit_string((int)imContext, (int[])preeditString, null, null);
                if (preeditString[0] == 0) break;
                int length = OS.strlen((int)preeditString[0]);
                OS.g_free((int)preeditString[0]);
                if (length == 0) break;
                return false;
            }
        }
        return super.translateTraversal(keyEvent);
    }

    String verifyText(String string, int start, int end) {
        if (string.length() == 0 && start == end) {
            return null;
        }
        Event event = new Event();
        event.text = string;
        event.start = start;
        event.end = end;
        int eventPtr = OS.gtk_get_current_event();
        if (eventPtr != 0) {
            GdkEventKey gdkEvent = new GdkEventKey();
            OS.memmove((GdkEventKey)gdkEvent, (int)eventPtr, (int)GdkEventKey.sizeof);
            switch (gdkEvent.type) {
                case 8: {
                    this.setKeyState(event, gdkEvent);
                }
            }
            OS.gdk_event_free((int)eventPtr);
        }
        int index = 0;
        while (index < string.length()) {
            if (!Character.isDigit(string.charAt(index))) break;
            ++index;
        }
        event.doit = index == string.length();
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

