/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tree
extends Composite {
    int modelHandle;
    int checkRenderer;
    int columnCount;
    int ignoreTextCell;
    int ignorePixbufCell;
    TreeItem[] items;
    TreeColumn[] columns;
    ImageList imageList;
    boolean firstCustomDraw;
    static final int ID_COLUMN = 0;
    static final int CHECKED_COLUMN = 1;
    static final int GRAYED_COLUMN = 2;
    static final int FOREGROUND_COLUMN = 3;
    static final int BACKGROUND_COLUMN = 4;
    static final int FONT_COLUMN = 5;
    static final int FIRST_COLUMN = 6;
    static final int CELL_PIXBUF = 0;
    static final int CELL_TEXT = 1;
    static final int CELL_FOREGROUND = 2;
    static final int CELL_BACKGROUND = 3;
    static final int CELL_FONT = 4;
    static final int CELL_TYPES = 5;

    public Tree(Composite parent, int style) {
        super(parent, Tree.checkStyle(style));
    }

    static int checkStyle(int style) {
        style |= 0x300;
        return Widget.checkBits(style &= 0xEFFFFFFF, 4, 2, 0, 0, 0, 0);
    }

    boolean checkData(TreeItem item) {
        if (item.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            item.cached = true;
            Event event = new Event();
            event.item = item;
            int mask = 17;
            int signal_id = OS.g_signal_lookup((byte[])OS.row_changed, (int)OS.gtk_tree_model_get_type());
            OS.g_signal_handlers_block_matched((int)this.modelHandle, (int)mask, (int)signal_id, (int)0, (int)0, (int)0, (int)this.handle);
            this.sendEvent(36, event);
            if (this.isDisposed()) {
                return false;
            }
            OS.g_signal_handlers_unblock_matched((int)this.modelHandle, (int)mask, (int)signal_id, (int)0, (int)0, (int)0, (int)this.handle);
            if (item.isDisposed()) {
                return false;
            }
        }
        return true;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    int calculateWidth(int column, int iter) {
        OS.gtk_tree_view_column_cell_set_cell_data((int)column, (int)this.modelHandle, (int)iter, (boolean)false, (boolean)false);
        int width = 0;
        int[] w = new int[1];
        if (OS.gtk_tree_view_get_expander_column((int)this.handle) == column) {
            OS.gtk_widget_style_get((int)this.handle, (byte[])OS.expander_size, (int[])w, (int)0);
            width += w[0] + 4;
        }
        OS.gtk_widget_style_get((int)this.handle, (byte[])OS.focus_line_width, (int[])w, (int)0);
        width += 2 * w[0];
        int list = OS.gtk_tree_view_column_get_cell_renderers((int)column);
        if (list == 0) {
            return 0;
        }
        int temp = list;
        while (temp != 0) {
            int renderer = OS.g_list_data((int)temp);
            if (renderer != 0) {
                OS.gtk_cell_renderer_get_size((int)renderer, (int)this.handle, null, null, null, (int[])w, null);
                width += w[0];
            }
            temp = OS.g_list_next((int)temp);
        }
        OS.g_list_free((int)list);
        return width;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        Point size = this.computeNativeSize(this.handle, wHint, hHint, changed);
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        size.x = trim.width;
        size.y = trim.height;
        return size;
    }

    void copyModel(int oldModel, int oldStart, int newModel, int newStart, int[] types, int oldParent, int newParent, int modelLength) {
        int iter = OS.g_malloc((int)OS.GtkTreeIter_sizeof());
        if (OS.gtk_tree_model_iter_children((int)oldModel, (int)iter, (int)oldParent)) {
            int[] oldItems = new int[OS.gtk_tree_model_iter_n_children((int)oldModel, (int)oldParent)];
            int oldIndex = 0;
            do {
                int newItem;
                if ((newItem = OS.g_malloc((int)OS.GtkTreeIter_sizeof())) == 0) {
                    this.error(2);
                }
                OS.gtk_tree_store_append((int)newModel, (int)newItem, (int)newParent);
                int[] index = new int[1];
                OS.gtk_tree_model_get((int)oldModel, (int)iter, (int)0, (int[])index, (int)-1);
                TreeItem item = this.items[index[0]];
                if (item != null) {
                    int oldItem = item.handle;
                    oldItems[oldIndex++] = oldItem;
                    int[] ptr = new int[1];
                    int j = 0;
                    while (j < 6) {
                        OS.gtk_tree_model_get((int)oldModel, (int)oldItem, (int)j, (int[])ptr, (int)-1);
                        OS.gtk_tree_store_set((int)newModel, (int)newItem, (int)j, (int)ptr[0], (int)-1);
                        if (types[j] == OS.G_TYPE_STRING()) {
                            OS.g_free((int)ptr[0]);
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < modelLength - 6) {
                        OS.gtk_tree_model_get((int)oldModel, (int)oldItem, (int)(oldStart + j), (int[])ptr, (int)-1);
                        OS.gtk_tree_store_set((int)newModel, (int)newItem, (int)(newStart + j), (int)ptr[0], (int)-1);
                        if (types[j] == OS.G_TYPE_STRING()) {
                            OS.g_free((int)ptr[0]);
                        }
                        ++j;
                    }
                }
                this.copyModel(oldModel, oldStart, newModel, newStart, types, iter, newItem, modelLength);
                if (item != null) {
                    item.handle = newItem;
                    continue;
                }
                OS.g_free((int)newItem);
            } while (OS.gtk_tree_model_iter_next((int)oldModel, (int)iter));
            int i = 0;
            while (i < oldItems.length) {
                int oldItem = oldItems[i];
                if (oldItem != 0) {
                    OS.gtk_tree_store_remove((int)oldModel, (int)oldItem);
                    OS.g_free((int)oldItem);
                }
                ++i;
            }
        }
        OS.g_free((int)iter);
    }

    void createColumn(TreeColumn column, int index) {
        int columnHandle;
        int modelIndex = 6;
        if (this.columnCount != 0) {
            int modelLength = OS.gtk_tree_model_get_n_columns((int)this.modelHandle);
            boolean[] usedColumns = new boolean[modelLength];
            int i = 0;
            while (i < this.columnCount) {
                int columnIndex = this.columns[i].modelIndex;
                int j = 0;
                while (j < 5) {
                    usedColumns[columnIndex + j] = true;
                    ++j;
                }
                ++i;
            }
            while (modelIndex < modelLength) {
                if (!usedColumns[modelIndex]) break;
                ++modelIndex;
            }
            if (modelIndex == modelLength) {
                int oldModel = this.modelHandle;
                int[] types = this.getColumnTypes(this.columnCount + 4);
                int newModel = OS.gtk_tree_store_newv((int)types.length, (int[])types);
                if (newModel == 0) {
                    this.error(2);
                }
                this.copyModel(oldModel, 6, newModel, 6, types, 0, 0, modelLength);
                OS.gtk_tree_view_set_model((int)this.handle, (int)newModel);
                OS.g_object_unref((int)oldModel);
                this.modelHandle = newModel;
            }
        }
        if ((columnHandle = OS.gtk_tree_view_column_new()) == 0) {
            this.error(2);
        }
        if (index == 0 && this.columnCount > 0) {
            TreeColumn checkColumn = this.columns[0];
            this.createRenderers(checkColumn.handle, checkColumn.modelIndex, false, checkColumn.style);
        }
        this.createRenderers(columnHandle, modelIndex, index == 0, column == null ? 0 : column.style);
        if ((this.style & 0x10000000) == 0 && this.columnCount == 0) {
            OS.gtk_tree_view_column_set_sizing((int)columnHandle, (int)1);
        } else {
            OS.gtk_tree_view_column_set_sizing((int)columnHandle, (int)2);
            if (this.columnCount != 0) {
                OS.gtk_tree_view_column_set_visible((int)columnHandle, (boolean)false);
            }
        }
        OS.gtk_tree_view_column_set_resizable((int)columnHandle, (boolean)true);
        OS.gtk_tree_view_column_set_clickable((int)columnHandle, (boolean)true);
        OS.gtk_tree_view_insert_column((int)this.handle, (int)columnHandle, (int)index);
        if (column != null) {
            column.handle = columnHandle;
            column.modelIndex = modelIndex;
        }
    }

    void createHandle(int index) {
        this.state |= 8;
        this.fixedHandle = OS.g_object_new((int)this.display.gtk_fixed_get_type(), (int)0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window((int)this.fixedHandle, (boolean)true);
        this.scrolledHandle = OS.gtk_scrolled_window_new((int)0, (int)0);
        if (this.scrolledHandle == 0) {
            this.error(2);
        }
        int[] types = this.getColumnTypes(1);
        this.modelHandle = OS.gtk_tree_store_newv((int)types.length, (int[])types);
        if (this.modelHandle == 0) {
            this.error(2);
        }
        this.handle = OS.gtk_tree_view_new_with_model((int)this.modelHandle);
        if (this.handle == 0) {
            this.error(2);
        }
        if ((this.style & 0x20) != 0) {
            this.checkRenderer = OS.gtk_cell_renderer_toggle_new();
            if (this.checkRenderer == 0) {
                this.error(2);
            }
            OS.g_object_ref((int)this.checkRenderer);
        }
        this.createColumn(null, 0);
        OS.gtk_container_add((int)this.fixedHandle, (int)this.scrolledHandle);
        OS.gtk_container_add((int)this.scrolledHandle, (int)this.handle);
        int mode = (this.style & 2) != 0 ? 3 : 2;
        int selectionHandle = OS.gtk_tree_view_get_selection((int)this.handle);
        OS.gtk_tree_selection_set_mode((int)selectionHandle, (int)mode);
        OS.gtk_tree_view_set_headers_visible((int)this.handle, (boolean)false);
        int hsp = (this.style & 0x100) != 0 ? 1 : 2;
        int vsp = (this.style & 0x200) != 0 ? 1 : 2;
        OS.gtk_scrolled_window_set_policy((int)this.scrolledHandle, (int)hsp, (int)vsp);
        if ((this.style & 0x800) != 0) {
            OS.gtk_scrolled_window_set_shadow_type((int)this.scrolledHandle, (int)3);
        }
        if ((this.style & 0x10000000) != 0 && OS.GTK_VERSION >= OS.VERSION((int)2, (int)3, (int)2)) {
            OS.g_object_set((int)this.handle, (byte[])OS.fixed_height_mode, (boolean)true, (int)0);
        }
    }

    void createItem(TreeColumn column, int index) {
        int imageHandle;
        int labelHandle;
        if (index < 0 || index > this.columnCount) {
            this.error(6);
        }
        if (index == 0) {
            column.style &= 0xFEFDBFFF;
            column.style |= 0x4000;
        }
        if (this.columnCount == 0) {
            column.handle = OS.gtk_tree_view_get_column((int)this.handle, (int)0);
            OS.gtk_tree_view_column_set_sizing((int)column.handle, (int)2);
            OS.gtk_tree_view_column_set_visible((int)column.handle, (boolean)false);
            column.modelIndex = 6;
            this.createRenderers(column.handle, column.modelIndex, true, column.style);
            column.customDraw = this.firstCustomDraw;
            this.firstCustomDraw = false;
        } else {
            this.createColumn(column, index);
        }
        int boxHandle = OS.gtk_hbox_new((boolean)false, (int)3);
        if (boxHandle == 0) {
            this.error(2);
        }
        if ((labelHandle = OS.gtk_label_new_with_mnemonic(null)) == 0) {
            this.error(2);
        }
        if ((imageHandle = OS.gtk_image_new()) == 0) {
            this.error(2);
        }
        OS.gtk_container_add((int)boxHandle, (int)imageHandle);
        OS.gtk_container_add((int)boxHandle, (int)labelHandle);
        OS.gtk_widget_show((int)boxHandle);
        OS.gtk_widget_show((int)labelHandle);
        column.labelHandle = labelHandle;
        column.imageHandle = imageHandle;
        OS.gtk_tree_view_column_set_widget((int)column.handle, (int)boxHandle);
        int widget = OS.gtk_widget_get_parent((int)boxHandle);
        while (widget != this.handle) {
            if (OS.GTK_IS_BUTTON((int)widget)) {
                column.buttonHandle = widget;
                break;
            }
            widget = OS.gtk_widget_get_parent((int)widget);
        }
        if (this.columnCount == this.columns.length) {
            TreeColumn[] newColumns = new TreeColumn[this.columns.length + 4];
            System.arraycopy(this.columns, 0, newColumns, 0, this.columns.length);
            this.columns = newColumns;
        }
        System.arraycopy(this.columns, index, this.columns, index + 1, this.columnCount++ - index);
        this.columns[index] = column;
        column.setFontDescription(this.getFontDescription());
        if (this.columnCount >= 1) {
            int i = 0;
            while (i < this.items.length) {
                Font[] cellFont;
                TreeItem item = this.items[i];
                if (item != null && (cellFont = item.cellFont) != null) {
                    Font[] temp = new Font[this.columnCount];
                    System.arraycopy(cellFont, 0, temp, 0, index);
                    System.arraycopy(cellFont, index, temp, index + 1, this.columnCount - index - 1);
                    item.cellFont = temp;
                }
                ++i;
            }
        }
    }

    void createItem(TreeItem item, int iter, int index) {
        int count = OS.gtk_tree_model_iter_n_children((int)this.modelHandle, (int)iter);
        if (index == -1) {
            index = count;
        }
        if (index < 0 || index > count) {
            this.error(6);
        }
        int id = 0;
        while (id < this.items.length && this.items[id] != null) {
            ++id;
        }
        if (id == this.items.length) {
            TreeItem[] newItems = new TreeItem[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        item.handle = OS.g_malloc((int)OS.GtkTreeIter_sizeof());
        if (item.handle == 0) {
            this.error(2);
        }
        if (index == count) {
            OS.gtk_tree_store_append((int)this.modelHandle, (int)item.handle, (int)iter);
        } else {
            OS.gtk_tree_store_insert((int)this.modelHandle, (int)item.handle, (int)iter, (int)index);
        }
        OS.gtk_tree_store_set((int)this.modelHandle, (int)item.handle, (int)0, (int)id, (int)-1);
        this.items[id] = item;
    }

    void createRenderers(int columnHandle, int modelIndex, boolean check, int columnStyle) {
        int textRenderer;
        int pixbufRenderer;
        OS.gtk_tree_view_column_clear((int)columnHandle);
        if ((this.style & 0x20) != 0 && check) {
            OS.gtk_tree_view_column_pack_start((int)columnHandle, (int)this.checkRenderer, (boolean)false);
            OS.gtk_tree_view_column_add_attribute((int)columnHandle, (int)this.checkRenderer, (byte[])OS.active, (int)1);
            if (OS.GTK_VERSION >= OS.VERSION((int)2, (int)2, (int)0)) {
                OS.gtk_tree_view_column_add_attribute((int)columnHandle, (int)this.checkRenderer, (byte[])OS.inconsistent, (int)2);
            }
            if (OS.GTK_VERSION > OS.VERSION((int)2, (int)2, (int)1)) {
                OS.gtk_tree_view_column_add_attribute((int)columnHandle, (int)this.checkRenderer, (byte[])OS.cell_background_gdk, (int)4);
            }
        }
        if ((pixbufRenderer = OS.gtk_cell_renderer_pixbuf_new()) == 0) {
            this.error(2);
        }
        if ((textRenderer = OS.gtk_cell_renderer_text_new()) == 0) {
            this.error(2);
        }
        if ((this.style & 0x20) != 0 && check) {
            OS.g_object_set((int)pixbufRenderer, (byte[])OS.mode, (int)1, (int)0);
        }
        if ((columnStyle & 0x20000) != 0) {
            OS.g_object_set((int)textRenderer, (byte[])OS.xalign, (float)1.0f, (int)0);
            OS.gtk_tree_view_column_pack_start((int)columnHandle, (int)pixbufRenderer, (boolean)false);
            OS.gtk_tree_view_column_pack_start((int)columnHandle, (int)textRenderer, (boolean)true);
            OS.gtk_tree_view_column_set_alignment((int)columnHandle, (float)1.0f);
        } else if ((columnStyle & 0x1000000) != 0) {
            OS.g_object_set((int)textRenderer, (byte[])OS.xalign, (float)0.5f, (int)0);
            OS.gtk_tree_view_column_pack_start((int)columnHandle, (int)pixbufRenderer, (boolean)false);
            OS.gtk_tree_view_column_pack_end((int)columnHandle, (int)textRenderer, (boolean)true);
            OS.gtk_tree_view_column_set_alignment((int)columnHandle, (float)0.5f);
        } else {
            OS.gtk_tree_view_column_pack_start((int)columnHandle, (int)pixbufRenderer, (boolean)false);
            OS.gtk_tree_view_column_pack_start((int)columnHandle, (int)textRenderer, (boolean)true);
            OS.gtk_tree_view_column_set_alignment((int)columnHandle, (float)0.0f);
        }
        OS.gtk_tree_view_column_add_attribute((int)columnHandle, (int)pixbufRenderer, (byte[])OS.pixbuf, (int)(modelIndex + 0));
        if (OS.GTK_VERSION > OS.VERSION((int)2, (int)2, (int)1)) {
            OS.gtk_tree_view_column_add_attribute((int)columnHandle, (int)pixbufRenderer, (byte[])OS.cell_background_gdk, (int)4);
            OS.gtk_tree_view_column_add_attribute((int)columnHandle, (int)textRenderer, (byte[])OS.background_gdk, (int)4);
        }
        OS.gtk_tree_view_column_add_attribute((int)columnHandle, (int)textRenderer, (byte[])OS.text, (int)(modelIndex + 1));
        OS.gtk_tree_view_column_add_attribute((int)columnHandle, (int)textRenderer, (byte[])OS.foreground_gdk, (int)3);
        OS.gtk_tree_view_column_add_attribute((int)columnHandle, (int)textRenderer, (byte[])OS.font_desc, (int)5);
        boolean customDraw = this.firstCustomDraw;
        if (this.columnCount != 0) {
            int i = 0;
            while (i < this.columnCount) {
                if (this.columns[i].handle == columnHandle) {
                    customDraw = this.columns[i].customDraw;
                    break;
                }
                ++i;
            }
        }
        if ((this.style & 0x10000000) != 0 || customDraw) {
            OS.gtk_tree_view_column_set_cell_data_func((int)columnHandle, (int)textRenderer, (int)this.display.textCellDataProc, (int)this.handle, (int)0);
            OS.gtk_tree_view_column_set_cell_data_func((int)columnHandle, (int)pixbufRenderer, (int)this.display.pixbufCellDataProc, (int)this.handle, (int)0);
        }
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.items = new TreeItem[4];
        this.columns = new TreeColumn[4];
        this.columnCount = 0;
    }

    GdkColor defaultBackground() {
        return this.display.COLOR_LIST_BACKGROUND;
    }

    GdkColor defaultForeground() {
        return this.display.COLOR_LIST_FOREGROUND;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(OS.gtk_tree_view_get_selection((int)this.handle));
        if (this.checkRenderer != 0) {
            this.display.removeWidget(this.checkRenderer);
        }
    }

    public void deselectAll() {
        this.checkWidget();
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        OS.g_signal_handlers_block_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
        OS.gtk_tree_selection_unselect_all((int)selection);
        OS.g_signal_handlers_unblock_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
    }

    void destroyItem(TreeColumn column) {
        int index = 0;
        while (index < this.columnCount) {
            if (this.columns[index] == column) break;
            ++index;
        }
        if (index == this.columnCount) {
            return;
        }
        int columnHandle = column.handle;
        if (this.columnCount == 1) {
            this.firstCustomDraw = column.customDraw;
        }
        System.arraycopy(this.columns, index + 1, this.columns, index, --this.columnCount - index);
        this.columns[this.columnCount] = null;
        column.deregister();
        OS.gtk_tree_view_remove_column((int)this.handle, (int)columnHandle);
        if (this.columnCount == 0) {
            int oldModel = this.modelHandle;
            int[] types = this.getColumnTypes(1);
            int newModel = OS.gtk_tree_store_newv((int)types.length, (int[])types);
            if (newModel == 0) {
                this.error(2);
            }
            this.copyModel(oldModel, column.modelIndex, newModel, 6, types, 0, 0, 11);
            OS.gtk_tree_view_set_model((int)this.handle, (int)newModel);
            OS.g_object_unref((int)oldModel);
            this.modelHandle = newModel;
            this.createColumn(null, 0);
        } else {
            int i = 0;
            while (i < this.items.length) {
                TreeItem item = this.items[i];
                if (item != null) {
                    int iter = item.handle;
                    int modelIndex = column.modelIndex;
                    OS.gtk_tree_store_set((int)this.modelHandle, (int)iter, (int)(modelIndex + 0), (int)0, (int)-1);
                    OS.gtk_tree_store_set((int)this.modelHandle, (int)iter, (int)(modelIndex + 1), (int)0, (int)-1);
                    OS.gtk_tree_store_set((int)this.modelHandle, (int)iter, (int)(modelIndex + 2), (int)0, (int)-1);
                    OS.gtk_tree_store_set((int)this.modelHandle, (int)iter, (int)(modelIndex + 3), (int)0, (int)-1);
                    OS.gtk_tree_store_set((int)this.modelHandle, (int)iter, (int)(modelIndex + 4), (int)0, (int)-1);
                    Font[] cellFont = item.cellFont;
                    if (cellFont != null) {
                        if (this.columnCount == 1) {
                            item.cellFont = null;
                        } else {
                            Font[] temp = new Font[this.columnCount - 1];
                            System.arraycopy(cellFont, 0, temp, 0, index);
                            System.arraycopy(cellFont, index + 1, temp, index, this.columnCount - 1 - index);
                            item.cellFont = temp;
                        }
                    }
                }
                ++i;
            }
            if (index == 0) {
                TreeColumn firstColumn = this.columns[0];
                firstColumn.style &= 0xFEFDBFFF;
                firstColumn.style |= 0x4000;
                this.createRenderers(firstColumn.handle, firstColumn.modelIndex, true, firstColumn.style);
            }
        }
        column.labelHandle = 0;
        column.buttonHandle = 0;
        column.handle = 0;
        column.imageHandle = 0;
    }

    void destroyItem(TreeItem item) {
        if (OS.GTK_VERSION < OS.VERSION((int)2, (int)0, (int)6)) {
            TreeItem[] roots = this.getItems(0);
            int i = 0;
            while (i < roots.length) {
                if (item == roots[i]) {
                    item.setExpanded(false);
                    break;
                }
                ++i;
            }
        }
        int[] index = new int[1];
        this.releaseItems(item.getItems(), index);
        this.releaseItem(item, index, false);
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        OS.g_signal_handlers_block_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
        OS.gtk_tree_store_remove((int)this.modelHandle, (int)item.handle);
        OS.g_signal_handlers_unblock_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
    }

    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    public TreeColumn getColumn(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.columnCount) {
            this.error(6);
        }
        return this.columns[index];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    int[] getColumnTypes(int columnCount) {
        int[] types = new int[6 + columnCount * 5];
        types[0] = OS.G_TYPE_INT();
        types[1] = OS.G_TYPE_BOOLEAN();
        types[2] = OS.G_TYPE_BOOLEAN();
        types[3] = OS.GDK_TYPE_COLOR();
        types[4] = OS.GDK_TYPE_COLOR();
        types[5] = OS.PANGO_TYPE_FONT_DESCRIPTION();
        int i = 6;
        while (i < types.length) {
            types[i + 0] = OS.GDK_TYPE_PIXBUF();
            types[i + 1] = OS.G_TYPE_STRING();
            types[i + 2] = OS.GDK_TYPE_COLOR();
            types[i + 3] = OS.GDK_TYPE_COLOR();
            types[i + 4] = OS.PANGO_TYPE_FONT_DESCRIPTION();
            i += 5;
        }
        return types;
    }

    public TreeColumn[] getColumns() {
        this.checkWidget();
        TreeColumn[] result = new TreeColumn[this.columnCount];
        System.arraycopy(this.columns, 0, result, 0, this.columnCount);
        return result;
    }

    TreeItem getFocusItem() {
        int[] path = new int[1];
        OS.gtk_tree_view_get_cursor((int)this.handle, (int[])path, null);
        if (path[0] == 0) {
            return null;
        }
        TreeItem item = null;
        int iter = OS.g_malloc((int)OS.GtkTreeIter_sizeof());
        if (OS.gtk_tree_model_get_iter((int)this.modelHandle, (int)iter, (int)path[0])) {
            int[] index = new int[1];
            OS.gtk_tree_model_get((int)this.modelHandle, (int)iter, (int)0, (int[])index, (int)-1);
            item = this.items[index[0]];
        }
        OS.g_free((int)iter);
        OS.gtk_tree_path_free((int)path[0]);
        return item;
    }

    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 0;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        if (!OS.gtk_tree_view_get_headers_visible((int)this.handle)) {
            return 0;
        }
        OS.gtk_widget_realize((int)this.handle);
        int fixedWindow = OS.GTK_WIDGET_WINDOW((int)this.fixedHandle);
        int binWindow = OS.gtk_tree_view_get_bin_window((int)this.handle);
        int[] binY = new int[1];
        OS.gdk_window_get_origin((int)binWindow, null, (int[])binY);
        int[] fixedY = new int[1];
        OS.gdk_window_get_origin((int)fixedWindow, null, (int[])fixedY);
        return binY[0] - fixedY[0];
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return OS.gtk_tree_view_get_headers_visible((int)this.handle);
    }

    public TreeItem getItem(Point point) {
        this.checkWidget();
        int[] path = new int[1];
        int clientX = point.x - this.getBorderWidth();
        int clientY = point.y - this.getHeaderHeight();
        OS.gtk_widget_realize((int)this.handle);
        if (!OS.gtk_tree_view_get_path_at_pos((int)this.handle, (int)clientX, (int)clientY, (int[])path, null, null, null)) {
            return null;
        }
        if (path[0] == 0) {
            return null;
        }
        TreeItem item = null;
        int iter = OS.g_malloc((int)OS.GtkTreeIter_sizeof());
        if (OS.gtk_tree_model_get_iter((int)this.modelHandle, (int)iter, (int)path[0])) {
            boolean overExpander = false;
            if (OS.gtk_tree_model_iter_n_children((int)this.modelHandle, (int)iter) > 0) {
                int i = 0;
                while (i <= this.columnCount) {
                    int column = OS.gtk_tree_view_get_column((int)this.handle, (int)i);
                    if (column != 0) {
                        int[] buffer = new int[1];
                        GdkRectangle rect = new GdkRectangle();
                        OS.gtk_tree_view_get_cell_area((int)this.handle, (int)path[0], (int)column, (GdkRectangle)rect);
                        OS.gtk_widget_style_get((int)this.handle, (byte[])OS.expander_size, (int[])buffer, (int)0);
                        int expanderSize = buffer[0] + 4;
                        overExpander = rect.x - 1 <= point.x && point.x < rect.x + expanderSize;
                    }
                    ++i;
                }
            }
            if (!overExpander) {
                int[] index = new int[1];
                OS.gtk_tree_model_get((int)this.modelHandle, (int)iter, (int)0, (int[])index, (int)-1);
                item = this.items[index[0]];
            }
        }
        OS.g_free((int)iter);
        OS.gtk_tree_path_free((int)path[0]);
        return item;
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.gtk_tree_model_iter_n_children((int)this.modelHandle, (int)0);
    }

    public int getItemHeight() {
        this.checkWidget();
        int itemCount = OS.gtk_tree_model_iter_n_children((int)this.modelHandle, (int)0);
        if (itemCount == 0) {
            int column = OS.gtk_tree_view_get_column((int)this.handle, (int)0);
            int[] w = new int[1];
            int[] h = new int[1];
            OS.gtk_tree_view_column_cell_get_size((int)column, null, null, null, (int[])w, (int[])h);
            return h[0];
        }
        int height = 0;
        int iter = OS.g_malloc((int)OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_get_iter_first((int)this.modelHandle, (int)iter);
        int columnCount = Math.max(1, this.columnCount);
        int i = 0;
        while (i < columnCount) {
            int column = OS.gtk_tree_view_get_column((int)this.handle, (int)i);
            OS.gtk_tree_view_column_cell_set_cell_data((int)column, (int)this.modelHandle, (int)iter, (boolean)false, (boolean)false);
            int[] w = new int[1];
            int[] h = new int[1];
            OS.gtk_tree_view_column_cell_get_size((int)column, null, null, null, (int[])w, (int[])h);
            height = Math.max(height, h[0]);
            ++i;
        }
        OS.g_free((int)iter);
        return height;
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        return this.getItems(0);
    }

    TreeItem[] getItems(int parent) {
        if ((this.style & 0x10000000) != 0) {
            return new TreeItem[0];
        }
        int length = OS.gtk_tree_model_iter_n_children((int)this.modelHandle, (int)parent);
        TreeItem[] result = new TreeItem[length];
        if (length == 0) {
            return result;
        }
        int i = 0;
        int[] index = new int[1];
        int iter = OS.g_malloc((int)OS.GtkTreeIter_sizeof());
        boolean valid = OS.gtk_tree_model_iter_children((int)this.modelHandle, (int)iter, (int)parent);
        while (valid) {
            OS.gtk_tree_model_get((int)this.modelHandle, (int)iter, (int)0, (int[])index, (int)-1);
            result[i++] = this.items[index[0]];
            valid = OS.gtk_tree_model_iter_next((int)this.modelHandle, (int)iter);
        }
        OS.g_free((int)iter);
        return result;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return OS.gtk_tree_view_get_rules_hint((int)this.handle);
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return null;
    }

    int getPixbufRenderer(int column) {
        int list = OS.gtk_tree_view_column_get_cell_renderers((int)column);
        if (list == 0) {
            return 0;
        }
        int count = OS.g_list_length((int)list);
        int pixbufRenderer = 0;
        int i = 0;
        while (i < count) {
            int renderer = OS.g_list_nth_data((int)list, (int)i);
            if (OS.GTK_IS_CELL_RENDERER_PIXBUF((int)renderer)) {
                pixbufRenderer = renderer;
                break;
            }
            ++i;
        }
        OS.g_list_free((int)list);
        return pixbufRenderer;
    }

    public TreeItem[] getSelection() {
        TreeItem[] result;
        this.checkWidget();
        if ((this.style & 2) != 0) {
            this.display.treeSelectionLength = 0;
            this.display.treeSelection = new int[this.items.length];
            int selection = OS.gtk_tree_view_get_selection((int)this.handle);
            OS.gtk_tree_selection_selected_foreach((int)selection, (int)this.display.treeSelectionProc, (int)this.handle);
            TreeItem[] result2 = new TreeItem[this.display.treeSelectionLength];
            int i = 0;
            while (i < result2.length) {
                result2[i] = this.items[this.display.treeSelection[i]];
                ++i;
            }
            return result2;
        }
        int iter = OS.g_malloc((int)OS.GtkTreeIter_sizeof());
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        boolean hasSelection = OS.gtk_tree_selection_get_selected((int)selection, null, (int)iter);
        if (hasSelection) {
            int[] index = new int[1];
            OS.gtk_tree_model_get((int)this.modelHandle, (int)iter, (int)0, (int[])index, (int)-1);
            result = new TreeItem[]{this.items[index[0]]};
        } else {
            result = new TreeItem[]{};
        }
        OS.g_free((int)iter);
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        this.display.treeSelectionLength = 0;
        this.display.treeSelection = null;
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        OS.gtk_tree_selection_selected_foreach((int)selection, (int)this.display.treeSelectionProc, (int)this.handle);
        return this.display.treeSelectionLength;
    }

    int getTextRenderer(int column) {
        int list = OS.gtk_tree_view_column_get_cell_renderers((int)column);
        if (list == 0) {
            return 0;
        }
        int count = OS.g_list_length((int)list);
        int textRenderer = 0;
        int i = 0;
        while (i < count) {
            int renderer = OS.g_list_nth_data((int)list, (int)i);
            if (OS.GTK_IS_CELL_RENDERER_TEXT((int)renderer)) {
                textRenderer = renderer;
                break;
            }
            ++i;
        }
        OS.g_list_free((int)list);
        return textRenderer;
    }

    public TreeItem getTopItem() {
        this.checkWidget();
        int[] path = new int[1];
        OS.gtk_widget_realize((int)this.handle);
        if (!OS.gtk_tree_view_get_path_at_pos((int)this.handle, (int)1, (int)1, (int[])path, null, null, null)) {
            return null;
        }
        if (path[0] == 0) {
            return null;
        }
        TreeItem item = null;
        int iter = OS.g_malloc((int)OS.GtkTreeIter_sizeof());
        if (OS.gtk_tree_model_get_iter((int)this.modelHandle, (int)iter, (int)path[0])) {
            int[] index = new int[1];
            OS.gtk_tree_model_get((int)this.modelHandle, (int)iter, (int)0, (int[])index, (int)-1);
            item = this.items[index[0]];
        }
        OS.g_free((int)iter);
        OS.gtk_tree_path_free((int)path[0]);
        return item;
    }

    int gtk_button_press_event(int widget, int event) {
        int selection;
        int[] path;
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove((GdkEventButton)gdkEvent, (int)event, (int)GdkEventButton.sizeof);
        if (gdkEvent.window != OS.gtk_tree_view_get_bin_window((int)this.handle)) {
            return 0;
        }
        int border = this.getBorderWidth();
        int headerHeight = this.getHeaderHeight();
        gdkEvent.x += (double)border;
        gdkEvent.y += (double)headerHeight;
        OS.memmove((int)event, (GdkEventButton)gdkEvent, (int)GdkEventButton.sizeof);
        int result = super.gtk_button_press_event(widget, event);
        gdkEvent.x -= (double)border;
        gdkEvent.y -= (double)headerHeight;
        OS.memmove((int)event, (GdkEventButton)gdkEvent, (int)GdkEventButton.sizeof);
        if (result != 0) {
            return result;
        }
        int button = gdkEvent.button;
        if (button == 3 && gdkEvent.type == 4 && OS.gtk_tree_view_get_path_at_pos((int)this.handle, (int)((int)gdkEvent.x), (int)((int)gdkEvent.y), (int[])(path = new int[1]), null, null, null) && path[0] != 0) {
            selection = OS.gtk_tree_view_get_selection((int)this.handle);
            if (OS.gtk_tree_selection_path_is_selected((int)selection, (int)path[0])) {
                result = 1;
            }
            OS.gtk_tree_path_free((int)path[0]);
        }
        if ((this.style & 4) != 0 && this.getSelectionCount() == 0 && OS.gtk_tree_view_get_path_at_pos((int)this.handle, (int)((int)gdkEvent.x), (int)((int)gdkEvent.y), (int[])(path = new int[1]), null, null, null) && path[0] != 0) {
            selection = OS.gtk_tree_view_get_selection((int)this.handle);
            OS.g_signal_handlers_block_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
            OS.gtk_tree_view_set_cursor((int)this.handle, (int)path[0], (int)0, (boolean)false);
            OS.g_signal_handlers_unblock_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
            OS.gtk_tree_path_free((int)path[0]);
        }
        if (!OS.GTK_WIDGET_HAS_FOCUS((int)this.handle)) {
            OS.gtk_widget_grab_focus((int)this.handle);
        }
        return result;
    }

    int gtk_button_release_event(int widget, int event) {
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove((GdkEventButton)gdkEvent, (int)event, (int)GdkEventButton.sizeof);
        if (gdkEvent.window != OS.gtk_tree_view_get_bin_window((int)this.handle)) {
            return 0;
        }
        int border = this.getBorderWidth();
        int headerHeight = this.getHeaderHeight();
        gdkEvent.x += (double)border;
        gdkEvent.y += (double)headerHeight;
        OS.memmove((int)event, (GdkEventButton)gdkEvent, (int)GdkEventButton.sizeof);
        int result = super.gtk_button_release_event(widget, event);
        gdkEvent.x -= (double)border;
        gdkEvent.y -= (double)headerHeight;
        OS.memmove((int)event, (GdkEventButton)gdkEvent, (int)GdkEventButton.sizeof);
        return result;
    }

    int gtk_changed(int widget) {
        TreeItem item = this.getFocusItem();
        if (item != null) {
            Event event = new Event();
            event.item = item;
            this.postEvent(13, event);
        }
        return 0;
    }

    int gtk_key_press_event(int widget, int eventPtr) {
        int result = super.gtk_key_press_event(widget, eventPtr);
        if (result != 0) {
            return result;
        }
        if (OS.GTK_VERSION < OS.VERSION((int)2, (int)2, (int)0)) {
            GdkEventKey keyEvent = new GdkEventKey();
            OS.memmove((GdkEventKey)keyEvent, (int)eventPtr, (int)GdkEventKey.sizeof);
            int key = keyEvent.keyval;
            switch (key) {
                case 65293: 
                case 65421: {
                    Event event = new Event();
                    event.item = this.getFocusItem();
                    this.postEvent(14, event);
                }
            }
        }
        return result;
    }

    int gtk_motion_notify_event(int widget, int event) {
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove((GdkEventButton)gdkEvent, (int)event, (int)GdkEventButton.sizeof);
        if (gdkEvent.window != OS.gtk_tree_view_get_bin_window((int)this.handle)) {
            return 0;
        }
        int border = this.getBorderWidth();
        int headerHeight = this.getHeaderHeight();
        gdkEvent.x += (double)border;
        gdkEvent.y += (double)headerHeight;
        OS.memmove((int)event, (GdkEventButton)gdkEvent, (int)GdkEventButton.sizeof);
        int result = super.gtk_motion_notify_event(widget, event);
        gdkEvent.x -= (double)border;
        gdkEvent.y -= (double)headerHeight;
        OS.memmove((int)event, (GdkEventButton)gdkEvent, (int)GdkEventButton.sizeof);
        return result;
    }

    int gtk_row_activated(int tree, int path, int column) {
        if (path == 0) {
            return 0;
        }
        TreeItem item = null;
        int iter = OS.g_malloc((int)OS.GtkTreeIter_sizeof());
        if (OS.gtk_tree_model_get_iter((int)this.modelHandle, (int)iter, (int)path)) {
            int[] index = new int[1];
            OS.gtk_tree_model_get((int)this.modelHandle, (int)iter, (int)0, (int[])index, (int)-1);
            item = this.items[index[0]];
        }
        OS.g_free((int)iter);
        Event event = new Event();
        event.item = item;
        this.postEvent(14, event);
        return 0;
    }

    int gtk_test_collapse_row(int tree, int iter, int path) {
        int[] index = new int[1];
        OS.gtk_tree_model_get((int)this.modelHandle, (int)iter, (int)0, (int[])index, (int)-1);
        Event event = new Event();
        event.item = this.items[index[0]];
        this.sendEvent(18, event);
        if (this.isDisposed()) {
            return 0;
        }
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)42);
        OS.gtk_tree_view_collapse_row((int)this.handle, (int)path);
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)42);
        return 1;
    }

    int gtk_test_expand_row(int tree, int iter, int path) {
        int[] index = new int[1];
        OS.gtk_tree_model_get((int)this.modelHandle, (int)iter, (int)0, (int[])index, (int)-1);
        Event event = new Event();
        event.item = this.items[index[0]];
        this.sendEvent(17, event);
        if (this.isDisposed()) {
            return 0;
        }
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)43);
        OS.gtk_tree_view_expand_row((int)this.handle, (int)path, (boolean)false);
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)43);
        return 1;
    }

    int gtk_toggled(int renderer, int pathStr) {
        int path = OS.gtk_tree_path_new_from_string((int)pathStr);
        if (path == 0) {
            return 0;
        }
        TreeItem item = null;
        int iter = OS.g_malloc((int)OS.GtkTreeIter_sizeof());
        if (OS.gtk_tree_model_get_iter((int)this.modelHandle, (int)iter, (int)path)) {
            int[] index = new int[1];
            OS.gtk_tree_model_get((int)this.modelHandle, (int)iter, (int)0, (int[])index, (int)-1);
            item = this.items[index[0]];
        }
        OS.g_free((int)iter);
        OS.gtk_tree_path_free((int)path);
        if (item != null) {
            item.setChecked(!item.getChecked());
            Event event = new Event();
            event.detail = 32;
            event.item = item;
            this.postEvent(13, event);
        }
        return 0;
    }

    void hookEvents() {
        super.hookEvents();
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        OS.g_signal_connect((int)selection, (byte[])OS.changed, (int)this.display.windowProc2, (int)4);
        OS.g_signal_connect((int)this.handle, (byte[])OS.row_activated, (int)this.display.windowProc4, (int)33);
        OS.g_signal_connect((int)this.handle, (byte[])OS.test_expand_row, (int)this.display.windowProc4, (int)43);
        OS.g_signal_connect((int)this.handle, (byte[])OS.test_collapse_row, (int)this.display.windowProc4, (int)42);
        if (this.checkRenderer != 0) {
            OS.g_signal_connect((int)this.checkRenderer, (byte[])OS.toggled, (int)this.display.windowProc3, (int)44);
        }
    }

    int indexOf(TreeColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        int i = 0;
        while (i < this.columnCount) {
            if (this.columns[i] == column) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    boolean mnemonicHit(char key) {
        int i = 0;
        while (i < this.columnCount) {
            int labelHandle = this.columns[i].labelHandle;
            if (labelHandle != 0 && this.mnemonicHit(labelHandle, key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean mnemonicMatch(char key) {
        int i = 0;
        while (i < this.columnCount) {
            int labelHandle = this.columns[i].labelHandle;
            if (labelHandle != 0 && this.mnemonicMatch(labelHandle, key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    int paintWindow() {
        OS.gtk_widget_realize((int)this.handle);
        return OS.gtk_tree_view_get_bin_window((int)this.handle);
    }

    int pixbufCellDataProc(int tree_column, int cell, int tree_model, int iter, int data) {
        if (cell == this.ignorePixbufCell) {
            return 0;
        }
        int modelIndex = -1;
        boolean customDraw = false;
        if (this.columnCount == 0) {
            modelIndex = 5;
            customDraw = this.firstCustomDraw;
        } else {
            int i = 0;
            while (i < this.columns.length) {
                if (this.columns[i] != null && this.columns[i].handle == tree_column) {
                    modelIndex = this.columns[i].modelIndex;
                    customDraw = this.columns[i].customDraw;
                    break;
                }
                ++i;
            }
        }
        if (modelIndex == -1) {
            return 0;
        }
        boolean setData = this.setCellData(tree_model, iter);
        int[] ptr = new int[1];
        if (setData) {
            OS.gtk_tree_model_get((int)tree_model, (int)iter, (int)(modelIndex + 0), (int[])ptr, (int)-1);
            OS.g_object_set((int)cell, (byte[])OS.pixbuf, (int)ptr[0], (int)0);
            ptr = new int[1];
        }
        if (customDraw && OS.GTK_VERSION > OS.VERSION((int)2, (int)2, (int)1)) {
            OS.gtk_tree_model_get((int)tree_model, (int)iter, (int)(modelIndex + 3), (int[])ptr, (int)-1);
            if (ptr[0] != 0) {
                OS.g_object_set((int)cell, (byte[])OS.cell_background_gdk, (int)ptr[0], (int)0);
            }
        }
        if (setData) {
            this.ignorePixbufCell = cell;
            this.setScrollWidth(tree_column, iter);
            this.ignorePixbufCell = 0;
        }
        return 0;
    }

    void register() {
        super.register();
        this.display.addWidget(OS.gtk_tree_view_get_selection((int)this.handle), this);
        if (this.checkRenderer != 0) {
            this.display.addWidget(this.checkRenderer, this);
        }
    }

    void releaseItem(TreeItem item, int[] index, boolean releaseResources) {
        if (item.isDisposed()) {
            return;
        }
        OS.gtk_tree_model_get((int)this.modelHandle, (int)item.handle, (int)0, (int[])index, (int)-1);
        this.items[index[0]] = null;
        if (releaseResources) {
            item.releaseResources();
        }
    }

    void releaseItems(TreeItem[] nodes, int[] index) {
        int i = 0;
        while (i < nodes.length) {
            TreeItem item = nodes[i];
            TreeItem[] sons = item.getItems();
            if (sons.length != 0) {
                this.releaseItems(sons, index);
            }
            this.releaseItem(item, index, true);
            ++i;
        }
    }

    void releaseWidget() {
        int i = 0;
        while (i < this.columnCount) {
            TreeColumn column = this.columns[i];
            if (!column.isDisposed()) {
                column.releaseResources();
            }
            ++i;
        }
        this.columns = null;
        i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null && !item.isDisposed()) {
                item.releaseResources();
            }
            ++i;
        }
        this.items = null;
        super.releaseWidget();
        if (this.modelHandle != 0) {
            OS.g_object_unref((int)this.modelHandle);
        }
        this.modelHandle = 0;
        if (this.checkRenderer != 0) {
            OS.g_object_unref((int)this.checkRenderer);
        }
        this.checkRenderer = 0;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
    }

    public void removeAll() {
        this.checkWidget();
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        OS.g_signal_handlers_block_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
        int oldModel = this.modelHandle;
        int[] types = this.getColumnTypes(Math.max(1, this.columnCount));
        int newModel = OS.gtk_tree_store_newv((int)types.length, (int[])types);
        if (newModel == 0) {
            this.error(2);
        }
        OS.gtk_tree_view_set_model((int)this.handle, (int)newModel);
        OS.g_object_unref((int)oldModel);
        this.modelHandle = newModel;
        OS.g_signal_handlers_unblock_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null && !item.isDisposed()) {
                item.releaseResources();
            }
            ++i;
        }
        this.items = new TreeItem[4];
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, listener);
        this.eventTable.unhook(18, listener);
    }

    void resetCustomDraw() {
        if ((this.style & 0x10000000) != 0) {
            return;
        }
        int end = Math.max(1, this.columnCount);
        int i = 0;
        while (i < end) {
            boolean customDraw;
            boolean bl = customDraw = this.columnCount != 0 ? this.columns[i].customDraw : this.firstCustomDraw;
            if (customDraw) {
                int column = OS.gtk_tree_view_get_column((int)this.handle, (int)i);
                int textRenderer = this.getTextRenderer(column);
                OS.gtk_tree_view_column_set_cell_data_func((int)column, (int)textRenderer, (int)0, (int)0, (int)0);
                if (this.columnCount != 0) {
                    this.columns[i].customDraw = false;
                }
            }
            ++i;
        }
        this.firstCustomDraw = false;
    }

    public void setInsertMark(TreeItem item, boolean before) {
        this.checkWidget();
        if (item == null) {
            OS.gtk_tree_view_unset_rows_drag_dest((int)this.handle);
            return;
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (item.parent != this) {
            return;
        }
        Rectangle rect = item.getBounds();
        int[] path = new int[1];
        OS.gtk_widget_realize((int)this.handle);
        if (!OS.gtk_tree_view_get_path_at_pos((int)this.handle, (int)rect.x, (int)rect.y, (int[])path, null, null, null)) {
            return;
        }
        if (path[0] == 0) {
            return;
        }
        int position = before ? 0 : 1;
        OS.gtk_tree_view_set_drag_dest_row((int)this.handle, (int)path[0], (int)position);
        OS.gtk_tree_path_free((int)path[0]);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        OS.g_signal_handlers_block_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
        OS.gtk_tree_selection_select_all((int)selection);
        OS.g_signal_handlers_unblock_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
    }

    void setBackgroundColor(GdkColor color) {
        super.setBackgroundColor(color);
        OS.gtk_widget_modify_base((int)this.handle, (int)0, (GdkColor)color);
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int result = super.setBounds(x, y, width, height, move, resize);
        OS.gtk_widget_realize((int)this.handle);
        return result;
    }

    boolean setCellData(int tree_model, int iter) {
        return false;
    }

    void setFontDescription(int font) {
        super.setFontDescription(font);
        TreeColumn[] columns = this.getColumns();
        int i = 0;
        while (i < columns.length) {
            if (columns[i] != null) {
                columns[i].setFontDescription(font);
            }
            ++i;
        }
    }

    void setForegroundColor(GdkColor color) {
        super.setForegroundColor(color);
        OS.gtk_widget_modify_text((int)this.handle, (int)0, (GdkColor)color);
    }

    public void setHeaderVisible(boolean show) {
        this.checkWidget();
        OS.gtk_tree_view_set_headers_visible((int)this.handle, (boolean)show);
    }

    public void setLinesVisible(boolean show) {
        this.checkWidget();
        OS.gtk_tree_view_set_rules_hint((int)this.handle, (boolean)show);
    }

    void setScrollWidth(int column, int iter) {
        int itemWidth;
        if (this.columnCount != 0) {
            return;
        }
        int width = OS.gtk_tree_view_column_get_width((int)column);
        if (width < (itemWidth = this.calculateWidth(column, iter))) {
            OS.gtk_tree_view_column_set_fixed_width((int)column, (int)itemWidth);
        }
    }

    public void setSelection(TreeItem[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = items.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        OS.g_signal_handlers_block_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
        boolean first = true;
        int i = 0;
        while (i < length) {
            TreeItem item = items[i];
            if (item != null) {
                if (item.isDisposed()) break;
                if (item.parent == this) {
                    int path = OS.gtk_tree_model_get_path((int)this.modelHandle, (int)item.handle);
                    this.showItem(path, first);
                    if (first) {
                        OS.gtk_tree_view_set_cursor((int)this.handle, (int)path, (int)0, (boolean)false);
                    }
                    OS.gtk_tree_selection_select_iter((int)selection, (int)item.handle);
                    OS.gtk_tree_path_free((int)path);
                    first = false;
                }
            }
            ++i;
        }
        OS.g_signal_handlers_unblock_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
    }

    public void setTopItem(TreeItem item) {
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (item.parent != this) {
            return;
        }
        int path = OS.gtk_tree_model_get_path((int)this.modelHandle, (int)item.handle);
        this.showItem(path, false);
        OS.gtk_tree_view_scroll_to_cell((int)this.handle, (int)path, (int)0, (boolean)true, (float)0.0f, (float)0.0f);
        OS.gtk_tree_path_free((int)path);
    }

    public void showColumn(TreeColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        if (column.parent != this) {
            return;
        }
        OS.gtk_widget_realize((int)this.handle);
        GdkRectangle cellRect = new GdkRectangle();
        OS.gtk_tree_view_get_cell_area((int)this.handle, (int)0, (int)column.handle, (GdkRectangle)cellRect);
        GdkRectangle visibleRect = new GdkRectangle();
        OS.gtk_tree_view_get_visible_rect((int)this.handle, (GdkRectangle)visibleRect);
        if (cellRect.x < visibleRect.x) {
            OS.gtk_tree_view_scroll_to_point((int)this.handle, (int)cellRect.x, (int)-1);
        } else {
            int width = Math.min(visibleRect.width, cellRect.width);
            if (cellRect.x + width > visibleRect.x + visibleRect.width) {
                int tree_x = cellRect.x + width - visibleRect.width;
                OS.gtk_tree_view_scroll_to_point((int)this.handle, (int)tree_x, (int)-1);
            }
        }
    }

    public void showSelection() {
        this.checkWidget();
        TreeItem[] items = this.getSelection();
        if (items.length != 0 && items[0] != null) {
            this.showItem(items[0]);
        }
    }

    void showItem(int path, boolean scroll) {
        int depth = OS.gtk_tree_path_get_depth((int)path);
        if (depth > 1) {
            int[] indices = new int[depth - 1];
            int indicesPtr = OS.gtk_tree_path_get_indices((int)path);
            OS.memmove((int[])indices, (int)indicesPtr, (int)(indices.length * 4));
            int tempPath = OS.gtk_tree_path_new();
            int i = 0;
            while (i < indices.length) {
                OS.gtk_tree_path_append_index((int)tempPath, (int)indices[i]);
                OS.gtk_tree_view_expand_row((int)this.handle, (int)tempPath, (boolean)false);
                ++i;
            }
            OS.gtk_tree_path_free((int)tempPath);
        }
        if (scroll) {
            boolean isHidden;
            GdkRectangle rect = new GdkRectangle();
            OS.gtk_widget_realize((int)this.handle);
            OS.gtk_tree_view_get_cell_area((int)this.handle, (int)path, (int)0, (GdkRectangle)rect);
            boolean bl = isHidden = rect.y == 0 && rect.height == 0;
            if (!isHidden) {
                int[] tx = new int[1];
                int[] ty = new int[1];
                OS.gtk_tree_view_widget_to_tree_coords((int)this.handle, (int)rect.x, (int)rect.y, (int[])tx, (int[])ty);
                rect.y = ty[0];
                GdkRectangle visRect = new GdkRectangle();
                OS.gtk_tree_view_get_visible_rect((int)this.handle, (GdkRectangle)visRect);
                if (rect.y < visRect.y || rect.y + rect.height > visRect.y + visRect.height) {
                    isHidden = true;
                }
            }
            if (isHidden) {
                OS.gtk_tree_view_scroll_to_cell((int)this.handle, (int)path, (int)0, (depth != 1 ? 1 : 0) != 0, (float)0.5f, (float)0.0f);
            }
        }
    }

    public void showItem(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (item.parent != this) {
            return;
        }
        int path = OS.gtk_tree_model_get_path((int)this.modelHandle, (int)item.handle);
        this.showItem(path, true);
        OS.gtk_tree_path_free((int)path);
    }

    int textCellDataProc(int tree_column, int cell, int tree_model, int iter, int data) {
        if (cell == this.ignoreTextCell) {
            return 0;
        }
        int modelIndex = -1;
        boolean customDraw = false;
        if (this.columnCount == 0) {
            modelIndex = 5;
            customDraw = this.firstCustomDraw;
        } else {
            int i = 0;
            while (i < this.columns.length) {
                if (this.columns[i] != null && this.columns[i].handle == tree_column) {
                    modelIndex = this.columns[i].modelIndex;
                    customDraw = this.columns[i].customDraw;
                    break;
                }
                ++i;
            }
        }
        if (modelIndex == -1) {
            return 0;
        }
        boolean setData = this.setCellData(tree_model, iter);
        int[] ptr = new int[1];
        if (setData) {
            OS.gtk_tree_model_get((int)tree_model, (int)iter, (int)(modelIndex + 1), (int[])ptr, (int)-1);
            if (ptr[0] != 0) {
                OS.g_object_set((int)cell, (byte[])OS.text, (int)ptr[0], (int)0);
                OS.g_free((int)ptr[0]);
            }
            ptr = new int[1];
        }
        if (customDraw) {
            OS.gtk_tree_model_get((int)tree_model, (int)iter, (int)(modelIndex + 2), (int[])ptr, (int)-1);
            if (ptr[0] != 0) {
                OS.g_object_set((int)cell, (byte[])OS.foreground_gdk, (int)ptr[0], (int)0);
            }
            if (OS.GTK_VERSION > OS.VERSION((int)2, (int)2, (int)1)) {
                ptr = new int[1];
                OS.gtk_tree_model_get((int)tree_model, (int)iter, (int)(modelIndex + 3), (int[])ptr, (int)-1);
                if (ptr[0] != 0) {
                    OS.g_object_set((int)cell, (byte[])OS.background_gdk, (int)ptr[0], (int)0);
                }
            }
            ptr = new int[1];
            OS.gtk_tree_model_get((int)tree_model, (int)iter, (int)(modelIndex + 4), (int[])ptr, (int)-1);
            if (ptr[0] != 0) {
                OS.g_object_set((int)cell, (byte[])OS.font_desc, (int)ptr[0], (int)0);
            }
        }
        if (setData) {
            this.ignoreTextCell = cell;
            this.setScrollWidth(tree_column, iter);
            this.ignoreTextCell = 0;
        }
        return 0;
    }

    int treeSelectionProc(int model, int path, int iter, int[] selection, int length) {
        if (selection != null) {
            int[] index = new int[1];
            OS.gtk_tree_model_get((int)this.modelHandle, (int)iter, (int)0, (int[])index, (int)-1);
            selection[length] = index[0];
        }
        return 0;
    }
}

