/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.content.ContentType;
import org.eclipse.core.internal.content.ContentTypeManager;
import org.eclipse.core.internal.content.ContentTypeVisitor;
import org.eclipse.core.internal.content.FileSpec;
import org.eclipse.core.internal.content.LazyInputStream;
import org.eclipse.core.internal.content.LazyReader;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;

public class ContentTypeCatalog {
    private Map aliases = new HashMap();
    private Map allChildren = new HashMap();
    private Map contentTypes = new HashMap();
    private Comparator lexicographical = new Comparator(){

        public int compare(Object o1, Object o2) {
            ContentType type1 = (ContentType)o1;
            ContentType type2 = (ContentType)o2;
            return type1.getId().compareTo(type2.getId());
        }
    };
    private Comparator specificIsBetter = new Comparator(){

        public int compare(Object o1, Object o2) {
            ContentType type1 = (ContentType)o1;
            ContentType type2 = (ContentType)o2;
            int depthCriteria = type1.getDepth(ContentTypeCatalog.this) - type2.getDepth(ContentTypeCatalog.this);
            if (depthCriteria != 0) {
                return -depthCriteria;
            }
            int priorityCriteria = type1.getPriority() - type2.getPriority();
            if (priorityCriteria != 0) {
                return -priorityCriteria;
            }
            return 0;
        }
    };
    private Comparator constantSpecificIsBetter = new Comparator(){

        public int compare(Object o1, Object o2) {
            ContentType type1 = (ContentType)o1;
            ContentType type2 = (ContentType)o2;
            int depthCriteria = type1.getDepth(ContentTypeCatalog.this) - type2.getDepth(ContentTypeCatalog.this);
            if (depthCriteria != 0) {
                return -depthCriteria;
            }
            int priorityCriteria = type1.getPriority() - type2.getPriority();
            if (priorityCriteria != 0) {
                return -priorityCriteria;
            }
            return type1.getId().compareTo(type2.getId());
        }
    };
    private Comparator constantGeneralIsBetter = new Comparator(){

        public int compare(Object o1, Object o2) {
            ContentType type1 = (ContentType)o1;
            ContentType type2 = (ContentType)o2;
            int depthCriteria = type1.getDepth(ContentTypeCatalog.this) - type2.getDepth(ContentTypeCatalog.this);
            if (depthCriteria != 0) {
                return depthCriteria;
            }
            int priorityCriteria = type1.getPriority() - type2.getPriority();
            if (priorityCriteria != 0) {
                return -priorityCriteria;
            }
            return type1.getId().compareTo(type2.getId());
        }
    };
    private Map fileExtensions = new HashMap();
    private Map fileNames = new HashMap();
    private ContentTypeManager manager;

    public ContentTypeCatalog(ContentTypeManager manager) {
        this.manager = manager;
    }

    void addContentType(IContentType contentType) {
        this.contentTypes.put(contentType.getId(), contentType);
    }

    void associate(ContentType contentType) {
        String[] builtInFileNames = contentType.getFileSpecs(this, 6);
        int i = 0;
        while (i < builtInFileNames.length) {
            this.associate(contentType, builtInFileNames[i], 4);
            ++i;
        }
        String[] builtInFileExtensions = contentType.getFileSpecs(this, 10);
        int i2 = 0;
        while (i2 < builtInFileExtensions.length) {
            this.associate(contentType, builtInFileExtensions[i2], 8);
            ++i2;
        }
    }

    void associate(ContentType contentType, String text, int type) {
        String mappingKey;
        Map fileSpecMap = (type & 4) != 0 ? this.fileNames : this.fileExtensions;
        HashSet<ContentType> existing = (HashSet<ContentType>)fileSpecMap.get(mappingKey = FileSpec.getMappingKeyFor(text));
        if (existing == null) {
            existing = new HashSet<ContentType>();
            fileSpecMap.put(mappingKey, existing);
        }
        existing.add(contentType);
    }

    void dissociate(ContentType contentType, String text, int type) {
        String mappingKey;
        Map fileSpecMap = (type & 4) != 0 ? this.fileNames : this.fileExtensions;
        Set existing = (Set)fileSpecMap.get(mappingKey = FileSpec.getMappingKeyFor(text));
        if (existing == null) {
            return;
        }
        existing.remove(contentType);
    }

    private boolean ensureValid(ContentType type) {
        ContentType aliasTarget;
        if (type.getValidation() != 0) {
            return type.isValid();
        }
        type.setValidation((byte)2);
        if (type.getBaseTypeId() != null) {
            ContentType baseType = (ContentType)this.contentTypes.get(type.getBaseTypeId());
            if (baseType == null) {
                return false;
            }
            this.ensureValid(baseType);
            if (baseType.getValidation() != 1) {
                return false;
            }
        }
        if ((aliasTarget = type.getTarget(this, false)) != null) {
            this.ensureValid(aliasTarget);
            if (aliasTarget.getValidation() != 1) {
                return false;
            }
        }
        type.setValidation((byte)1);
        return true;
    }

    protected IContentType[] findContentTypesFor(InputStream contents, String fileName) throws IOException {
        LazyInputStream buffer = ContentTypeManager.readBuffer(contents);
        return this.internalFindContentTypesFor(buffer, false, this.getSubset(fileName), fileName == null ? this.constantSpecificIsBetter : this.specificIsBetter);
    }

    public IContentType[] findContentTypesFor(String fileName) {
        return this.internalFindContentTypesFor(fileName, this.constantGeneralIsBetter);
    }

    public IContentType[] findContentTypesFor(InputStream contents, IContentType[] subset) throws IOException {
        LazyInputStream buffer = ContentTypeManager.readBuffer(contents);
        return this.internalFindContentTypesFor(buffer, false, subset, this.specificIsBetter);
    }

    public IContentType[] internalFindContentTypesFor(String fileName, Comparator sortingPolicy) {
        ArrayList selected = new ArrayList(5);
        Set allByFileName = (Set)this.fileNames.get(FileSpec.getMappingKeyFor(fileName));
        this.collectMatchingByName(allByFileName, selected, fileName, 4);
        int boundary = selected.size();
        String fileExtension = ContentTypeManager.getFileExtension(fileName);
        if (fileExtension != null) {
            Set allByFileExtension = (Set)this.fileExtensions.get(FileSpec.getMappingKeyFor(fileExtension));
            this.collectMatchingByName(allByFileExtension, selected, fileExtension, 8);
        }
        IContentType[] result = selected.toArray(new IContentType[selected.size()]);
        if (sortingPolicy == null) {
            return result;
        }
        if (boundary > 1) {
            Arrays.sort(result, 0, boundary, sortingPolicy);
        }
        if (boundary < result.length - 1) {
            Arrays.sort(result, boundary, result.length, sortingPolicy);
        }
        return result;
    }

    private void collectMatchingByName(Collection source, final Collection destination, final String fileSpecText, final int fileSpecType) {
        if (source == null || source.isEmpty()) {
            return;
        }
        Iterator i = source.iterator();
        while (i.hasNext()) {
            final ContentType root = (ContentType)i.next();
            this.internalAccept(new ContentTypeVisitor(){

                public int visit(ContentType type) {
                    if (type != root && type.hasBuiltInAssociations()) {
                        return 1;
                    }
                    if (type == root && !type.hasFileSpec(fileSpecText, fileSpecType)) {
                        return 1;
                    }
                    if (!destination.contains(type)) {
                        destination.add(type);
                    }
                    return 0;
                }
            }, root);
        }
    }

    public ContentType getAliasTarget(ContentType alias) {
        return (ContentType)this.aliases.get(alias);
    }

    public IContentType[] getAllContentTypes() {
        ArrayList<ContentType> result = new ArrayList<ContentType>(this.contentTypes.size());
        Iterator i = this.contentTypes.values().iterator();
        while (i.hasNext()) {
            ContentType type = (ContentType)i.next();
            if (!type.isValid() || type.isAlias(this)) continue;
            result.add(type);
        }
        return result.toArray(new IContentType[result.size()]);
    }

    public ContentType[] getChildren(ContentType parent) {
        ContentType[] children = (ContentType[])this.allChildren.get(parent);
        if (children != null) {
            return children;
        }
        ArrayList<ContentType> result = new ArrayList<ContentType>(5);
        Iterator i = this.contentTypes.values().iterator();
        while (i.hasNext()) {
            ContentType next = (ContentType)i.next();
            if (next.getBaseType(this) != parent) continue;
            result.add(next);
        }
        children = result.toArray(new ContentType[result.size()]);
        this.allChildren.put(parent, children);
        return children;
    }

    public ContentType getContentType(String contentTypeIdentifier) {
        ContentType type = this.internalGetContentType(contentTypeIdentifier);
        return type != null && type.isValid() && !type.isAlias(this) ? type : null;
    }

    public IContentDescription getDescriptionFor(InputStream contents, String fileName, QualifiedName[] options) throws IOException {
        LazyInputStream buffer = ContentTypeManager.readBuffer(contents);
        IContentType[] selected = this.internalFindContentTypesFor(buffer, false, this.getSubset(fileName), fileName == null ? this.constantSpecificIsBetter : this.specificIsBetter);
        if (selected.length == 0) {
            return null;
        }
        return ((ContentType)selected[0]).internalGetDescriptionFor(this, buffer, options);
    }

    private IContentType[] getSubset(String fileName) {
        return fileName == null ? this.getAllContentTypes() : this.internalFindContentTypesFor(fileName, this.lexicographical);
    }

    public IContentDescription getDescriptionFor(Reader contents, String fileName, QualifiedName[] options) throws IOException {
        LazyReader buffer = ContentTypeManager.readBuffer(contents);
        IContentType[] selected = this.internalFindContentTypesFor(buffer, true, this.getSubset(fileName), fileName == null ? this.constantSpecificIsBetter : this.specificIsBetter);
        if (selected.length == 0) {
            return null;
        }
        return ((ContentType)selected[0]).internalGetDescriptionFor(this, buffer, options);
    }

    public ContentTypeManager getManager() {
        return this.manager;
    }

    public IContentType[] internalFindContentTypesFor(Object buffer, boolean text, IContentType[] subset, Comparator sortingPolicy) throws IOException {
        ArrayList<ContentType> appropriate = new ArrayList<ContentType>();
        int valid = 0;
        int i = 0;
        while (i < subset.length) {
            ContentType current = (ContentType)subset[i];
            IContentDescriber describer = current.getDescriber(this);
            int status = 1;
            if (describer == null || (status = current.describe(describer, text, buffer, null)) != 0) {
                if (status == 2) {
                    appropriate.add(valid++, current);
                } else {
                    appropriate.add(current);
                }
            }
            ++i;
        }
        IContentType[] result = appropriate.toArray(new IContentType[appropriate.size()]);
        if (valid > 1) {
            Arrays.sort(result, 0, valid, sortingPolicy);
        }
        if (result.length - valid > 1) {
            Arrays.sort(result, valid, result.length, sortingPolicy);
        }
        return result;
    }

    ContentType internalGetContentType(String contentTypeIdentifier) {
        return (ContentType)this.contentTypes.get(contentTypeIdentifier);
    }

    private void makeAliases() {
        Iterator i = this.contentTypes.values().iterator();
        while (i.hasNext()) {
            ContentType target;
            ContentType type = (ContentType)i.next();
            String targetId = type.getAliasTargetId();
            if (targetId == null || (target = this.internalGetContentType(targetId)) == null) continue;
            type.setAliasTarget(this, target);
        }
    }

    protected void organize() {
        ContentType type;
        this.makeAliases();
        Iterator i = this.contentTypes.values().iterator();
        while (i.hasNext()) {
            type = (ContentType)i.next();
            if (!this.ensureValid(type)) continue;
            this.associate(type);
        }
        if (ContentTypeManager.DEBUGGING) {
            i = this.contentTypes.values().iterator();
            while (i.hasNext()) {
                type = (ContentType)i.next();
                if (type.isValid()) continue;
                Policy.debug("Invalid: " + type);
            }
        }
    }

    void setAliasTarget(ContentType alias, ContentType target) {
        if (target == null) {
            this.aliases.remove(alias);
            return;
        }
        if (alias.isKindOf(this, target)) {
            return;
        }
        this.aliases.put(alias, target);
        if (ContentTypeManager.DEBUGGING) {
            Policy.debug("Set alias target for " + alias + " -> " + target);
        }
    }

    public boolean internalAccept(ContentTypeVisitor visitor, ContentType root) {
        if (!root.isValid() || root.isAlias(this)) {
            return false;
        }
        int result = visitor.visit(root);
        switch (result) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        ContentType[] children = this.getChildren(root);
        if (children == null) {
            return true;
        }
        int i = 0;
        while (i < children.length) {
            if (!this.internalAccept(visitor, children[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

