/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.dynamicHelpers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.runtime.ListenerList;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamicHelpers.IExtensionAdditionHandler;
import org.eclipse.core.runtime.dynamicHelpers.IExtensionRemovalHandler;
import org.eclipse.core.runtime.dynamicHelpers.IExtensionTracker;
import org.eclipse.core.runtime.dynamicHelpers.ReferenceHashSet;

public class ExtensionTracker
implements IExtensionTracker,
IRegistryChangeListener {
    private Map extensionToObjects = new HashMap();
    private ListenerList additionHandlers = new ListenerList();
    private ListenerList removalHandlers = new ListenerList();
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public ExtensionTracker() {
        Platform.getExtensionRegistry().addRegistryChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAdditionHandler(IExtensionAdditionHandler handler) {
        ListenerList listenerList = this.additionHandlers;
        synchronized (listenerList) {
            this.additionHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAdditionHandler(IExtensionAdditionHandler handler) {
        ListenerList listenerList = this.additionHandlers;
        synchronized (listenerList) {
            this.additionHandlers.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRemovalHandler(IExtensionRemovalHandler handler) {
        ListenerList listenerList = this.removalHandlers;
        synchronized (listenerList) {
            this.removalHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterRemovalHandler(IExtensionRemovalHandler handler) {
        ListenerList listenerList = this.removalHandlers;
        synchronized (listenerList) {
            this.removalHandlers.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerObject(IExtension element, Object object, int referenceType) {
        if (element == null || object == null) {
            return;
        }
        Map map = this.extensionToObjects;
        synchronized (map) {
            ReferenceHashSet associatedObjects = (ReferenceHashSet)this.extensionToObjects.get(element);
            if (associatedObjects == null) {
                associatedObjects = new ReferenceHashSet();
                this.extensionToObjects.put(element, associatedObjects);
            }
            associatedObjects.add(object, referenceType);
        }
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] delta = event.getExtensionDeltas();
        int len = delta.length;
        int i = 0;
        while (i < len) {
            switch (delta[i].getKind()) {
                case 1: {
                    this.doAdd(delta[i]);
                    break;
                }
                case 2: {
                    this.doRemove(delta[i]);
                    break;
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAdd(IExtensionDelta delta) {
        Object[] handlersCopy = null;
        ListenerList listenerList = this.additionHandlers;
        synchronized (listenerList) {
            if (this.additionHandlers == null || this.additionHandlers.isEmpty()) {
                return;
            }
            handlersCopy = this.additionHandlers.getListeners();
        }
        int i = 0;
        while (i < handlersCopy.length) {
            IExtensionAdditionHandler handler = (IExtensionAdditionHandler)handlersCopy[i];
            if (handler.getExtensionPointFilter() == null || handler.getExtensionPointFilter().equals(delta.getExtensionPoint())) {
                this.applyAdd(handler, delta.getExtension());
            }
            ++i;
        }
    }

    protected void applyAdd(IExtensionAdditionHandler handler, IExtension extension) {
        handler.addInstance(this, extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemove(IExtensionDelta delta) {
        Object associatedObjects;
        IExtension removedExtension = delta.getExtension();
        Object[] removedObjects = null;
        Map map = this.extensionToObjects;
        synchronized (map) {
            associatedObjects = (ReferenceHashSet)this.extensionToObjects.remove(removedExtension);
            if (associatedObjects == null) {
                return;
            }
            removedObjects = ((ReferenceHashSet)associatedObjects).toArray();
        }
        Object[] handlersCopy = null;
        associatedObjects = this.removalHandlers;
        synchronized (associatedObjects) {
            if (this.removalHandlers == null || this.removalHandlers.isEmpty()) {
                return;
            }
            handlersCopy = this.removalHandlers.getListeners();
        }
        int i = 0;
        while (i < handlersCopy.length) {
            this.applyRemove((IExtensionRemovalHandler)handlersCopy[i], removedExtension, removedObjects);
            ++i;
        }
    }

    protected void applyRemove(IExtensionRemovalHandler handler, IExtension removedExtension, Object[] removedObjects) {
        handler.removeInstance(removedExtension, removedObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getObjects(IExtension element) {
        Map map = this.extensionToObjects;
        synchronized (map) {
            ReferenceHashSet objectSet = (ReferenceHashSet)this.extensionToObjects.get(element);
            if (objectSet == null) {
                return EMPTY_ARRAY;
            }
            return objectSet.toArray();
        }
    }

    public void close() {
        Platform.getExtensionRegistry().removeRegistryChangeListener(this);
        this.extensionToObjects = null;
        this.additionHandlers = null;
        this.removalHandlers = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterObject(IExtension extension, Object object) {
        Map map = this.extensionToObjects;
        synchronized (map) {
            ReferenceHashSet associatedObjects = (ReferenceHashSet)this.extensionToObjects.get(extension);
            if (associatedObjects != null) {
                associatedObjects.remove(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] unregisterObject(IExtension extension) {
        Map map = this.extensionToObjects;
        synchronized (map) {
            ReferenceHashSet associatedObjects = (ReferenceHashSet)this.extensionToObjects.remove(extension);
            if (associatedObjects == null) {
                return EMPTY_ARRAY;
            }
            return associatedObjects.toArray();
        }
    }
}

