/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XColor;

public abstract class Device
implements Drawable {
    public int xDisplay;
    public boolean setDPI;
    public static boolean DEBUG;
    boolean debug = DEBUG;
    boolean tracking = DEBUG;
    Error[] errors;
    Object[] objects;
    String display_name;
    String application_name;
    String application_class;
    XColor[] xcolors;
    int[] colorRefCount;
    Color COLOR_BLACK;
    Color COLOR_DARK_RED;
    Color COLOR_DARK_GREEN;
    Color COLOR_DARK_YELLOW;
    Color COLOR_DARK_BLUE;
    Color COLOR_DARK_MAGENTA;
    Color COLOR_DARK_CYAN;
    Color COLOR_GRAY;
    Color COLOR_DARK_GRAY;
    Color COLOR_RED;
    Color COLOR_GREEN;
    Color COLOR_YELLOW;
    Color COLOR_BLUE;
    Color COLOR_MAGENTA;
    Color COLOR_CYAN;
    Color COLOR_WHITE;
    Font systemFont;
    boolean warnings = true;
    Callback xErrorCallback;
    Callback xtWarningCallback;
    Callback xIOErrorCallback;
    Callback xtErrorCallback;
    int xErrorProc;
    int xtWarningProc;
    int xIOErrorProc;
    int xtErrorProc;
    int xNullErrorProc;
    int xtNullWarningProc;
    int xNullIOErrorProc;
    int xtNullErrorProc;
    int tabMapping;
    int crMapping;
    int tabPointer;
    int crPointer;
    protected static Device CurrentDevice;
    protected static Runnable DeviceFinder;

    static Device getDevice() {
        if (DeviceFinder != null) {
            DeviceFinder.run();
        }
        Device device = CurrentDevice;
        CurrentDevice = null;
        return device;
    }

    public Device(DeviceData data) {
        if (data != null) {
            this.display_name = data.display_name;
            this.application_name = data.application_name;
            this.application_class = data.application_class;
            this.tracking = data.tracking;
            this.debug = data.debug;
        }
        if (this.tracking) {
            this.errors = new Error[128];
            this.objects = new Object[128];
        }
        this.create(data);
        this.init();
        this.systemFont = this.getSystemFont();
    }

    protected void checkDevice() {
        if (this.xDisplay == 0) {
            SWT.error(45);
        }
    }

    protected void create(DeviceData data) {
    }

    protected void destroy() {
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.checkDevice();
        this.release();
        this.destroy();
        this.xDisplay = 0;
        if (this.tracking) {
            this.objects = null;
            this.errors = null;
        }
    }

    void dispose_Object(Object object) {
        int i = 0;
        while (i < this.objects.length) {
            if (this.objects[i] == object) {
                this.objects[i] = null;
                this.errors[i] = null;
                return;
            }
            ++i;
        }
    }

    public Rectangle getBounds() {
        this.checkDevice();
        int screen = OS.XDefaultScreen(this.xDisplay);
        int width = OS.XDisplayWidth(this.xDisplay, screen);
        int height = OS.XDisplayHeight(this.xDisplay, screen);
        return new Rectangle(0, 0, width, height);
    }

    public Rectangle getClientArea() {
        return this.getBounds();
    }

    public int getDepth() {
        this.checkDevice();
        int xScreenPtr = OS.XDefaultScreenOfDisplay(this.xDisplay);
        return OS.XDefaultDepthOfScreen(xScreenPtr);
    }

    public DeviceData getDeviceData() {
        this.checkDevice();
        DeviceData data = new DeviceData();
        data.display_name = this.display_name;
        data.application_name = this.application_name;
        data.application_class = this.application_class;
        data.debug = this.debug;
        data.tracking = this.tracking;
        int count = 0;
        int length = 0;
        if (this.tracking) {
            length = this.objects.length;
        }
        int i = 0;
        while (i < length) {
            if (this.objects[i] != null) {
                ++count;
            }
            ++i;
        }
        int index = 0;
        data.objects = new Object[count];
        data.errors = new Error[count];
        int i2 = 0;
        while (i2 < length) {
            if (this.objects[i2] != null) {
                data.objects[index] = this.objects[i2];
                data.errors[index] = this.errors[i2];
                ++index;
            }
            ++i2;
        }
        return data;
    }

    public Point getDPI() {
        this.checkDevice();
        int xScreenNum = OS.XDefaultScreen(this.xDisplay);
        int width = OS.XDisplayWidth(this.xDisplay, xScreenNum);
        int height = OS.XDisplayHeight(this.xDisplay, xScreenNum);
        int mmX = OS.XDisplayWidthMM(this.xDisplay, xScreenNum);
        int mmY = OS.XDisplayHeightMM(this.xDisplay, xScreenNum);
        double inchesX = (double)mmX * 0.03937;
        double inchesY = (double)mmY * 0.03937;
        int x = (int)((double)width / inchesX + 0.5);
        int y = (int)((double)height / inchesY + 0.5);
        return new Point(x, y);
    }

    public FontData[] getFontList(String faceName, boolean scalable) {
        int listPtr;
        int dashIndex;
        this.checkDevice();
        String xlfd = faceName == null ? "-*-*-*-*-*-*-*-*-*-*-*-*-*-*" : ((dashIndex = faceName.indexOf(45)) < 0 ? "-*-" + faceName + "-*-*-*-*-*-*-*-*-*-*-*-*" : "-" + faceName + "-*-*-*-*-*-*-*-*-*-*-*-*");
        byte[] buffer1 = Converter.wcsToMbcs(null, xlfd, true);
        int[] ret = new int[1];
        int ptr = listPtr = OS.XListFonts(this.xDisplay, buffer1, 65535, ret);
        int[] intBuf = new int[1];
        FontData[] fd = new FontData[ret[0]];
        int fdIndex = 0;
        int i = 0;
        while (i < ret[0]) {
            boolean isScalable;
            OS.memmove(intBuf, ptr, 4);
            int charPtr = intBuf[0];
            int length = OS.strlen(charPtr);
            byte[] buffer2 = new byte[length];
            OS.memmove(buffer2, charPtr, length);
            char[] chars = Converter.mbcsToWcs(null, buffer2);
            FontData data = FontData.motif_new(new String(chars));
            boolean bl = isScalable = data.averageWidth == 0 && data.pixels == 0 && data.points == 0;
            if (isScalable == scalable) {
                fd[fdIndex++] = data;
            }
            ptr += 4;
            ++i;
        }
        OS.XFreeFontNames(listPtr);
        if (fdIndex == ret[0]) {
            return fd;
        }
        FontData[] result = new FontData[fdIndex];
        System.arraycopy(fd, 0, result, 0, fdIndex);
        return result;
    }

    public Color getSystemColor(int id) {
        this.checkDevice();
        XColor xColor = null;
        switch (id) {
            case 2: {
                return this.COLOR_BLACK;
            }
            case 4: {
                return this.COLOR_DARK_RED;
            }
            case 6: {
                return this.COLOR_DARK_GREEN;
            }
            case 8: {
                return this.COLOR_DARK_YELLOW;
            }
            case 10: {
                return this.COLOR_DARK_BLUE;
            }
            case 12: {
                return this.COLOR_DARK_MAGENTA;
            }
            case 14: {
                return this.COLOR_DARK_CYAN;
            }
            case 15: {
                return this.COLOR_GRAY;
            }
            case 16: {
                return this.COLOR_DARK_GRAY;
            }
            case 3: {
                return this.COLOR_RED;
            }
            case 5: {
                return this.COLOR_GREEN;
            }
            case 7: {
                return this.COLOR_YELLOW;
            }
            case 9: {
                return this.COLOR_BLUE;
            }
            case 11: {
                return this.COLOR_MAGENTA;
            }
            case 13: {
                return this.COLOR_CYAN;
            }
            case 1: {
                return this.COLOR_WHITE;
            }
        }
        if (xColor == null) {
            return this.COLOR_BLACK;
        }
        return Color.motif_new(this, xColor);
    }

    public Font getSystemFont() {
        this.checkDevice();
        return this.systemFont;
    }

    public boolean getWarnings() {
        this.checkDevice();
        return this.warnings;
    }

    protected void init() {
        int xScreenPtr;
        int defaultDepth;
        this.xErrorCallback = new Callback(this, "xErrorProc", 2);
        this.xNullErrorProc = this.xErrorCallback.getAddress();
        if (this.xNullErrorProc == 0) {
            SWT.error(3);
        }
        this.xtWarningCallback = new Callback(this, "xtWarningProc", 1);
        this.xtNullWarningProc = this.xtWarningCallback.getAddress();
        if (this.xtNullWarningProc == 0) {
            SWT.error(3);
        }
        this.xIOErrorCallback = new Callback(this, "xIOErrorProc", 1);
        this.xNullIOErrorProc = this.xIOErrorCallback.getAddress();
        if (this.xNullIOErrorProc == 0) {
            SWT.error(3);
        }
        this.xtErrorCallback = new Callback(this, "xtErrorProc", 1);
        this.xtNullErrorProc = this.xtErrorCallback.getAddress();
        if (this.xtNullErrorProc == 0) {
            SWT.error(3);
        }
        if (this.debug) {
            OS.XSynchronize(this.xDisplay, true);
        }
        int xtContext = OS.XtDisplayToApplicationContext(this.xDisplay);
        this.xErrorProc = OS.XSetErrorHandler(this.xNullErrorProc);
        if (!this.debug) {
            OS.XSetErrorHandler(this.xErrorProc);
        }
        this.xtWarningProc = OS.XtAppSetWarningHandler(xtContext, this.xtNullWarningProc);
        if (!this.debug) {
            OS.XtAppSetWarningHandler(xtContext, this.xtWarningProc);
        }
        this.xIOErrorProc = OS.XSetIOErrorHandler(this.xNullIOErrorProc);
        if (!this.debug) {
            OS.XSetIOErrorHandler(this.xIOErrorProc);
        }
        this.xtErrorProc = OS.XtAppSetErrorHandler(xtContext, this.xtNullErrorProc);
        if (!this.debug) {
            OS.XtAppSetErrorHandler(xtContext, this.xtErrorProc);
        }
        if ((defaultDepth = OS.XDefaultDepthOfScreen(xScreenPtr = OS.XDefaultScreenOfDisplay(this.xDisplay))) <= 8) {
            int numColors = 1 << defaultDepth;
            this.colorRefCount = new int[numColors];
            this.xcolors = new XColor[numColors];
        }
        this.COLOR_BLACK = new Color(this, 0, 0, 0);
        this.COLOR_DARK_RED = new Color(this, 128, 0, 0);
        this.COLOR_DARK_GREEN = new Color(this, 0, 128, 0);
        this.COLOR_DARK_YELLOW = new Color(this, 128, 128, 0);
        this.COLOR_DARK_BLUE = new Color(this, 0, 0, 128);
        this.COLOR_DARK_MAGENTA = new Color(this, 128, 0, 128);
        this.COLOR_DARK_CYAN = new Color(this, 0, 128, 128);
        this.COLOR_GRAY = new Color(this, 192, 192, 192);
        this.COLOR_DARK_GRAY = new Color(this, 128, 128, 128);
        this.COLOR_RED = new Color(this, 255, 0, 0);
        this.COLOR_GREEN = new Color(this, 0, 255, 0);
        this.COLOR_YELLOW = new Color(this, 255, 255, 0);
        this.COLOR_BLUE = new Color(this, 0, 0, 255);
        this.COLOR_MAGENTA = new Color(this, 255, 0, 255);
        this.COLOR_CYAN = new Color(this, 0, 255, 255);
        this.COLOR_WHITE = new Color(this, 255, 255, 255);
        byte[] tabBuffer = new byte[]{9, 0};
        this.tabPointer = OS.XtMalloc(tabBuffer.length);
        OS.memmove(this.tabPointer, tabBuffer, tabBuffer.length);
        int tabString = OS.XmStringComponentCreate(12, 0, null);
        int[] argList = new int[]{OS.XmNpattern, this.tabPointer, OS.XmNsubstitute, tabString};
        this.tabMapping = OS.XmParseMappingCreate(argList, argList.length / 2);
        OS.XmStringFree(tabString);
        byte[] crBuffer = new byte[]{10, 0};
        this.crPointer = OS.XtMalloc(crBuffer.length);
        OS.memmove(this.crPointer, crBuffer, crBuffer.length);
        int crString = OS.XmStringComponentCreate(4, 0, null);
        argList = new int[]{OS.XmNpattern, this.crPointer, OS.XmNsubstitute, crString};
        this.crMapping = OS.XmParseMappingCreate(argList, argList.length / 2);
        OS.XmStringFree(crString);
    }

    public abstract int internal_new_GC(GCData var1);

    public abstract void internal_dispose_GC(int var1, GCData var2);

    public boolean isDisposed() {
        return this.xDisplay == 0;
    }

    void new_Object(Object object) {
        int i = 0;
        while (i < this.objects.length) {
            if (this.objects[i] == null) {
                this.objects[i] = object;
                this.errors[i] = new Error();
                return;
            }
            ++i;
        }
        Object[] newObjects = new Object[this.objects.length + 128];
        System.arraycopy(this.objects, 0, newObjects, 0, this.objects.length);
        newObjects[this.objects.length] = object;
        this.objects = newObjects;
        Error[] newErrors = new Error[this.errors.length + 128];
        System.arraycopy(this.errors, 0, newErrors, 0, this.errors.length);
        newErrors[this.errors.length] = new Error();
        this.errors = newErrors;
    }

    protected void release() {
        OS.XtFree(this.tabPointer);
        OS.XtFree(this.crPointer);
        OS.XmParseMappingFree(this.tabMapping);
        OS.XmParseMappingFree(this.crMapping);
        this.crMapping = 0;
        this.tabMapping = 0;
        this.crPointer = 0;
        this.tabPointer = 0;
        if (this.xcolors != null) {
            int xScreen = OS.XDefaultScreen(this.xDisplay);
            int xColormap = OS.XDefaultColormap(this.xDisplay, xScreen);
            int[] pixel = new int[1];
            int i = 0;
            while (i < this.xcolors.length) {
                XColor color = this.xcolors[i];
                if (color != null) {
                    pixel[0] = color.pixel;
                    while (this.colorRefCount[i] > 0) {
                        OS.XFreeColors(this.xDisplay, xColormap, pixel, 1, 0);
                        int n = i;
                        this.colorRefCount[n] = this.colorRefCount[n] - 1;
                    }
                }
                ++i;
            }
        }
        this.xcolors = null;
        this.colorRefCount = null;
        this.COLOR_WHITE = null;
        this.COLOR_CYAN = null;
        this.COLOR_MAGENTA = null;
        this.COLOR_BLUE = null;
        this.COLOR_YELLOW = null;
        this.COLOR_GREEN = null;
        this.COLOR_RED = null;
        this.COLOR_DARK_GRAY = null;
        this.COLOR_GRAY = null;
        this.COLOR_DARK_CYAN = null;
        this.COLOR_DARK_MAGENTA = null;
        this.COLOR_DARK_BLUE = null;
        this.COLOR_DARK_YELLOW = null;
        this.COLOR_DARK_GREEN = null;
        this.COLOR_DARK_RED = null;
        this.COLOR_BLACK = null;
        int xtContext = OS.XtDisplayToApplicationContext(this.xDisplay);
        OS.XtAppSetErrorHandler(xtContext, this.xtErrorProc);
        this.xtErrorCallback.dispose();
        this.xtErrorCallback = null;
        this.xtErrorProc = 0;
        this.xtNullErrorProc = 0;
        OS.XtAppSetWarningHandler(xtContext, this.xtWarningProc);
        this.xtWarningCallback.dispose();
        this.xtWarningCallback = null;
        this.xtWarningProc = 0;
        this.xtNullWarningProc = 0;
        OS.XSetIOErrorHandler(this.xIOErrorProc);
        this.xIOErrorCallback.dispose();
        this.xIOErrorCallback = null;
        this.xIOErrorProc = 0;
        this.xNullIOErrorProc = 0;
        OS.XSetErrorHandler(this.xNullErrorProc);
    }

    public void setWarnings(boolean warnings) {
        this.checkDevice();
        this.warnings = warnings;
        if (this.debug) {
            return;
        }
        int xtContext = OS.XtDisplayToApplicationContext(this.xDisplay);
        if (warnings) {
            OS.XSetErrorHandler(this.xErrorProc);
            OS.XtAppSetWarningHandler(xtContext, this.xtWarningProc);
        } else {
            OS.XSetErrorHandler(this.xNullErrorProc);
            OS.XtAppSetWarningHandler(xtContext, this.xtNullWarningProc);
        }
    }

    int xErrorProc(int xDisplay, int xErrorEvent) {
        if (DEBUG || this.debug && this.warnings) {
            new SWTError().printStackTrace();
            OS.Call(this.xErrorProc, xDisplay, xErrorEvent);
        }
        return 0;
    }

    int xIOErrorProc(int xDisplay) {
        if (DEBUG || this.debug) {
            new SWTError().printStackTrace();
            OS.Call(this.xIOErrorProc, xDisplay, 0);
        }
        return 0;
    }

    int xtErrorProc(int message) {
        if (DEBUG || this.debug) {
            new SWTError().printStackTrace();
            OS.Call(this.xtErrorProc, message, 0);
        }
        return 0;
    }

    int xtWarningProc(int message) {
        if (DEBUG || this.debug && this.warnings) {
            new SWTError().printStackTrace();
            OS.Call(this.xtWarningProc, message, 0);
        }
        return 0;
    }

    static {
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (Throwable e) {}
    }
}

