/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.program;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.motif.CDE;
import org.eclipse.swt.internal.motif.GNOME;
import org.eclipse.swt.internal.motif.GnomeVFSMimeApplication;
import org.eclipse.swt.internal.motif.KDE;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.widgets.Display;

public final class Program {
    String name;
    String extension;
    String command;
    Display display;
    boolean gnomeExpectUri;
    private static final String cdeShell = "Program_CDE_SHELL";
    private static final String[] cdeIconExt = new String[]{".m.pm", ".l.pm", ".s.pm", ".t.pm"};
    private static final String[] cdeMaskExt = new String[]{".m_m.bm", ".l_m.bm", ".s_m.bm", ".t_m.bm"};
    private static final String desktopData = "Program_DESKTOP";
    static final int DESKTOP_UNKNOWN = 0;
    static final int DESKTOP_KDE = 1;
    static final int DESKTOP_GNOME = 2;
    static final int DESKTOP_CDE = 3;

    Program() {
    }

    static int getDesktop(Display display) {
        int[] numProp;
        if (display == null) {
            return 0;
        }
        Integer desktopValue = (Integer)display.getData(desktopData);
        if (desktopValue != null) {
            return desktopValue;
        }
        int desktop = 0;
        if (Program.isGnomeDesktop(display)) {
            if (Program.gnome_init()) {
                desktop = 2;
            }
            display.setData(desktopData, new Integer(desktop));
            return desktop;
        }
        int xDisplay = display.xDisplay;
        byte[] cdeName = Converter.wcsToMbcs(null, "_DT_SM_PREFERENCES", true);
        byte[] kdeName = Converter.wcsToMbcs(null, "KWIN_RUNNING", true);
        int cde = OS.XInternAtom(xDisplay, cdeName, true);
        int kde = OS.XInternAtom(xDisplay, kdeName, true);
        int rootWindow = OS.XDefaultRootWindow(xDisplay);
        int propList = OS.XListProperties(xDisplay, rootWindow, numProp = new int[1]);
        if (propList == 0) {
            return 0;
        }
        int[] property = new int[numProp[0]];
        OS.memmove(property, propList, property.length * 4);
        OS.XFree(propList);
        int index = 0;
        while (desktop == 0 && index < property.length) {
            if (property[index] != 0) {
                if (property[index] == cde && Program.cde_init(display)) {
                    desktop = 3;
                }
                if (property[index] == kde && Program.kde_init()) {
                    desktop = 1;
                }
            }
            ++index;
        }
        display.setData(desktopData, new Integer(desktop));
        return desktop;
    }

    public static Program findProgram(String extension) {
        return Program.findProgram(Display.getCurrent(), extension);
    }

    private static Program findProgram(Display display, String extension) {
        if (extension == null) {
            SWT.error(4);
        }
        if (extension.length() == 0) {
            return null;
        }
        if (extension.charAt(0) != '.') {
            extension = "." + extension;
        }
        String command = null;
        String name = null;
        int desktop = Program.getDesktop(display);
        Hashtable mimeInfo = null;
        if (desktop == 1) {
            mimeInfo = Program.kde_getMimeInfo();
        }
        if (desktop == 2) {
            mimeInfo = Program.gnome_getMimeInfo();
        }
        if (desktop == 3) {
            mimeInfo = Program.cde_getDataTypeInfo();
        }
        if (mimeInfo == null) {
            return null;
        }
        Iterator keys = mimeInfo.keySet().iterator();
        block0: while (name == null && keys.hasNext()) {
            String mimeType = (String)keys.next();
            Vector mimeExts = (Vector)mimeInfo.get(mimeType);
            int index = 0;
            while (index < mimeExts.size()) {
                if (extension.equals(mimeExts.elementAt(index))) {
                    name = mimeType;
                    continue block0;
                }
                ++index;
            }
        }
        if (name == null) {
            return null;
        }
        boolean[] gnomeExpectUri = null;
        if (desktop == 2) {
            gnomeExpectUri = new boolean[1];
            command = Program.gnome_getMimeTypeCommand(name, gnomeExpectUri);
        }
        if (desktop == 1) {
            command = Program.kde_getMimeTypeCommand(name);
        }
        if (desktop == 3) {
            command = Program.cde_getAction(name);
        }
        if (command == null) {
            return null;
        }
        Program program = new Program();
        program.name = name;
        program.command = command;
        if (desktop == 2) {
            program.gnomeExpectUri = gnomeExpectUri[0];
        }
        program.extension = extension;
        program.display = display;
        return program;
    }

    public static String[] getExtensions() {
        return Program.getExtensions(Display.getCurrent());
    }

    private static String[] getExtensions(Display display) {
        int desktop = Program.getDesktop(display);
        Hashtable mimeInfo = null;
        if (desktop == 1) {
            mimeInfo = Program.kde_getMimeInfo();
        }
        if (desktop == 2) {
            mimeInfo = Program.gnome_getMimeInfo();
        }
        if (desktop == 3) {
            mimeInfo = Program.cde_getDataTypeInfo();
        }
        if (mimeInfo == null) {
            return new String[0];
        }
        Vector extensions = new Vector();
        Iterator keys = mimeInfo.keySet().iterator();
        while (keys.hasNext()) {
            String mimeType = (String)keys.next();
            Vector mimeExts = (Vector)mimeInfo.get(mimeType);
            int index = 0;
            while (index < mimeExts.size()) {
                if (!extensions.contains(mimeExts.elementAt(index))) {
                    extensions.addElement(mimeExts.elementAt(index));
                }
                ++index;
            }
        }
        String[] extStrings = new String[extensions.size()];
        int index = 0;
        while (index < extensions.size()) {
            extStrings[index] = (String)extensions.elementAt(index);
            ++index;
        }
        return extStrings;
    }

    public static Program[] getPrograms() {
        return Program.getPrograms(Display.getCurrent());
    }

    private static Program[] getPrograms(Display display) {
        int desktop = Program.getDesktop(display);
        Hashtable mimeInfo = null;
        if (desktop == 1) {
            mimeInfo = Program.kde_getMimeInfo();
        }
        if (desktop == 2) {
            mimeInfo = Program.gnome_getMimeInfo();
        }
        if (desktop == 3) {
            mimeInfo = Program.cde_getDataTypeInfo();
        }
        if (mimeInfo == null) {
            return new Program[0];
        }
        Vector<Program> programs = new Vector<Program>();
        boolean[] gnomeExpectUri = null;
        if (desktop == 2) {
            gnomeExpectUri = new boolean[1];
        }
        Iterator keys = mimeInfo.keySet().iterator();
        while (keys.hasNext()) {
            String mimeType = (String)keys.next();
            Vector mimeExts = (Vector)mimeInfo.get(mimeType);
            String extension = "";
            if (mimeExts.size() > 0) {
                extension = (String)mimeExts.elementAt(0);
            }
            String command = null;
            if (desktop == 2) {
                command = Program.gnome_getMimeTypeCommand(mimeType, gnomeExpectUri);
            }
            if (desktop == 1) {
                command = Program.kde_getMimeTypeCommand(mimeType);
            }
            if (desktop == 3) {
                command = Program.cde_getAction(mimeType);
            }
            if (command == null) continue;
            Program program = new Program();
            program.name = mimeType;
            program.command = command;
            if (desktop == 2) {
                program.gnomeExpectUri = gnomeExpectUri[0];
            }
            program.extension = extension;
            program.display = display;
            programs.addElement(program);
        }
        Program[] programList = new Program[programs.size()];
        int index = 0;
        while (index < programList.length) {
            programList[index] = (Program)programs.elementAt(index);
            ++index;
        }
        return programList;
    }

    private static boolean isGnomeDesktop(Display display) {
        int xDisplay = display.xDisplay;
        byte[] name = Converter.wcsToMbcs(null, "_WIN_SUPPORTING_WM_CHECK", true);
        int atom_set = OS.XInternAtom(xDisplay, name, true);
        return atom_set != 0;
    }

    private static Hashtable gnome_getMimeInfo() {
        int mimeList;
        Hashtable mimeInfo = new Hashtable();
        int[] mimeData = new int[1];
        int[] extensionData = new int[1];
        int mimeElement = mimeList = GNOME.gnome_vfs_get_registered_mime_types();
        while (mimeElement != 0) {
            OS.memmove(mimeData, mimeElement, 4);
            int mimePtr = mimeData[0];
            int mimeLength = OS.strlen(mimePtr);
            byte[] mimeTypeBuffer = new byte[mimeLength];
            OS.memmove(mimeTypeBuffer, mimePtr, mimeLength);
            String mimeType = new String(Converter.mbcsToWcs(null, mimeTypeBuffer));
            int extensionList = GNOME.gnome_vfs_mime_get_extensions_list(mimePtr);
            if (extensionList != 0) {
                Vector<String> extensions = new Vector<String>();
                int extensionElement = extensionList;
                while (extensionElement != 0) {
                    OS.memmove(extensionData, extensionElement, 4);
                    int extensionPtr = extensionData[0];
                    int extensionLength = OS.strlen(extensionPtr);
                    byte[] extensionBuffer = new byte[extensionLength];
                    OS.memmove(extensionBuffer, extensionPtr, extensionLength);
                    String extension = new String(Converter.mbcsToWcs(null, extensionBuffer));
                    extension = '.' + extension;
                    extensions.add(extension);
                    extensionElement = GNOME.g_list_next(extensionElement);
                }
                GNOME.gnome_vfs_mime_extensions_list_free(extensionList);
                if (extensions.size() > 0) {
                    mimeInfo.put(mimeType, extensions);
                }
            }
            mimeElement = GNOME.g_list_next(mimeElement);
        }
        if (mimeList != 0) {
            GNOME.gnome_vfs_mime_registered_mime_type_list_free(mimeList);
        }
        return mimeInfo;
    }

    private static String gnome_getMimeTypeCommand(String mimeType, boolean[] gnomeExpectUri) {
        String command = null;
        GnomeVFSMimeApplication application = new GnomeVFSMimeApplication();
        byte[] mimeTypeBuffer = Converter.wcsToMbcs(null, mimeType, true);
        int ptr = GNOME.gnome_vfs_mime_get_default_application(mimeTypeBuffer);
        if (ptr != 0) {
            GNOME.memmove(application, ptr, 28);
            int length = OS.strlen(application.command);
            byte[] buffer = new byte[length];
            OS.memmove(buffer, application.command, length);
            command = new String(Converter.mbcsToWcs(null, buffer));
            gnomeExpectUri[0] = application.expects_uris == 0;
            GNOME.gnome_vfs_mime_application_free(ptr);
        }
        return command;
    }

    /*
     * Unable to fully structure code
     */
    private static String[] parseCommand(String cmd) {
        args = new Vector<String>();
        sIndex = 0;
        ** GOTO lbl25
        {
            ++sIndex;
            do {
                if (sIndex < cmd.length() && Compatibility.isWhitespace(cmd.charAt(sIndex))) continue block0;
                if (sIndex >= cmd.length()) continue;
                if (cmd.charAt(sIndex) == '\"' || cmd.charAt(sIndex) == '\'') {
                    eIndex = sIndex + 1;
                    while (eIndex < cmd.length() && cmd.charAt(eIndex) != cmd.charAt(sIndex)) {
                        ++eIndex;
                    }
                    if (eIndex >= cmd.length()) {
                        args.addElement(cmd.substring(sIndex, eIndex));
                    } else {
                        args.addElement(cmd.substring(sIndex + 1, eIndex));
                    }
                    sIndex = eIndex + 1;
                    continue;
                }
                eIndex = sIndex;
                while (eIndex < cmd.length() && !Compatibility.isWhitespace(cmd.charAt(eIndex))) {
                    ++eIndex;
                }
                args.addElement(cmd.substring(sIndex, eIndex));
                sIndex = eIndex + 1;
lbl25:
                // 4 sources

            } while (sIndex < cmd.length());
        }
        strings = new String[args.size()];
        index = 0;
        while (index < args.size()) {
            strings[index] = (String)args.elementAt(index);
            ++index;
        }
        return strings;
    }

    static boolean kde_init() {
        return false;
    }

    private static String kde_getMimeTypeCommand(String mimeType) {
        byte[] buffer = Converter.wcsToMbcs(null, mimeType, true);
        int qMimeType = KDE.QString_new(buffer);
        int serviceList = KDE.KMimeType_offers(qMimeType);
        KDE.QString_delete(qMimeType);
        if (serviceList == 0) {
            return null;
        }
        KDE.KServiceList_delete(serviceList);
        return "KRun::runURL(url,mimeType)";
    }

    private static Hashtable kde_getMimeInfo() {
        Hashtable mimeInfo = new Hashtable();
        Vector<String> mimeExts = null;
        int mimeTypeList = KDE.KMimeType_allMimeTypes();
        int iterator = KDE.KMimeTypeList_begin(mimeTypeList);
        int listEnd = KDE.KMimeTypeList_end(mimeTypeList);
        while (KDE.KMimeTypeListIterator_equals(iterator, listEnd) == 0) {
            int kMimeType = KDE.KMimeTypeListIterator_dereference(iterator);
            int mimeName = KDE.KMimeType_name(kMimeType);
            String mimeType = Program.kde_convertQStringAndFree(mimeName);
            mimeExts = new Vector<String>();
            int patternList = KDE.KMimeType_patterns(kMimeType);
            int patIterator = KDE.QStringList_begin(patternList);
            int patListEnd = KDE.QStringList_end(patternList);
            while (KDE.QStringListIterator_equals(patIterator, patListEnd) == 0) {
                int patString = KDE.QStringListIterator_dereference(patIterator);
                String extension = Program.kde_convertQStringAndFree(patString);
                int period = extension.indexOf(46);
                if (period != -1) {
                    mimeExts.addElement(extension.substring(period));
                }
                KDE.QStringListIterator_increment(patIterator);
            }
            KDE.QStringListIterator_delete(patIterator);
            KDE.QStringListIterator_delete(patListEnd);
            KDE.QStringList_delete(patternList);
            if (mimeExts.size() > 0) {
                mimeInfo.put(mimeType, mimeExts);
            }
            KDE.KMimeTypeListIterator_increment(iterator);
        }
        KDE.KMimeTypeListIterator_delete(iterator);
        KDE.KMimeTypeListIterator_delete(listEnd);
        KDE.KMimeTypeList_delete(mimeTypeList);
        return mimeInfo;
    }

    static String kde_convertQStringAndFree(int qString) {
        int qCString = KDE.QString_utf8(qString);
        int charString = KDE.QCString_data(qCString);
        int length = KDE.strlen(charString);
        byte[] buffer = new byte[length];
        KDE.memmove(buffer, charString, length);
        String answer = new String(Converter.mbcsToWcs(null, buffer));
        KDE.QCString_delete(qCString);
        KDE.QString_delete(qString);
        return answer;
    }

    public static boolean launch(String fileName) {
        return Program.launch(Display.getCurrent(), fileName);
    }

    private static boolean launch(Display display, String fileName) {
        String extension;
        Program program;
        int index;
        if (fileName == null) {
            SWT.error(4);
        }
        if ((index = fileName.lastIndexOf(46)) > 0 && (program = Program.findProgram(display, extension = fileName.substring(index))) != null && program.execute(fileName)) {
            return true;
        }
        try {
            Compatibility.exec(fileName);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean execute(String fileName) {
        if (fileName == null) {
            SWT.error(4);
        }
        switch (Program.getDesktop(this.display)) {
            case 1: {
                String urlString = "file://" + fileName;
                byte[] buffer = Converter.wcsToMbcs(null, urlString, true);
                int qString = KDE.QString_new(buffer);
                int url = KDE.KURL_new(qString);
                KDE.QString_delete(qString);
                buffer = Converter.wcsToMbcs(null, this.name, true);
                int mimeTypeName = KDE.QString_new(buffer);
                int pid = KDE.KRun_runURL(url, mimeTypeName);
                KDE.KURL_delete(url);
                KDE.QString_delete(mimeTypeName);
                return pid != 0;
            }
            case 2: {
                if (this.gnomeExpectUri) {
                    fileName = "file://" + fileName;
                }
                String[] args = Program.parseCommand(this.command);
                int fileArg = -1;
                int index = 0;
                while (index < args.length) {
                    int j = args[index].indexOf("%f");
                    if (j != -1) {
                        String value = args[index];
                        fileArg = index;
                        args[index] = value.substring(0, j) + fileName + value.substring(j + 2);
                    }
                    ++index;
                }
                if (fileName.length() > 0 && fileArg < 0) {
                    String[] newArgs = new String[args.length + 1];
                    index = 0;
                    while (index < args.length) {
                        newArgs[index] = args[index];
                        ++index;
                    }
                    newArgs[args.length] = fileName;
                    args = newArgs;
                }
                try {
                    Compatibility.exec(args);
                }
                catch (IOException e) {
                    return false;
                }
                return true;
            }
            case 3: {
                byte[] action = Converter.wcsToMbcs(null, this.command, true);
                byte[] fileArg = Converter.wcsToMbcs(null, fileName, true);
                Integer shell = (Integer)this.display.getData(cdeShell);
                int actionID = 0;
                if (shell != null) {
                    actionID = CDE.DtActionInvoke(shell, action, fileArg, 1, null, null, null, 1, 0, 0);
                }
                return actionID != 0;
            }
        }
        return false;
    }

    public ImageData getImageData() {
        String iconPath = null;
        switch (Program.getDesktop(this.display)) {
            case 1: {
                byte[] buffer = Converter.wcsToMbcs(null, this.name, true);
                int mimeTypeName = KDE.QString_new(buffer);
                int mimeType = KDE.KMimeType_mimeType(mimeTypeName);
                KDE.QString_delete(mimeTypeName);
                if (mimeType == 0) {
                    return null;
                }
                int mimeIcon = KDE.KMimeType_icon(mimeType, 0, 0);
                int loader = KDE.KGlobal_iconLoader();
                int path = KDE.KIconLoader_iconPath(loader, mimeIcon, 0, 1);
                if (path == 0) {
                    return null;
                }
                iconPath = Program.kde_convertQStringAndFree(path);
                break;
            }
            case 2: {
                return null;
            }
            case 3: {
                return this.cde_getImageData();
            }
            case 0: {
                return null;
            }
        }
        if (iconPath.endsWith("xpm")) {
            int xDisplay = this.display.xDisplay;
            int screen = OS.XDefaultScreenOfDisplay(xDisplay);
            int fgPixel = OS.XWhitePixel(this.display.xDisplay, OS.XDefaultScreen(xDisplay));
            int bgPixel = OS.XBlackPixel(this.display.xDisplay, OS.XDefaultScreen(xDisplay));
            byte[] iconName = Converter.wcsToMbcs(null, iconPath, true);
            int pixmap = OS.XmGetPixmap(screen, iconName, fgPixel, bgPixel);
            if (pixmap == 2) {
                return null;
            }
            Image image = Image.motif_new(this.display, 0, pixmap, 0);
            ImageData imageData = image.getImageData();
            OS.XmDestroyPixmap(screen, pixmap);
            return imageData;
        }
        try {
            return new ImageData(iconPath);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Program) {
            Program program = (Program)other;
            return this.display == program.display && this.extension.equals(program.extension) && this.name.equals(program.name) && this.command.equals(program.command);
        }
        return false;
    }

    public int hashCode() {
        return this.extension.hashCode() ^ this.name.hashCode() ^ this.command.hashCode() ^ this.display.hashCode();
    }

    public String toString() {
        return "Program {" + this.name + "}";
    }

    static boolean gnome_init() {
        try {
            Library.loadLibrary("swt-gnome");
            return GNOME.gnome_vfs_init();
        }
        catch (Throwable e) {
            return false;
        }
    }

    static String cde_getAttribute(String dataType, String attrName) {
        byte[] optNameBuf;
        byte[] attrNameBuf;
        byte[] dataTypeBuf = Converter.wcsToMbcs(null, dataType, true);
        int attrValue = CDE.DtDtsDataTypeToAttributeValue(dataTypeBuf, attrNameBuf = Converter.wcsToMbcs(null, attrName, true), optNameBuf = null);
        if (attrValue == 0) {
            return null;
        }
        int length = OS.strlen(attrValue);
        byte[] attrValueBuf = new byte[length];
        OS.memmove(attrValueBuf, attrValue, length);
        CDE.DtDtsFreeAttributeValue(attrValue);
        return new String(Converter.mbcsToWcs(null, attrValueBuf));
    }

    static String cde_getAction(String dataType) {
        String action = null;
        String actions = Program.cde_getAttribute(dataType, "ACTIONS");
        if (actions != null) {
            int index = actions.indexOf("Open");
            action = index != -1 ? actions.substring(index, index + 4) : ((index = actions.indexOf(",")) != -1 ? actions.substring(0, index) : actions);
        }
        return action;
    }

    static String cde_getExtension(String dataType) {
        String fileExt = Program.cde_getAttribute(dataType, "NAME_TEMPLATE");
        if (fileExt == null || fileExt.indexOf("%s.") == -1) {
            return null;
        }
        int dot = fileExt.indexOf(".");
        return fileExt.substring(dot);
    }

    static Hashtable cde_getDataTypeInfo() {
        Hashtable dataTypeInfo = new Hashtable();
        int dataTypeList = CDE.DtDtsDataTypeNames();
        if (dataTypeList != 0) {
            int index = 0;
            int dataType = CDE.listElementAt(dataTypeList, index++);
            while (dataType != 0) {
                int length = OS.strlen(dataType);
                byte[] dataTypeBuf = new byte[length];
                OS.memmove(dataTypeBuf, dataType, length);
                String dataTypeName = new String(Converter.mbcsToWcs(null, dataTypeBuf));
                String extension = Program.cde_getExtension(dataTypeName);
                if (!CDE.DtDtsDataTypeIsAction(dataTypeBuf) && extension != null && Program.cde_getAction(dataTypeName) != null) {
                    Vector<String> exts = new Vector<String>();
                    exts.addElement(extension);
                    dataTypeInfo.put(dataTypeName, exts);
                }
                dataType = CDE.listElementAt(dataTypeList, index++);
            }
            CDE.DtDtsFreeDataTypeNames(dataTypeList);
        }
        return dataTypeInfo;
    }

    ImageData cde_getImageData() {
        int xDisplay = this.display.xDisplay;
        int screen = OS.XDefaultScreenOfDisplay(xDisplay);
        int fgPixel = OS.XWhitePixel(this.display.xDisplay, OS.XDefaultScreen(xDisplay));
        int bgPixel = OS.XBlackPixel(this.display.xDisplay, OS.XDefaultScreen(xDisplay));
        String icon = Program.cde_getAttribute(this.name, "ICON");
        byte[] maskName = null;
        int pixmap = 0;
        int index = 0;
        while (index < cdeIconExt.length && pixmap == 0) {
            byte[] iconName = Converter.wcsToMbcs(null, icon + cdeIconExt[index], true);
            maskName = Converter.wcsToMbcs(null, icon + cdeMaskExt[index], true);
            pixmap = OS.XmGetPixmap(screen, iconName, fgPixel, bgPixel);
            if (pixmap == 2) {
                pixmap = 0;
            }
            ++index;
        }
        if (pixmap != 0) {
            int type = 1;
            int mask = OS.XmGetPixmapByDepth(screen, maskName, 1, 0, 1);
            if (mask == 2) {
                type = 0;
                mask = 0;
            }
            Image image = Image.motif_new(this.display, type, pixmap, mask);
            ImageData imageData = image.getImageData();
            OS.XmDestroyPixmap(screen, pixmap);
            if (mask != 0) {
                OS.XmDestroyPixmap(screen, mask);
            }
            return imageData;
        }
        return null;
    }

    static boolean cde_init(Display display) {
        try {
            Library.loadLibrary("swt-cde");
        }
        catch (Throwable e) {
            return false;
        }
        byte[] appName = Converter.wcsToMbcs(null, "SWT", true);
        int xtContext = OS.XtDisplayToApplicationContext(display.xDisplay);
        int widgetClass = OS.TopLevelShellWidgetClass();
        int shell = OS.XtAppCreateShell(appName, appName, widgetClass, display.xDisplay, null, 0);
        boolean initOK = CDE.DtAppInitialize(xtContext, display.xDisplay, shell, appName, appName);
        if (!initOK) {
            OS.XtDestroyWidget(shell);
        } else {
            CDE.DtDbLoad();
            display.setData(cdeShell, new Integer(shell));
            display.disposeExec(new Runnable(){

                public void run() {
                    Integer shell = (Integer)Display.getCurrent().getData(Program.cdeShell);
                    if (shell != null) {
                        OS.XtDestroyWidget(shell);
                    }
                }
            });
        }
        return initOK;
    }
}

