/*
 * Decompiled with CFR 0.152.
 */
package org.argosdic.resource;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.Assert;

public class ResourceManager {
    public static final String RESOURCE_BUNDLE = "org.argosdic.resource.ApplicationResources";
    public static final String ACTION_PREFIX = "org.argosdic.action";
    private static ResourceManager instance;
    private ImageRegistry imageRegistry;
    private ResourceBundle bundle = ResourceBundle.getBundle("org.argosdic.resource.ApplicationResources");
    static /* synthetic */ Class class$0;

    private ResourceManager() {
        this.imageRegistry = new ImageRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResourceManager getInstance() {
        if (instance != null) return instance;
        Class<ResourceManager> clazz = ResourceManager.class;
        synchronized (ResourceManager.class) {
            instance = new ResourceManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String getString(String key) {
        Assert.isNotNull((Object)key);
        String value = null;
        try {
            value = this.bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return value;
    }

    public String getString(String key, Object[] args) {
        Assert.isNotNull((Object)key);
        String value = null;
        try {
            value = this.bundle.getString(key);
            value = MessageFormat.format(value, args);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return value;
    }

    public ImageDescriptor getImage(String key) {
        String path;
        ImageDescriptor image = this.imageRegistry.getDescriptor(key);
        if (image == null && (path = this.getString(key)) != null) {
            image = ImageDescriptor.createFromFile(ResourceManager.class, (String)path);
            this.imageRegistry.put(key, image);
        }
        return image;
    }

    public Collection getActionNames() {
        ArrayList<String> actions = new ArrayList<String>(20);
        Enumeration<String> e = this.bundle.getKeys();
        while (e.hasMoreElements()) {
            int index;
            String name = e.nextElement();
            if (!name.startsWith(ACTION_PREFIX) || actions.contains(name = name.substring(0, index = name.lastIndexOf("Action") + 6))) continue;
            actions.add(name);
        }
        return actions;
    }
}

