/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.bindings;

import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.util.Util;

public abstract class Binding {
    private static final int HASH_FACTOR = 89;
    private static final int HASH_INITIAL;
    public static final int SYSTEM = 0;
    public static final int USER = 1;
    private final String commandId;
    private final String contextId;
    private transient int hashCode;
    private transient boolean hashCodeComputed = false;
    private final String locale;
    private final String platform;
    private final String schemeId;
    protected transient String string = null;
    private final int type;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.bindings.Binding");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HASH_INITIAL = clazz.getName().hashCode();
    }

    protected Binding(String commandId, String schemeId, String contextId, String locale, String platform, String windowManager, int type) {
        if (commandId != null && commandId.length() < 1) {
            throw new IllegalArgumentException("Cannot bind to an empty command id");
        }
        if (schemeId == null) {
            throw new NullPointerException("The scheme cannot be null");
        }
        if (contextId == null) {
            throw new NullPointerException("The context cannot be null");
        }
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException("The type must be SYSTEM or USER");
        }
        this.commandId = commandId;
        this.schemeId = schemeId;
        this.contextId = contextId;
        this.locale = locale;
        this.platform = platform;
        this.type = type;
    }

    final boolean deletes(Binding binding) {
        boolean deletes = true;
        deletes &= Util.equals(this.getContextId(), binding.getContextId());
        deletes &= Util.equals(this.getTriggerSequence(), binding.getTriggerSequence());
        if (this.getLocale() != null) {
            deletes &= !Util.equals(this.getLocale(), binding.getLocale());
        }
        if (this.getPlatform() != null) {
            deletes &= !Util.equals(this.getPlatform(), binding.getPlatform());
        }
        deletes &= binding.getType() == 0;
        return deletes &= Util.equals(this.getCommandId(), null);
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Binding)) {
            return false;
        }
        Binding binding = (Binding)object;
        boolean equals = true;
        equals &= Util.equals(this.getCommandId(), binding.getCommandId());
        equals &= Util.equals(this.getContextId(), binding.getContextId());
        equals &= Util.equals(this.getTriggerSequence(), binding.getTriggerSequence());
        equals &= Util.equals(this.getLocale(), binding.getLocale());
        equals &= Util.equals(this.getPlatform(), binding.getPlatform());
        equals &= Util.equals(this.getSchemeId(), binding.getSchemeId());
        return equals &= this.getType() == binding.getType();
    }

    public final String getCommandId() {
        return this.commandId;
    }

    public final String getContextId() {
        return this.contextId;
    }

    public final String getLocale() {
        return this.locale;
    }

    public final String getPlatform() {
        return this.platform;
    }

    public final String getSchemeId() {
        return this.schemeId;
    }

    public abstract TriggerSequence getTriggerSequence();

    public final int getType() {
        return this.type;
    }

    public final int hashCode() {
        if (!this.hashCodeComputed) {
            this.hashCode = HASH_INITIAL;
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.getCommandId());
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.getContextId());
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.getTriggerSequence());
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.getLocale());
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.getPlatform());
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.getSchemeId());
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.getType());
            this.hashCodeComputed = true;
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Binding(");
            stringBuffer.append(this.getTriggerSequence());
            stringBuffer.append(',');
            stringBuffer.append(this.commandId);
            stringBuffer.append(',');
            stringBuffer.append(this.schemeId);
            stringBuffer.append(',');
            stringBuffer.append(this.contextId);
            stringBuffer.append(',');
            stringBuffer.append(this.locale);
            stringBuffer.append(',');
            stringBuffer.append(this.platform);
            stringBuffer.append(',');
            stringBuffer.append(this.type == 0 ? "system" : "user");
            stringBuffer.append(')');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }
}

