/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.bindings.keys;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.bindings.keys.formatting.KeyFormatterFactory;
import org.eclipse.jface.util.Util;

public final class KeySequence
extends TriggerSequence
implements Comparable {
    private static final KeySequence EMPTY_KEY_SEQUENCE = new KeySequence(Collections.EMPTY_LIST);
    public static final String KEY_STROKE_DELIMITER = Character.toString(' ');
    public static final String KEY_STROKE_DELIMITERS = String.valueOf(KEY_STROKE_DELIMITER) + "\b\r\u007f\u001b\f\n\u0000\t\u000b";

    public static final KeySequence getInstance() {
        return EMPTY_KEY_SEQUENCE;
    }

    public static final KeySequence getInstance(KeySequence keySequence, KeyStroke keyStroke) {
        if (keySequence == null || keyStroke == null) {
            throw new NullPointerException();
        }
        ArrayList<KeyStroke> keyStrokes = new ArrayList<KeyStroke>(keySequence.getKeyStrokes());
        keyStrokes.add(keyStroke);
        return new KeySequence(keyStrokes);
    }

    public static final KeySequence getInstance(KeyStroke keyStroke) {
        return new KeySequence(Collections.singletonList(keyStroke));
    }

    public static final KeySequence getInstance(KeyStroke[] keyStrokes) {
        return new KeySequence(Arrays.asList(keyStrokes));
    }

    public static final KeySequence getInstance(List keyStrokes) {
        return new KeySequence(keyStrokes);
    }

    public static final KeySequence getInstance(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException();
        }
        ArrayList<KeyStroke> keyStrokes = new ArrayList<KeyStroke>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, KEY_STROKE_DELIMITERS);
        while (stringTokenizer.hasMoreTokens()) {
            keyStrokes.add(KeyStroke.getInstance(stringTokenizer.nextToken()));
        }
        try {
            return new KeySequence(keyStrokes);
        }
        catch (Throwable throwable) {
            throw new ParseException("Could not construct key sequence with these key strokes: " + keyStrokes);
        }
    }

    protected KeySequence(List keyStrokes) {
        super(keyStrokes);
        int i = 0;
        while (i < this.triggers.size() - 1) {
            KeyStroke keyStroke = (KeyStroke)this.triggers.get(i);
            if (!keyStroke.isComplete()) {
                throw new IllegalArgumentException();
            }
            ++i;
        }
    }

    public final int compareTo(Object object) {
        KeySequence castedObject = (KeySequence)object;
        return Util.compare(this.triggers, castedObject.triggers);
    }

    public final String format() {
        return KeyFormatterFactory.getDefault().format(this);
    }

    public final List getKeyStrokes() {
        return this.getTriggers();
    }

    public List getPrefixes() {
        ArrayList prefixTriggers = new ArrayList();
        ArrayList<KeySequence> prefixes = new ArrayList<KeySequence>();
        int numberOfPrefixes = this.triggers.size() - 1;
        prefixes.add(KeySequence.getInstance());
        int i = 0;
        while (i < numberOfPrefixes) {
            prefixTriggers.add(this.triggers.get(i));
            prefixes.add(KeySequence.getInstance(prefixTriggers));
            ++i;
        }
        return prefixes;
    }

    public final boolean isComplete() {
        return this.triggers.isEmpty() || ((KeyStroke)this.triggers.get(this.triggers.size() - 1)).isComplete();
    }

    public final String toString() {
        return KeyFormatterFactory.getFormalKeyFormatter().format(this);
    }
}

