/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osgi.framework.internal.core.Constants;
import org.eclipse.osgi.framework.internal.core.KeyedElement;
import org.eclipse.osgi.internal.resolver.BaseDescriptionImpl;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.internal.resolver.ImportPackageSpecificationImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.State;

public class BundleDescriptionImpl
extends BaseDescriptionImpl
implements BundleDescription,
KeyedElement {
    static final byte RESOLVED = 1;
    static final byte SINGLETON = 2;
    static final byte REMOVAL_PENDING = 4;
    static final byte FULLY_LOADED = 8;
    static final byte LAZY_LOADED = 16;
    static final byte HAS_DYNAMICIMPORT = 32;
    private byte stateBits = (byte)8;
    private long bundleId = -1L;
    private HostSpecification host;
    private StateImpl containingState;
    private Object userObject;
    private int lazyDataSize = -1;
    private ArrayList dependencies;
    private ArrayList dependents;
    private LazyData lazyData;
    private long lazyTimeStamp;

    public long getBundleId() {
        return this.bundleId;
    }

    public String getSymbolicName() {
        return this.getName();
    }

    public String getLocation() {
        this.fullyLoad();
        return this.lazyData.location;
    }

    public String getPlatformFilter() {
        this.fullyLoad();
        return this.lazyData.platformFilter;
    }

    public ImportPackageSpecification[] getImportPackages() {
        this.fullyLoad();
        if (this.lazyData.importPackages == null) {
            return new ImportPackageSpecification[0];
        }
        return this.lazyData.importPackages;
    }

    public BundleSpecification[] getRequiredBundles() {
        this.fullyLoad();
        if (this.lazyData.requiredBundles == null) {
            return new BundleSpecification[0];
        }
        return this.lazyData.requiredBundles;
    }

    public ExportPackageDescription[] getExportPackages() {
        this.fullyLoad();
        if (this.lazyData.exportPackages == null) {
            return new ExportPackageDescription[0];
        }
        return this.lazyData.exportPackages;
    }

    public boolean isResolved() {
        return (this.stateBits & 1) != 0;
    }

    public State getContainingState() {
        return this.containingState;
    }

    public BundleDescription[] getFragments() {
        if (this.host != null) {
            return new BundleDescription[0];
        }
        return this.containingState.getFragments(this);
    }

    public HostSpecification getHost() {
        return this.host;
    }

    public boolean isSingleton() {
        return (this.stateBits & 2) != 0;
    }

    public boolean isRemovalPending() {
        return (this.stateBits & 4) != 0;
    }

    public boolean hasDynamicImports() {
        return (this.stateBits & 0x20) != 0;
    }

    public ExportPackageDescription[] getSelectedExports() {
        this.fullyLoad();
        if (this.lazyData.selectedExports == null) {
            return new ExportPackageDescription[0];
        }
        return this.lazyData.selectedExports;
    }

    public BundleDescription[] getResolvedRequires() {
        this.fullyLoad();
        if (this.lazyData.resolvedRequires == null) {
            return new BundleDescription[0];
        }
        return this.lazyData.resolvedRequires;
    }

    public ExportPackageDescription[] getResolvedImports() {
        this.fullyLoad();
        if (this.lazyData.resolvedImports == null) {
            return new ExportPackageDescription[0];
        }
        return this.lazyData.resolvedImports;
    }

    protected void setBundleId(long bundleId) {
        this.bundleId = bundleId;
    }

    protected void setSymbolicName(String symbolicName) {
        this.setName(symbolicName);
    }

    protected void setLocation(String location) {
        this.checkLazyData();
        this.lazyData.location = location;
    }

    protected void setPlatformFilter(String platformFilter) {
        this.checkLazyData();
        this.lazyData.platformFilter = platformFilter;
    }

    protected void setExportPackages(ExportPackageDescription[] exportPackages) {
        this.checkLazyData();
        this.lazyData.exportPackages = exportPackages;
        if (exportPackages != null) {
            int i = 0;
            while (i < exportPackages.length) {
                ((ExportPackageDescriptionImpl)exportPackages[i]).setExporter(this);
                ++i;
            }
        }
    }

    protected void setImportPackages(ImportPackageSpecification[] importPackages) {
        this.checkLazyData();
        this.lazyData.importPackages = importPackages;
        if (importPackages != null) {
            int i = 0;
            while (i < importPackages.length) {
                if ("system.bundle".equals(importPackages[i].getBundleSymbolicName())) {
                    ((ImportPackageSpecificationImpl)importPackages[i]).setBundleSymbolicName(Constants.getInternalSymbolicName());
                }
                ((ImportPackageSpecificationImpl)importPackages[i]).setBundle(this);
                if ((importPackages[i].getResolution() & 4) != 0) {
                    this.stateBits = (byte)(this.stateBits | 0x20);
                }
                ++i;
            }
        }
    }

    protected void setRequiredBundles(BundleSpecification[] requiredBundles) {
        this.checkLazyData();
        this.lazyData.requiredBundles = requiredBundles;
        if (requiredBundles != null) {
            int i = 0;
            while (i < requiredBundles.length) {
                if ("system.bundle".equals(requiredBundles[i].getName())) {
                    ((VersionConstraintImpl)((Object)requiredBundles[i])).setName(Constants.getInternalSymbolicName());
                }
                ((VersionConstraintImpl)((Object)requiredBundles[i])).setBundle(this);
                ++i;
            }
        }
    }

    protected byte getStateBits() {
        return this.stateBits;
    }

    protected void setStateBit(byte stateBit, boolean on) {
        this.stateBits = on ? (byte)(this.stateBits | stateBit) : (byte)(this.stateBits & ~stateBit);
    }

    protected void setContainingState(State value) {
        this.containingState = (StateImpl)value;
        this.stateBits = this.containingState != null && this.containingState.getReader() != null ? (this.containingState.getReader().isLazyLoaded() ? (byte)(this.stateBits | 0x10) : (byte)(this.stateBits & 0xFFFFFFEF)) : (byte)(this.stateBits & 0xFFFFFFEF);
    }

    protected void setHost(HostSpecification host) {
        this.host = host;
        if (host != null) {
            if ("system.bundle".equals(host.getName())) {
                ((VersionConstraintImpl)((Object)host)).setName(Constants.getInternalSymbolicName());
            }
            ((VersionConstraintImpl)((Object)host)).setBundle(this);
        }
    }

    protected void setLazyLoaded(boolean lazyLoad) {
        this.fullyLoad();
        this.stateBits = lazyLoad ? (byte)(this.stateBits | 0x10) : (byte)(this.stateBits & 0xFFFFFFEF);
    }

    protected void setSelectedExports(ExportPackageDescription[] selectedExports) {
        this.checkLazyData();
        this.lazyData.selectedExports = selectedExports;
        if (selectedExports != null) {
            int i = 0;
            while (i < selectedExports.length) {
                ((ExportPackageDescriptionImpl)selectedExports[i]).setExporter(this);
                ++i;
            }
        }
    }

    protected void setResolvedImports(ExportPackageDescription[] resolvedImports) {
        this.checkLazyData();
        this.lazyData.resolvedImports = resolvedImports;
    }

    protected void setResolvedRequires(BundleDescription[] resolvedRequires) {
        this.checkLazyData();
        this.lazyData.resolvedRequires = resolvedRequires;
    }

    public String toString() {
        if (this.getSymbolicName() == null) {
            return "[" + this.getBundleId() + "]";
        }
        return String.valueOf(this.getSymbolicName()) + "_" + this.getVersion();
    }

    public Object getKey() {
        return new Long(this.bundleId);
    }

    public boolean compare(KeyedElement other) {
        if (!(other instanceof BundleDescriptionImpl)) {
            return false;
        }
        BundleDescriptionImpl otherBundleDescription = (BundleDescriptionImpl)other;
        return this.bundleId == otherBundleDescription.bundleId;
    }

    public int getKeyHashCode() {
        return (int)(this.bundleId % Integer.MAX_VALUE);
    }

    protected synchronized void removeDependencies() {
        if (this.dependencies == null) {
            return;
        }
        Iterator iter = this.dependencies.iterator();
        while (iter.hasNext()) {
            ((BundleDescriptionImpl)iter.next()).removeDependent(this);
        }
        this.dependencies = null;
    }

    protected void addDependencies(BaseDescription[] newDependencies) {
        if (newDependencies == null) {
            return;
        }
        int i = 0;
        while (i < newDependencies.length) {
            this.addDependency((BaseDescriptionImpl)newDependencies[i]);
            ++i;
        }
    }

    protected synchronized void addDependency(BaseDescriptionImpl dependency) {
        BundleDescriptionImpl bundle;
        if (this.dependencies == null) {
            this.dependencies = new ArrayList(10);
        }
        if (!this.dependencies.contains(bundle = dependency instanceof ExportPackageDescription ? (BundleDescriptionImpl)((ExportPackageDescription)((Object)dependency)).getExporter() : (BundleDescriptionImpl)dependency)) {
            bundle.addDependent(this);
            this.dependencies.add(bundle);
        }
    }

    synchronized List getBundleDependencies() {
        if (this.dependencies == null) {
            return new ArrayList(0);
        }
        ArrayList required = new ArrayList(this.dependencies.size());
        Iterator iter = this.dependencies.iterator();
        while (iter.hasNext()) {
            Object dep = iter.next();
            if (dep == this || !(dep instanceof BundleDescription) || ((BundleDescription)dep).getHost() != null) continue;
            required.add(dep);
        }
        return required;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    protected synchronized void addDependent(BundleDescription dependent) {
        if (this.dependents == null) {
            this.dependents = new ArrayList(10);
        }
        if (!this.dependents.contains(dependent)) {
            this.dependents.add(dependent);
        }
    }

    protected synchronized void removeDependent(BundleDescription dependent) {
        if (this.dependents == null) {
            return;
        }
        this.dependents.remove(dependent);
    }

    public synchronized BundleDescription[] getDependents() {
        if (this.dependents == null) {
            return new BundleDescription[0];
        }
        return this.dependents.toArray(new BundleDescription[this.dependents.size()]);
    }

    void setFullyLoaded(boolean fullyLoaded) {
        if (fullyLoaded) {
            this.stateBits = (byte)(this.stateBits | 8);
            this.lazyTimeStamp = System.currentTimeMillis();
        } else {
            this.stateBits = (byte)(this.stateBits & 0xFFFFFFF7);
        }
    }

    boolean isFullyLoaded() {
        return (this.stateBits & 8) != 0;
    }

    void setLazyDataSize(int lazyDataSize) {
        this.lazyDataSize = lazyDataSize;
    }

    int getLazyDataSize() {
        return this.lazyDataSize;
    }

    private void fullyLoad() {
        if ((this.stateBits & 0x10) == 0) {
            return;
        }
        if (this.isFullyLoaded()) {
            return;
        }
        try {
            this.containingState.getReader().fullyLoad(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    synchronized void addDynamicResolvedImport(ExportPackageDescriptionImpl result) {
        this.addDependency(result);
        this.checkLazyData();
        if (this.lazyData.resolvedImports == null) {
            this.lazyData.resolvedImports = new ExportPackageDescription[]{result};
            return;
        }
        ExportPackageDescription[] newImports = new ExportPackageDescription[this.lazyData.resolvedImports.length + 1];
        System.arraycopy(this.lazyData.resolvedImports, 0, newImports, 0, this.lazyData.resolvedImports.length);
        newImports[newImports.length - 1] = result;
        this.lazyData.resolvedImports = newImports;
    }

    synchronized void unload(long currentTime, long expireTime) {
        if ((this.stateBits & 0x10) == 0) {
            return;
        }
        if (!this.isFullyLoaded() || currentTime - this.lazyTimeStamp - expireTime <= 0L) {
            return;
        }
        this.setFullyLoaded(false);
        this.lazyData = null;
    }

    private void checkLazyData() {
        if (this.lazyData == null) {
            this.lazyData = new LazyData();
        }
    }

    private final class LazyData {
        String location;
        String platformFilter;
        BundleSpecification[] requiredBundles;
        ExportPackageDescription[] exportPackages;
        ImportPackageSpecification[] importPackages;
        ExportPackageDescription[] selectedExports;
        BundleDescription[] resolvedRequires;
        ExportPackageDescription[] resolvedImports;

        LazyData() {
        }
    }
}

