/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.profile;

import java.io.File;
import org.eclipse.osgi.framework.debug.DebugOptions;
import org.eclipse.osgi.profile.ProfileLogger;

public class DefaultProfileLogger
implements ProfileLogger {
    private static final String DEFAULTPROFILE_PROP = "osgi.defaultprofile.";
    private static final String PROP_FILENAME = "osgi.defaultprofile.logfilename";
    private static final String PROP_LOGSYNCHRONOUSLY = "osgi.defaultprofile.logsynchronously";
    private static final String PROP_BUFFERSIZE = "osgi.defaultprofile.buffersize";
    private static final String DEFAULTPROFILE_OPTION = "org.eclipse.osgi/defaultprofile/";
    private static final String OPTION_FILENAME = "org.eclipse.osgi/defaultprofile/logfilename";
    private static final String OPTION_LOGSYNCHRONOUSLY = "org.eclipse.osgi/defaultprofile/logsynchronously";
    private static final String OPTION_BUFFERSIZE = "org.eclipse.osgi/defaultprofile/buffersize";
    protected boolean logSynchronously = false;
    protected long startTime = 0L;
    protected static final int DEFAULT_BUFFER_SIZE = 256;
    protected String launchTimeString = null;
    protected long launchTime = 0L;
    protected TimeEntry[] timeLogEntries = null;
    protected int timeEntriesIndex = 0;
    protected StringBuffer timelog = null;
    private int bufferSize = 256;
    private String logFileName = null;
    private File logFile = null;
    private StringBuffer entryReport = new StringBuffer(120);
    private StringBuffer padsb = new StringBuffer(16);
    private int indent;

    DefaultProfileLogger() {
        this.initProps();
        int size = this.getBufferSize();
        this.timeLogEntries = new TimeEntry[size];
        this.timelog = new StringBuffer(4096);
        int i = 0;
        while (i < size) {
            this.timeLogEntries[i] = this.timeEntryFactory();
            ++i;
        }
        this.timeEntriesIndex = 0;
        String timeString = System.getProperty("eclipse.startTime");
        this.startTime = timeString != null ? Long.parseLong(timeString) : System.currentTimeMillis();
        int index = 0;
        long mainTime = this.startTime;
        this.launchTimeString = System.getProperty("launch.startMillis");
        if (this.launchTimeString != null) {
            this.startTime = Long.parseLong(this.launchTimeString);
            this.logTime(0, "DefaultProfileLogger.init()", "launch time initialized", null);
            this.timeLogEntries[index++].time = this.getStartTime();
        }
        this.logTime(0, "DefaultProfileLogger.init()", "start time initialized", null);
        this.timeLogEntries[index++].time = mainTime;
    }

    public void initProps() {
        String prop;
        DebugOptions dbgOptions = null;
        if (System.getProperty("osgi.debug") != null && (dbgOptions = DebugOptions.getDefault()) != null) {
            this.logFileName = dbgOptions.getOption(OPTION_FILENAME);
            this.logSynchronously = dbgOptions.getBooleanOption(OPTION_LOGSYNCHRONOUSLY, false);
            int size = dbgOptions.getIntegerOption(OPTION_BUFFERSIZE, 0);
            if (size > 0) {
                this.bufferSize = size;
            }
        }
        if ((prop = System.getProperty(PROP_FILENAME)) != null) {
            this.logFileName = prop;
            if (dbgOptions != null) {
                dbgOptions.setOption(OPTION_FILENAME, this.logFileName);
            }
        }
        if ((prop = System.getProperty(PROP_LOGSYNCHRONOUSLY)) != null) {
            this.logSynchronously = Boolean.valueOf(prop);
            if (dbgOptions != null) {
                dbgOptions.setOption(OPTION_LOGSYNCHRONOUSLY, new Boolean(this.logSynchronously).toString());
            }
        }
        if ((prop = System.getProperty(PROP_BUFFERSIZE)) != null) {
            try {
                int value = Integer.parseInt(prop);
                if (value > 0) {
                    this.bufferSize = value;
                    if (dbgOptions != null) {
                        dbgOptions.setOption(OPTION_BUFFERSIZE, Integer.toString(this.bufferSize));
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public synchronized void logTime(int flag, String id, String msg, String description) {
        if (this.timeEntriesIndex == this.timeLogEntries.length) {
            this.makeLog();
            this.logTime(0, "Profile.logTime()", "log entries rolled", null);
        }
        TimeEntry entry = this.timeLogEntries[this.timeEntriesIndex++];
        entry.time = this.getTime();
        entry.id = id;
        entry.msg = msg;
        entry.flag = flag;
        entry.description = description;
        if (this.logSynchronously) {
            System.out.print(this.getProfileLog().substring(2));
        }
    }

    public synchronized String getProfileLog() {
        String log = this.getProfileLogReport();
        this.writeToProfileLogFile(log);
        return log;
    }

    protected long getTime() {
        return System.currentTimeMillis();
    }

    protected TimeEntry findCompareEntry(int index, String id, int flag) {
        if (index > 0) {
            --index;
        }
        int prev = index;
        if (flag != 1) {
            while (index >= 0) {
                TimeEntry entry = this.timeLogEntries[index];
                if (entry.id.equals(id)) {
                    switch (flag) {
                        case 0: {
                            return entry;
                        }
                        case 2: {
                            if (entry.flag != 1) break;
                            return entry;
                        }
                    }
                }
                --index;
            }
        }
        return this.timeLogEntries[prev];
    }

    protected String entryReport(TimeEntry entry, TimeEntry compareWith) {
        this.entryReport.setLength(0);
        if (entry.flag == 1) {
            ++this.indent;
        }
        long zeroTime = this.getRelativeTime(this.getStartTime());
        this.entryReport.append('-');
        long entryTime = this.getRelativeTime(entry.time);
        long diff = entryTime - zeroTime;
        this.entryReport.append(this.pad(Long.toString(diff), 6));
        this.entryReport.append(" : ");
        diff = entry.time - compareWith.time;
        this.entryReport.append(this.pad(Long.toString(diff), 5));
        this.entryReport.append(this.pad("", this.indent * 2));
        this.entryReport.append("  - ");
        this.entryReport.append(entry.id);
        this.entryReport.append(" > ");
        this.entryReport.append(entry.msg);
        if (entry.description != null) {
            this.entryReport.append(" :: ");
            this.entryReport.append(entry.description);
        }
        this.entryReport.append("\r\n");
        if (entry.flag == 2) {
            --this.indent;
        }
        return this.entryReport.toString();
    }

    protected void makeLog() {
        this.indent = 0;
        this.timelog.append("\r\n");
        int i = 0;
        while (i < this.timeEntriesIndex) {
            TimeEntry entry = this.timeLogEntries[i];
            TimeEntry cmpEntry = this.findCompareEntry(i, entry.id, entry.flag);
            this.timelog.append(this.entryReport(entry, cmpEntry));
            ++i;
        }
        this.timeEntriesIndex = 0;
    }

    protected String pad(String str, int size) {
        this.padsb.setLength(0);
        int len = str.length();
        int count = size - len;
        int i = 0;
        while (i < count) {
            this.padsb.append(' ');
            ++i;
        }
        this.padsb.append(str);
        return this.padsb.toString();
    }

    protected String getProfileLogReport() {
        if (this.timelog == null) {
            return "";
        }
        this.makeLog();
        String log = this.timelog.toString();
        this.timelog.setLength(0);
        return log;
    }

    /*
     * Exception decompiling
     */
    protected void writeToProfileLogFile(String log) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 67->71)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected File getProfileLogFile() {
        if (this.logFile == null && this.logFileName != null && this.logFileName.length() > 0) {
            this.logFile = new File(this.logFileName);
        }
        return this.logFile;
    }

    protected long getStartTime() {
        return this.startTime;
    }

    protected long getRelativeTime(long absoluteTime) {
        return absoluteTime;
    }

    protected int getBufferSize() {
        if (this.bufferSize < 2) {
            return 256;
        }
        return this.bufferSize;
    }

    protected TimeEntry timeEntryFactory() {
        return new TimeEntry();
    }

    protected class TimeEntry {
        long time;
        String id;
        String msg;
        String description;
        int flag;

        protected TimeEntry() {
        }
    }
}

