package org.argosdic.speech;

import org.eclipse.jface.util.Assert;

import com.sun.speech.freetts.Voice;
import com.sun.speech.freetts.VoiceManager;

/**
 * SpeechManager.java
 * 
 * @author Xavier Cho
 * @version $Revision: 1.3 $ $Date: 2005/03/13 09:10:16 $
 */
public class SpeechManager {

    private Voice voice;
    private static SpeechManager instance;

    private SpeechManager() {
        VoiceManager manager = VoiceManager.getInstance();
        this.voice = manager.getVoice("kevin16");
        voice.allocate();
    }

    public static SpeechManager getInstance() {
        if (instance == null) {
            synchronized (SpeechManager.class) {
                instance = new SpeechManager();
            }
        }
        return instance;
    }

    public void dispose() {
        if (voice != null) {
            voice.deallocate();
        }
    }

    public void speak(String sentence) {
        Assert.isNotNull(sentence);
        voice.speak(sentence);
    }
}