/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import org.eclipse.core.internal.jobs.LockManager;
import org.eclipse.core.internal.jobs.Queue;
import org.eclipse.core.internal.jobs.Semaphore;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.runtime.jobs.ILock;

public class OrderedLock
implements ILock {
    private static final boolean DEBUG = false;
    private static int nextLockNumber = 0;
    private Thread currentOperationThread;
    private int depth;
    private final LockManager manager;
    private final int number;
    private final Queue operations = new Queue();

    protected OrderedLock(LockManager manager) {
        this.manager = manager;
        this.number = nextLockNumber++;
    }

    public void acquire() {
        while (true) {
            try {
                if (!this.acquire(Long.MAX_VALUE)) continue;
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public boolean acquire(long delay) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        boolean success = true;
        if (delay <= 0L) {
            success = this.attempt();
        } else {
            Semaphore semaphore = this.createSemaphore();
            if (semaphore != null) {
                LockManager.LockState[] oldLocks = this.manager.suspendGreaterLocks(this);
                success = this.doAcquire(semaphore, delay);
                if (oldLocks != null) {
                    int i = 0;
                    while (i < oldLocks.length) {
                        oldLocks[i].resume();
                        ++i;
                    }
                }
            }
        }
        if (success) {
            ++this.depth;
        }
        return success;
    }

    protected synchronized boolean attempt() {
        if (this.currentOperationThread == Thread.currentThread()) {
            return true;
        }
        if (this.currentOperationThread == null && this.operations.isEmpty()) {
            this.setCurrentOperationThread(Thread.currentThread());
            return true;
        }
        return false;
    }

    protected synchronized Semaphore createSemaphore() {
        return this.attempt() ? null : this.enqueue(new Semaphore(Thread.currentThread()));
    }

    protected boolean doAcquire(Semaphore semaphore, long delay) throws InterruptedException {
        if (semaphore != null) {
            boolean success = false;
            if (this.manager.aboutToWait(this.getCurrentOperationThread())) {
                this.operations.dequeue();
                return true;
            }
            success = semaphore.acquire(delay);
            this.updateCurrentOperation();
            return success;
        }
        return true;
    }

    protected synchronized int doRelease() {
        this.manager.aboutToRelease();
        int oldDepth = this.depth;
        this.depth = 0;
        Semaphore next = (Semaphore)this.operations.peek();
        this.setCurrentOperationThread(null);
        if (next != null) {
            next.release();
        }
        return oldDepth;
    }

    private synchronized Semaphore enqueue(Semaphore newSemaphore) {
        Semaphore semaphore = (Semaphore)this.operations.get(newSemaphore);
        if (semaphore == null) {
            this.operations.enqueue(newSemaphore);
            return newSemaphore;
        }
        return semaphore;
    }

    public Thread getCurrentOperationThread() {
        return this.currentOperationThread;
    }

    public synchronized int getDepth() {
        return this.depth;
    }

    public synchronized void release() {
        if (this.depth == 0) {
            return;
        }
        Assert.isTrue(this.depth >= 0, "Lock released too many times");
        if (--this.depth == 0) {
            this.doRelease();
        }
    }

    private void setCurrentOperationThread(Thread newThread) {
        if (this.currentOperationThread != null) {
            this.manager.removeLockThread(this.currentOperationThread);
        }
        this.currentOperationThread = newThread;
        if (this.currentOperationThread != null) {
            this.manager.addLockThread(this.currentOperationThread);
        }
    }

    protected void setDepth(int newDepth) {
        this.depth = newDepth;
    }

    public String toString() {
        return "OrderedLock(" + this.number + ")";
    }

    private synchronized void updateCurrentOperation() {
        this.operations.dequeue();
        this.setCurrentOperationThread(Thread.currentThread());
    }
}

