/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import java.util.AbstractCollection;
import java.util.ArrayList;
import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.jobs.Worker;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;

class WorkerPool {
    private static final int MIN_THREADS = 1;
    private static final int MAX_THREADS = 10;
    private boolean running = false;
    private ArrayList threads = new ArrayList();
    private int sleepingThreads = 0;
    private int busyThreads = 0;
    private static final int BEST_BEFORE = 60000;
    private JobManager manager;

    protected WorkerPool(JobManager manager) {
        this.manager = manager;
        this.running = true;
    }

    protected synchronized void endJob(Job job, IStatus result) {
        --this.busyThreads;
        this.manager.endJob(job, result);
        this.manager.getLockManager().removeAllLocks(Thread.currentThread());
    }

    protected synchronized void endWorker(Worker worker) {
        ((AbstractCollection)this.threads).remove(worker);
        if (JobManager.DEBUG) {
            JobManager.debug("worker removed from pool: " + worker);
        }
    }

    protected synchronized void jobQueued(InternalJob job) {
        if (this.sleepingThreads > 0) {
            if (JobManager.DEBUG) {
                JobManager.debug("notifiying a worker");
            }
            this.notify();
            return;
        }
        this.threads.size();
        Worker worker = new Worker(this);
        this.threads.add(worker);
        if (JobManager.DEBUG) {
            JobManager.debug("worker added to pool: " + worker);
        }
        worker.start();
    }

    protected synchronized void shutdown() {
        this.running = false;
        this.notifyAll();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void sleep(long duration) {
        ++this.sleepingThreads;
        if (JobManager.DEBUG) {
            JobManager.debug("worker sleeping for: " + duration + "ms");
        }
        try {
            try {
                this.wait(duration);
            }
            catch (InterruptedException interruptedException) {
                if (JobManager.DEBUG) {
                    JobManager.debug("worker interrupted while waiting... :-|");
                }
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            --this.sleepingThreads;
            throw throwable;
        }
        {
            Object var3_4 = null;
            --this.sleepingThreads;
            return;
        }
    }

    protected synchronized Job startJob() {
        if (!this.running || this.threads.size() > 10) {
            return null;
        }
        Job job = this.manager.startJob();
        long idleStart = System.currentTimeMillis();
        while (this.running && job == null) {
            long hint = this.manager.sleepHint();
            if (hint > 0L) {
                this.sleep(Math.min(hint, 60000L));
            }
            if ((job = this.manager.startJob()) == null && System.currentTimeMillis() - idleStart > 60000L && this.threads.size() > 1) break;
        }
        if (job != null) {
            ++this.busyThreads;
            if (job.getRule() != null) {
                this.manager.getLockManager().addLockThread(Thread.currentThread());
            }
            if (this.manager.sleepHint() <= 0L) {
                this.jobQueued(null);
            }
        }
        return job;
    }
}

