/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.model.Factory;
import org.eclipse.core.runtime.model.PluginRegistryModel;

public final class Platform {
    public static final String PI_RUNTIME = "org.eclipse.core.runtime";
    public static final String PT_APPLICATIONS = "applications";
    public static final String OPTION_STARTTIME = "org.eclipse.core.runtime/starttime";
    public static final int PARSE_PROBLEM = 1;
    public static final int PLUGIN_ERROR = 2;
    public static final int INTERNAL_ERROR = 3;
    public static final int FAILED_READ_METADATA = 4;
    public static final int FAILED_WRITE_METADATA = 5;
    public static final int FAILED_DELETE_METADATA = 6;

    private Platform() {
    }

    public static void addAuthorizationInfo(URL serverUrl, String realm, String authScheme, Map info) throws CoreException {
        InternalPlatform.addAuthorizationInfo(serverUrl, realm, authScheme, info);
    }

    public static void addLogListener(ILogListener listener) {
        InternalPlatform.addLogListener(listener);
    }

    public static void addProtectionSpace(URL resourceUrl, String realm) throws CoreException {
        InternalPlatform.addProtectionSpace(resourceUrl, realm);
    }

    public static URL asLocalURL(URL url) throws IOException {
        return InternalPlatform.asLocalURL(url);
    }

    public static void endSplash() {
        InternalPlatform.endSplash();
    }

    public static void flushAuthorizationInfo(URL serverUrl, String realm, String authScheme) throws CoreException {
        InternalPlatform.flushAuthorizationInfo(serverUrl, realm, authScheme);
    }

    public static IAdapterManager getAdapterManager() {
        return InternalPlatform.getAdapterManager();
    }

    public static Map getAuthorizationInfo(URL serverUrl, String realm, String authScheme) {
        return InternalPlatform.getAuthorizationInfo(serverUrl, realm, authScheme);
    }

    public static String[] getCommandLineArgs() {
        return BootLoader.getCommandLineArgs();
    }

    public static String getDebugOption(String option) {
        return InternalPlatform.getDebugOption(option);
    }

    public static IJobManager getJobManager() {
        return InternalPlatform.getJobManager();
    }

    public static IPath getLocation() {
        return InternalPlatform.getLocation();
    }

    public static IPath getLogFileLocation() {
        return InternalPlatform.getMetaArea().getLogLocation();
    }

    public static Plugin getPlugin(String id) {
        return InternalPlatform.getPlugin(id);
    }

    public static IPluginRegistry getPluginRegistry() {
        return InternalPlatform.getPluginRegistry();
    }

    public static IPath getPluginStateLocation(Plugin plugin) {
        return InternalPlatform.getPluginStateLocation(plugin.getDescriptor(), true);
    }

    public static String getProtectionSpace(URL resourceUrl) {
        return InternalPlatform.getProtectionSpace(resourceUrl);
    }

    public static PluginRegistryModel parsePlugins(URL[] pluginPath, Factory factory) {
        return InternalPlatform.parsePlugins(pluginPath, factory);
    }

    public static void removeLogListener(ILogListener listener) {
        InternalPlatform.removeLogListener(listener);
    }

    public static URL resolve(URL url) throws IOException {
        return InternalPlatform.resolve(url);
    }

    public static void run(ISafeRunnable runnable) {
        InternalPlatform.run(runnable);
    }
}

