/*
 * Decompiled with CFR 0.152.
 */
package javax.speech.recognition;

import javax.speech.SpeechEvent;
import javax.speech.recognition.Grammar;
import javax.speech.recognition.GrammarException;

public class GrammarEvent
extends SpeechEvent {
    public static final int GRAMMAR_CHANGES_COMMITTED = 200;
    public static final int GRAMMAR_ACTIVATED = 201;
    public static final int GRAMMAR_DEACTIVATED = 202;
    protected boolean enabledChanged;
    protected boolean definitionChanged;
    protected GrammarException grammarException;

    public GrammarEvent(Grammar grammar, int n) {
        super(grammar, n);
        this.enabledChanged = false;
        this.definitionChanged = false;
        this.grammarException = null;
    }

    public GrammarEvent(Grammar grammar, int n, boolean bl, boolean bl2, GrammarException grammarException) {
        super(grammar, n);
        this.enabledChanged = bl;
        this.definitionChanged = bl2;
        this.grammarException = grammarException;
    }

    public boolean getDefinitionChanged() {
        return this.definitionChanged;
    }

    public boolean getEnabledChanged() {
        return this.enabledChanged;
    }

    public GrammarException getGrammarException() {
        return this.grammarException;
    }

    public String paramString() {
        switch (this.id) {
            case 200: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("GRAMMAR_CHANGES_COMMITTED");
                if (this.enabledChanged) {
                    stringBuffer.append(": enabledChanged");
                }
                if (this.definitionChanged) {
                    stringBuffer.append(": definitionChanged");
                }
                if (this.grammarException != null) {
                    stringBuffer.append(": " + this.grammarException.getMessage());
                }
                return stringBuffer.toString();
            }
            case 201: {
                return "GRAMMAR_ACTIVATED";
            }
            case 202: {
                return "GRAMMAR_DEACTIVATED";
            }
        }
        return super.paramString();
    }
}

