/*
 * Decompiled with CFR 0.152.
 */
package javax.speech.recognition;

import javax.speech.recognition.Rule;
import javax.speech.recognition.RuleToken;

public class RuleAlternatives
extends Rule {
    protected Rule[] rules;
    protected float[] weights;

    public RuleAlternatives() {
        this.setRules(null);
        this.weights = null;
    }

    public RuleAlternatives(Rule rule) {
        Rule[] ruleArray = new Rule[]{rule};
        this.setRules(ruleArray);
        this.weights = null;
    }

    public RuleAlternatives(String[] stringArray) {
        if (stringArray == null) {
            stringArray = new String[]{};
            this.weights = null;
            return;
        }
        this.rules = new Rule[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            this.rules[n] = new RuleToken(stringArray[n]);
            ++n;
        }
        this.weights = null;
    }

    public RuleAlternatives(Rule[] ruleArray) {
        this.setRules(ruleArray);
        this.weights = null;
    }

    public RuleAlternatives(Rule[] ruleArray, float[] fArray) throws IllegalArgumentException {
        this.setRules(ruleArray);
        this.setWeights(fArray);
    }

    public void append(Rule rule) {
        if (rule == null) {
            throw new NullPointerException("null rule to append");
        }
        int n = this.rules.length;
        Rule[] ruleArray = new Rule[n + 1];
        System.arraycopy(this.rules, 0, ruleArray, 0, n);
        ruleArray[n] = rule;
        this.rules = ruleArray;
        this.weights = null;
    }

    public Rule copy() {
        float[] fArray = null;
        if (this.weights != null) {
            fArray = new float[this.weights.length];
            System.arraycopy(this.weights, 0, fArray, 0, this.weights.length);
        }
        Rule[] ruleArray = null;
        if (this.rules != null) {
            ruleArray = new Rule[this.rules.length];
            int n = 0;
            while (n < this.rules.length) {
                ruleArray[n] = this.rules[n].copy();
                ++n;
            }
        }
        return new RuleAlternatives(ruleArray, fArray);
    }

    public Rule[] getRules() {
        return this.rules;
    }

    public float[] getWeights() {
        return this.weights;
    }

    public void setRules(Rule[] ruleArray) {
        if (ruleArray == null) {
            ruleArray = new Rule[]{};
        }
        if (this.weights != null && ruleArray.length != this.weights.length) {
            this.weights = null;
        }
        this.rules = ruleArray;
    }

    public void setWeights(float[] fArray) throws IllegalArgumentException {
        if (fArray == null || fArray.length == 0) {
            this.weights = null;
            return;
        }
        if (fArray.length != this.rules.length) {
            throw new IllegalArgumentException("weights/rules array length mismatch");
        }
        float f = 0.0f;
        int n = 0;
        while (n < fArray.length) {
            if (Float.isNaN(fArray[n])) {
                throw new IllegalArgumentException("illegal weight value: NaN");
            }
            if (Float.isInfinite(fArray[n])) {
                throw new IllegalArgumentException("illegal weight value: infinite");
            }
            if ((double)fArray[n] < 0.0) {
                throw new IllegalArgumentException("illegal weight value: negative");
            }
            f += fArray[n];
            ++n;
        }
        if ((double)f <= 0.0) {
            throw new IllegalArgumentException("illegal weight values: all zero");
        }
        this.weights = fArray;
    }

    public String toString() {
        if (this.rules == null || this.rules.length == 0) {
            return "<VOID>";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.rules.length) {
            if (n > 0) {
                stringBuffer.append(" | ");
            }
            if (this.weights != null) {
                stringBuffer.append("/" + this.weights[n] + "/ ");
            }
            if (this.rules[n] instanceof RuleAlternatives) {
                stringBuffer.append("( " + this.rules[n].toString() + " )");
            } else {
                stringBuffer.append(this.rules[n].toString());
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

