/*
 * Decompiled with CFR 0.152.
 */
package javax.speech.recognition;

import java.util.Vector;
import javax.speech.recognition.Rule;
import javax.speech.recognition.RuleAlternatives;
import javax.speech.recognition.RuleName;
import javax.speech.recognition.RuleSequence;
import javax.speech.recognition.RuleTag;
import javax.speech.recognition.RuleToken;

public class RuleParse
extends Rule {
    protected RuleName ruleName;
    protected Rule rule;

    public RuleParse() {
        this.setRuleName(null);
        this.setRule(null);
    }

    public RuleParse(RuleName ruleName, Rule rule) {
        this.setRuleName(ruleName);
        this.setRule(rule);
    }

    public Rule copy() {
        RuleName ruleName = null;
        if (this.ruleName != null) {
            ruleName = (RuleName)this.ruleName.copy();
        }
        return new RuleParse(ruleName, this.rule.copy());
    }

    public Rule getRule() {
        return this.rule;
    }

    public RuleName getRuleName() {
        return this.ruleName;
    }

    public String[] getTags() {
        Vector vector = new Vector();
        this.getTags(this.rule, vector);
        return this.vectorToStringArray(vector);
    }

    private void getTags(Rule rule, Vector vector) {
        if (rule instanceof RuleToken) {
            return;
        }
        if (rule instanceof RuleParse) {
            this.getTags(((RuleParse)rule).getRule(), vector);
            return;
        }
        if (rule instanceof RuleTag) {
            RuleTag ruleTag = (RuleTag)rule;
            this.getTags(ruleTag.getRule(), vector);
            vector.addElement(ruleTag.tag);
            return;
        }
        if (rule instanceof RuleSequence) {
            RuleSequence ruleSequence = (RuleSequence)rule;
            int n = 0;
            while (n < ruleSequence.rules.length) {
                this.getTags(ruleSequence.rules[n], vector);
                ++n;
            }
            return;
        }
        if (rule instanceof RuleAlternatives) {
            RuleAlternatives ruleAlternatives = (RuleAlternatives)rule;
            int n = 0;
            while (n < ruleAlternatives.rules.length) {
                this.getTags(ruleAlternatives.rules[n], vector);
                ++n;
            }
            return;
        }
        if (rule instanceof RuleName) {
            return;
        }
        throw new IllegalArgumentException(String.valueOf(rule.getClass().getName()) + " is not a legal object in a RuleParse");
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public void setRuleName(RuleName ruleName) {
        this.ruleName = ruleName;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("(");
        if (this.ruleName == null) {
            stringBuffer.append("<???>");
        } else {
            stringBuffer.append(this.ruleName.toString());
        }
        stringBuffer.append(" = " + this.rule.toString() + ')');
        return stringBuffer.toString();
    }

    private String[] vectorToStringArray(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return null;
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }
}

