/*
 * Decompiled with CFR 0.152.
 */
package javax.speech.synthesis;

public class Voice
implements Cloneable {
    public static final int GENDER_DONT_CARE = 65535;
    public static final int GENDER_FEMALE = 1;
    public static final int GENDER_MALE = 2;
    public static final int GENDER_NEUTRAL = 4;
    public static final int AGE_DONT_CARE = 65535;
    public static final int AGE_CHILD = 1;
    public static final int AGE_TEENAGER = 2;
    public static final int AGE_YOUNGER_ADULT = 4;
    public static final int AGE_MIDDLE_ADULT = 8;
    public static final int AGE_OLDER_ADULT = 16;
    public static final int AGE_NEUTRAL = 32;
    private String name;
    private int gender;
    private int age;
    private String style;

    public Voice() {
        this.name = null;
        this.gender = 65535;
        this.age = 65535;
        this.style = null;
    }

    public Voice(String string, int n, int n2, String string2) {
        this.name = string;
        this.gender = n;
        this.age = n2;
        this.style = string2;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Voice)) {
            return false;
        }
        Voice voice = (Voice)object;
        if (this.name == null ? voice.name != null : !this.name.equals(voice.name)) {
            return false;
        }
        if (this.style == null ? voice.style != null : !this.style.equals(voice.style)) {
            return false;
        }
        return this.gender == voice.gender && this.age == voice.age;
    }

    public int getAge() {
        return this.age;
    }

    public int getGender() {
        return this.gender;
    }

    public String getName() {
        return this.name;
    }

    public String getStyle() {
        return this.style;
    }

    public boolean match(Voice voice) {
        if (voice.name != null && !voice.name.equals("")) {
            if (this.name == null) {
                return false;
            }
            if (!this.name.equals(voice.name)) {
                return false;
            }
        }
        if (voice.style != null && !voice.style.equals("")) {
            if (this.style == null) {
                return false;
            }
            if (!this.style.equals(voice.style)) {
                return false;
            }
        }
        if ((voice.gender & this.gender) == 0) {
            return false;
        }
        return (voice.age & this.age) != 0;
    }

    public void setAge(int n) {
        this.age = n;
    }

    public void setGender(int n) {
        this.gender = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setStyle(String string) {
        this.style = string;
    }
}

