/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;

public class SashForm
extends Composite {
    public int SASH_WIDTH = 3;
    private static final int DRAG_MINIMUM = 20;
    private int orientation = 256;
    private Sash[] sashes = new Sash[0];
    private Control[] controls = new Control[0];
    private Control maxControl = null;
    private Listener sashListener;
    private static final String LAYOUT_RATIO = "layout ratio";

    public SashForm(Composite parent, int style) {
        super(parent, SashForm.checkStyle(style));
        if ((style & 0x200) != 0) {
            this.orientation = 512;
        }
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                SashForm.this.layout(true);
            }
        });
        this.sashListener = new Listener(){

            public void handleEvent(Event e) {
                SashForm.this.onDragSash(e);
            }
        };
    }

    private static int checkStyle(int style) {
        int mask = 0x6000800;
        return style & mask;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        boolean vertical;
        this.checkWidget();
        Control[] controls = this.getControls(true);
        if (controls.length == 0) {
            return new Point(wHint, hHint);
        }
        int width = 0;
        int height = 0;
        boolean bl = vertical = this.orientation == 512;
        if (vertical) {
            height += (controls.length - 1) * this.SASH_WIDTH;
        } else {
            width += (controls.length - 1) * this.SASH_WIDTH;
        }
        int i = 0;
        while (i < controls.length) {
            Point size;
            if (vertical) {
                size = controls[i].computeSize(wHint, -1);
                height += size.y;
                width = Math.max(width, size.x);
            } else {
                size = controls[i].computeSize(-1, hHint);
                width += size.x;
                height = Math.max(height, size.y);
            }
            ++i;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public Control getMaximizedControl() {
        return this.maxControl;
    }

    public int[] getWeights() {
        this.checkWidget();
        Control[] cArray = this.getControls(false);
        int[] ratios = new int[cArray.length];
        int i = 0;
        while (i < cArray.length) {
            Long ratio = (Long)cArray[i].getData(LAYOUT_RATIO);
            ratios[i] = ratio != null ? (int)(ratio * 1000L >> 16) : 200;
            ++i;
        }
        return ratios;
    }

    private Control[] getControls(boolean onlyVisible) {
        Control[] children = this.getChildren();
        Control[] controls = new Control[]{};
        int i = 0;
        while (i < children.length) {
            if (!(children[i] instanceof Sash || onlyVisible && !children[i].getVisible())) {
                Control[] newControls = new Control[controls.length + 1];
                System.arraycopy(controls, 0, newControls, 0, controls.length);
                newControls[controls.length] = children[i];
                controls = newControls;
            }
            ++i;
        }
        return controls;
    }

    public void layout(boolean changed) {
        Sash[] newSashes;
        this.checkWidget();
        Rectangle area = this.getClientArea();
        if (area.width == 0 || area.height == 0) {
            return;
        }
        Control[] newControls = this.getControls(true);
        if (this.controls.length == 0 && newControls.length == 0) {
            return;
        }
        this.controls = newControls;
        if (this.maxControl != null && !this.maxControl.isDisposed()) {
            int i = 0;
            while (i < this.controls.length) {
                if (this.controls[i] != this.maxControl) {
                    this.controls[i].setBounds(-200, -200, 0, 0);
                } else {
                    this.controls[i].setBounds(area);
                }
                ++i;
            }
            return;
        }
        if (this.sashes.length < this.controls.length - 1) {
            newSashes = new Sash[this.controls.length - 1];
            System.arraycopy(this.sashes, 0, newSashes, 0, this.sashes.length);
            int sashOrientation = this.orientation == 256 ? 512 : 256;
            int i = this.sashes.length;
            while (i < newSashes.length) {
                newSashes[i] = new Sash(this, sashOrientation);
                newSashes[i].addListener(13, this.sashListener);
                ++i;
            }
            this.sashes = newSashes;
        }
        if (this.sashes.length > this.controls.length - 1) {
            if (this.controls.length == 0) {
                int i = 0;
                while (i < this.sashes.length) {
                    this.sashes[i].dispose();
                    ++i;
                }
                this.sashes = new Sash[0];
            } else {
                newSashes = new Sash[this.controls.length - 1];
                System.arraycopy(this.sashes, 0, newSashes, 0, newSashes.length);
                int i = this.controls.length - 1;
                while (i < this.sashes.length) {
                    this.sashes[i].dispose();
                    ++i;
                }
                this.sashes = newSashes;
            }
        }
        if (this.controls.length == 0) {
            return;
        }
        long[] ratios = new long[this.controls.length];
        long total = 0L;
        int i = 0;
        while (i < this.controls.length) {
            Long ratio = (Long)this.controls[i].getData(LAYOUT_RATIO);
            ratios[i] = ratio != null ? ratio : 13108L;
            total += ratios[i];
            ++i;
        }
        total = this.orientation == 256 ? (total += (((long)(this.sashes.length * this.SASH_WIDTH) << 16) + (long)area.width - 1L) / (long)area.width) : (total += (((long)(this.sashes.length * this.SASH_WIDTH) << 16) + (long)area.height - 1L) / (long)area.height);
        if (this.orientation == 256) {
            int width = (int)(ratios[0] * (long)area.width / total);
            int x = area.x;
            this.controls[0].setBounds(x, area.y, width, area.height);
            x += width;
            int i2 = 1;
            while (i2 < this.controls.length - 1) {
                this.sashes[i2 - 1].setBounds(x, area.y, this.SASH_WIDTH, area.height);
                width = (int)(ratios[i2] * (long)area.width / total);
                this.controls[i2].setBounds(x += this.SASH_WIDTH, area.y, width, area.height);
                x += width;
                ++i2;
            }
            if (this.controls.length > 1) {
                this.sashes[this.sashes.length - 1].setBounds(x, area.y, this.SASH_WIDTH, area.height);
                width = area.width - (x += this.SASH_WIDTH);
                this.controls[this.controls.length - 1].setBounds(x, area.y, width, area.height);
            }
        } else {
            int height = (int)(ratios[0] * (long)area.height / total);
            int y = area.y;
            this.controls[0].setBounds(area.x, y, area.width, height);
            y += height;
            int i3 = 1;
            while (i3 < this.controls.length - 1) {
                this.sashes[i3 - 1].setBounds(area.x, y, area.width, this.SASH_WIDTH);
                height = (int)(ratios[i3] * (long)area.height / total);
                this.controls[i3].setBounds(area.x, y += this.SASH_WIDTH, area.width, height);
                y += height;
                ++i3;
            }
            if (this.controls.length > 1) {
                this.sashes[this.sashes.length - 1].setBounds(area.x, y, area.width, this.SASH_WIDTH);
                height = area.height - (y += this.SASH_WIDTH);
                this.controls[this.controls.length - 1].setBounds(area.x, y, area.width, height);
            }
        }
    }

    private void onDragSash(Event event) {
        if (event.detail == 1) {
            Rectangle area = this.getClientArea();
            if (this.orientation == 256) {
                event.x = Math.min(Math.max(20, event.x), area.width - 20);
            } else {
                event.y = Math.min(Math.max(20, event.y), area.height - 20);
            }
            return;
        }
        Sash sash = (Sash)event.widget;
        int sashIndex = -1;
        int i = 0;
        while (i < this.sashes.length) {
            if (this.sashes[i] == sash) {
                sashIndex = i;
                break;
            }
            ++i;
        }
        if (sashIndex == -1) {
            return;
        }
        Control c1 = this.controls[sashIndex];
        Control c2 = this.controls[sashIndex + 1];
        Rectangle b1 = c1.getBounds();
        Rectangle b2 = c2.getBounds();
        Rectangle sashBounds = sash.getBounds();
        Rectangle area = this.getClientArea();
        if (this.orientation == 256) {
            int shift = event.x - sashBounds.x;
            b1.width += shift;
            b2.x += shift;
            b2.width -= shift;
            if (b1.width < 20 || b2.width < 20) {
                return;
            }
            c1.setData(LAYOUT_RATIO, new Long((((long)b1.width << 16) + (long)area.width - 1L) / (long)area.width));
            c2.setData(LAYOUT_RATIO, new Long((((long)b2.width << 16) + (long)area.width - 1L) / (long)area.width));
        } else {
            int shift = event.y - sashBounds.y;
            b1.height += shift;
            b2.y += shift;
            b2.height -= shift;
            if (b1.height < 20 || b2.height < 20) {
                return;
            }
            c1.setData(LAYOUT_RATIO, new Long((((long)b1.height << 16) + (long)area.height - 1L) / (long)area.height));
            c2.setData(LAYOUT_RATIO, new Long((((long)b2.height << 16) + (long)area.height - 1L) / (long)area.height));
        }
        c1.setBounds(b1);
        sash.setBounds(event.x, event.y, event.width, event.height);
        c2.setBounds(b2);
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
        if (this.orientation == orientation) {
            return;
        }
        if (orientation != 256 && orientation != 512) {
            SWT.error(5);
        }
        this.orientation = orientation;
        int sashOrientation = orientation == 256 ? 512 : 256;
        int i = 0;
        while (i < this.sashes.length) {
            this.sashes[i].dispose();
            this.sashes[i] = new Sash(this, sashOrientation);
            this.sashes[i].addListener(13, this.sashListener);
            ++i;
        }
        this.layout();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setMaximizedControl(Control control) {
        this.checkWidget();
        if (control == null) {
            if (this.maxControl != null) {
                this.maxControl = null;
                this.layout();
                int i = 0;
                while (i < this.sashes.length) {
                    this.sashes[i].setVisible(true);
                    ++i;
                }
            }
            return;
        }
        int i = 0;
        while (i < this.sashes.length) {
            this.sashes[i].setVisible(false);
            ++i;
        }
        this.maxControl = control;
        this.layout();
    }

    public void setWeights(int[] weights) {
        this.checkWidget();
        Control[] cArray = this.getControls(false);
        if (weights == null || weights.length != cArray.length) {
            SWT.error(5);
        }
        int total = 0;
        int i = 0;
        while (i < weights.length) {
            if (weights[i] < 0) {
                SWT.error(5);
            }
            total += weights[i];
            ++i;
        }
        if (total == 0) {
            SWT.error(5);
        }
        i = 0;
        while (i < cArray.length) {
            cArray[i].setData(LAYOUT_RATIO, new Long((((long)weights[i] << 16) + (long)total - 1L) / (long)total));
            ++i;
        }
        this.layout();
    }
}

