/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DialogSettings
implements IDialogSettings {
    private String name;
    private Map sections;
    private Map items;
    private Map arrayItems;
    private final String TAG_SECTION = "section";
    private final String TAG_NAME = "name";
    private final String TAG_KEY = "key";
    private final String TAG_VALUE = "value";
    private final String TAG_LIST = "list";
    private final String TAG_ITEM = "item";

    public DialogSettings(String sectionName) {
        this.name = sectionName;
        this.items = new HashMap();
        this.arrayItems = new HashMap();
        this.sections = new HashMap();
    }

    public IDialogSettings addNewSection(String name) {
        DialogSettings section = new DialogSettings(name);
        this.addSection(section);
        return section;
    }

    public void addSection(IDialogSettings section) {
        this.sections.put(section.getName(), section);
    }

    public String get(String key) {
        return (String)this.items.get(key);
    }

    public String[] getArray(String key) {
        return (String[])this.arrayItems.get(key);
    }

    public boolean getBoolean(String key) {
        return new Boolean((String)this.items.get(key));
    }

    public double getDouble(String key) throws NumberFormatException {
        String setting = (String)this.items.get(key);
        if (setting == null) {
            throw new NumberFormatException("There is no setting associated with the key \"" + key + "\"");
        }
        return new Double(setting);
    }

    public float getFloat(String key) throws NumberFormatException {
        String setting = (String)this.items.get(key);
        if (setting == null) {
            throw new NumberFormatException("There is no setting associated with the key \"" + key + "\"");
        }
        return new Float(setting).floatValue();
    }

    public int getInt(String key) throws NumberFormatException {
        String setting = (String)this.items.get(key);
        if (setting == null) {
            throw new NumberFormatException("There is no setting associated with the key \"" + key + "\"");
        }
        return new Integer(setting);
    }

    public long getLong(String key) throws NumberFormatException {
        String setting = (String)this.items.get(key);
        if (setting == null) {
            throw new NumberFormatException("There is no setting associated with the key \"" + key + "\"");
        }
        return new Long(setting);
    }

    public String getName() {
        return this.name;
    }

    public IDialogSettings getSection(String sectionName) {
        return (IDialogSettings)this.sections.get(sectionName);
    }

    public IDialogSettings[] getSections() {
        Collection values = this.sections.values();
        IDialogSettings[] result = new DialogSettings[values.size()];
        values.toArray(result);
        return result;
    }

    public void load(Reader r) {
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            document = parser.parse(new InputSource(r));
            Node root = document.getFirstChild();
            while (root.getNodeType() == 8) {
                document.removeChild(root);
                root = document.getFirstChild();
            }
            this.load(document, (Element)root);
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (IOException iOException) {
        }
        catch (SAXException sAXException) {}
    }

    public void load(String fileName) throws IOException {
        FileInputStream stream = new FileInputStream(fileName);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, "utf-8"));
        this.load(reader);
        reader.close();
    }

    private void load(Document document, Element root) {
        Node n;
        this.name = root.getAttribute("name");
        NodeList l = root.getElementsByTagName("item");
        int i = 0;
        while (i < l.getLength()) {
            n = l.item(i);
            if (root == n.getParentNode()) {
                String key = ((Element)l.item(i)).getAttribute("key");
                String value = ((Element)l.item(i)).getAttribute("value");
                this.items.put(key, value);
            }
            ++i;
        }
        l = root.getElementsByTagName("list");
        i = 0;
        while (i < l.getLength()) {
            n = l.item(i);
            if (root == n.getParentNode()) {
                Element child = (Element)l.item(i);
                String key = child.getAttribute("key");
                NodeList list = child.getElementsByTagName("item");
                ArrayList<String> valueList = new ArrayList<String>();
                int j = 0;
                while (j < list.getLength()) {
                    Element node = (Element)list.item(j);
                    if (child == node.getParentNode()) {
                        valueList.add(node.getAttribute("value"));
                    }
                    ++j;
                }
                String[] value = new String[valueList.size()];
                valueList.toArray(value);
                this.arrayItems.put(key, value);
            }
            ++i;
        }
        l = root.getElementsByTagName("section");
        i = 0;
        while (i < l.getLength()) {
            n = l.item(i);
            if (root == n.getParentNode()) {
                DialogSettings s = new DialogSettings("NoName");
                s.load(document, (Element)n);
                this.addSection(s);
            }
            ++i;
        }
    }

    public void put(String key, String[] value) {
        this.arrayItems.put(key, value);
    }

    public void put(String key, double value) {
        this.put(key, String.valueOf(value));
    }

    public void put(String key, float value) {
        this.put(key, String.valueOf(value));
    }

    public void put(String key, int value) {
        this.put(key, String.valueOf(value));
    }

    public void put(String key, long value) {
        this.put(key, String.valueOf(value));
    }

    public void put(String key, String value) {
        this.items.put(key, value);
    }

    public void put(String key, boolean value) {
        this.put(key, String.valueOf(value));
    }

    public void save(Writer writer) throws IOException {
        DocumentImpl document = new DocumentImpl();
        this.save((Document)document, (Node)document);
        OutputFormat format = new OutputFormat();
        Serializer serializer = SerializerFactory.getSerializerFactory((String)"xml").makeSerializer(writer, format);
        serializer.asDOMSerializer().serialize((Document)document);
    }

    public void save(String fileName) throws IOException {
        FileOutputStream stream = new FileOutputStream(fileName);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, "utf-8");
        this.save(writer);
        writer.close();
    }

    private void save(Document document, Node parent) {
        Element child;
        String key;
        Element root = document.createElement("section");
        parent.appendChild(root);
        root.setAttribute("name", this.name);
        Iterator<Object> i = this.items.keySet().iterator();
        while (i.hasNext()) {
            key = (String)i.next();
            child = document.createElement("item");
            root.appendChild(child);
            child.setAttribute("key", key);
            child.setAttribute("value", (String)this.items.get(key));
        }
        i = this.arrayItems.keySet().iterator();
        while (i.hasNext()) {
            key = (String)i.next();
            child = document.createElement("list");
            root.appendChild(child);
            child.setAttribute("key", key);
            String[] value = (String[])this.arrayItems.get(key);
            int index = 0;
            while (index < value.length) {
                Element c = document.createElement("item");
                child.appendChild(c);
                c.setAttribute("value", value[index]);
                ++index;
            }
        }
        i = this.sections.values().iterator();
        while (i.hasNext()) {
            ((DialogSettings)i.next()).save(document, root);
        }
    }
}

