/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.de;

import java.io.File;
import java.io.Reader;
import java.util.Hashtable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.de.GermanStemFilter;
import org.apache.lucene.analysis.de.WordlistLoader;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;

public class GermanAnalyzer
extends Analyzer {
    private String[] GERMAN_STOP_WORDS = new String[]{"einer", "eine", "eines", "einem", "einen", "der", "die", "das", "dass", "da\u00df", "du", "er", "sie", "es", "was", "wer", "wie", "wir", "und", "oder", "ohne", "mit", "am", "im", "in", "aus", "auf", "ist", "sein", "war", "wird", "ihr", "ihre", "ihres", "als", "f\u00fcr", "von", "mit", "dich", "dir", "mich", "mir", "mein", "sein", "kein", "durch", "wegen", "wird"};
    private Hashtable stoptable = new Hashtable();
    private Hashtable excltable = new Hashtable();

    public GermanAnalyzer() {
        this.stoptable = StopFilter.makeStopTable(this.GERMAN_STOP_WORDS);
    }

    public GermanAnalyzer(String[] stringArray) {
        this.stoptable = StopFilter.makeStopTable(stringArray);
    }

    public GermanAnalyzer(Hashtable hashtable) {
        this.stoptable = hashtable;
    }

    public GermanAnalyzer(File file) {
        this.stoptable = WordlistLoader.getWordtable(file);
    }

    public void setStemExclusionTable(String[] stringArray) {
        this.excltable = StopFilter.makeStopTable(stringArray);
    }

    public void setStemExclusionTable(Hashtable hashtable) {
        this.excltable = hashtable;
    }

    public void setStemExclusionTable(File file) {
        this.excltable = WordlistLoader.getWordtable(file);
    }

    public TokenStream tokenStream(String string, Reader reader) {
        TokenStream tokenStream = new StandardTokenizer(reader);
        tokenStream = new StandardFilter(tokenStream);
        tokenStream = new StopFilter(tokenStream, this.stoptable);
        tokenStream = new GermanStemFilter(tokenStream, this.excltable);
        return tokenStream;
    }
}

