/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ru;

class RussianStemmer {
    private char[] charset;
    private int RV;
    private int R1;
    private int R2;
    private static char A = '\u0000';
    private static char B = '\u0001';
    private static char V = (char)2;
    private static char G = (char)3;
    private static char D = (char)4;
    private static char E = (char)5;
    private static char ZH = (char)6;
    private static char Z = (char)7;
    private static char I = (char)8;
    private static char I_ = (char)9;
    private static char K = (char)10;
    private static char L = (char)11;
    private static char M = (char)12;
    private static char N = (char)13;
    private static char O = (char)14;
    private static char P = (char)15;
    private static char R = (char)16;
    private static char S = (char)17;
    private static char T = (char)18;
    private static char U = (char)19;
    private static char F = (char)20;
    private static char X = (char)21;
    private static char TS = (char)22;
    private static char CH = (char)23;
    private static char SH = (char)24;
    private static char SHCH = (char)25;
    private static char HARD = (char)26;
    private static char Y = (char)27;
    private static char SOFT = (char)28;
    private static char AE = (char)29;
    private static char IU = (char)30;
    private static char IA = (char)31;
    private static char[] vowels = new char[]{A, E, I, O, U, Y, AE, IU, IA};
    private static char[][] perfectiveGerundEndings1 = new char[][]{{V}, {V, SH, I}, {V, SH, I, S, SOFT}};
    private static char[][] perfectiveGerund1Predessors = new char[][]{{A}, {IA}};
    private static char[][] perfectiveGerundEndings2 = new char[][]{{I, V}, {Y, V}, {I, V, SH, I}, {Y, V, SH, I}, {I, V, SH, I, S, SOFT}, {Y, V, SH, I, S, SOFT}};
    private static char[][] adjectiveEndings = new char[][]{{E, E}, {I, E}, {Y, E}, {O, E}, {E, I_}, {I, I_}, {Y, I_}, {O, I_}, {E, M}, {I, M}, {Y, M}, {O, M}, {I, X}, {Y, X}, {U, IU}, {IU, IU}, {A, IA}, {IA, IA}, {O, IU}, {E, IU}, {I, M, I}, {Y, M, I}, {E, G, O}, {O, G, O}, {E, M, U}, {O, M, U}};
    private static char[][] participleEndings1 = new char[][]{{SHCH}, {E, M}, {N, N}, {V, SH}, {IU, SHCH}};
    private static char[][] participleEndings2 = new char[][]{{I, V, SH}, {Y, V, SH}, {U, IU, SHCH}};
    private static char[][] participle1Predessors = new char[][]{{A}, {IA}};
    private static char[][] reflexiveEndings = new char[][]{{S, IA}, {S, SOFT}};
    private static char[][] verbEndings1 = new char[][]{{I_}, {L}, {N}, {L, O}, {N, O}, {E, T}, {IU, T}, {L, A}, {N, A}, {L, I}, {E, M}, {N, Y}, {E, T, E}, {I_, T, E}, {T, SOFT}, {E, SH, SOFT}, {N, N, O}};
    private static char[][] verbEndings2 = new char[][]{{IU}, {U, IU}, {E, N}, {E, I_}, {IA, T}, {U, I_}, {I, L}, {Y, L}, {I, M}, {Y, M}, {I, T}, {Y, T}, {I, L, A}, {Y, L, A}, {E, N, A}, {I, T, E}, {I, L, I}, {Y, L, I}, {I, L, O}, {Y, L, O}, {E, N, O}, {U, E, T}, {U, IU, T}, {E, N, Y}, {I, T, SOFT}, {Y, T, SOFT}, {I, SH, SOFT}, {E, I_, T, E}, {U, I_, T, E}};
    private static char[][] verb1Predessors = new char[][]{{A}, {IA}};
    private static char[][] nounEndings = new char[][]{{A}, {U}, {I_}, {O}, {U}, {E}, {Y}, {I}, {SOFT}, {IA}, {E, V}, {O, V}, {I, E}, {SOFT, E}, {IA, X}, {I, IU}, {E, I}, {I, I}, {E, I_}, {O, I_}, {E, M}, {A, M}, {O, M}, {A, X}, {SOFT, IU}, {I, IA}, {SOFT, IA}, {I, I_}, {IA, M}, {IA, M, I}, {A, M, I}, {I, E, I_}, {I, IA, M}, {I, E, M}, {I, IA, X}, {I, IA, M, I}};
    private static char[][] superlativeEndings = new char[][]{{E, I_, SH}, {E, I_, SH, E}};
    private static char[][] derivationalEndings = new char[][]{{O, S, T}, {O, S, T, SOFT}};

    public RussianStemmer() {
    }

    public RussianStemmer(char[] cArray) {
        this.charset = cArray;
    }

    private boolean adjectival(StringBuffer stringBuffer) {
        if (!this.findAndRemoveEnding(stringBuffer, adjectiveEndings)) {
            return false;
        }
        boolean bl = this.findAndRemoveEnding(stringBuffer, participleEndings1, participle1Predessors) || this.findAndRemoveEnding(stringBuffer, participleEndings2);
        return true;
    }

    private boolean derivational(StringBuffer stringBuffer) {
        int n = this.findEnding(stringBuffer, derivationalEndings);
        if (n == 0) {
            return false;
        }
        if (this.R2 - this.RV <= stringBuffer.length() - n) {
            stringBuffer.setLength(stringBuffer.length() - n);
            return true;
        }
        return false;
    }

    private int findEnding(StringBuffer stringBuffer, int n, char[][] cArray) {
        boolean bl = false;
        int n2 = cArray.length - 1;
        while (n2 >= 0) {
            char[] cArray2 = cArray[n2];
            if (n < cArray2.length - 1) {
                bl = false;
            } else {
                bl = true;
                int n3 = n;
                int n4 = cArray2.length - 1;
                while (n4 >= 0) {
                    if (stringBuffer.charAt(n3--) != this.charset[cArray2[n4]]) {
                        bl = false;
                        break;
                    }
                    --n4;
                }
                if (bl) {
                    return cArray[n2].length;
                }
            }
            --n2;
        }
        return 0;
    }

    private int findEnding(StringBuffer stringBuffer, char[][] cArray) {
        return this.findEnding(stringBuffer, stringBuffer.length() - 1, cArray);
    }

    private boolean findAndRemoveEnding(StringBuffer stringBuffer, char[][] cArray) {
        int n = this.findEnding(stringBuffer, cArray);
        if (n == 0) {
            return false;
        }
        stringBuffer.setLength(stringBuffer.length() - n);
        return true;
    }

    private boolean findAndRemoveEnding(StringBuffer stringBuffer, char[][] cArray, char[][] cArray2) {
        int n = this.findEnding(stringBuffer, cArray);
        if (n == 0) {
            return false;
        }
        int n2 = this.findEnding(stringBuffer, stringBuffer.length() - n - 1, cArray2);
        if (n2 == 0) {
            return false;
        }
        stringBuffer.setLength(stringBuffer.length() - n);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private void markPositions(String var1_1) {
        this.RV = 0;
        this.R1 = 0;
        this.R2 = 0;
        var2_2 = 0;
        while (var1_1.length() > var2_2 && !this.isVowel(var1_1.charAt(var2_2))) {
            ++var2_2;
        }
        if (var1_1.length() - 1 < ++var2_2) {
            return;
        }
        this.RV = var2_2;
        while (var1_1.length() > var2_2 && this.isVowel(var1_1.charAt(var2_2))) {
            ++var2_2;
        }
        if (var1_1.length() - 1 < ++var2_2) {
            return;
        }
        this.R1 = var2_2;
        while (var1_1.length() > var2_2 && !this.isVowel(var1_1.charAt(var2_2))) {
            ++var2_2;
        }
        if (var1_1.length() - 1 >= ++var2_2) ** GOTO lbl23
        return;
lbl-1000:
        // 1 sources

        {
            ++var2_2;
lbl23:
            // 2 sources

            ** while (var1_1.length() > var2_2 && this.isVowel((char)var1_1.charAt((int)var2_2)))
        }
lbl24:
        // 1 sources

        if (var1_1.length() - 1 < ++var2_2) {
            return;
        }
        this.R2 = var2_2;
    }

    private boolean isVowel(char c) {
        int n = 0;
        while (n < vowels.length) {
            if (c == this.charset[vowels[n]]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean noun(StringBuffer stringBuffer) {
        return this.findAndRemoveEnding(stringBuffer, nounEndings);
    }

    private boolean perfectiveGerund(StringBuffer stringBuffer) {
        return this.findAndRemoveEnding(stringBuffer, perfectiveGerundEndings1, perfectiveGerund1Predessors) || this.findAndRemoveEnding(stringBuffer, perfectiveGerundEndings2);
    }

    private boolean reflexive(StringBuffer stringBuffer) {
        return this.findAndRemoveEnding(stringBuffer, reflexiveEndings);
    }

    private boolean removeI(StringBuffer stringBuffer) {
        if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == this.charset[I]) {
            stringBuffer.setLength(stringBuffer.length() - 1);
            return true;
        }
        return false;
    }

    private boolean removeSoft(StringBuffer stringBuffer) {
        if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == this.charset[SOFT]) {
            stringBuffer.setLength(stringBuffer.length() - 1);
            return true;
        }
        return false;
    }

    public void setCharset(char[] cArray) {
        this.charset = cArray;
    }

    private void setEndings() {
        vowels = new char[]{A, E, I, O, U, Y, AE, IU, IA};
        perfectiveGerundEndings1 = new char[][]{{V}, {V, SH, I}, {V, SH, I, S, SOFT}};
        perfectiveGerund1Predessors = new char[][]{{A}, {IA}};
        perfectiveGerundEndings2 = new char[][]{{I, V}, {Y, V}, {I, V, SH, I}, {Y, V, SH, I}, {I, V, SH, I, S, SOFT}, {Y, V, SH, I, S, SOFT}};
        adjectiveEndings = new char[][]{{E, E}, {I, E}, {Y, E}, {O, E}, {E, I_}, {I, I_}, {Y, I_}, {O, I_}, {E, M}, {I, M}, {Y, M}, {O, M}, {I, X}, {Y, X}, {U, IU}, {IU, IU}, {A, IA}, {IA, IA}, {O, IU}, {E, IU}, {I, M, I}, {Y, M, I}, {E, G, O}, {O, G, O}, {E, M, U}, {O, M, U}};
        participleEndings1 = new char[][]{{SHCH}, {E, M}, {N, N}, {V, SH}, {IU, SHCH}};
        participleEndings2 = new char[][]{{I, V, SH}, {Y, V, SH}, {U, IU, SHCH}};
        participle1Predessors = new char[][]{{A}, {IA}};
        reflexiveEndings = new char[][]{{S, IA}, {S, SOFT}};
        verbEndings1 = new char[][]{{I_}, {L}, {N}, {L, O}, {N, O}, {E, T}, {IU, T}, {L, A}, {N, A}, {L, I}, {E, M}, {N, Y}, {E, T, E}, {I_, T, E}, {T, SOFT}, {E, SH, SOFT}, {N, N, O}};
        verbEndings2 = new char[][]{{IU}, {U, IU}, {E, N}, {E, I_}, {IA, T}, {U, I_}, {I, L}, {Y, L}, {I, M}, {Y, M}, {I, T}, {Y, T}, {I, L, A}, {Y, L, A}, {E, N, A}, {I, T, E}, {I, L, I}, {Y, L, I}, {I, L, O}, {Y, L, O}, {E, N, O}, {U, E, T}, {U, IU, T}, {E, N, Y}, {I, T, SOFT}, {Y, T, SOFT}, {I, SH, SOFT}, {E, I_, T, E}, {U, I_, T, E}};
        verb1Predessors = new char[][]{{A}, {IA}};
        nounEndings = new char[][]{{A}, {IU}, {I_}, {O}, {U}, {E}, {Y}, {I}, {SOFT}, {IA}, {E, V}, {O, V}, {I, E}, {SOFT, E}, {IA, X}, {I, IU}, {E, I}, {I, I}, {E, I_}, {O, I_}, {E, M}, {A, M}, {O, M}, {A, X}, {SOFT, IU}, {I, IA}, {SOFT, IA}, {I, I_}, {IA, M}, {IA, M, I}, {A, M, I}, {I, E, I_}, {I, IA, M}, {I, E, M}, {I, IA, X}, {I, IA, M, I}};
        superlativeEndings = new char[][]{{E, I_, SH}, {E, I_, SH, E}};
        derivationalEndings = new char[][]{{O, S, T}, {O, S, T, SOFT}};
    }

    public String stem(String string) {
        this.markPositions(string);
        if (this.RV == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.substring(this.RV));
        if (!this.perfectiveGerund(stringBuffer)) {
            this.reflexive(stringBuffer);
            boolean bl = this.adjectival(stringBuffer) || this.verb(stringBuffer) || this.noun(stringBuffer);
        }
        this.removeI(stringBuffer);
        this.derivational(stringBuffer);
        this.superlative(stringBuffer);
        this.undoubleN(stringBuffer);
        this.removeSoft(stringBuffer);
        return string.substring(0, this.RV) + stringBuffer.toString();
    }

    private boolean superlative(StringBuffer stringBuffer) {
        return this.findAndRemoveEnding(stringBuffer, superlativeEndings);
    }

    private boolean undoubleN(StringBuffer stringBuffer) {
        char[][] cArrayArray = new char[][]{{N, N}};
        if (this.findEnding(stringBuffer, cArrayArray) != 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
            return true;
        }
        return false;
    }

    private boolean verb(StringBuffer stringBuffer) {
        return this.findAndRemoveEnding(stringBuffer, verbEndings1, verb1Predessors) || this.findAndRemoveEnding(stringBuffer, verbEndings2);
    }

    public static String stem(String string, char[] cArray) {
        RussianStemmer russianStemmer = new RussianStemmer();
        russianStemmer.setCharset(cArray);
        return russianStemmer.stem(string);
    }
}

