/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.Date;

public class DateField {
    private static int DATE_LEN = Long.toString(31536000000000L, 36).length();

    private DateField() {
    }

    public static String MIN_DATE_STRING() {
        return DateField.timeToString(0L);
    }

    public static String MAX_DATE_STRING() {
        char[] cArray = new char[DATE_LEN];
        char c = Character.forDigit(35, 36);
        int n = 0;
        while (n < DATE_LEN) {
            cArray[n] = c;
            ++n;
        }
        return new String(cArray);
    }

    public static String dateToString(Date date) {
        return DateField.timeToString(date.getTime());
    }

    public static String timeToString(long l) {
        if (l < 0L) {
            throw new RuntimeException("time too early");
        }
        String string = Long.toString(l, 36);
        if (string.length() > DATE_LEN) {
            throw new RuntimeException("time too late");
        }
        if (string.length() < DATE_LEN) {
            StringBuffer stringBuffer = new StringBuffer(string);
            while (stringBuffer.length() < DATE_LEN) {
                stringBuffer.insert(0, ' ');
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static long stringToTime(String string) {
        return Long.parseLong(string, 36);
    }

    public static Date stringToDate(String string) {
        return new Date(DateField.stringToTime(string));
    }
}

